/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.AnomalyFixStatus;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.RebalanceResult;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationResult;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizerResult;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalOptimizationResult;
import com.linkedin.kafka.cruisecontrol.async.progress.OperationProgress;
import com.linkedin.kafka.cruisecontrol.config.GoalsConfig;
import com.linkedin.kafka.cruisecontrol.detector.KafkaAnomaly;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyNotificationResult;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;
import com.linkedin.kafka.cruisecontrol.detector.notifier.SelfHealingNotifier;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import io.confluent.databalancer.operation.SelfHealingStateTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoalViolations
extends KafkaAnomaly {
    private static final String ID_PREFIX = AnomalyType.GOAL_VIOLATION.toString();
    private static final Logger LOG = LoggerFactory.getLogger(GoalViolations.class);
    private final KafkaCruiseControl kafkaCruiseControl;
    private final SelfHealingStateTracker selfHealingStateTracker;
    private final Map<Boolean, List<GoalResult>> violatedGoalsByFixability;
    private final boolean allowCapacityEstimation;
    private final boolean excludeRecentlyRemovedBrokers;
    private final String anomalyId;
    private final GoalsConfig goalsConfig;
    private final Set<Integer> failedBrokers;
    private AnomalyFixStatus fixStatus;
    private final long creationTime;

    public GoalViolations(KafkaCruiseControl kafkaCruiseControl, SelfHealingStateTracker selfHealingStateTracker, boolean allowCapacityEstimation, boolean excludeRecentlyRemovedBrokers, GoalsConfig goalsConfig, Set<Integer> failedBrokers, long creationTime) {
        this.kafkaCruiseControl = kafkaCruiseControl;
        this.selfHealingStateTracker = selfHealingStateTracker;
        this.allowCapacityEstimation = allowCapacityEstimation;
        this.violatedGoalsByFixability = new HashMap<Boolean, List<GoalResult>>();
        this.excludeRecentlyRemovedBrokers = excludeRecentlyRemovedBrokers;
        this.anomalyId = String.format("%s-%s", ID_PREFIX, UUID.randomUUID().toString().substring(ID_PREFIX.length() + 1));
        this.optimizationResult = null;
        this.goalsConfig = goalsConfig;
        this.failedBrokers = failedBrokers;
        this.fixStatus = AnomalyFixStatus.START_SUCCESSFULLY;
        this.creationTime = creationTime;
    }

    void addViolation(String goalName, boolean fixable, Exception e) {
        this.violatedGoalsByFixability.computeIfAbsent(fixable, k -> new ArrayList()).add(new GoalResult(goalName, e));
    }

    void addViolation(String goalName, boolean fixable) {
        this.addViolation(goalName, fixable, null);
    }

    public Map<Boolean, List<GoalResult>> violatedGoalsByFixability() {
        return this.violatedGoalsByFixability;
    }

    @Override
    public String anomalyId() {
        return this.anomalyId;
    }

    @Override
    public boolean ready() {
        KafkaCruiseControl.CompletenessRequirementCheck completenessCheck = this.kafkaCruiseControl.meetCompletenessRequirements(this.goalsConfig.goals(), this.failedBrokers);
        if (!completenessCheck.meetsRequirements()) {
            LOG.warn("Skipping {} fix because load completeness requirement is not met for goals - {}.", (Object)AnomalyType.GOAL_VIOLATION, (Object)completenessCheck.failureReason());
        }
        return completenessCheck.meetsRequirements();
    }

    @Override
    public AnomalyNotificationResult notifyAnomalyInProgress(SelfHealingNotifier selfHealingNotifier) {
        AnomalyNotificationResult notificationResult = selfHealingNotifier.onGoalViolation(this);
        if (selfHealingNotifier.isSelfHealingEnabled(AnomalyType.GOAL_VIOLATION) && this.hasUnfixableGoals()) {
            this.fixStatus = AnomalyFixStatus.START_FAILED;
        }
        return notificationResult;
    }

    public boolean canViolationBeFixed() {
        return this.fixStatus == AnomalyFixStatus.START_SUCCESSFULLY;
    }

    public boolean hasUnfixableGoals() {
        List<GoalResult> unfixableGoals = this.violatedGoalsByFixability().get(false);
        return unfixableGoals != null && !unfixableGoals.isEmpty();
    }

    @Override
    public AnomalyFixStatus fix() throws KafkaCruiseControlException {
        try {
            this.fixStatus = this.tryFix();
        }
        catch (KafkaCruiseControlException ex) {
            this.fixStatus = AnomalyFixStatus.START_FAILED;
            throw ex;
        }
        return this.fixStatus;
    }

    public AnomalyFixStatus tryFix() throws KafkaCruiseControlException {
        if (this.violatedGoalsByFixability.get(false) != null) {
            LOG.info("Skip fixing goal violations due to unfixable goal violations {} detected.", this.violatedGoalsByFixability.get(false));
            return AnomalyFixStatus.START_FAILED;
        }
        try {
            List<String> triggeringGoals = this.violatedGoalsByFixability.getOrDefault(true, Collections.emptyList()).stream().map(r -> r.name).collect(Collectors.toList());
            RebalanceResult rebalanceResult = this.kafkaCruiseControl.rebalanceForEvenClusterLoad(this.goalsConfig, false, null, new OperationProgress(), this.allowCapacityEstimation, this.anomalyId, this.excludeRecentlyRemovedBrokers, triggeringGoals);
            OptimizerResult optimizerResult = rebalanceResult.optimizerResult();
            if (!rebalanceResult.wasExecuted()) {
                if (optimizerResult != null && optimizerResult.goalProposals().isEmpty()) {
                    this.optimizationResult = new OptimizationResult(optimizerResult);
                    this.optimizationResult.cacheText();
                    LOG.info("No balancing actions can be generated to fix Goal violation {} and triggering goals {} at this time", (Object)this.anomalyId, triggeringGoals);
                    return AnomalyFixStatus.DID_NOT_START;
                }
                LOG.warn("Goal violation {} could not be safely fixed: no triggering goals {} could be successfully fixed", (Object)this.anomalyId, triggeringGoals);
                return AnomalyFixStatus.START_FAILED;
            }
            if (optimizerResult != null) {
                this.updateSelfHealingState(optimizerResult);
            }
            this.optimizationResult = new OptimizationResult(optimizerResult);
            this.optimizationResult.cacheText();
            return AnomalyFixStatus.START_SUCCESSFULLY;
        }
        catch (IllegalStateException e) {
            LOG.warn(String.format("Got exception when trying to fix the cluster for violated goals %s", this.violatedGoalsByFixability.get(true)), (Throwable)e);
            return AnomalyFixStatus.START_FAILED;
        }
    }

    private void updateSelfHealingState(OptimizerResult optimizerResult) {
        Map<String, GoalOptimizationResult.GoalOptimizationResultState> goalOptimizationResultStateByGoalName = optimizerResult.goalOptimizationResultStateByGoalName();
        for (Map.Entry<String, GoalOptimizationResult.GoalOptimizationResultState> goalNameAndResultState : goalOptimizationResultStateByGoalName.entrySet()) {
            String goalName = goalNameAndResultState.getKey();
            GoalOptimizationResult.GoalOptimizationResultState resultState = goalNameAndResultState.getValue();
            if (resultState.isSuccessful()) {
                this.selfHealingStateTracker.markGoalAsSuccessful(goalName);
                continue;
            }
            this.selfHealingStateTracker.recordIteration(goalName);
        }
    }

    public long creationTime() {
        return this.creationTime;
    }

    public Optional<OptimizerResult> optimizerResult() {
        if (this.optimizationResult == null || this.optimizationResult.optimizerResult() == null) {
            return Optional.empty();
        }
        return Optional.of(this.optimizationResult.optimizerResult());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{Unfixable goal violations: {");
        StringJoiner joiner = new StringJoiner(",");
        this.violatedGoalsByFixability.getOrDefault(false, Collections.emptyList()).stream().map(GoalResult::toString).forEach(joiner::add);
        sb.append(joiner.toString());
        sb.append("}, Fixable goal violations: {");
        joiner = new StringJoiner(",");
        this.violatedGoalsByFixability.getOrDefault(true, Collections.emptyList()).stream().map(GoalResult::toString).forEach(joiner::add);
        sb.append(joiner.toString());
        sb.append(String.format("}, Exclude brokers recently (removed: %s)}", this.excludeRecentlyRemovedBrokers));
        return sb.toString();
    }

    public static class GoalResult {
        public final String name;
        public final Exception exception;

        public GoalResult(String name, Exception exception) {
            this.name = name;
            this.exception = exception;
        }

        public String toString() {
            return "GoalResult{goalName='" + this.name + "'" + (String)(this.exception == null ? "" : ", exception=" + String.valueOf(this.exception)) + "}";
        }
    }
}

