/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.detector.ResourceUtilizationDetector;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtilizationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUtilizationHandler.class);
    private final List<ResourceUtilizationDetector> detectors;
    private final ModelCompletenessRequirements modelCompletenessRequirements;

    public ResourceUtilizationHandler(KafkaCruiseControlConfig kccConfig, List<ResourceUtilizationDetector> detectors) {
        double minMonitoredPartitionPercentage = kccConfig.getDouble("min.valid.partition.ratio");
        this.modelCompletenessRequirements = new ModelCompletenessRequirements(1, minMonitoredPartitionPercentage, true);
        this.detectors = detectors;
    }

    public ModelCompletenessRequirements requirements() {
        return this.modelCompletenessRequirements;
    }

    public void detect(ClusterModel clusterModel) {
        try {
            LOG.info("Running resource utilization detector.");
            this.detectors.forEach(detector -> detector.detectResourceUtilization(clusterModel));
        }
        catch (Exception e) {
            LOG.error("Resetting all resource detectors because of an unexpected exception", (Throwable)e);
            this.detectors.forEach(ResourceUtilizationDetector::resetDetectorState);
        }
        finally {
            LOG.info("Resource utilization detection finished.");
        }
    }

    public void close() {
        this.detectors.forEach(detector -> KafkaCruiseControlUtils.executeSilently(detector, ResourceUtilizationDetector::close, () -> String.format("Failed to shutdown %s during the shutdown of ResourceUtilizationHandler.", detector.name())));
    }
}

