/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.metricsreporter.metric;

import com.linkedin.kafka.cruisecontrol.metricsreporter.exception.UnknownVersionException;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.BrokerMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.CruiseControlMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.PartitionMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.TopicMetric;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;

public class MetricSerde
implements Serializer<CruiseControlMetric>,
Deserializer<CruiseControlMetric> {
    private static final int METRIC_TYPE_OFFSET = 0;
    private static final int HEADER_LENGTH = 1;

    public static byte[] toBytes(CruiseControlMetric metric) {
        ByteBuffer byteBuffer = metric.toBuffer(1);
        byteBuffer.put(0, metric.metricClassId().id());
        return byteBuffer.array();
    }

    public static CruiseControlMetric fromBytes(byte[] bytes) throws UnknownVersionException {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        switch (CruiseControlMetric.MetricClassId.forId(buffer.get())) {
            case BROKER_METRIC: {
                return BrokerMetric.fromBuffer(buffer);
            }
            case TOPIC_METRIC: {
                return TopicMetric.fromBuffer(buffer);
            }
            case PARTITION_METRIC: {
                return PartitionMetric.fromBuffer(buffer);
            }
        }
        return null;
    }

    public CruiseControlMetric deserialize(String topic, byte[] bytes) {
        try {
            return MetricSerde.fromBytes(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred when deserialize Cruise Control metrics.", e);
        }
    }

    public void configure(Map<String, ?> map, boolean b) {
    }

    public byte[] serialize(String s, CruiseControlMetric cruiseControlMetric) {
        return MetricSerde.toBytes(cruiseControlMetric);
    }

    public void close() {
    }
}

