/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.metricsreporter.metric;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum RawMetricType {
    ALL_TOPIC_BYTES_IN(DesiredMetricUnit.KiB, MetricScope.BROKER, 0),
    ALL_TOPIC_BYTES_OUT(DesiredMetricUnit.KiB, MetricScope.BROKER, 1),
    TOPIC_BYTES_IN(DesiredMetricUnit.KiB, MetricScope.TOPIC, 2),
    TOPIC_BYTES_OUT(DesiredMetricUnit.KiB, MetricScope.TOPIC, 3),
    PARTITION_SIZE(DesiredMetricUnit.MiB, MetricScope.PARTITION, 4),
    BROKER_CPU_UTIL(DesiredMetricUnit.ORIGINAL, MetricScope.BROKER, 5),
    ALL_TOPIC_REPLICATION_BYTES_IN(DesiredMetricUnit.KiB, MetricScope.BROKER, 6),
    ALL_TOPIC_REPLICATION_BYTES_OUT(DesiredMetricUnit.KiB, MetricScope.BROKER, 7),
    ALL_TOPIC_PRODUCE_REQUEST_RATE(DesiredMetricUnit.ORIGINAL, MetricScope.BROKER, 8),
    ALL_TOPIC_FETCH_REQUEST_RATE(DesiredMetricUnit.ORIGINAL, MetricScope.BROKER, 9),
    ALL_TOPIC_MESSAGES_IN_PER_SEC(DesiredMetricUnit.ORIGINAL, MetricScope.BROKER, 10),
    TOPIC_REPLICATION_BYTES_IN(DesiredMetricUnit.KiB, MetricScope.TOPIC, 11),
    TOPIC_REPLICATION_BYTES_OUT(DesiredMetricUnit.KiB, MetricScope.TOPIC, 12),
    TOPIC_PRODUCE_REQUEST_RATE(DesiredMetricUnit.ORIGINAL, MetricScope.TOPIC, 13),
    TOPIC_FETCH_REQUEST_RATE(DesiredMetricUnit.ORIGINAL, MetricScope.TOPIC, 14),
    TOPIC_MESSAGES_IN_PER_SEC(DesiredMetricUnit.ORIGINAL, MetricScope.TOPIC, 15),
    BROKER_PRODUCE_REQUEST_RATE(DesiredMetricUnit.ORIGINAL, MetricScope.BROKER, 16),
    BROKER_CONSUMER_FETCH_REQUEST_RATE(DesiredMetricUnit.ORIGINAL, MetricScope.BROKER, 17),
    BROKER_FOLLOWER_FETCH_REQUEST_RATE(DesiredMetricUnit.ORIGINAL, MetricScope.BROKER, 18),
    BROKER_DISK_CAPACITY(DesiredMetricUnit.ORIGINAL, MetricScope.BROKER, 19),
    TOPIC_FOLLOWER_FETCH_REQUEST_RATE(DesiredMetricUnit.ORIGINAL, MetricScope.TOPIC, 20),
    ALL_TOPIC_FOLLOWER_FETCH_REQUEST_RATE(DesiredMetricUnit.ORIGINAL, MetricScope.BROKER, 21),
    TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT(DesiredMetricUnit.KiB, MetricScope.TOPIC, 22),
    ALL_TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT(DesiredMetricUnit.KiB, MetricScope.BROKER, 23),
    TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE(DesiredMetricUnit.ORIGINAL, MetricScope.TOPIC, 24),
    ALL_TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE(DesiredMetricUnit.ORIGINAL, MetricScope.BROKER, 25),
    MIRROR_TOPIC_BYTES_IN(DesiredMetricUnit.KiB, MetricScope.TOPIC, 26),
    ALL_MIRROR_TOPIC_BYTES_IN(DesiredMetricUnit.KiB, MetricScope.BROKER, 27),
    BROKER_PRODUCE_MIRROR_CAPACITY(DesiredMetricUnit.KiB, MetricScope.BROKER, 28),
    BROKER_CONSUME_CAPACITY(DesiredMetricUnit.KiB, MetricScope.BROKER, 29);

    private static final Set<RawMetricType> BROKER_METRIC_TYPES;
    private static final List<RawMetricType> TOPIC_METRIC_TYPES;
    private final byte id;
    private final MetricScope metricScope;
    private final DesiredMetricUnit desiredUnit;

    private RawMetricType(DesiredMetricUnit desiredUnit, MetricScope scope, byte id) {
        this.id = id;
        this.metricScope = scope;
        this.desiredUnit = desiredUnit;
    }

    public byte id() {
        return this.id;
    }

    public MetricScope metricScope() {
        return this.metricScope;
    }

    public DesiredMetricUnit desiredMetricUnit() {
        return this.desiredUnit;
    }

    public static List<RawMetricType> topicMetricTypes() {
        return TOPIC_METRIC_TYPES;
    }

    public static Set<RawMetricType> brokerMetricTypes() {
        return BROKER_METRIC_TYPES;
    }

    public double convertUnit(double value) {
        switch (this.desiredUnit.ordinal()) {
            case 0: {
                return value / 1024.0;
            }
            case 1: {
                return value / 1048576.0;
            }
            case 2: {
                return value;
            }
        }
        throw new IllegalArgumentException(String.format("Unhandled desired metric unit - %s", new Object[]{this.desiredUnit}));
    }

    public static RawMetricType forId(byte id) {
        if (id < RawMetricType.values().length) {
            return RawMetricType.values()[id];
        }
        throw new IllegalArgumentException("CruiseControlMetric type " + id + " does not exist.");
    }

    private static Set<RawMetricType> buildBrokerMetricTypes() {
        HashSet<RawMetricType> buildBrokerMetricTypes = new HashSet<RawMetricType>();
        for (RawMetricType type : RawMetricType.values()) {
            if (type.metricScope() != MetricScope.BROKER) continue;
            buildBrokerMetricTypes.add(type);
        }
        return buildBrokerMetricTypes;
    }

    private static List<RawMetricType> buildMetricTypeList(MetricScope metricScope) {
        ArrayList<RawMetricType> brokerMetricTypes = new ArrayList<RawMetricType>();
        for (RawMetricType type : RawMetricType.values()) {
            if (type.metricScope() != metricScope) continue;
            brokerMetricTypes.add(type);
        }
        return brokerMetricTypes;
    }

    static {
        BROKER_METRIC_TYPES = RawMetricType.buildBrokerMetricTypes();
        TOPIC_METRIC_TYPES = RawMetricType.buildMetricTypeList(MetricScope.TOPIC);
    }

    public static enum DesiredMetricUnit {
        KiB,
        MiB,
        ORIGINAL;

        static final int BYTES_IN_KIB = 1024;
        static final int BYTES_IN_MIB = 0x100000;
    }

    public static enum MetricScope {
        BROKER,
        TOPIC,
        PARTITION;

    }
}

