/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.ResourceUtilizationRatioThresholdsProvider;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Capacity;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Partition;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.ResourceStats;
import com.linkedin.kafka.cruisecontrol.model.Tenant;
import com.linkedin.kafka.cruisecontrol.model.Utilization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClusterModelHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterModelHelper.class);

    public static Set<Broker> brokersWithUtilizationUnderCapacityThreshold(Collection<Broker> brokers, Resource resource, double capacityThreshold) {
        ClusterModel.CapacityLimitProvider provider = broker -> ClusterModelHelper.resourceStatsFor(broker, resource).capacity().totalCapacityFor(resource) * capacityThreshold;
        return ClusterModelHelper.brokersWithUtilizationUnderCapacity(brokers, resource, provider);
    }

    public static Set<Broker> brokersWithUtilizationUnderCapacityThreshold(Collection<Broker> brokers, Resource resource, ClusterModel.ThresholdProvider thresholdProvider) {
        ClusterModel.CapacityLimitProvider capacityLimitProvider = broker -> ClusterModelHelper.resourceStatsFor(broker, resource).capacity().totalCapacityFor(resource) * thresholdProvider.threshold(broker);
        return ClusterModelHelper.brokersWithUtilizationUnderCapacity(brokers, resource, capacityLimitProvider);
    }

    public static Set<Broker> brokersWithUtilizationUnderCapacity(Collection<Broker> brokers, Resource resource, ClusterModel.CapacityLimitProvider capacityLimitProvider) {
        return brokers.stream().filter(broker -> {
            double capacity = capacityLimitProvider.capacityLimit((Broker)broker);
            double utilization = ClusterModelHelper.resourceStatsFor(broker, resource).load().expectedUtilizationFor(resource);
            return utilization < capacity;
        }).collect(Collectors.toSet());
    }

    public static Set<Broker> brokersWithUtilizationOverThreshold(Collection<Broker> originalBrokers, Resource resource, double utilizationThreshold) {
        return originalBrokers.stream().filter(broker -> ClusterModelHelper.resourceStatsInHierarchicalOrder(broker, resource).stream().anyMatch(stats -> {
            double capacity = stats.capacity().totalCapacityFor(resource) * utilizationThreshold;
            double utilization = stats.load().expectedUtilizationFor(resource);
            return utilization > capacity;
        })).collect(Collectors.toSet());
    }

    public static Set<Broker> brokersWithUtilizationOverLowUtilizationRatioThreshold(Collection<Broker> brokers, ResourceUtilizationRatioThresholdsProvider thresholds) {
        return brokers.stream().filter(broker -> ClusterModelHelper.resourceStatsInHierarchicalOrder(broker, thresholds.resource()).stream().anyMatch(stats -> {
            double capacity = stats.capacity().totalCapacityFor(thresholds.resource()) * thresholds.lowUtilizationRatio((Broker)broker);
            double utilization = stats.load().expectedUtilizationFor(thresholds.resource());
            return utilization > capacity;
        })).collect(Collectors.toSet());
    }

    public static ResourceStats resourceStatsFor(Broker broker, Resource resource) {
        if (resource.isBrokerResource()) {
            return broker;
        }
        if (resource.isHostResource()) {
            return broker.host();
        }
        throw new IllegalStateException(String.format("Provided %s resource is not broker or host level resource", new Object[]{resource}));
    }

    private static List<ResourceStats> resourceStatsInHierarchicalOrder(Broker broker, Resource resource) {
        ArrayList<ResourceStats> resourceStats = new ArrayList<ResourceStats>();
        if (resource.isBrokerResource()) {
            resourceStats.add(broker);
        }
        if (resource.isHostResource()) {
            resourceStats.add(broker.host());
        }
        return resourceStats;
    }

    public static Double calculateNormalizedStdDeviationOfRatio(List<? extends Number> values) {
        if (values.size() <= 1) {
            return 0.0;
        }
        double sum = values.stream().mapToDouble(Number::doubleValue).sum();
        double mean = sum / (double)values.size();
        double sumOfSquares = values.stream().mapToDouble(value -> Math.pow(1.0 - value.doubleValue() / mean, 2.0)).sum();
        double variance = sumOfSquares / (double)values.size();
        double stdDeviation = Math.sqrt(variance);
        double maxStdDeviation = Math.sqrt(values.size() - 1);
        int remainder = (int)(sum % (double)values.size());
        double minSumOfSquares = Math.pow(1.0 - Math.ceil(mean) / mean, 2.0) * (double)remainder + Math.pow(1.0 - Math.floor(mean) / mean, 2.0) * (double)(values.size() - remainder);
        double minStdDeviation = Math.sqrt(minSumOfSquares / (double)values.size());
        return (stdDeviation - minStdDeviation) / (maxStdDeviation - minStdDeviation);
    }

    public static Optional<Double> utilizationRatioForResource(Utilization utilization, Capacity capacity, Resource resource) {
        double eligibleDestinationCapacity = capacity.eligibleDestinationCapacityFor(resource);
        if (eligibleDestinationCapacity == 0.0) {
            return Optional.empty();
        }
        return Optional.of(utilization.eligibleSourceUtilization().map(load -> load.expectedUtilizationFor(resource) / eligibleDestinationCapacity).orElse(0.0));
    }

    public static boolean replicasAreInExpectedCell(ClusterModel clusterModel) {
        for (Replica leaderReplica : clusterModel.leaderReplicas()) {
            Partition partition;
            List<Replica> replicasNotInExpectedCells;
            List<Cell> expectedCells;
            Tenant tenant;
            Optional<Tenant> tenantOpt = clusterModel.tenantOfTopic(leaderReplica.topicPartition().topic());
            if (!tenantOpt.isPresent() || (tenant = tenantOpt.get()).placementPolicy() != PartitionPlacementStrategy.TENANT_IN_CELL || (expectedCells = tenant.cellIds().stream().map(clusterModel::cell).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty() || (replicasNotInExpectedCells = ClusterModelHelper.replicasNotInExpectedCells(partition = clusterModel.partition(leaderReplica.topicPartition()), expectedCells)).isEmpty()) continue;
            LOG.debug("ReplicasNotInExpectedCell: {}", replicasNotInExpectedCells);
            return false;
        }
        return true;
    }

    public static List<Replica> replicasNotInExpectedCell(Partition partition, Cell cell) {
        return partition.replicas().stream().filter(replica -> !replica.broker().cell().equals(cell)).collect(Collectors.toList());
    }

    public static List<Replica> replicasNotInExpectedCells(Partition partition, List<Cell> expectedCells) {
        return partition.replicas().stream().filter(replica -> !expectedCells.contains(replica.broker().cell())).collect(Collectors.toList());
    }
}

