/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.common.TopicPartition;

@Immutable
public class SampleIngestionResults {
    public final int numTotalSamples;
    public final int numSamplesAdded;
    public final int numSamplesDiscarded;
    public final int numEntities;
    public final int numAssignedPartitions;
    public final int numUnrecognizedEntities;
    public final List<TopicPartition> unrecognizedTopicPartitions;
    public static final SampleIngestionResults EMPTY = new SampleIngestionResults(0, 0, 0, 0, 0, 0, Collections.emptyList());

    private SampleIngestionResults(int numTotalSamples, int numSamplesAdded, int numSamplesDiscarded, int numEntities, int numAssignedPartitions, int numUnrecognizedEntities, List<TopicPartition> unrecognizedTopicPartitions) {
        this.numTotalSamples = numTotalSamples;
        this.numSamplesAdded = numSamplesAdded;
        this.numSamplesDiscarded = numSamplesDiscarded;
        this.numEntities = numEntities;
        this.numAssignedPartitions = numAssignedPartitions;
        this.numUnrecognizedEntities = numUnrecognizedEntities;
        this.unrecognizedTopicPartitions = unrecognizedTopicPartitions;
    }

    public boolean isEmpty() {
        return this.numSamplesAdded == 0;
    }

    public String toString() {
        return "SampleIngestionResults{numTotalSamples=" + this.numTotalSamples + ", numSamplesAdded=" + this.numSamplesAdded + ", numSamplesDiscarded=" + this.numSamplesDiscarded + ", numEntities=" + this.numEntities + ", numAssignedPartitions=" + this.numAssignedPartitions + ", numUnrecognizedEntities=" + this.numUnrecognizedEntities + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SampleIngestionResults that = (SampleIngestionResults)o;
        return this.numTotalSamples == that.numTotalSamples && this.numSamplesAdded == that.numSamplesAdded && this.numSamplesDiscarded == that.numSamplesDiscarded && this.numEntities == that.numEntities && this.numAssignedPartitions == that.numAssignedPartitions && this.numUnrecognizedEntities == that.numUnrecognizedEntities;
    }

    public int hashCode() {
        return Objects.hash(this.numTotalSamples, this.numSamplesAdded, this.numSamplesDiscarded, this.numEntities, this.numAssignedPartitions, this.numUnrecognizedEntities);
    }

    public static class Builder {
        private int numTotalSamples;
        private int numSamplesAdded;
        private int numSamplesDiscarded;
        private int numEntities;
        private int numAssignedPartitions;
        private int numUnrecognizedEntities;
        private List<TopicPartition> unrecognizedTopicPartitions = new ArrayList<TopicPartition>();

        public Builder numTotalSamples(int numTotalSamples) {
            this.numTotalSamples = numTotalSamples;
            return this;
        }

        public Builder numSamplesAdded(int numSamplesAdded) {
            this.numSamplesAdded = numSamplesAdded;
            return this;
        }

        public Builder numSamplesDiscarded(int numSamplesDiscarded) {
            this.numSamplesDiscarded = numSamplesDiscarded;
            return this;
        }

        public Builder numEntities(int numEntities) {
            this.numEntities = numEntities;
            return this;
        }

        public Builder numAssignedPartitions(int numAssignedPartitions) {
            this.numAssignedPartitions = numAssignedPartitions;
            return this;
        }

        public Builder numUnrecognizedEntities(int numUnrecognizedEntities) {
            this.numUnrecognizedEntities = numUnrecognizedEntities;
            return this;
        }

        public Builder unrecognizedTopicPartitions(List<TopicPartition> unrecognizedTopicPartitions) {
            this.unrecognizedTopicPartitions = unrecognizedTopicPartitions;
            return this;
        }

        public SampleIngestionResults build() {
            return new SampleIngestionResults(this.numTotalSamples, this.numSamplesAdded, this.numSamplesDiscarded, this.numEntities, this.numAssignedPartitions, this.numUnrecognizedEntities, this.unrecognizedTopicPartitions);
        }
    }
}

