/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.operation;

import com.linkedin.kafka.cruisecontrol.PlanComputationOptions;
import com.linkedin.kafka.cruisecontrol.async.progress.OperationProgress;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorReservationHandle;
import com.linkedin.kafka.cruisecontrol.executor.PartitionProposal;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalCallback;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;

public class BrokerRemovalContext {
    public final boolean shouldShutdown;
    public final BrokerRemovalCallback progressCallback;
    public final String uid;
    public final PlanComputationOptions planComputationOptions;
    public final OperationProgress operationProgress;
    private final AtomicReference<ExecutorReservationHandle> reservationHandle;
    public final Map<Integer, Optional<Long>> brokersToRemoveAndEpochs;
    public Set<PartitionProposal> proposals;
    private volatile Future<?> executorFuture;
    private volatile Optional<Boolean> planExecutionSuccess;
    private volatile Exception planExecutionException;

    public BrokerRemovalContext(Map<Integer, Optional<Long>> brokersToRemoveAndEpochs, boolean shouldShutdown, BrokerRemovalCallback progressCallback, String uid, PlanComputationOptions planComputationOptions, OperationProgress operationProgress) {
        this.brokersToRemoveAndEpochs = brokersToRemoveAndEpochs;
        this.shouldShutdown = shouldShutdown;
        this.progressCallback = progressCallback;
        this.uid = uid;
        this.planComputationOptions = planComputationOptions;
        this.operationProgress = operationProgress;
        this.reservationHandle = new AtomicReference();
        this.planExecutionSuccess = Optional.empty();
        this.planExecutionException = null;
    }

    public Set<Integer> brokersToRemove() {
        return new HashSet<Integer>(this.brokersToRemoveAndEpochs.keySet());
    }

    public void proposals(Set<PartitionProposal> proposals) {
        this.proposals = proposals;
    }

    public void executorFuture(Future<?> executorFuture) {
        this.executorFuture = executorFuture;
    }

    public AtomicReference<ExecutorReservationHandle> reservationHandle() {
        return this.reservationHandle;
    }

    public Optional<Future<?>> executorFuture() {
        return Optional.ofNullable(this.executorFuture);
    }

    public Optional<Boolean> planExecutionSuccess() {
        return this.planExecutionSuccess;
    }

    public void planExecutionSuccess(boolean executionSuccess) {
        this.planExecutionSuccess = Optional.of(executionSuccess);
    }

    public Exception planExecutionException() {
        return this.planExecutionException;
    }

    public void planExecutionException(Exception executionException) {
        this.planExecutionException = executionException;
    }
}

