/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.operation;

import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalCallback;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalContext;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalPhase;
import io.confluent.databalancer.operation.BrokerRemovalStateMachine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerRemovalRestartablePhase<T>
implements BrokerRemovalPhase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerRemovalRestartablePhase.class);
    private final BrokerRemovalPhase<T> phase;
    private final boolean alwaysExecute;
    private final BrokerRemovalCallback brokerRemovalStateTracker;
    private boolean hasSkippedExecution;

    private BrokerRemovalRestartablePhase(BrokerRemovalCallback brokerRemovalStateTracker, BrokerRemovalPhase<T> phase, boolean alwaysExecute) {
        this.brokerRemovalStateTracker = brokerRemovalStateTracker;
        this.phase = phase;
        this.alwaysExecute = alwaysExecute;
    }

    @Override
    public T execute(BrokerRemovalContext context) throws Exception {
        if (this.alwaysExecute || this.brokerRemovalStateTracker.currentState() == this.phase.startState()) {
            return this.phase.execute(context);
        }
        LOG.info("Skipping execution of {} as it doesn't match state machine state: {}", (Object)this.phase.startState(), this.brokerRemovalStateTracker.currentState());
        this.hasSkippedExecution = true;
        return null;
    }

    @Override
    public boolean hasSkippedExecution() {
        return this.hasSkippedExecution;
    }

    @Override
    public BrokerRemovalStateMachine.BrokerRemovalState startState() {
        return this.phase.startState();
    }

    public static class BrokerRemovalRestartablePhaseBuilder<T> {
        private BrokerRemovalPhase<T> phase;
        private boolean alwaysExecute = false;
        private BrokerRemovalCallback brokerRemovalStateTracker;

        public BrokerRemovalRestartablePhase<T> build() {
            return new BrokerRemovalRestartablePhase<T>(this.brokerRemovalStateTracker, this.phase, this.alwaysExecute);
        }

        public BrokerRemovalRestartablePhaseBuilder<T> setBrokerRemovalStateTracker(BrokerRemovalCallback brokerRemovalStateTracker) {
            this.brokerRemovalStateTracker = brokerRemovalStateTracker;
            return this;
        }

        public BrokerRemovalRestartablePhaseBuilder<T> setPhase(BrokerRemovalPhase<T> phase) {
            this.phase = phase;
            return this;
        }

        public BrokerRemovalRestartablePhaseBuilder<T> setAlwaysExecute(boolean alwaysExecute) {
            this.alwaysExecute = alwaysExecute;
            return this;
        }
    }
}

