/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.statemachine;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlContext;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlOperationMetricsTracker;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationResult;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizerResult;
import com.linkedin.kafka.cruisecontrol.async.progress.OperationProgress;
import com.linkedin.kafka.cruisecontrol.common.AdminClientResult;
import com.linkedin.kafka.cruisecontrol.config.GoalsConfig;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorReservationHandle;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalCallback;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalContext;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalFuture;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalPhase;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalPhaseBuilder;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalRestartablePhase;
import com.linkedin.kafka.cruisecontrol.statemachine.Task;
import io.confluent.databalancer.operation.BalanceOpExecutionCompletionCallback;
import io.confluent.databalancer.operation.BrokerRemovalStateMachine;
import io.confluent.databalancer.operation.EvenClusterLoadStateMachine;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.kafka.clients.admin.AlterBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.errors.BalancerOperationFailedException;
import org.apache.kafka.common.protocol.BalancerOperationOverriddenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerRemovalTask
implements Task {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerRemovalTask.class);
    private final String taskId;
    private final KafkaCruiseControl kafkaCruiseControl;
    private final KafkaCruiseControlContext kafkaCruiseControlContext;
    private final GoalsConfig goalConfig;
    private final BrokerRemovalFuture brokerRemovalFuture;

    public BrokerRemovalTask(String taskId, KafkaCruiseControl kafkaCruiseControl, KafkaCruiseControlContext context, GoalsConfig goalsConfig, boolean shouldShutdown, Map<Integer, Optional<Long>> brokersToRemoveAndEpochs, KafkaCruiseControlOperationMetricsTracker operationMetricsTracker, @Nonnull BalanceOpExecutionCompletionCallback executionCompletionCallback, @Nonnull BrokerRemovalCallback progressCallback) {
        this.taskId = taskId;
        this.kafkaCruiseControl = kafkaCruiseControl;
        this.kafkaCruiseControlContext = context;
        this.goalConfig = goalsConfig;
        this.brokerRemovalFuture = this.createBrokerRemoval(brokersToRemoveAndEpochs, shouldShutdown, operationMetricsTracker, executionCompletionCallback, progressCallback);
    }

    private BrokerRemovalFuture createBrokerRemoval(final Map<Integer, Optional<Long>> brokersToRemoveAndEpochs, boolean shouldShutdown, final KafkaCruiseControlOperationMetricsTracker operationMetricsTracker, final @Nonnull BalanceOpExecutionCompletionCallback executionCompletionCallback, @Nonnull BrokerRemovalCallback progressCallback) {
        OperationProgress operationProgress = new OperationProgress();
        final HashSet<Integer> brokersToRemove = new HashSet<Integer>(brokersToRemoveAndEpochs.keySet());
        final String logPrefix = BrokerRemovalCallback.logPrefix(this.taskId);
        final BrokerRemovalContext removalArgs = new BrokerRemovalContext(brokersToRemoveAndEpochs, shouldShutdown, progressCallback, this.taskId, this.kafkaCruiseControlContext.defaultPlanComputationOptions(), operationProgress);
        BrokerRemovalRestartablePhase<Void> reserveExecutorPhase = new BrokerRemovalRestartablePhase.BrokerRemovalRestartablePhaseBuilder().setAlwaysExecute(true).setPhase(new BrokerRemovalPhase<Void>(){

            @Override
            public Void execute(BrokerRemovalContext context) throws Exception {
                LOG.info("{} Reserving the Executor and aborting ongoing executions", (Object)logPrefix);
                BrokerRemovalTask.this.kafkaCruiseControlContext.evenClusterLoadStateManager().maybeRegisterEvent(EvenClusterLoadStateMachine.EvenClusterLoadEvent.REMOVE_BROKER_TRIGGERED, (Exception)new BalancerOperationOverriddenException("Even cluster load balancing operation was aborted by a higher priority 'Remove Broker' operation."));
                long start = BrokerRemovalTask.this.kafkaCruiseControlContext.time().hiResClockMs();
                ExecutorReservationHandle handle = BrokerRemovalTask.this.kafkaCruiseControlContext.executor().reserveAndAbortOngoingExecutions(Duration.ofMinutes(1L), false, String.format("A broker removal operation %s overrides the existing execution", BrokerRemovalTask.this.taskId));
                removalArgs.reservationHandle().set(handle);
                long end = BrokerRemovalTask.this.kafkaCruiseControlContext.time().hiResClockMs();
                LOG.info("{} Successfully reserved the Executor in {} ms", (Object)logPrefix, (Object)(end - start));
                return null;
            }

            @Override
            public BrokerRemovalStateMachine.BrokerRemovalState startState() {
                return null;
            }
        }).build();
        BrokerRemovalRestartablePhase<Void> initialPlanComputationPhase = new BrokerRemovalRestartablePhase.BrokerRemovalRestartablePhaseBuilder().setBrokerRemovalStateTracker(progressCallback).setPhase(new BrokerRemovalPhase<Void>(){

            @Override
            public Void execute(BrokerRemovalContext context) throws Exception {
                BrokerRemovalTask.this.kafkaCruiseControl.generateRemoveBrokerPlan(context.brokersToRemove(), BrokerRemovalTask.this.goalConfig, context.operationProgress, context.planComputationOptions, BrokerRemovalTask.this.kafkaCruiseControlContext, "compute initial removal plan (validation)", true);
                LOG.info("{} Successfully computed the remove broker plan", (Object)logPrefix);
                return null;
            }

            @Override
            public BrokerRemovalStateMachine.BrokerRemovalState startState() {
                return BrokerRemovalStateMachine.BrokerRemovalState.INITIAL_PLAN_COMPUTATION_INITIATED;
            }
        }).build();
        BrokerRemovalRestartablePhase<Void> brokerExclusionPhase = new BrokerRemovalRestartablePhase.BrokerRemovalRestartablePhaseBuilder().setBrokerRemovalStateTracker(progressCallback).setPhase(new BrokerRemovalPhase<Void>(){

            @Override
            public Void execute(BrokerRemovalContext context) throws Exception {
                LOG.info("{} Attempting to exclude brokers {} as part of broker removal operation", (Object)logPrefix, context.brokersToRemove());
                long start = BrokerRemovalTask.this.kafkaCruiseControlContext.time().hiResClockMs();
                AdminClientResult<AlterBrokerReplicaExclusionsResult.ExclusionsResult> exclusionResult = BrokerRemovalTask.this.kafkaCruiseControlContext.sbkAdminUtils().alterBrokerReplicaExclusions(new ExclusionOp(ExclusionOp.OpType.SET, BrokerRemovalTask.this.taskId), context.brokersToRemove());
                long end = BrokerRemovalTask.this.kafkaCruiseControlContext.time().hiResClockMs();
                LOG.info("{} Brokers {} had replica exclusion emplaced in {} milliseconds", new Object[]{logPrefix, context.brokersToRemove(), end - start});
                if (exclusionResult.hasException()) {
                    throw (Exception)exclusionResult.exception();
                }
                if (!exclusionResult.result().isSuccessful()) {
                    throw new BalancerOperationFailedException(String.format("Unable to set broker exclusions on brokers %s", context.brokersToRemove()));
                }
                return null;
            }

            @Override
            public BrokerRemovalStateMachine.BrokerRemovalState startState() {
                return BrokerRemovalStateMachine.BrokerRemovalState.EXCLUSION_INITIATED;
            }
        }).build();
        BrokerRemovalRestartablePhase<Void> planComputationPhase = new BrokerRemovalRestartablePhase.BrokerRemovalRestartablePhaseBuilder().setBrokerRemovalStateTracker(progressCallback).setPhase(new BrokerRemovalPhase<Void>(){

            @Override
            public Void execute(BrokerRemovalContext context) throws Exception {
                LOG.info("{} Beginning computation of broker removal plan", (Object)logPrefix);
                OptimizerResult plan = BrokerRemovalTask.this.kafkaCruiseControl.generateRemoveBrokerPlan(context.brokersToRemove(), BrokerRemovalTask.this.goalConfig, context.operationProgress, context.planComputationOptions, BrokerRemovalTask.this.kafkaCruiseControlContext, "compute actual removal plan (executable)", true);
                OptimizationResult optimizationResult = new OptimizationResult(plan);
                LOG.info("{} Computed broker removal plan {}", (Object)logPrefix, (Object)optimizationResult.proposalSummary("broker removal"));
                context.proposals(plan.goalProposals());
                return null;
            }

            @Override
            public BrokerRemovalStateMachine.BrokerRemovalState startState() {
                return BrokerRemovalStateMachine.BrokerRemovalState.PLAN_COMPUTATION_INITIATED;
            }
        }).build();
        BrokerRemovalRestartablePhase<Void> planExecutionPhase = new BrokerRemovalRestartablePhase.BrokerRemovalRestartablePhaseBuilder().setBrokerRemovalStateTracker(progressCallback).setPhase(new BrokerRemovalPhase<Void>(){

            @Override
            public Void execute(BrokerRemovalContext context) throws Exception {
                BalanceOpExecutionCompletionCallback onRemovalExecutionCompletion = (success, ex) -> {
                    operationMetricsTracker.completeOperation(KafkaCruiseControlOperationMetricsTracker.Operation.BROKER_REMOVAL);
                    context.planExecutionSuccess(success);
                    Exception exc = BrokerRemovalTask.this.maybeWrapException(ex);
                    context.planExecutionException(exc);
                };
                operationMetricsTracker.beginOperation(KafkaCruiseControlOperationMetricsTracker.Operation.BROKER_REMOVAL);
                Future<?> future = KafkaCruiseControl.executeRemoval(context.proposals, context.brokersToRemove(), BrokerRemovalTask.this.taskId, onRemovalExecutionCompletion, BrokerRemovalTask.this.kafkaCruiseControlContext);
                context.executorFuture(future);
                LOG.info("{} Successfully submitted the broker removal plan", (Object)logPrefix);
                future.get();
                if (context.planExecutionException() == null) {
                    LOG.info("{} execution completed with value: {}", (Object)logPrefix, context.planExecutionSuccess());
                } else {
                    LOG.info("{} execution completed with value: {}, exception", new Object[]{logPrefix, context.planExecutionSuccess(), context.planExecutionException()});
                }
                if (context.planExecutionException() != null) {
                    throw context.planExecutionException();
                }
                return null;
            }

            @Override
            public BrokerRemovalStateMachine.BrokerRemovalState startState() {
                return BrokerRemovalStateMachine.BrokerRemovalState.PLAN_EXECUTION_INITIATED;
            }
        }).build();
        BrokerRemovalRestartablePhase<Void> brokerShutdownPhase = new BrokerRemovalRestartablePhase.BrokerRemovalRestartablePhaseBuilder().setBrokerRemovalStateTracker(progressCallback).setPhase(new BrokerRemovalPhase<Void>(){

            @Override
            public Void execute(BrokerRemovalContext context) throws Exception {
                LOG.info("{} Attempting to shut down brokers {} as part of broker removal operation", (Object)logPrefix, (Object)brokersToRemove);
                long start = BrokerRemovalTask.this.kafkaCruiseControlContext.time().hiResClockMs();
                Map<Integer, Boolean> brokerShutdownResults = BrokerRemovalTask.this.kafkaCruiseControlContext.brokerShutdownManager().maybeShutdownBrokers(brokersToRemoveAndEpochs);
                long end = BrokerRemovalTask.this.kafkaCruiseControlContext.time().hiResClockMs();
                Set brokersShutdown = brokerShutdownResults.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
                Set brokersNotShutdown = brokerShutdownResults.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet());
                if (!brokersShutdown.isEmpty()) {
                    LOG.info("{} Brokers {} were shut down successfully in {} milliseconds (brokers being removed: {}) ", new Object[]{logPrefix, brokersShutdown, end - start, brokersToRemove});
                }
                if (!brokersNotShutdown.isEmpty()) {
                    LOG.info("{} Brokers {} were not shut down (already offline?) (brokers being removed: {})", new Object[]{logPrefix, brokersNotShutdown, brokersToRemove});
                }
                if (brokersShutdown.isEmpty() && brokersNotShutdown.isEmpty()) {
                    throw new IllegalStateException(String.format("%s shutdown of brokers %s had empty values for brokers shutdown/not-shutdown", logPrefix, brokersToRemoveAndEpochs.keySet()));
                }
                BrokerRemovalTask.this.kafkaCruiseControlContext.brokerShutdownManager().unregisterBrokers(brokerShutdownResults.keySet());
                return null;
            }

            @Override
            public BrokerRemovalStateMachine.BrokerRemovalState startState() {
                return BrokerRemovalStateMachine.BrokerRemovalState.BROKER_SHUTDOWN_INITIATED;
            }
        }).build();
        BrokerRemovalRestartablePhase<Void> brokerExclusionRemovalPhase = new BrokerRemovalRestartablePhase.BrokerRemovalRestartablePhaseBuilder().setBrokerRemovalStateTracker(progressCallback).setPhase(new BrokerRemovalPhase<Void>(){

            @Override
            public Void execute(BrokerRemovalContext context) throws Exception {
                long start = BrokerRemovalTask.this.kafkaCruiseControlContext.time().hiResClockMs();
                AdminClientResult<AlterBrokerReplicaExclusionsResult.ExclusionsResult> exclusionResult = BrokerRemovalTask.this.kafkaCruiseControlContext.sbkAdminUtils().alterBrokerReplicaExclusions(new ExclusionOp(ExclusionOp.OpType.DELETE, BrokerRemovalTask.this.taskId), context.brokersToRemove());
                long end = BrokerRemovalTask.this.kafkaCruiseControlContext.time().hiResClockMs();
                if (exclusionResult.hasException()) {
                    LOG.error("{} Unexpected exception while removing broker replica exclusions:", (Object)logPrefix, (Object)exclusionResult.exception());
                    throw new BalancerOperationFailedException("Exception while removing broker replica exclusions", exclusionResult.exception());
                }
                if (!exclusionResult.result().isSuccessful()) {
                    LOG.error("{} Exclusion removal had errors after {} ms: {}", new Object[]{logPrefix, end - start, exclusionResult.result().exclusionResultByBroker()});
                    throw new BalancerOperationFailedException(String.format("Unable to remove all broker exclusions on brokers %s with errors %s", context.brokersToRemove(), exclusionResult.result().exclusionResultByBroker()));
                }
                LOG.info("{} Broker replica exclusions removed in {} milliseconds (for brokers {})", new Object[]{logPrefix, end - start, context.brokersToRemove()});
                return null;
            }

            @Override
            public BrokerRemovalStateMachine.BrokerRemovalState startState() {
                return BrokerRemovalStateMachine.BrokerRemovalState.EXCLUSION_REMOVAL_INITIATED;
            }
        }).build();
        BrokerRemovalRestartablePhase<Void> removalOpCompletionPhase = new BrokerRemovalRestartablePhase.BrokerRemovalRestartablePhaseBuilder().setBrokerRemovalStateTracker(progressCallback).setAlwaysExecute(true).setPhase(new BrokerRemovalPhase<Void>(){

            @Override
            public Void execute(BrokerRemovalContext context) {
                boolean opSuccess = context.planExecutionSuccess().orElse(false);
                executionCompletionCallback.accept(opSuccess, context.planExecutionException());
                return null;
            }

            @Override
            public BrokerRemovalStateMachine.BrokerRemovalState startState() {
                return null;
            }
        }).build();
        BrokerRemovalPhaseBuilder brokerRemovalPhaseBuilder = new BrokerRemovalPhaseBuilder();
        return brokerRemovalPhaseBuilder.composeRemoval(removalArgs, progressCallback, reserveExecutorPhase, initialPlanComputationPhase, brokerExclusionPhase, planComputationPhase, planExecutionPhase, brokerShutdownPhase, brokerExclusionRemovalPhase, removalOpCompletionPhase);
    }

    private Exception maybeWrapException(Throwable ex) {
        Exception exc = ex == null ? null : (ex instanceof Exception ? (Exception)ex : new Exception(ex));
        return exc;
    }

    public BrokerRemovalFuture brokerRemovalFuture() {
        return this.brokerRemovalFuture;
    }

    @Override
    public String taskId() {
        return this.taskId;
    }

    @Override
    public void run() {
        try {
            this.brokerRemovalFuture.execute(Duration.ofMinutes(60L));
        }
        catch (Throwable cause) {
            LOG.error("Error when executing broker removal task.", cause);
        }
    }
}

