/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractTopicGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.ReplicaRelocationContext;
import com.linkedin.kafka.cruisecontrol.model.Tenant;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import io.confluent.cruisecontrol.analyzer.goals.TenantTopicDistributionStrategy;
import io.confluent.cruisecontrol.analyzer.goals.TenantTopicPartitionDistributionBasedStrategy;
import io.confluent.cruisecontrol.analyzer.goals.TopicRebalanceContext;
import io.confluent.databalancer.DatabalancerUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.common.TenantHelpers;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantAwareGoal
extends AbstractTopicGoal {
    private static final Logger LOG = LoggerFactory.getLogger(TenantAwareGoal.class);
    private final TenantTopicDistributionStrategy tenantTopicDistributionStrategy = new TenantTopicPartitionDistributionBasedStrategy();

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(1, 0.0, true, false);
    }

    @Override
    public String name() {
        return TenantAwareGoal.class.getSimpleName();
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean isHardGoal() {
        return true;
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) throws OptimizationFailureException {
        this.tenantTopicDistributionStrategy.init(this.topicsToRebalance(clusterModel, optimizationOptions.excludedTopics()), clusterModel);
    }

    @Override
    protected boolean shouldExcludeTopic(String topic, ClusterModel clusterModel) {
        try {
            if (DatabalancerUtils.expectedCellsForTenantTopic(clusterModel, topic).isEmpty()) {
                LOG.debug("Skipping topic {} because there are no expected cells for the topic.", (Object)topic);
                return true;
            }
        }
        catch (OptimizationFailureException e) {
            LOG.debug("Skipping topic {} because expected cells for the topic are not present in the cluster.", (Object)topic);
            return true;
        }
        boolean isTopicBalanced = this.isTopicBalanced(topic, clusterModel);
        if (isTopicBalanced) {
            LOG.debug("Skipping topic {} because it is already balanced.", (Object)topic);
        }
        return isTopicBalanced;
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, Set<String> excludedTopics) throws OptimizationFailureException {
        this.tenantTopicDistributionStrategy.postRebalanceCheck(clusterModel);
        DatabalancerUtils.ensureTenantAwareGoalConstraintsAreMet(clusterModel, excludedTopics);
        this.finish();
    }

    @Override
    protected List<String> topicsToRebalance(ClusterModel clusterModel, Set<String> excludedTopics) {
        if (clusterModel.skipCellBalancing()) {
            return Collections.emptyList();
        }
        return super.topicsToRebalance(clusterModel, excludedTopics);
    }

    @Override
    protected void rebalanceForTopic(String topic, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) throws OptimizationFailureException {
        TopicRebalanceContext topicRebalanceContext = new TopicRebalanceContext(topic, clusterModel, optimizedGoals, optimizationOptions, (replica, destinationBroker, replicaRelocationContext) -> this.relocateReplica(replica, destinationBroker, replicaRelocationContext, clusterModel));
        this.tenantTopicDistributionStrategy.rebalancetopic(topicRebalanceContext);
    }

    @Override
    protected double getTopicImbalanceScore(String topic, ClusterModel clusterModel) {
        return this.tenantTopicDistributionStrategy.getTopicImbalanceScore(topic, clusterModel);
    }

    protected boolean isTopicBalanced(String topic, ClusterModel clusterModel) {
        return this.tenantTopicDistributionStrategy.getTopicImbalanceScore(topic, clusterModel) == 0.0;
    }

    private void relocateReplica(Replica replica, Broker destinationBroker, ReplicaRelocationContext replicaRelocationContext, ClusterModel clusterModel) {
        this.relocateReplica(clusterModel, replica.topicPartition(), replica.broker().id(), destinationBroker.id(), replicaRelocationContext);
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        String tenantId = TenantHelpers.extractTenantPrefix((String)action.topic(), (boolean)false);
        if (clusterModel.skipCellBalancing() || !clusterModel.tenant(tenantId).isPresent()) {
            return ActionAcceptance.ACCEPT;
        }
        Cell destinationCell = clusterModel.broker(action.destinationBrokerId()).cell();
        return clusterModel.tenant(tenantId).map(t -> {
            PartitionPlacementStrategy strategy = t.placementPolicy();
            switch (strategy) {
                case CLUSTER_WIDE: {
                    return ActionAcceptance.ACCEPT;
                }
                case PARTITION_IN_CELL: 
                case TENANT_IN_CELL: {
                    List<Cell> expectedCells = DatabalancerUtils.expectedCellsForTenant(clusterModel, tenantId);
                    return expectedCells.contains(destinationCell) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
                }
            }
            return ActionAcceptance.REPLICA_REJECT;
        }).orElse(ActionAcceptance.ACCEPT);
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        Optional<String> tenantId;
        block3: {
            block2: {
                tenantId = action.replicaMoves().keySet().stream().findAny().map(DatabalancerUtils::getTenantId);
                if (clusterModel.skipCellBalancing()) break block2;
                if (tenantId.flatMap(clusterModel::tenant).isPresent()) break block3;
            }
            return ActionAcceptance.ACCEPT;
        }
        Set destinationCells = action.replicaMoves().values().stream().map(Broker::cell).collect(Collectors.toSet());
        return tenantId.flatMap(tId -> clusterModel.tenant((String)tId).map(tenant -> {
            PartitionPlacementStrategy strategy = tenant.placementPolicy();
            switch (strategy) {
                case CLUSTER_WIDE: {
                    return ActionAcceptance.ACCEPT;
                }
                case PARTITION_IN_CELL: {
                    return destinationCells.size() == 1 ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
                }
                case TENANT_IN_CELL: {
                    return this.tenantTopicDistributionStrategy.isPartitionMovementAcceptable(action, clusterModel, (Tenant)tenant) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
                }
            }
            return ActionAcceptance.REPLICA_REJECT;
        })).orElse(ActionAcceptance.ACCEPT);
    }

    @Override
    public boolean replicaActionSelfSatisfied(ClusterModel clusterModel, ReplicaBalancingAction action) {
        return true;
    }

    @Override
    public boolean partitionActionSelfSatisfied(ClusterModel clusterModel, PartitionBalancingAction action) {
        Optional<Tenant> tenant = clusterModel.tenant(TenantHelpers.extractTenantPrefix((String)action.topicPartition().topic(), (boolean)false));
        if (tenant.isPresent()) {
            return this.tenantTopicDistributionStrategy.isPartitionMovementAcceptable(action, clusterModel, tenant.get());
        }
        return false;
    }
}

