/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.link;

import io.confluent.kafka.link.LinkContext;
import org.apache.kafka.common.message.DescribeAclsResponseData;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LinkContextTest {
    @Test
    public void testClusterIdHandlingInMultiTenantEnv() {
        String clusterId = "lkc-123";
        String tenantPrefix = clusterId + "_";
        LinkContext linkContext = new LinkContext(tenantPrefix, "link1", "link-1", Boolean.valueOf(false));
        String val = "val";
        String res = linkContext.write(EntityType.CLUSTER_ID, val);
        Assertions.assertEquals((Object)clusterId, (Object)res);
    }

    @Test
    public void testClusterIdHandlingNotInMultiTenantEnv() {
        LinkContext linkContext = new LinkContext("", "link1", "link-1", Boolean.valueOf(false));
        String val = "val";
        String res = linkContext.write(EntityType.CLUSTER_ID, val);
        Assertions.assertEquals((Object)val, (Object)res);
    }

    @Test
    public void testAclResourceWithTenantPrefixWildcard() {
        String clusterId = "lkc-123";
        String tenantPrefix = clusterId + "_";
        LinkContext linkContext = new LinkContext(tenantPrefix, "link1", "link-1", Boolean.valueOf(false));
        DescribeAclsResponseData.DescribeAclsResource describeAclsResource = new DescribeAclsResponseData.DescribeAclsResource();
        describeAclsResource.setResourceName("*");
        describeAclsResource.setResourceType(ResourceType.TOPIC.code());
        describeAclsResource.setPatternType(PatternType.LITERAL.code());
        DescribeAclsResponseData.DescribeAclsResource res = (DescribeAclsResponseData.DescribeAclsResource)linkContext.read(EntityType.ACL_RESOURCE, (Message)describeAclsResource);
        Assertions.assertEquals((byte)PatternType.PREFIXED.code(), (byte)res.patternType());
        Assertions.assertEquals((Object)tenantPrefix, (Object)res.resourceName());
    }

    @Test
    public void testAclResourceWithTenantPrefixLiteral() {
        String clusterId = "lkc-123";
        String tenantPrefix = clusterId + "_";
        LinkContext linkContext = new LinkContext(tenantPrefix, "link1", "link-1", Boolean.valueOf(false));
        DescribeAclsResponseData.DescribeAclsResource describeAclsResource = new DescribeAclsResponseData.DescribeAclsResource();
        String resourceName = "resourceName";
        describeAclsResource.setResourceName(resourceName);
        describeAclsResource.setResourceType(ResourceType.TOPIC.code());
        describeAclsResource.setPatternType(PatternType.LITERAL.code());
        DescribeAclsResponseData.DescribeAclsResource res = (DescribeAclsResponseData.DescribeAclsResource)linkContext.read(EntityType.ACL_RESOURCE, (Message)describeAclsResource);
        Assertions.assertEquals((byte)PatternType.LITERAL.code(), (byte)res.patternType());
        Assertions.assertEquals((Object)(tenantPrefix + resourceName), (Object)res.resourceName());
    }

    @Test
    public void testAclResourceWithoutTenantPrefix() {
        LinkContext linkContext = new LinkContext("", "link1", "link-1", Boolean.valueOf(false));
        DescribeAclsResponseData.DescribeAclsResource describeAclsResource = new DescribeAclsResponseData.DescribeAclsResource();
        String resourceName = "resourceName";
        describeAclsResource.setResourceName(resourceName);
        describeAclsResource.setResourceType(ResourceType.TOPIC.code());
        describeAclsResource.setPatternType(PatternType.LITERAL.code());
        DescribeAclsResponseData.DescribeAclsResource res = (DescribeAclsResponseData.DescribeAclsResource)linkContext.read(EntityType.ACL_RESOURCE, (Message)describeAclsResource);
        Assertions.assertEquals((Object)res, (Object)describeAclsResource);
    }

    @Test
    public void testAclResourceWithoutTenantPrefixWildcard() {
        LinkContext linkContext = new LinkContext("", "link1", "link-1", Boolean.valueOf(false));
        DescribeAclsResponseData.DescribeAclsResource describeAclsResource = new DescribeAclsResponseData.DescribeAclsResource();
        describeAclsResource.setResourceName("*");
        describeAclsResource.setResourceType(ResourceType.TOPIC.code());
        describeAclsResource.setPatternType(PatternType.LITERAL.code());
        DescribeAclsResponseData.DescribeAclsResource res = (DescribeAclsResponseData.DescribeAclsResource)linkContext.read(EntityType.ACL_RESOURCE, (Message)describeAclsResource);
        Assertions.assertEquals((Object)res, (Object)describeAclsResource);
    }
}

