/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.link.integration;

import com.google.common.base.Strings;
import io.confluent.kafka.link.integration.ClusterLinkTestUtils;
import java.util.Collections;
import java.util.Properties;
import kafka.link.ClusterLinkControlPlaneMirrorResourceIntegrationTest;
import kafka.server.link.ClusterLinkConfig;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.collection.Map;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:shard_count:4"), @Tag(value="bazel:size:large")})
public class ClusterLinkPrefixControlPlaneMirrorResourceIntegrationTest
extends ClusterLinkControlPlaneMirrorResourceIntegrationTest {
    Long syncPeriod = 100L;
    String consumerGroup = "testGroup";

    public ClusterLinkPrefixControlPlaneMirrorResourceIntegrationTest() {
        this.clusterLinkPrefix_$eq("src_");
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testReplicaStatus(String quorum, boolean coordinator) {
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testMetadataCacheUpdateOnMirrorTopicStateChanges(String quorum, boolean useLinkCoordinator) {
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testCreateMirrorTopicMaxNameLength(String quorum, boolean coordinator) {
        String clusterLinkPrefix = "test_";
        String validTopic = Strings.repeat((String)"a", (int)(249 - clusterLinkPrefix.length()));
        String invalidTopic = Strings.repeat((String)"a", (int)(250 - clusterLinkPrefix.length()));
        this.sourceCluster().createTopic(validTopic, this.numPartitions(), (int)this.replicationFactor(), new Properties(), this.sourceCluster().listenerName(), this.sourceCluster().adminClientConfig());
        this.sourceCluster().createTopic(invalidTopic, this.numPartitions(), (int)this.replicationFactor(), new Properties(), this.sourceCluster().listenerName(), this.sourceCluster().adminClientConfig());
        Properties linkProps = this.destLinkProps((Map)ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap()));
        linkProps.setProperty(ClusterLinkConfig.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup));
        linkProps.setProperty(ClusterLinkConfig.ConsumerOffsetSyncMsProp(), String.valueOf(this.syncPeriod));
        linkProps.setProperty(ClusterLinkConfig.ClusterLinkPrefixProp(), clusterLinkPrefix);
        linkProps.setProperty(ClusterLinkConfig.ConsumerGroupPrefixEnableProp(), "false");
        this.createClusterLink(this.linkName(), linkProps, this.sourceLinkProps((Map)ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap())), false, true);
        Assertions.assertThrows(InvalidTopicException.class, () -> this.destCluster().linkTopic(invalidTopic, (short)2, this.linkName(), ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap()), clusterLinkPrefix), (String)"Mirror topic name cannot be more than 249 characters");
        Assertions.assertDoesNotThrow(() -> this.destCluster().linkTopic(validTopic, (short)2, this.linkName(), ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap()), clusterLinkPrefix));
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testStopMirrorAfterBrokerRestart(String quorum, boolean useLinkCoordinator) {
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDescribeMirrorWithRepairMirrorError(String quorum, boolean useLinkCoordinator) {
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testCreateMirrorTopicWithTopicPlacement(String quorum, boolean useLinkCoordinator) {
    }
}

