/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.test.AbstractMultiTenantKafkaIntegrationTest;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import kafka.metrics.BrokerWithMember;
import kafka.metrics.ConsumerLagEmitter;
import kafka.metrics.ConsumerLagEmitterIntegrationTest;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
public class MultiTenantConsumerLagEmitterIntegrationTest
extends AbstractMultiTenantKafkaIntegrationTest {
    private final SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
    private final String groupId = "test-group";
    private final String topic = "test-topic";

    @Override
    protected Properties nodeProps() {
        Properties props = super.nodeProps();
        props.put("confluent.consumer.lag.emitter.enabled", "true");
        props.put("confluent.consumer.lag.emitter.interval.ms", "1000");
        return props;
    }

    @ParameterizedTest
    @ValueSource(strings={"CLASSIC", "CONSUMER"})
    public void testMultiTenantConsumerLagMetrics(String groupProtocol) throws Throwable {
        this.setUp();
        this.createPhysicalAndLogicalClusters();
        LogicalClusterUser user1 = this.logicalCluster1.user(11);
        LogicalClusterUser user2 = this.logicalCluster2.user(21);
        KafkaProducer<String, String> producer1 = this.testHarness.createProducer(user1, this.securityProtocol);
        KafkaProducer<String, String> producer2 = this.testHarness.createProducer(user2, this.securityProtocol);
        Properties props = new Properties();
        props.put("group.protocol", groupProtocol);
        KafkaConsumer<String, String> consumer1 = this.testHarness.createConsumer(user1, "test-group", this.securityProtocol, Optional.empty(), props);
        KafkaConsumer<String, String> consumer2 = this.testHarness.createConsumer(user2, "test-group", this.securityProtocol);
        String prefixedTopic1 = user1.tenantPrefix() + "test-topic";
        String prefixedTopic2 = user2.tenantPrefix() + "test-topic";
        this.physicalCluster.kafkaCluster().createTopic(prefixedTopic1, 1, 1);
        this.physicalCluster.kafkaCluster().createTopic(prefixedTopic2, 1, 1);
        int firstMessageIndex = 0;
        KafkaTestUtils.sendRecords(producer1, "test-topic", firstMessageIndex, 100);
        KafkaTestUtils.sendRecords(producer2, "test-topic", firstMessageIndex, 200);
        KafkaTestUtils.consumeRecords(consumer1, "test-topic", firstMessageIndex, 100);
        KafkaTestUtils.consumeRecords(consumer2, "test-topic", firstMessageIndex, 200);
        consumer1.commitSync();
        consumer2.commitSync();
        BrokerWithMember serverWithMember1 = ConsumerLagEmitterIntegrationTest.findBrokerWithMember(this.physicalCluster.kafkaCluster().kafkaBrokers(), (String)(user1.tenantPrefix() + "test-group"), (GroupProtocol)GroupProtocol.of((String)groupProtocol));
        BrokerWithMember serverWithMember2 = ConsumerLagEmitterIntegrationTest.findBrokerWithMember(this.physicalCluster.kafkaCluster().kafkaBrokers(), (String)(user2.tenantPrefix() + "test-group"), (GroupProtocol)GroupProtocol.CLASSIC);
        this.assertConsumerLag(serverWithMember1, user1, groupProtocol, 0L);
        this.assertConsumerLag(serverWithMember2, user2, GroupProtocol.CLASSIC.toString(), 0L);
        KafkaTestUtils.sendRecords(producer1, "test-topic", 100, 400);
        KafkaTestUtils.sendRecords(producer2, "test-topic", 200, 500);
        this.assertConsumerLag(serverWithMember1, user1, groupProtocol, 400L);
        this.assertConsumerLag(serverWithMember2, user2, GroupProtocol.CLASSIC.toString(), 500L);
        this.assertConsumerLagEmitterLatency(serverWithMember1);
        KafkaTestUtils.consumeRecords(consumer1, "test-topic", 100, 400);
        KafkaTestUtils.consumeRecords(consumer2, "test-topic", 200, 500);
        consumer1.commitSync();
        consumer2.commitSync();
        this.assertConsumerLag(serverWithMember1, user1, groupProtocol, 0L);
        this.assertConsumerLag(serverWithMember2, user2, GroupProtocol.CLASSIC.toString(), 0L);
        this.assertConsumerLagEmitterLatency(serverWithMember1);
        this.assertConsumerLagEmitterLatency(serverWithMember2);
    }

    private void assertConsumerLag(BrokerWithMember serverWithMember, LogicalClusterUser user, String groupProtocol, long expectedLag) throws InterruptedException {
        TestUtils.waitForCondition(() -> this.verifyConsumerLagMetrics(serverWithMember, user, groupProtocol, expectedLag), (String)String.format("consumer lag should be %d", expectedLag));
    }

    private void assertConsumerLagEmitterLatency(BrokerWithMember serverWithMember) throws InterruptedException {
        TestUtils.waitForCondition(() -> this.verifyConsumerLagEmitterLatency(serverWithMember), (String)String.format("consumer lag emitter run should take 0 - 1 seconds.", new Object[0]));
        Assertions.assertTrue((boolean)this.verifyConsumerLagEmitterTimeSinceLastSuccessfulRun(serverWithMember));
    }

    private boolean verifyConsumerLagMetrics(BrokerWithMember serverWithMember, LogicalClusterUser user, String groupProtocol, Long expectedLag) {
        DescribeGroupsResponseData.DescribedGroupMember member = serverWithMember.member();
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("tenant", user.logicalClusterId);
        tags.put("consumer-group", "test-group");
        tags.put("member", member.memberId());
        tags.put("client-id", member.clientId());
        tags.put("group-protocol", groupProtocol);
        tags.put("topic", "test-topic");
        tags.put("partition", "0");
        Metrics metrics = serverWithMember.broker().metrics();
        KafkaMetric kafkaMetric = (KafkaMetric)metrics.metrics().get(metrics.metricName(ConsumerLagEmitter.ConsumerLagMetricName(), "tenant-metrics", tags));
        if (kafkaMetric == null) {
            return false;
        }
        return expectedLag.equals(kafkaMetric.metricValue());
    }

    private boolean verifyConsumerLagEmitterLatency(BrokerWithMember serverWithMember) {
        Metrics metrics = serverWithMember.broker().metrics();
        KafkaMetric kafkaMetric = (KafkaMetric)metrics.metrics().get(metrics.metricName(ConsumerLagEmitter.ExecutionTimeMetricName(), ConsumerLagEmitter.MetricGroupName()));
        if (kafkaMetric == null) {
            return false;
        }
        return this.isMetricValueInRange(kafkaMetric);
    }

    private boolean verifyConsumerLagEmitterTimeSinceLastSuccessfulRun(BrokerWithMember serverWithMember) {
        Metrics metrics = serverWithMember.broker().metrics();
        KafkaMetric kafkaMetric = (KafkaMetric)metrics.metrics().get(metrics.metricName(ConsumerLagEmitter.TimeSinceLastSuccessfulRunMsMetricName(), ConsumerLagEmitter.MetricGroupName()));
        if (kafkaMetric == null) {
            return false;
        }
        return this.isMetricValueInRange(kafkaMetric);
    }

    private boolean isMetricValueInRange(KafkaMetric kafkaMetric) {
        return (Long)kafkaMetric.metricValue() >= 0L && (Long)kafkaMetric.metricValue() < 1000L;
    }
}

