/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantInterceptorConfig;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.MultiTenantRequestContext;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.ZoneAlignment;
import io.confluent.kafka.multitenant.metrics.FetchApiSensorBuilder;
import io.confluent.kafka.multitenant.metrics.HotPartitionManager;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import io.confluent.kafka.multitenant.metrics.TenantMetricsTestUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.apache.kafka.server.metrics.ApiSensors;
import org.apache.kafka.server.metrics.MetricsBuilderContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;

public class FetchApiSensorBuilderTest {
    private static final ApiKeys FETCH = ApiKeys.FETCH;
    private static final String RACK = "zone-a";
    private static final String RACK_LIST = "zone-a,zone-b,zone-c";
    private Metrics metrics;
    private Time time;
    private TenantMetrics tenantMetrics;
    private HotPartitionManager hotPartitionManager;
    private MultiTenantPrincipal principal;
    MultiTenantRequestContext requestContext;
    MultiTenantInterceptorConfig configs;

    @BeforeEach
    public void setUp() {
        String tenantName = "tenant";
        String userName = "user1";
        this.time = new MockTime();
        this.metrics = new Metrics(this.time);
        TenantMetadata metadata = new TenantMetadata.Builder(tenantName, "u-1").build();
        this.principal = new MultiTenantPrincipal(userName, metadata);
        this.tenantMetrics = new TenantMetrics();
        this.hotPartitionManager = new HotPartitionManager(this.time);
        HashMap<String, Number> hotPartitionManagerConfig = new HashMap<String, Number>();
        hotPartitionManagerConfig.put("confluent.broker.limit.producer.bytes.per.second", ConfluentConfigs.BROKER_LIMIT_PRODUCER_DEFAULT);
        hotPartitionManagerConfig.put("confluent.broker.limit.consumer.bytes.per.second", ConfluentConfigs.BROKER_LIMIT_CONSUMER_DEFAULT);
        hotPartitionManagerConfig.put("confluent.hot.partition.ratio", 0.8);
        this.hotPartitionManager.configure(hotPartitionManagerConfig);
        this.configs = new MultiTenantInterceptorConfig(false, false, false, false, "replica-selector", RACK, RACK_LIST, null, "", true, false, false, null, false);
        this.requestContext = this.requestContext(this.configs, FETCH.latestVersion());
    }

    @AfterEach
    public void tearDown() {
        this.metrics.close();
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.FETCH)
    public void testResponseBytesFFFTagsAllFetchVersions(short version) {
        this.metrics = new Metrics(this.time);
        FetchRequestData data = new FetchRequestData().setRackId("invalid-zone");
        FetchRequest request = new FetchRequest(data, version);
        this.requestContext = this.requestContext(this.configs, version);
        Map<String, String> fetchResponseTags = this.tags(this.requestContext, ZoneAlignment.UNKNOWN.name(), String.valueOf(version >= 11));
        this.requestContext.parseRequest(request.serialize().buffer());
        TenantMetricsTestUtils.verifyMetrics(this.metrics, fetchResponseTags, true, Arrays.asList(TenantMetricsTestUtils.RESPONSE_METRICS));
        FetchResponseData responseData = new FetchResponseData();
        FetchResponse response = new FetchResponse(responseData);
        RequestContext.ResponseSend responseSend = this.requestContext.buildResponseSend((AbstractResponse)response);
        Assertions.assertEquals((int)2, (int)responseSend.getDelayedActions().size());
        responseSend.getDelayedActions().forEach(action -> action.run());
        TenantMetricsTestUtils.verifyMetrics(this.metrics, fetchResponseTags, false, Arrays.asList(TenantMetricsTestUtils.RESPONSE_METRICS));
    }

    @Test
    public void testAllFetchApiSensors() {
        FetchRequestData data = new FetchRequestData().setRackId("invalid-zone");
        FetchRequest request = new FetchRequest(data, FETCH.latestVersion());
        Map<String, String> requestTags = this.tags(this.requestContext);
        Map<String, String> fetchResponseTags = this.tags(this.requestContext, ZoneAlignment.UNKNOWN.name(), Boolean.toString(true));
        this.requestContext.parseRequest(request.serialize().buffer());
        TenantMetricsTestUtils.verifyMetrics(this.metrics, requestTags, false, Arrays.asList(TenantMetricsTestUtils.REQUEST_METRICS));
        TenantMetricsTestUtils.verifyMetrics(this.metrics, fetchResponseTags, true, Arrays.asList(TenantMetricsTestUtils.RESPONSE_METRICS));
        this.time.sleep(100L);
        FetchResponseData responseData = new FetchResponseData();
        FetchResponse response = new FetchResponse(responseData);
        RequestContext.ResponseSend responseSend = this.requestContext.buildResponseSend((AbstractResponse)response);
        Assertions.assertEquals((int)2, (int)responseSend.getDelayedActions().size());
        responseSend.getDelayedActions().forEach(action -> action.run());
        TenantMetricsTestUtils.verifyMetrics(this.metrics, fetchResponseTags, false, Arrays.asList(TenantMetricsTestUtils.RESPONSE_METRICS));
        TenantMetricsTestUtils.verifyMetrics(this.metrics, requestTags, false, Arrays.asList(TenantMetricsTestUtils.RESPONSE_TIME_METRICS));
    }

    @Test
    public void testReinitializeFetchApiSensors() {
        FetchRequestData data = new FetchRequestData().setRackId("invalid-zone");
        FetchRequest request = new FetchRequest(data, FETCH.latestVersion());
        Map<String, String> fetchResponseTags = this.tags(this.requestContext, ZoneAlignment.UNKNOWN.name(), Boolean.toString(true));
        this.requestContext.parseRequest(request.serialize().buffer());
        TenantMetricsTestUtils.verifyMetrics(this.metrics, fetchResponseTags, true, Arrays.asList(TenantMetricsTestUtils.RESPONSE_METRICS));
        FetchResponseData responseData = new FetchResponseData();
        FetchResponse response = new FetchResponse(responseData);
        RequestContext.ResponseSend responseSend = this.requestContext.buildResponseSend((AbstractResponse)response);
        Assertions.assertEquals((int)2, (int)responseSend.getDelayedActions().size());
        responseSend.getDelayedActions().forEach(action -> action.run());
        TenantMetricsTestUtils.verifyMetrics(this.metrics, fetchResponseTags, false, Arrays.asList(TenantMetricsTestUtils.RESPONSE_METRICS));
        this.metrics.removeSensor("UNKNOWN-response-byte:request-Fetch:tenant-tenant:user-user1:user-resource-id-u-1:application-identity-default");
        Assertions.assertTrue((boolean)((ApiSensors)this.tenantMetrics.apiSensors.get(ApiKeys.FETCH)).responseSensorsExpired(this.metrics));
        this.requestContext = this.requestContext(this.configs, FETCH.latestVersion());
        this.requestContext.parseRequest(request.serialize().buffer());
        response = new FetchResponse(responseData);
        responseSend = this.requestContext.buildResponseSend((AbstractResponse)response);
        Assertions.assertEquals((int)2, (int)responseSend.getDelayedActions().size());
        responseSend.getDelayedActions().forEach(action -> action.run());
        TenantMetricsTestUtils.verifyMetrics(this.metrics, fetchResponseTags, false, Arrays.asList(TenantMetricsTestUtils.RESPONSE_METRICS));
    }

    @Test
    public void testFetchResponseByteSensorNoFetchFromFollower() {
        MultiTenantInterceptorConfig configs = new MultiTenantInterceptorConfig(false, false, false, false, null, RACK, RACK_LIST, null, "", true, false, false, null, false);
        MultiTenantRequestContext requestContext = this.requestContext(configs, FETCH.latestVersion());
        List<String> responseByteMetrics = Arrays.asList("response-byte-total", "response-byte-min", "response-byte-max", "response-byte-avg", "response-byte-rate");
        FetchRequest request = new FetchRequest(new FetchRequestData(), FETCH.latestVersion());
        Map<String, String> noZoneAlignmentFetchResponseTags = this.tags(requestContext);
        requestContext.parseRequest(request.serialize().buffer());
        TenantMetricsTestUtils.verifyMetrics(this.metrics, noZoneAlignmentFetchResponseTags, true, responseByteMetrics);
        this.time.sleep(100L);
        FetchResponseData responseData = new FetchResponseData();
        FetchResponse response = new FetchResponse(responseData);
        RequestContext.ResponseSend responseSend = requestContext.buildResponseSend((AbstractResponse)response);
        Assertions.assertEquals((int)2, (int)responseSend.getDelayedActions().size());
        responseSend.getDelayedActions().forEach(action -> action.run());
        TenantMetricsTestUtils.verifyMetrics(this.metrics, noZoneAlignmentFetchResponseTags, false, responseByteMetrics);
        TenantMetricsTestUtils.verifyMetrics(this.metrics, noZoneAlignmentFetchResponseTags, false, Arrays.asList(TenantMetricsTestUtils.RESPONSE_TIME_METRICS));
    }

    @Test
    public void testResponseBytesZoneAlignmentTag() {
        HashMap<String, String> zones = new HashMap<String, String>();
        zones.put(RACK, ZoneAlignment.SAME_ZONE.name());
        zones.put("zone-b", ZoneAlignment.CROSS_ZONE.name());
        zones.put("invalid-zone", ZoneAlignment.UNKNOWN.name());
        for (String zone : zones.keySet()) {
            this.metrics = new Metrics(this.time);
            this.tenantMetrics = new TenantMetrics();
            this.requestContext = this.requestContext(this.configs, FETCH.latestVersion());
            String expectedZoneAlignment = (String)zones.get(zone);
            FetchRequestData data = new FetchRequestData().setRackId(zone);
            FetchRequest request = new FetchRequest(data, FETCH.latestVersion());
            this.requestContext.parseRequest(request.serialize().buffer());
            FetchResponseData responseData = new FetchResponseData();
            FetchResponse response = new FetchResponse(responseData);
            RequestContext.ResponseSend responseSend = this.requestContext.buildResponseSend((AbstractResponse)response);
            Assertions.assertEquals((int)2, (int)responseSend.getDelayedActions().size());
            responseSend.getDelayedActions().forEach(action -> action.run());
            for (String zoneState : zones.values()) {
                Map<String, String> fetchResponseTags = this.tags(this.requestContext, zoneState, Boolean.toString(true));
                boolean isExpectedZoneAlignment = zoneState.equals(expectedZoneAlignment);
                if (isExpectedZoneAlignment) {
                    TenantMetricsTestUtils.verifyMetrics(this.metrics, fetchResponseTags, false, Arrays.asList(TenantMetricsTestUtils.RESPONSE_METRICS));
                    continue;
                }
                TenantMetricsTestUtils.verifyMetrics(this.metrics, fetchResponseTags, Arrays.asList(TenantMetricsTestUtils.RESPONSE_METRICS), false);
            }
        }
    }

    @Test
    public void testUpdateFFFSensors() {
        ApiSensors fetchApiSensors = new FetchApiSensorBuilder(this.metrics, (MetricsBuilderContext)new TenantMetrics.MetricsRequestContext(this.principal, "consumer-0", ApiKeys.FETCH), ApiKeys.FETCH, ZoneAlignment.SAME_ZONE, false).build();
        String expectedSensorName = String.format("SAME_ZONE-response-byte:request-Fetch%s", this.requestContext.metricsRequestContext().sensorSuffix());
        Assertions.assertEquals((Object)expectedSensorName, (Object)fetchApiSensors.responseByteSensor().name());
        HashMap<String, String> expectedTags = new HashMap<String, String>();
        expectedTags.put("zone-alignment", ZoneAlignment.SAME_ZONE.name());
        expectedTags.put("is-supported-fff-client", Boolean.toString(false));
        expectedTags.put("request", ApiKeys.FETCH.name);
        expectedTags.put("tenant", this.principal.tenantMetadata().tenantName);
        expectedTags.put("user", this.principal.user());
        expectedTags.put("user-resource-id", this.principal.tenantMetadata().userResourceId);
        Assertions.assertNotNull((Object)this.metrics.metricName("response-byte-total", "tenant-metrics", expectedTags));
    }

    private MultiTenantRequestContext requestContext(MultiTenantInterceptorConfig configs, short version) {
        RequestHeader header = this.requestHeader(version);
        return new MultiTenantRequestContext(header, "connection-id", 123L, null, Optional.empty(), this.principal, new ListenerName("listener"), SecurityProtocol.SASL_PLAINTEXT, ClientInformation.EMPTY, null, this.time, this.metrics, this.tenantMetrics, this.hotPartitionManager, configs, Optional.empty(), false, Optional.empty(), null, null, false, null, false);
    }

    private RequestHeader requestHeader(short version) {
        return new RequestHeader(FETCH, version, "test-client", 23);
    }

    private Map<String, String> tags(MultiTenantRequestContext requestContext) {
        return this.tags(requestContext, null, null);
    }

    private Map<String, String> tags(MultiTenantRequestContext requestContext, String zoneState, String isSupportedFFFClient) {
        Map tags = requestContext.metricsRequestContext().metricTags();
        tags.put("request", requestContext.metricsRequestContext().apiKey().name);
        if (zoneState != null) {
            tags.put("zone-alignment", zoneState);
        }
        if (isSupportedFFFClient != null) {
            tags.put("is-supported-fff-client", isSupportedFFFClient);
        }
        return tags;
    }
}

