/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantInterceptor;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.apache.kafka.server.link.ClusterLinkSourceMetricsTest;
import org.junit.jupiter.api.Assertions;

public class MultiTenantClusterLinkSourceMetricsTest
extends ClusterLinkSourceMetricsTest {
    private final String tenant = "tenant";

    protected BrokerInterceptor createInterceptor(Time time, boolean metricReductionEnabled) {
        HashMap<String, Serializable> configs = new HashMap<String, Serializable>();
        configs.put("broker.id", Integer.valueOf(1));
        configs.put("default.replication.factor", Short.valueOf((short)1));
        configs.put("num.partitions", Integer.valueOf(1));
        configs.put("confluent.multitenant.listener.hostname.cluster.prefix.enable", Boolean.valueOf(false));
        configs.put("confluent.multitenant.interceptor.balancer.apis.enabled", Boolean.valueOf(false));
        configs.put("confluent.schema.validator.multitenant.enable", Boolean.valueOf(false));
        configs.put("confluent.multitenant.listener.hostname.subdomain.suffix.enable", Boolean.valueOf(false));
        configs.put("confluent.subdomain.separator.map", null);
        configs.put("confluent.fetch.from.follower.require.leader.epoch.enable", Boolean.valueOf(true));
        configs.put("confluent.broker.limit.producer.bytes.per.second", ConfluentConfigs.BROKER_LIMIT_PRODUCER_DEFAULT);
        configs.put("confluent.broker.limit.consumer.bytes.per.second", ConfluentConfigs.BROKER_LIMIT_CONSUMER_DEFAULT);
        configs.put("confluent.hot.partition.ratio", Double.valueOf(0.8));
        configs.put("confluent.cluster.link.enable.metrics.reduction.advanced", Boolean.valueOf(metricReductionEnabled));
        configs.put("confluent.ppv2.endpoint.scheme.enable", Boolean.valueOf(false));
        MultiTenantInterceptor interceptor = new MultiTenantInterceptor(time);
        interceptor.configure(configs);
        return interceptor;
    }

    protected KafkaPrincipal createPrincipal() {
        return new MultiTenantPrincipal("user", new TenantMetadata("tenant", "tenant"));
    }

    protected String responseTopic() {
        return "tenant_topic";
    }

    protected void verifyMetrics(Uuid linkId, boolean metricReductionEnabled) {
        super.verifyMetrics(linkId, metricReductionEnabled);
        Set metricNames = this.metrics.metrics().keySet().stream().filter(m -> m.tags().containsKey("link-id")).collect(Collectors.toSet());
        for (MetricName metricName : metricNames) {
            Assertions.assertEquals((Object)"tenant", metricName.tags().get("tenant"));
        }
        Set tenantMetrics = this.metrics.metrics().keySet().stream().filter(m -> m.group().equals("tenant-metrics")).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)tenantMetrics.isEmpty(), (String)tenantMetrics.toString());
    }
}

