/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.server.plugins.auth.SniValidationMode;
import java.util.Optional;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SniValidationModeTest {
    private static final String UNRECOGNIZED_MODE = "unrecognized_mode";
    private static final String EXPECTED_LKC = "lkc-123";
    private static final String WRONG_LKC = "lkc-wrong";
    private static final String WRONG_PKC = "pkc-wrong";
    private static final String HOST_NAME_SUFFIX = "-00aa.confluent.io";

    @Test
    public void fromStringTest() {
        Assertions.assertEquals((Object)SniValidationMode.OPTIONAL_VALIDATION, (Object)SniValidationMode.fromString(null), (String)"Should return optional_validation if input is null");
        Assertions.assertEquals((Object)SniValidationMode.OPTIONAL_VALIDATION, (Object)SniValidationMode.fromString((String)UNRECOGNIZED_MODE), (String)"Should return optional_validation if input is not recognized");
        Assertions.assertEquals((Object)SniValidationMode.OPTIONAL_VALIDATION, (Object)SniValidationMode.fromString((String)SniValidationMode.OPTIONAL_VALIDATION.getText()), (String)"Should parse optional_validation successfully");
        Assertions.assertEquals((Object)SniValidationMode.ALLOW_LEGACY_BOOTSTRAP, (Object)SniValidationMode.fromString((String)SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.getText()), (String)"Should parse allow_legacy_bootstrap successfully");
        Assertions.assertEquals((Object)SniValidationMode.STRICT, (Object)SniValidationMode.fromString((String)SniValidationMode.STRICT.getText()), (String)"Should parse strict successfully");
    }

    @Test
    public void isSniHostNameMatchedOptionalTest() {
        Assertions.assertTrue((boolean)SniValidationMode.OPTIONAL_VALIDATION.sniHostNameMatches(EXPECTED_LKC, Optional.of(EXPECTED_LKC), this.constructSNIHostNameFor(EXPECTED_LKC)), (String)"SNI hostname should match if the supplied cluster name is the same as expected in optional mode");
        Assertions.assertTrue((boolean)SniValidationMode.OPTIONAL_VALIDATION.sniHostNameMatches(EXPECTED_LKC, Optional.empty(), this.constructSNIHostNameFor(WRONG_PKC)), (String)"SNI hostname should match regardless in optional mode");
        Assertions.assertTrue((boolean)SniValidationMode.OPTIONAL_VALIDATION.sniHostNameMatches(EXPECTED_LKC, Optional.empty(), Optional.empty()), (String)"SNI hostname should match if hostname is empty in optional mode");
        Assertions.assertFalse((boolean)SniValidationMode.OPTIONAL_VALIDATION.sniHostNameMatches(EXPECTED_LKC, Optional.of(WRONG_LKC), this.constructSNIHostNameFor(WRONG_LKC)), (String)"SNI hostname shouldn't match in optional mode if supplied cluster name is different from expected");
    }

    @Test
    public void isSniHostNameMatchedLegacyTest() {
        Assertions.assertTrue((boolean)SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.sniHostNameMatches(EXPECTED_LKC, Optional.of(EXPECTED_LKC), this.constructSNIHostNameFor(EXPECTED_LKC)), (String)"SNI hostname should match if supplied cluster name is the same as expected in legacy mode");
        Assertions.assertTrue((boolean)SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.sniHostNameMatches(EXPECTED_LKC, Optional.empty(), this.constructSNIHostNameFor(WRONG_PKC)), (String)"SNI hostname should match in legacy mode if supplied cluster name starts with `pkc-`. We accept any SNI hostname that starts with `pkc-` since it is the bootstrap path and we don't have a mapping for the correct PKC.");
        Assertions.assertFalse((boolean)SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.sniHostNameMatches(EXPECTED_LKC, Optional.of(WRONG_LKC), this.constructSNIHostNameFor(WRONG_LKC)), (String)"SNI hostname shouldn't match in legacy mode if supplied cluster name is different from expected");
        Assertions.assertFalse((boolean)SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.sniHostNameMatches(EXPECTED_LKC, Optional.empty(), Optional.empty()), (String)"SNI hostname shouldn't match in legacy mode if cluster name is not supplied");
    }

    @Test
    public void isSniHostNameMatchedStrictTest() {
        Assertions.assertTrue((boolean)SniValidationMode.STRICT.sniHostNameMatches(EXPECTED_LKC, Optional.of(EXPECTED_LKC), this.constructSNIHostNameFor(EXPECTED_LKC)), (String)"SNI hostname should match if the supplied cluster name is the same as expected in strict mode");
        Assertions.assertFalse((boolean)SniValidationMode.STRICT.sniHostNameMatches(EXPECTED_LKC, Optional.of(WRONG_LKC), this.constructSNIHostNameFor(WRONG_LKC)), (String)"SNI hostname shouldn't match if the supplied cluster name is not the same as expected in strict mode");
        Assertions.assertFalse((boolean)SniValidationMode.STRICT.sniHostNameMatches(EXPECTED_LKC, Optional.empty(), this.constructSNIHostNameFor(WRONG_PKC)), (String)"SNI hostname shouldn't match if supplied cluster name is not the same as expected even if it starts with `pkc-` in strict mode");
        Assertions.assertFalse((boolean)SniValidationMode.STRICT.sniHostNameMatches(EXPECTED_LKC, Optional.empty(), Optional.empty()), (String)"SNI hostname shouldn't match if supplied cluster name is not supplied in strict mode");
    }

    private Optional<PathAwareSniHostName> constructSNIHostNameFor(String clusterId) {
        return Optional.of(new PathAwareSniHostName(clusterId + HOST_NAME_SUFFIX));
    }
}

