/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Histogram;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbstractLog;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.log.OffsetsToClean;
import kafka.log.PreCleanStats;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.storage.internals.checkpoint.OffsetCheckpointFile;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0005b!B/_\u0001y\u0013\u0007\u0002C8\u0001\u0005\u000b\u0007I\u0011A9\t\u0013\u0005\u0005\u0001A!A!\u0002\u0013\u0011\bBCA\u0002\u0001\t\u0015\r\u0011\"\u0001\u0002\u0006!Q\u00111\u0006\u0001\u0003\u0002\u0003\u0006I!a\u0002\t\u0015\u00055\u0002A!b\u0001\n\u0003\ty\u0003\u0003\u0006\u0002D\u0001\u0011\t\u0011)A\u0005\u0003cAq!!\u0012\u0001\t\u0003\t9\u0005C\u0005\u0002R\u0001\u0011\r\u0011\"\u0003\u0002T!A\u0011Q\r\u0001!\u0002\u0013\t)\u0006C\u0004\u0002h\u0001!\t&!\u001b\t\u0015\u0005\u0005\u0005A1A\u0005\u0002y\u000b\u0019\t\u0003\u0005\u0002\u0010\u0002\u0001\u000b\u0011BAC\u0011%\t\t\n\u0001a\u0001\n\u0013\t\u0019\nC\u0005\u0002.\u0002\u0001\r\u0011\"\u0003\u00020\"A\u00111\u0018\u0001!B\u0013\t)\nC\u0005\u0002F\u0002\u0011\r\u0011\"\u0003\u0002H\"A\u00111\u001c\u0001!\u0002\u0013\tI\rC\u0005\u0002^\u0002\u0011\r\u0011\"\u0003\u0002`\"A\u0011\u0011\u001e\u0001!\u0002\u0013\t\t\u000fC\u0005\u0002l\u0002\u0011\r\u0011\"\u0003\u0002n\"A!1\u0001\u0001!\u0002\u0013\ty\u000fC\u0005\u0003\u0006\u0001\u0011\r\u0011\"\u0003\u0003\b!A!q\u0002\u0001!\u0002\u0013\u0011I\u0001C\u0005\u0003\u0012\u0001\u0011\r\u0011\"\u0001\u0003\u0014!A!\u0011\u0005\u0001!\u0002\u0013\u0011)\u0002C\u0005\u0003$\u0001\u0011\r\u0011\"\u0001\u0003\u0014!A!Q\u0005\u0001!\u0002\u0013\u0011)\u0002C\u0005\u0003(\u0001\u0011\r\u0011\"\u0001\u0003\u0014!A!\u0011\u0006\u0001!\u0002\u0013\u0011)\u0002C\u0005\u0003,\u0001\u0001\r\u0011\"\u0001\u0003.!I!Q\u0007\u0001A\u0002\u0013\u0005!q\u0007\u0005\t\u0005w\u0001\u0001\u0015)\u0003\u00030!Q!q\b\u0001C\u0002\u0013\u0005aL!\u0011\t\u0011\tM\u0003\u0001)A\u0005\u0005\u0007B\u0011B!\u0016\u0001\u0001\u0004%IAa\u0016\t\u0013\t}\u0003\u00011A\u0005\n\t\u0005\u0004\u0002\u0003B3\u0001\u0001\u0006KA!\u0017\t\u0013\t%\u0004A1A\u0005\n\t-\u0004\u0002\u0003BB\u0001\u0001\u0006IA!\u001c\t\u000f\t\u0015\u0005\u0001\"\u0001\u0003\b\"A!Q\u0012\u0001\u0005\u0002y\u0013y\t\u0003\u0005\u0003\u001c\u0002!\tA\u0018BO\u0011\u001d\u0011)\u000b\u0001C\u0001\u0005OC\u0011B!3\u0001#\u0003%\tAa3\t\u000f\t\u0005\b\u0001\"\u0001\u0003d\"9!\u0011\u001f\u0001\u0005\u0002\t\r\bb\u0002Bz\u0001\u0011\u0005!Q\u001f\u0005\b\u0005w\u0004A\u0011\u0001B\u007f\u0011\u001d\u0019\t\u0001\u0001C\u0001\u0007\u0007Aqaa\u0003\u0001\t\u0013\u0019i\u0001C\u0004\u0004\u001c\u0001!Ia!\b\t\u000f\r\u0005\u0002\u0001\"\u0001\u0004$!91q\u0005\u0001\u0005\u0002\r%\u0002\"CB!\u0001E\u0005I\u0011AB\"\u0011%\u00199\u0005AI\u0001\n\u0003\u0019I\u0005C\u0004\u0004N\u0001!\taa\u0014\t\u000f\rm\u0003\u0001\"\u0001\u0004^!911\r\u0001\u0005\u0002\r\u0015\u0004bBB8\u0001\u0011\u00051\u0011\u000f\u0005\b\u0007w\u0002A\u0011AB?\u0011!\ti\u000e\u0001C\u0001=\u000e\u0005\u0005bBBF\u0001\u0011\u00051Q\u0012\u0005\b\u0007+\u0003A\u0011ABL\u0011\u001d\u0019i\n\u0001C\u0001\u0007?Cqa!)\u0001\t\u0003\u0019yjB\u0004\u0004$zC\ta!*\u0007\rus\u0006\u0012ABT\u0011\u001d\t)e\u0011C\u0001\u0007SC\u0011ba+D\u0005\u0004%I!a!\t\u0011\r56\t)A\u0005\u0003\u000bC\u0011ba,D\u0005\u0004%I!a!\t\u0011\rE6\t)A\u0005\u0003\u000bC\u0011ba-D\u0005\u0004%I!a!\t\u0011\rU6\t)A\u0005\u0003\u000bC\u0011ba.D\u0005\u0004%I!a!\t\u0011\re6\t)A\u0005\u0003\u000bC\u0011ba/D\u0005\u0004%I!a!\t\u0011\ru6\t)A\u0005\u0003\u000bC\u0011ba0D\u0005\u0004%I!a!\t\u0011\r\u00057\t)A\u0005\u0003\u000bC\u0011ba1D\u0005\u0004%I!a!\t\u0011\r\u00157\t)A\u0005\u0003\u000bC!ba2D\u0005\u0004%\tAXBe\u0011!\u0019ym\u0011Q\u0001\n\r-\u0007BCBi\u0007\n\u0007I\u0011\u00010\u0004J\"A11[\"!\u0002\u0013\u0019Y\rC\u0004\u0004V\u000e#Iaa6\t\u000f\rm7\t\"\u0001\u0004^\"91Q]\"\u0005\u0002\r\u001d\bbBB}\u0007\u0012\u000511 \u0005\b\t\u001b\u0019E\u0011\u0001C\b\u0011\u001d!Yb\u0011C\u0001\t;\u0011\u0011\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s\u0015\ty\u0006-A\u0002m_\u001eT\u0011!Y\u0001\u0006W\u000647.Y\n\u0004\u0001\rL\u0007C\u00013h\u001b\u0005)'\"\u00014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!,'AB!osJ+g\r\u0005\u0002k[6\t1N\u0003\u0002mA\u0006)Q\u000f^5mg&\u0011an\u001b\u0002\b\u0019><w-\u001b8h\u0003\u001dawn\u001a#jeN\u001c\u0001!F\u0001s!\r\u0019h\u000f_\u0007\u0002i*\u0011Q/Z\u0001\u000bG>dG.Z2uS>t\u0017BA<u\u0005\r\u0019V-\u001d\t\u0003szl\u0011A\u001f\u0006\u0003wr\f!![8\u000b\u0003u\fAA[1wC&\u0011qP\u001f\u0002\u0005\r&dW-\u0001\u0005m_\u001e$\u0015N]:!\u0003\u0011awnZ:\u0016\u0005\u0005\u001d\u0001c\u00026\u0002\n\u00055\u00111E\u0005\u0004\u0003\u0017Y'\u0001\u0002)p_2\u0004B!a\u0004\u0002 5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"\u0001\u0004d_6lwN\u001c\u0006\u0004C\u0006]!\u0002BA\r\u00037\ta!\u00199bG\",'BAA\u000f\u0003\ry'oZ\u0005\u0005\u0003C\t\tB\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005\u0015\u0012qE\u0007\u0002=&\u0019\u0011\u0011\u00060\u0003\u0017\u0005\u00137\u000f\u001e:bGRdunZ\u0001\u0006Y><7\u000fI\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003\u007fi!!!\u000e\u000b\u0007}\u000b9D\u0003\u0003\u0002:\u0005m\u0012!C5oi\u0016\u0014h.\u00197t\u0015\u0011\ti$!\u0006\u0002\u000fM$xN]1hK&!\u0011\u0011IA\u001b\u0005Qaun\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0006)Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0005\u0002J\u0005-\u0013QJA(!\r\t)\u0003\u0001\u0005\u0006_\u001e\u0001\rA\u001d\u0005\b\u0003\u00079\u0001\u0019AA\u0004\u0011\u001d\tic\u0002a\u0001\u0003c\tA\"\\3ue&\u001c7o\u0012:pkB,\"!!\u0016\u0011\t\u0005]\u0013\u0011M\u0007\u0003\u00033RA!a\u0017\u0002^\u00059Q.\u001a;sS\u000e\u001c(\u0002BA0\u0003+\taa]3sm\u0016\u0014\u0018\u0002BA2\u00033\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u00035iW\r\u001e:jGN<%o\\;qA\u0005QAn\\4hKJt\u0015-\\3\u0016\u0005\u0005-\u0004\u0003BA7\u0003wrA!a\u001c\u0002xA\u0019\u0011\u0011O3\u000e\u0005\u0005M$bAA;a\u00061AH]8pizJ1!!\u001ff\u0003\u0019\u0001&/\u001a3fM&!\u0011QPA@\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011P3\u0002)=4gm]3u\u0007\",7m\u001b9pS:$h)\u001b7f+\t\t)\t\u0005\u0003\u0002\b\u00065UBAAE\u0015\r\tY\t`\u0001\u0005Y\u0006tw-\u0003\u0003\u0002~\u0005%\u0015!F8gMN,Go\u00115fG.\u0004x.\u001b8u\r&dW\rI\u0001\fG\",7m\u001b9pS:$8/\u0006\u0002\u0002\u0016B9\u0011qSAOq\u0006\u0005VBAAM\u0015\r\tY\n^\u0001\nS6lW\u000f^1cY\u0016LA!a(\u0002\u001a\n\u0019Q*\u00199\u0011\t\u0005\r\u0016\u0011V\u0007\u0003\u0003KSA!a*\u00028\u0005Q1\r[3dWB|\u0017N\u001c;\n\t\u0005-\u0016Q\u0015\u0002\u0015\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3\u0002\u001f\rDWmY6q_&tGo]0%KF$B!!-\u00028B\u0019A-a-\n\u0007\u0005UVM\u0001\u0003V]&$\b\"CA]\u001d\u0005\u0005\t\u0019AAK\u0003\rAH%M\u0001\rG\",7m\u001b9pS:$8\u000f\t\u0015\u0004\u001f\u0005}\u0006c\u00013\u0002B&\u0019\u00111Y3\u0003\u0011Y|G.\u0019;jY\u0016\f!\"\u001b8Qe><'/Z:t+\t\tI\r\u0005\u0005\u0002L\u0006E\u0017QBAk\u001b\t\tiMC\u0002\u0002PR\fq!\\;uC\ndW-\u0003\u0003\u0002T\u00065'a\u0002%bg\"l\u0015\r\u001d\t\u0005\u0003K\t9.C\u0002\u0002Zz\u0013\u0001\u0003T8h\u00072,\u0017M\\5oON#\u0018\r^3\u0002\u0017%t\u0007K]8he\u0016\u001c8\u000fI\u0001\u0016k:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8t+\t\t\t\u000f\u0005\u0005\u0002L\u0006E\u00171NAr!\u0019\tY-!:\u0002\u000e%!\u0011q]Ag\u0005\r\u0019V\r^\u0001\u0017k:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8tA\u0005!An\\2l+\t\ty\u000f\u0005\u0003\u0002r\u0006}XBAAz\u0015\u0011\t)0a>\u0002\u000b1|7m[:\u000b\t\u0005e\u00181`\u0001\u000bG>t7-\u001e:sK:$(bAA\u007fy\u0006!Q\u000f^5m\u0013\u0011\u0011\t!a=\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0003\u0015awnY6!\u0003I\u0001\u0018-^:fI\u000ecW-\u00198j]\u001e\u001cuN\u001c3\u0016\u0005\t%\u0001\u0003BAy\u0005\u0017IAA!\u0004\u0002t\nI1i\u001c8eSRLwN\\\u0001\u0014a\u0006,8/\u001a3DY\u0016\fg.\u001b8h\u0007>tG\rI\u0001\u000fG2,\u0017M\u001c\"zi\u0016\u001cH*Y:u+\t\u0011)\u0002\u0005\u0003\u0003\u0018\tuQB\u0001B\r\u0015\u0011\u0011Y\"a>\u0002\r\u0005$x.\\5d\u0013\u0011\u0011yB!\u0007\u0003\u0015\u0005#x.\\5d\u0019>tw-A\bdY\u0016\fgNQ=uKNd\u0015m\u001d;!\u0003I\u0019G.Z1oC\ndWMQ=uKNd\u0015m\u001d;\u0002'\rdW-\u00198bE2,')\u001f;fg2\u000b7\u000f\u001e\u0011\u0002)Ut7\r\\3b]\u0006\u0014G.\u001a\"zi\u0016\u001cH*Y:u\u0003U)hn\u00197fC:\f'\r\\3CsR,7\u000fT1ti\u0002\n\u0011\u0004Z5si&,7\u000f\u001e'pO\u000ecW-\u00198bE2,'+\u0019;j_V\u0011!q\u0006\t\u0004I\nE\u0012b\u0001B\u001aK\n1Ai\\;cY\u0016\fQ\u0004Z5si&,7\u000f\u001e'pO\u000ecW-\u00198bE2,'+\u0019;j_~#S-\u001d\u000b\u0005\u0003c\u0013I\u0004C\u0005\u0002:~\t\t\u00111\u0001\u00030\u0005QB-\u001b:uS\u0016\u001cH\u000fT8h\u00072,\u0017M\\1cY\u0016\u0014\u0016\r^5pA!\u001a\u0001%a0\u0002-\u001d\fWoZ3NKR\u0014\u0018n\u0019(b[\u0016<\u0016\u000e\u001e5UC\u001e,\"Aa\u0011\u0011\u0011\t\u0015#qIA6\u0005\u0013j!!a?\n\t\u0005M\u00171 \t\u0007\u0005\u000b\u0012YEa\u0014\n\t\t5\u00131 \u0002\u0005\u0019&\u001cH\u000f\u0005\u0005\u0003F\tE\u00131NA6\u0013\u0011\ty*a?\u0002/\u001d\fWoZ3NKR\u0014\u0018n\u0019(b[\u0016<\u0016\u000e\u001e5UC\u001e\u0004\u0013!\u0004;j[\u0016|e\rT1tiJ+h.\u0006\u0002\u0003ZA\u0019AMa\u0017\n\u0007\tuSM\u0001\u0003M_:<\u0017!\u0005;j[\u0016|e\rT1tiJ+hn\u0018\u0013fcR!\u0011\u0011\u0017B2\u0011%\tI\fJA\u0001\u0002\u0004\u0011I&\u0001\buS6,wJ\u001a'bgR\u0014VO\u001c\u0011)\u0007\u0015\ny,A\u000bbG\"LWM^3e\u00072,\u0017M\\5oOJ\u000bG/[8\u0016\u0005\t5\u0004\u0003\u0002B8\u0005\u007fj!A!\u001d\u000b\t\tM$QO\u0001\u0005G>\u0014XM\u0003\u0003\u0002\\\t]$\u0002\u0002B=\u0005w\na!_1n[\u0016\u0014(B\u0001B?\u0003\r\u0019w.\\\u0005\u0005\u0005\u0003\u0013\tHA\u0005ISN$xn\u001a:b[\u00061\u0012m\u00195jKZ,Gm\u00117fC:Lgn\u001a*bi&|\u0007%A\u000bbY2\u001cE.Z1oKJ\u001c\u0005.Z2la>Lg\u000e^:\u0016\u0005\t%\u0005\u0003CA7\u0005\u0017\u000biA!\u0017\n\t\u0005}\u0015qP\u0001\u000eG2,\u0017M\\5oON#\u0018\r^3\u0015\t\tE%q\u0013\t\u0006I\nM\u0015Q[\u0005\u0004\u0005++'AB(qi&|g\u000eC\u0004\u0003\u001a&\u0002\r!!\u0004\u0002\u0005Q\u0004\u0018\u0001E:fi\u000ecW-\u00198j]\u001e\u001cF/\u0019;f)\u0019\t\tLa(\u0003\"\"9!\u0011\u0014\u0016A\u0002\u00055\u0001b\u0002BRU\u0001\u0007\u0011Q[\u0001\u0006gR\fG/Z\u0001\u001aOJ\f'MR5mi\"LWm\u001d;D_6\u0004\u0018m\u0019;fI2{w\r\u0006\u0004\u0003*\nE&q\u0018\t\u0006I\nM%1\u0016\t\u0005\u0003K\u0011i+C\u0002\u00030z\u0013!\u0002T8h)>\u001cE.Z1o\u0011\u001d\u0011\u0019l\u000ba\u0001\u0005k\u000bA\u0001^5nKB!!q\u0017B^\u001b\t\u0011ILC\u0002m\u0003#IAA!0\u0003:\n!A+[7f\u0011%\u0011\tm\u000bI\u0001\u0002\u0004\u0011\u0019-A\u0007qe\u0016\u001cE.Z1o'R\fGo\u001d\t\u0005\u0003K\u0011)-C\u0002\u0003Hz\u0013Q\u0002\u0015:f\u00072,\u0017M\\*uCR\u001c\u0018aI4sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001e$C-\u001a4bk2$HEM\u000b\u0003\u0005\u001bTCAa1\u0003P.\u0012!\u0011\u001b\t\u0005\u0005'\u0014i.\u0004\u0002\u0003V*!!q\u001bBm\u0003%)hn\u00195fG.,GMC\u0002\u0003\\\u0016\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yN!6\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0014qCV\u001cXm\u00117fC:Lgn\u001a$pe:{gnQ8na\u0006\u001cG/\u001a3QCJ$\u0018\u000e^5p]N$\"A!:\u0011\u000bM\u00149Oa;\n\u0007\t%HO\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u001d!'Q^A\u0007\u0003GI1Aa<f\u0005\u0019!V\u000f\u001d7fe\u0005iA-\u001a7fi\u0006\u0014G.\u001a'pON\fQ\"\u00192peR\u001cE.Z1oS:<G\u0003BAY\u0005oDqA!?0\u0001\u0004\ti!\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0002+\u0005\u0014wN\u001d;B]\u0012\u0004\u0016-^:f\u00072,\u0017M\\5oOR!\u0011\u0011\u0017B\u0000\u0011\u001d\u0011I\u0010\ra\u0001\u0003\u001b\taB]3tk6,7\t\\3b]&tw\r\u0006\u0003\u00022\u000e\u0015\u0001bBB\u0004c\u0001\u00071\u0011B\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB)1Oa:\u0002\u000e\u0005\t\u0012n]\"mK\u0006t\u0017N\\4J]N#\u0018\r^3\u0015\r\r=1QCB\f!\r!7\u0011C\u0005\u0004\u0007')'a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005s\u0014\u0004\u0019AA\u0007\u0011\u001d\u0019IB\ra\u0001\u0003+\fQ\"\u001a=qK\u000e$X\rZ*uCR,\u0017aF5t\u00072,\u0017M\\5oO&s7\u000b^1uKB\u000bWo]3e)\u0011\u0019yaa\b\t\u000f\te8\u00071\u0001\u0002\u000e\u0005!2\r[3dW\u000ecW-\u00198j]\u001e\f%m\u001c:uK\u0012$B!!-\u0004&!9!\u0011 \u001bA\u0002\u00055\u0011!E;qI\u0006$Xm\u00115fG.\u0004x.\u001b8ugRA\u0011\u0011WB\u0016\u0007_\u0019Y\u0004\u0003\u0004\u0004.U\u0002\r\u0001_\u0001\bI\u0006$\u0018\rR5s\u0011%\u0019\t$\u000eI\u0001\u0002\u0004\u0019\u0019$\u0001\fqCJ$\u0018\u000e^5p]R{W\u000b\u001d3bi\u0016|%/\u00113e!\u0015!'1SB\u001b!\u001d!'Q^A\u0007\u0007o\u0001B!a\"\u0004:%!!QLAE\u0011%\u0019i$\u000eI\u0001\u0002\u0004\u0019y$A\tqCJ$\u0018\u000e^5p]R{'+Z7pm\u0016\u0004R\u0001\u001aBJ\u0003\u001b\t1$\u001e9eCR,7\t[3dWB|\u0017N\u001c;tI\u0011,g-Y;mi\u0012\u0012TCAB#U\u0011\u0019\u0019Da4\u00027U\u0004H-\u0019;f\u0007\",7m\u001b9pS:$8\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019YE\u000b\u0003\u0004@\t=\u0017AE1mi\u0016\u00148\t[3dWB|\u0017N\u001c;ESJ$\u0002\"!-\u0004R\rM3q\u000b\u0005\b\u0005sD\u0004\u0019AA\u0007\u0011\u0019\u0019)\u0006\u000fa\u0001q\u0006a1o\\;sG\u0016dun\u001a#je\"11\u0011\f\u001dA\u0002a\f!\u0002Z3ti2{w\rR5s\u0003MA\u0017M\u001c3mK2{w\rR5s\r\u0006LG.\u001e:f)\u0011\t\tla\u0018\t\u000f\r\u0005\u0014\b1\u0001\u0002l\u0005\u0019A-\u001b:\u0002/5\f\u0017PY3UeVt7-\u0019;f\u0007\",7m\u001b9pS:$H\u0003CAY\u0007O\u001aIga\u001b\t\r\r5\"\b1\u0001y\u0011\u001d\u0011IP\u000fa\u0001\u0003\u001bAqa!\u001c;\u0001\u0004\u00199$\u0001\u0004pM\u001a\u001cX\r^\u0001\rI>tWm\u00117fC:Lgn\u001a\u000b\t\u0003c\u001b\u0019h!\u001e\u0004x!9!\u0011`\u001eA\u0002\u00055\u0001BBB\u0017w\u0001\u0007\u0001\u0010C\u0004\u0004zm\u0002\rA!\u0017\u0002\u0013\u0015tGm\u00144gg\u0016$\u0018\u0001\u00043p]\u0016$U\r\\3uS:<G\u0003BAY\u0007\u007fBqaa\u0002=\u0001\u0004\u0019I\u0001\u0006\u0003\u0004\u0004\u000e\u001d\u0005CBA7\u0007\u000b\u000bi!\u0003\u0003\u0002h\u0006}\u0004bBBE{\u0001\u0007\u00111N\u0001\u0007Y><G)\u001b:\u000215\f'o\u001b)beRLG/[8o+:\u001cG.Z1oC\ndW\r\u0006\u0004\u00022\u000e=5\u0011\u0013\u0005\b\u0007\u0013s\u0004\u0019AA6\u0011\u001d\u0019\u0019J\u0010a\u0001\u0003\u001b\t\u0011\u0002]1si&$\u0018n\u001c8\u0002-%\u001cXK\\2mK\u0006t\u0017M\u00197f!\u0006\u0014H/\u001b;j_:$baa\u0004\u0004\u001a\u000em\u0005BB0@\u0001\u0004\t\u0019\u0003C\u0004\u0003z~\u0002\r!!\u0004\u0002;5\f\u0017N\u001c;bS:,fn\u00197fC:\f'\r\\3QCJ$\u0018\u000e^5p]N$\"!!-\u0002\u001bI,Wn\u001c<f\u001b\u0016$(/[2t\u0003EaunZ\"mK\u0006tWM]'b]\u0006<WM\u001d\t\u0004\u0003K\u00195cA\"dSR\u00111QU\u0001%+:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8t\u0007>,h\u000e^'fiJL7MT1nK\u0006)SK\\2mK\u0006t\u0017M\u00197f!\u0006\u0014H/\u001b;j_:\u001c8i\\;oi6+GO]5d\u001d\u0006lW\rI\u0001\u001b+:\u001cG.Z1oC\ndWMQ=uKNlU\r\u001e:jG:\u000bW.Z\u0001\u001c+:\u001cG.Z1oC\ndWMQ=uKNlU\r\u001e:jG:\u000bW.\u001a\u0011\u00029QKW.Z*j]\u000e,G*Y:u%VtWj]'fiJL7MT1nK\u0006iB+[7f'&t7-\u001a'bgR\u0014VO\\'t\u001b\u0016$(/[2OC6,\u0007%A\u000bBG\"LWM^3e\u00072,\u0017M\\5oOJ\u000bG/[8\u0002-\u0005\u001b\u0007.[3wK\u0012\u001cE.Z1oS:<'+\u0019;j_\u0002\nqcQ8na\u0006\u001cG/\u001a3QCJ$\u0018\u000e^5p]\nKH/Z:\u00021\r{W\u000e]1di\u0016$\u0007+\u0019:uSRLwN\u001c\"zi\u0016\u001c\b%\u0001\u000fD_6\u0004\u0018m\u0019;fIB\u000b'\u000f^5uS>tGj\\2bY\nKH/Z:\u0002;\r{W\u000e]1di\u0016$\u0007+\u0019:uSRLwN\u001c'pG\u0006d')\u001f;fg\u0002\nQdQ8na\u0006\u001cG/\u001a3QCJ$\u0018\u000e^5p]RKWM]3e\u0005f$Xm]\u0001\u001f\u0007>l\u0007/Y2uK\u0012\u0004\u0016M\u001d;ji&|g\u000eV5fe\u0016$')\u001f;fg\u0002\nAcR1vO\u0016lU\r\u001e:jG:\u000bW.\u001a(p)\u0006<WCABf!\u0019\t9j!4\u0002\u0006&!\u0011q]AM\u0003U9\u0015-^4f\u001b\u0016$(/[2OC6,gj\u001c+bO\u0002\nA\u0003S5ti><'/Y7NKR\u0014\u0018n\u0019(b[\u0016\u001c\u0018!\u0006%jgR|wM]1n\u001b\u0016$(/[2OC6,7\u000fI\u0001\u0013SN\u001cu.\u001c9bGR\fe\u000e\u001a#fY\u0016$X\r\u0006\u0003\u0004\u0010\re\u0007BB0X\u0001\u0004\t\u0019#\u0001\u0011m_\u000e\fG.R1sY&,7\u000f\u001e#jeRL()\u0019;dQRKW.Z:uC6\u0004HC\u0002B-\u0007?\u001c\t\u000f\u0003\u0004`1\u0002\u0007\u00111\u0005\u0005\b\u0007GD\u0006\u0019\u0001B-\u0003A1\u0017N]:u\t&\u0014H/_(gMN,G/\u0001\nnCb\u001cu.\u001c9bGRLwN\u001c#fY\u0006LH\u0003\u0003B-\u0007S\u001cYo!>\t\r}K\u0006\u0019AA\u0012\u0011\u001d\u0019i/\u0017a\u0001\u0007_\fa#Z1sY&,7\u000f\u001e#jeRLH+[7fgR\fW\u000e\u001d\t\u0006I\u000eE(\u0011L\u0005\u0004\u0007g,'!\u0003$v]\u000e$\u0018n\u001c81\u0011\u001d\u001990\u0017a\u0001\u00053\n1A\\8x\u0003A\u0019G.Z1oC\ndWm\u00144gg\u0016$8\u000f\u0006\u0005\u0004~\u0012\rAQ\u0001C\u0006!\u0011\t)ca@\n\u0007\u0011\u0005aL\u0001\bPM\u001a\u001cX\r^:U_\u000ecW-\u00198\t\r}S\u0006\u0019AA\u0012\u0011\u001d!9A\u0017a\u0001\t\u0013\tq\u0002\\1ti\u000ecW-\u00198PM\u001a\u001cX\r\u001e\t\u0006I\nM%\u0011\f\u0005\b\u0007oT\u0006\u0019\u0001B-\u0003]\u0019\u0017\r\\2vY\u0006$Xm\u00117fC:\f'\r\\3CsR,7\u000f\u0006\u0005\u0005\u0012\u0011MAQ\u0003C\f!\u001d!'Q\u001eB-\u00053BaaX.A\u0002\u0005\r\u0002bBBr7\u0002\u0007!\u0011\f\u0005\b\t3Y\u0006\u0019\u0001B-\u0003E)hn\u00197fC:\f'\r\\3PM\u001a\u001cX\r^\u0001\u001cIV\fGnQ8na\u0006\u001cG/[8o\u00072,\u0017M\\5oO\n{WO\u001c3\u0015\t\u0011%Aq\u0004\u0005\u0007?r\u0003\r!a\t")
public class LogCleanerManager
implements Logging {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, AbstractLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    private final KafkaMetricsGroup metricsGroup;
    private final String offsetCheckpointFile;
    private volatile scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints;
    private final scala.collection.mutable.HashMap<TopicPartition, LogCleaningState> inProgress;
    private final scala.collection.mutable.HashMap<String, Set<TopicPartition>> uncleanablePartitions;
    private final ReentrantLock lock;
    private final Condition pausedCleaningCond;
    private final AtomicLong cleanBytesLast;
    private final AtomicLong cleanableBytesLast;
    private final AtomicLong uncleanableBytesLast;
    private volatile double dirtiestLogCleanableRatio;
    private final HashMap<String, List<java.util.Map<String, String>>> gaugeMetricNameWithTag;
    private volatile long timeOfLastRun;
    private final Histogram achievedCleaningRatio;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<Object> dualCompactionCleaningBound(AbstractLog log) {
        return LogCleanerManager$.MODULE$.dualCompactionCleaningBound(log);
    }

    public static Tuple2<Object, Object> calculateCleanableBytes(AbstractLog log, long firstDirtyOffset, long uncleanableOffset) {
        return LogCleanerManager$.MODULE$.calculateCleanableBytes(log, firstDirtyOffset, uncleanableOffset);
    }

    public static OffsetsToClean cleanableOffsets(AbstractLog log, Option<Object> lastCleanOffset, long now) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log, lastCleanOffset, now);
    }

    public static long maxCompactionDelay(AbstractLog log, Function0<Object> earliestDirtyTimestamp, long now) {
        return LogCleanerManager$.MODULE$.maxCompactionDelay(log, earliestDirtyTimestamp, now);
    }

    public static long localEarliestDirtyBatchTimestamp(AbstractLog log, long firstDirtyOffset) {
        return LogCleanerManager$.MODULE$.localEarliestDirtyBatchTimestamp(log, firstDirtyOffset);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager logCleanerManager = this;
        synchronized (logCleanerManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, AbstractLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints() {
        return this.checkpoints;
    }

    private void checkpoints_$eq(scala.collection.immutable.Map<File, OffsetCheckpointFile> x$1) {
        this.checkpoints = x$1;
    }

    private scala.collection.mutable.HashMap<TopicPartition, LogCleaningState> inProgress() {
        return this.inProgress;
    }

    private scala.collection.mutable.HashMap<String, Set<TopicPartition>> uncleanablePartitions() {
        return this.uncleanablePartitions;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    private Condition pausedCleaningCond() {
        return this.pausedCleaningCond;
    }

    public AtomicLong cleanBytesLast() {
        return this.cleanBytesLast;
    }

    public AtomicLong cleanableBytesLast() {
        return this.cleanableBytesLast;
    }

    public AtomicLong uncleanableBytesLast() {
        return this.uncleanableBytesLast;
    }

    public double dirtiestLogCleanableRatio() {
        return this.dirtiestLogCleanableRatio;
    }

    public void dirtiestLogCleanableRatio_$eq(double x$1) {
        this.dirtiestLogCleanableRatio = x$1;
    }

    public HashMap<String, List<java.util.Map<String, String>>> gaugeMetricNameWithTag() {
        return this.gaugeMetricNameWithTag;
    }

    private long timeOfLastRun() {
        return this.timeOfLastRun;
    }

    private void timeOfLastRun_$eq(long x$1) {
        this.timeOfLastRun = x$1;
    }

    private Histogram achievedCleaningRatio() {
        return this.achievedCleaningRatio;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        return (scala.collection.immutable.Map)CoreUtils$.MODULE$.inLock(this.lock(), (Function0<scala.collection.immutable.Map> & Serializable)() -> ((IterableOnceOps)this.checkpoints().values().flatMap((Function1<OffsetCheckpointFile, Map> & Serializable)checkpoint -> {
            Object object;
            try {
                object = (Map)CollectionConverters$.MODULE$.MapHasAsScala(checkpoint.read()).asScala().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        Long offset = (Long)tuple2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), BoxesRunTime.boxToLong(Predef$.MODULE$.Long2long(offset)));
                    }
                    throw new MatchError(tuple2);
                });
            }
            catch (KafkaStorageException e) {
                this.error((Function0<String> & Serializable)() -> "Failed to access checkpoint file " + checkpoint.file().getName() + " in dir " + checkpoint.file().getParentFile().getAbsolutePath(), (Function0<Throwable>)(Function0<KafkaStorageException> & Serializable)() -> e);
                object = Predef$.MODULE$.Map().empty();
            }
            return object;
        })).toMap($less$colon$less$.MODULE$.refl()));
    }

    public Option<LogCleaningState> cleaningState(TopicPartition tp) {
        return (Option)CoreUtils$.MODULE$.inLock(this.lock(), (Function0<Option> & Serializable)() -> this.inProgress().get(tp));
    }

    public void setCleaningState(TopicPartition tp, LogCleaningState state) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0<Option> & Serializable)() -> this.inProgress().put(tp, state));
    }

    public Option<LogToClean> grabFilthiestCompactedLog(Time time, PreCleanStats preCleanStats) {
        return (Option)CoreUtils$.MODULE$.inLock(this.lock(), (Function0<Option> & Serializable)() -> {
            long now = time.milliseconds();
            this.timeOfLastRun_$eq(now);
            scala.collection.immutable.Map<TopicPartition, Object> lastClean = this.allCleanerCheckpoints();
            Iterable allCleanableLogs = (Iterable)((IterableOps)((IterableOps)((IterableOps)this.logs().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$grabFilthiestCompactedLog$2(x0$1)))).filterNot((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$grabFilthiestCompactedLog$3(this, x0$2)))).map((Function1<Tuple2, LogToClean> & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    LogToClean logToClean;
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    AbstractLog log = (AbstractLog)tuple2._2();
                    try {
                        Option<Object> lastCleanOffset = lastClean.get(topicPartition);
                        OffsetsToClean offsetsToClean = LogCleanerManager$.MODULE$.cleanableOffsets(log, lastCleanOffset, now);
                        if (offsetsToClean.forceUpdateCheckpoint()) {
                            this.updateCheckpoints(log.parentDirFile(), Option$.MODULE$.apply(new Tuple2<TopicPartition, Long>(topicPartition, Predef$.MODULE$.long2Long(offsetsToClean.firstDirtyOffset()))), this.updateCheckpoints$default$3());
                        }
                        long compactionDelayMs = LogCleanerManager$.MODULE$.maxCompactionDelay(log, () -> LogCleanerManager$.MODULE$.localEarliestDirtyBatchTimestamp(log, offsetsToClean.firstDirtyOffset()), now);
                        preCleanStats.updateMaxCompactionDelay(compactionDelayMs);
                        logToClean = new LogToClean(topicPartition, log, offsetsToClean.firstDirtyOffset(), offsetsToClean.firstUncleanableDirtyOffset(), compactionDelayMs > 0L);
                    }
                    catch (Throwable e) {
                        throw new LogCleaningException(log, "Failed to calculate log cleaning stats for partition " + topicPartition, e);
                    }
                    return logToClean;
                }
                throw new MatchError(tuple2);
            })).filter((Function1<LogToClean, Object> & Serializable)ltc -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$grabFilthiestCompactedLog$6(ltc)));
            this.cleanBytesLast().set(BoxesRunTime.unboxToLong(((IterableOnceOps)allCleanableLogs.map((Function1<LogToClean, Object> & Serializable)x$4 -> BoxesRunTime.boxToLong(x$4.cleanBytes()))).sum(Numeric.LongIsIntegral$.MODULE$)));
            this.cleanableBytesLast().set(BoxesRunTime.unboxToLong(((IterableOnceOps)allCleanableLogs.map((Function1<LogToClean, Object> & Serializable)x$5 -> BoxesRunTime.boxToLong(x$5.cleanableBytes()))).sum(Numeric.LongIsIntegral$.MODULE$)));
            this.uncleanableBytesLast().set(BoxesRunTime.unboxToLong(((IterableOnceOps)allCleanableLogs.map((Function1<LogToClean, Object> & Serializable)x$6 -> BoxesRunTime.boxToLong(x$6.uncleanableBytes()))).sum(Numeric.LongIsIntegral$.MODULE$)));
            Iterable dirtyLogs = (Iterable)allCleanableLogs.filterNot((Function1<LogToClean, Object> & Serializable)logToClean -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$grabFilthiestCompactedLog$10(this, logToClean)));
            this.dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
            Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1<LogToClean, Object> & Serializable)ltc -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$grabFilthiestCompactedLog$11(ltc)));
            if (cleanableLogs.isEmpty()) {
                return None$.MODULE$;
            }
            preCleanStats.recordCleanablePartitions(cleanableLogs.size());
            LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            this.inProgress().put(filthiest.topicPartition(), LogCleaningInProgress$.MODULE$);
            this.achievedCleaningRatio().update((int)(filthiest.cleanableRatio() * (double)100));
            double expectedShrinkageRatio = filthiest.log().lastShrinkageRatio() * filthiest.cleanableRatio();
            this.info((Function0<String> & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Filthiest log %s has last.shrinkage.ratio=%.3f, dirty.ratio=%.3f, expected.shrinkage.ratio=%.3f %n"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{filthiest.log().name(), BoxesRunTime.boxToDouble(filthiest.log().lastShrinkageRatio()), BoxesRunTime.boxToDouble(filthiest.cleanableRatio()), BoxesRunTime.boxToDouble(expectedShrinkageRatio)})));
            return new Some<LogToClean>(filthiest);
        });
    }

    public PreCleanStats grabFilthiestCompactedLog$default$2() {
        return new PreCleanStats();
    }

    public Iterable<Tuple2<TopicPartition, AbstractLog>> pauseCleaningForNonCompactedPartitions() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.lock(), (Function0<Iterable> & Serializable)() -> {
            Iterable deletableLogs = (Iterable)((IterableOps)this.logs().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$2(x0$1)))).filterNot((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$3(this, x0$2)));
            deletableLogs.foreach((Function1<Tuple2, Option> & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    return this.inProgress().put(topicPartition, new LogCleaningPaused(1));
                }
                throw new MatchError(tuple2);
            });
            return deletableLogs;
        });
    }

    public Iterable<Tuple2<TopicPartition, AbstractLog>> deletableLogs() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.lock(), (Function0<Iterable> & Serializable)() -> {
            Iterable toClean = (Iterable)this.logs().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$deletableLogs$2(this, x0$1)));
            toClean.foreach((Function1<Tuple2, Option> & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    return this.inProgress().put(tp, LogCleaningInProgress$.MODULE$);
                }
                throw new MatchError(tuple2);
            });
            return toClean;
        });
    }

    public void abortCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), () -> {
            this.abortAndPauseCleaning(topicPartition);
            this.resumeCleaning(new $colon$colon<Nothing$>((Nothing$)((Object)topicPartition), Nil$.MODULE$));
        });
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), () -> LogCleanerManager.$anonfun$abortAndPauseCleaning$1(this, topicPartition));
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        CoreUtils$.MODULE$.inLock(this.lock(), () -> topicPartitions.foreach((Function1<TopicPartition, Option> & Serializable)topicPartition -> {
            Option<LogCleaningState> option = this.inProgress().get((TopicPartition)topicPartition);
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException("Compaction for partition " + topicPartition + " cannot be resumed since it is not paused.");
            }
            if (option instanceof Some) {
                int count;
                Some some = (Some)option;
                LogCleaningState state = (LogCleaningState)some.value();
                boolean bl = false;
                LogCleaningPaused logCleaningPaused = null;
                LogCleaningState logCleaningState = state;
                if (logCleaningState instanceof LogCleaningPaused) {
                    bl = true;
                    logCleaningPaused = (LogCleaningPaused)logCleaningState;
                    int count2 = logCleaningPaused.pausedCount();
                    if (count2 == 1) {
                        return this.inProgress().remove((TopicPartition)topicPartition);
                    }
                }
                if (bl && (count = logCleaningPaused.pausedCount()) > 1) {
                    return this.inProgress().put((TopicPartition)topicPartition, new LogCleaningPaused(count - 1));
                }
                throw new IllegalStateException("Compaction for partition " + topicPartition + " cannot be resumed since it is in " + logCleaningState + " state.");
            }
            throw new MatchError(option);
        }));
    }

    private boolean isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        Option<LogCleaningState> option = this.inProgress().get(topicPartition);
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            LogCleaningState state;
            Some some = (Some)option;
            LogCleaningState logCleaningState = state = (LogCleaningState)some.value();
            LogCleaningState logCleaningState2 = expectedState;
            return !(logCleaningState != null ? !logCleaningState.equals(logCleaningState2) : logCleaningState2 != null);
        }
        throw new MatchError(option);
    }

    private boolean isCleaningInStatePaused(TopicPartition topicPartition) {
        Option<LogCleaningState> option = this.inProgress().get(topicPartition);
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            LogCleaningState state = (LogCleaningState)some.value();
            LogCleaningState logCleaningState = state;
            return logCleaningState instanceof LogCleaningPaused;
        }
        throw new MatchError(option);
    }

    public void checkCleaningAborted(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), () -> {
            if (this.isCleaningInState(topicPartition, LogCleaningAborted$.MODULE$)) {
                throw new LogCleaningAbortedException();
            }
            if (Option$.MODULE$.apply(this.logs().get(topicPartition)).exists((Function1<AbstractLog, Object> & Serializable)x$7 -> BoxesRunTime.boxToBoolean(x$7.isFrozenLogStartOffsetState()))) {
                throw new LogCleaningAbortedException();
            }
        });
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Long>> partitionToUpdateOrAdd, Option<TopicPartition> partitionToRemove) {
        CoreUtils$.MODULE$.inLock(this.lock(), () -> {
            OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)this.checkpoints().apply(dataDir);
            if (checkpoint != null) {
                try {
                    scala.collection.immutable.Map map;
                    scala.collection.immutable.Map map2;
                    scala.collection.immutable.Map currentCheckpoint = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(checkpoint.read()).asScala().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$updateCheckpoints$2(this, x0$1)))).toMap($less$colon$less$.MODULE$.refl());
                    Option option = partitionToRemove;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        TopicPartition topicPartition = (TopicPartition)some.value();
                        map2 = (scala.collection.immutable.Map)currentCheckpoint.$minus(topicPartition);
                    } else if (None$.MODULE$.equals(option)) {
                        map2 = currentCheckpoint;
                    } else {
                        throw new MatchError(option);
                    }
                    scala.collection.immutable.Map updatedCheckpoint = map2;
                    Option option2 = partitionToUpdateOrAdd;
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        Tuple2 updatedOffset = (Tuple2)some.value();
                        map = (scala.collection.immutable.Map)updatedCheckpoint.$plus(updatedOffset);
                    } else if (None$.MODULE$.equals(option2)) {
                        map = updatedCheckpoint;
                    } else {
                        throw new MatchError(option2);
                    }
                    updatedCheckpoint = map;
                    checkpoint.write(CollectionConverters$.MODULE$.MapHasAsJava(updatedCheckpoint).asJava());
                }
                catch (KafkaStorageException e) {
                    this.error((Function0<String> & Serializable)() -> "Failed to access checkpoint file " + checkpoint.file().getName() + " in dir " + checkpoint.file().getParentFile().getAbsolutePath(), (Function0<Throwable>)(Function0<KafkaStorageException> & Serializable)() -> e);
                }
                return;
            }
        });
    }

    public Option<Tuple2<TopicPartition, Long>> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public Option<TopicPartition> updateCheckpoints$default$3() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        CoreUtils$.MODULE$.inLock(this.lock(), () -> {
            block5: {
                try {
                    Option option = this.checkpoints().get(sourceLogDir).flatMap((Function1<OffsetCheckpointFile, Option> & Serializable)x$8 -> CollectionConverters$.MODULE$.MapHasAsScala(x$8.read()).asScala().get(topicPartition));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Long offset = (Long)some.value();
                        this.debug((Function0<String> & Serializable)() -> "Removing the partition offset data in checkpoint file for '" + topicPartition + "' from " + sourceLogDir.getAbsoluteFile() + " directory.");
                        File x$1 = sourceLogDir;
                        Option<TopicPartition> x$2 = Option$.MODULE$.apply(topicPartition);
                        Option<Tuple2<TopicPartition, Long>> x$3 = this.updateCheckpoints$default$2();
                        this.updateCheckpoints(x$1, x$3, x$2);
                        this.debug((Function0<String> & Serializable)() -> "Adding the partition offset data in checkpoint file for '" + topicPartition + "' to " + destLogDir.getAbsoluteFile() + " directory.");
                        this.updateCheckpoints(destLogDir, Option$.MODULE$.apply(new Tuple2<TopicPartition, Long>(topicPartition, offset)), this.updateCheckpoints$default$3());
                        break block5;
                    }
                    if (None$.MODULE$.equals(option)) {
                        break block5;
                    }
                    throw new MatchError(option);
                }
                catch (KafkaStorageException e) {
                    this.error((Function0<String> & Serializable)() -> "Failed to access checkpoint file in dir " + sourceLogDir.getAbsolutePath(), (Function0<Throwable>)(Function0<KafkaStorageException> & Serializable)() -> e);
                }
            }
            Set logUncleanablePartitions = (Set)this.uncleanablePartitions().getOrElse(sourceLogDir.toString(), (Function0<Set> & Serializable)() -> (Set)Set$.MODULE$.apply(Nil$.MODULE$));
            if (logUncleanablePartitions.contains(topicPartition)) {
                logUncleanablePartitions.remove(topicPartition);
                this.markPartitionUncleanable(destLogDir.toString(), topicPartition);
                return;
            }
        });
    }

    public void handleLogDirFailure(String dir) {
        this.warn((Function0<String> & Serializable)() -> "Stopping cleaning logs in dir " + dir);
        CoreUtils$.MODULE$.inLock(this.lock(), () -> this.checkpoints_$eq((scala.collection.immutable.Map)this.checkpoints().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$handleLogDirFailure$3(dir, x0$1)))));
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, Long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), () -> {
            if (Option$.MODULE$.apply(this.logs().get(topicPartition)).exists((Function1<AbstractLog, Object> & Serializable)x$9 -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$maybeTruncateCheckpoint$2(x$9)))) {
                OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)this.checkpoints().apply(dataDir);
                if (checkpoint != null) {
                    java.util.Map<TopicPartition, Long> existing = checkpoint.read();
                    if (Predef$.MODULE$.Long2long(existing.getOrDefault(topicPartition, Predef$.MODULE$.long2Long(0L))) > Predef$.MODULE$.Long2long(offset)) {
                        existing.put(topicPartition, offset);
                        checkpoint.write(existing);
                        return;
                    }
                    return;
                }
                return;
            }
        });
    }

    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0<Object> & Serializable)() -> {
            LogCleaningState logCleaningState;
            boolean bl = false;
            Some some = null;
            Option<LogCleaningState> option = this.inProgress().get(topicPartition);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                    this.updateCheckpoints(dataDir, Option$.MODULE$.apply(new Tuple2<TopicPartition, Long>(topicPartition, Predef$.MODULE$.long2Long(endOffset))), this.updateCheckpoints$default$3());
                    return this.inProgress().remove(topicPartition);
                }
            }
            if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                this.inProgress().put(topicPartition, new LogCleaningPaused(1));
                this.pausedCleaningCond().signalAll();
                return BoxedUnit.UNIT;
            }
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException("State for partition " + topicPartition + " should exist.");
            }
            throw new IllegalStateException("In-progress partition " + topicPartition + " cannot be in " + option + " state.");
        });
    }

    public void doneDeleting(Iterable<TopicPartition> topicPartitions) {
        CoreUtils$.MODULE$.inLock(this.lock(), () -> topicPartitions.foreach((Function1<TopicPartition, Object> & Serializable)topicPartition -> {
            LogCleaningState logCleaningState;
            boolean bl = false;
            Some some = null;
            Option<LogCleaningState> option = this.inProgress().get((TopicPartition)topicPartition);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                    return this.inProgress().remove((TopicPartition)topicPartition);
                }
            }
            if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                this.inProgress().put((TopicPartition)topicPartition, new LogCleaningPaused(1));
                this.pausedCleaningCond().signalAll();
                return BoxedUnit.UNIT;
            }
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException("State for partition " + topicPartition + " should exist.");
            }
            throw new IllegalStateException("In-progress partition " + topicPartition + " cannot be in " + option + " state.");
        }));
    }

    public scala.collection.immutable.Set<TopicPartition> uncleanablePartitions(String logDir) {
        ObjectRef<scala.collection.immutable.Set> partitions = ObjectRef.create((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$));
        CoreUtils$.MODULE$.inLock(this.lock(), () -> {
            partitions$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)partitions$1.elem).$plus$plus((IterableOnce)this.uncleanablePartitions().getOrElse(logDir, (Function0<scala.collection.immutable.Set> & Serializable)() -> (scala.collection.immutable.Set)partitions$1.elem));
        });
        return (scala.collection.immutable.Set)partitions.elem;
    }

    public void markPartitionUncleanable(String logDir, TopicPartition partition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0<Object> & Serializable)() -> {
            Option<Set<TopicPartition>> option = this.uncleanablePartitions().get(logDir);
            if (option instanceof Some) {
                Some some = (Some)option;
                Set partitions = (Set)some.value();
                return BoxesRunTime.boxToBoolean(partitions.add(partition));
            }
            if (None$.MODULE$.equals(option)) {
                return this.uncleanablePartitions().put(logDir, (Set<TopicPartition>)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
            }
            throw new MatchError(option);
        });
    }

    public boolean isUncleanablePartition(AbstractLog log, TopicPartition topicPartition) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.lock(), () -> this.uncleanablePartitions().get(log.parentDir()).exists((Function1<Set<TopicPartition>, Object>)(Function1<Set, Object> & Serializable)partitions -> BoxesRunTime.boxToBoolean(partitions.contains(topicPartition)))));
    }

    public void maintainUncleanablePartitions() {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0<scala.collection.mutable.HashMap> & Serializable)() -> {
            this.uncleanablePartitions().values().foreach((Function1<Set, Set> & Serializable)partitions -> (Set)partitions.filterInPlace((Function1<TopicPartition, Object> & Serializable)id -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$maintainUncleanablePartitions$3(this, id))));
            return this.uncleanablePartitions().filterInPlace((Function2<String, Set, Object> & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$maintainUncleanablePartitions$4(x0$1, x1$1)));
        });
    }

    public void removeMetrics() {
        LogCleanerManager$.MODULE$.GaugeMetricNameNoTag().foreach((Function1<String, Object> & Serializable)name -> {
            LogCleanerManager.$anonfun$removeMetrics$1(this, name);
            return BoxedUnit.UNIT;
        });
        LogCleanerManager$.MODULE$.HistogramMetricNames().foreach((Function1<String, Object> & Serializable)name -> {
            LogCleanerManager.$anonfun$removeMetrics$2(this, name);
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.MapHasAsScala(this.gaugeMetricNameWithTag()).asScala().foreach((Function1<Tuple2, Object> & Serializable)metricNameAndTags -> {
            LogCleanerManager.$anonfun$removeMetrics$3(this, metricNameAndTags);
            return BoxedUnit.UNIT;
        });
        this.gaugeMetricNameWithTag().clear();
    }

    public static final /* synthetic */ int $anonfun$new$2(LogCleanerManager $this, File dir$1) {
        return BoxesRunTime.unboxToInt(CoreUtils$.MODULE$.inLock($this.lock(), () -> BoxesRunTime.unboxToInt($this.uncleanablePartitions().get(dir$1.getAbsolutePath()).map((Function1<Set, Object> & Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1.size())).getOrElse(() -> 0))));
    }

    public static final /* synthetic */ boolean $anonfun$new$1(LogCleanerManager $this, File dir) {
        java.util.Map<String, String> metricTag = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("logDirectory"), dir.getAbsolutePath())}))).asJava();
        $this.metricsGroup().newGauge(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$UncleanablePartitionsCountMetricName(), () -> BoxesRunTime.boxToInteger(LogCleanerManager.$anonfun$new$2($this, dir)), metricTag);
        return ((List)$this.gaugeMetricNameWithTag().computeIfAbsent(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$UncleanablePartitionsCountMetricName(), x$2 -> new ArrayList())).add(metricTag);
    }

    public static final /* synthetic */ long $anonfun$new$11(scala.collection.immutable.Map lastClean$1, TopicPartition tp$1, long now$1, AbstractLog log) {
        Option<Object> lastCleanOffset = lastClean$1.get(tp$1);
        OffsetsToClean offsetsToClean = LogCleanerManager$.MODULE$.cleanableOffsets(log, lastCleanOffset, now$1);
        Tuple2<Object, Object> tuple2 = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, offsetsToClean.firstDirtyOffset(), offsetsToClean.firstUncleanableDirtyOffset());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long uncleanableBytes = tuple2._2$mcJ$sp();
        long uncleanableBytes2 = uncleanableBytes;
        return uncleanableBytes2;
    }

    public static final /* synthetic */ long $anonfun$new$10(LogCleanerManager $this, scala.collection.immutable.Map lastClean$1, long now$1, TopicPartition tp) {
        return BoxesRunTime.unboxToLong(Option$.MODULE$.apply($this.logs().get(tp)).map((Function1<AbstractLog, Object> & Serializable)log -> BoxesRunTime.boxToLong(LogCleanerManager.$anonfun$new$11(lastClean$1, tp, now$1, log))).getOrElse(() -> 0L));
    }

    public static final /* synthetic */ long $anonfun$new$8(LogCleanerManager $this, File dir$2) {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inLock($this.lock(), () -> {
            Option<Set<TopicPartition>> option = $this.uncleanablePartitions().get(dir$2.getAbsolutePath());
            if (option instanceof Some) {
                Some some = (Some)option;
                Set partitions = (Set)some.value();
                scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.allCleanerCheckpoints();
                long now = Time.SYSTEM.milliseconds();
                return BoxesRunTime.unboxToLong(partitions.iterator().map((Function1<TopicPartition, Object> & Serializable)tp -> BoxesRunTime.boxToLong(LogCleanerManager.$anonfun$new$10($this, lastClean, now, tp))).sum(Numeric.LongIsIntegral$.MODULE$));
            }
            if (None$.MODULE$.equals(option)) {
                return 0L;
            }
            throw new MatchError(option);
        }));
    }

    public static final /* synthetic */ boolean $anonfun$new$7(LogCleanerManager $this, File dir) {
        java.util.Map<String, String> metricTag = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("logDirectory"), dir.getAbsolutePath())}))).asJava();
        $this.metricsGroup().newGauge(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$UncleanableBytesMetricName(), () -> BoxesRunTime.boxToLong(LogCleanerManager.$anonfun$new$8($this, dir)), metricTag);
        return ((List)$this.gaugeMetricNameWithTag().computeIfAbsent(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$UncleanableBytesMetricName(), x$3 -> new ArrayList())).add(metricTag);
    }

    public static final /* synthetic */ boolean $anonfun$new$16(File dir$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            AbstractLog log = (AbstractLog)tuple2._2();
            return log.config().compact() && log.parentDir().equals(dir$3.getAbsolutePath());
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ long $anonfun$new$17(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            AbstractLog log = (AbstractLog)tuple2._2();
            return log.sizeAsyncUpdated();
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ long $anonfun$new$15(LogCleanerManager $this, File dir$3) {
        return BoxesRunTime.unboxToLong(((IterableOnceOps)((IterableOps)$this.logs().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$new$16(dir$3, x0$1)))).map((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToLong(LogCleanerManager.$anonfun$new$17(x0$2)))).sum(Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$new$20(File dir$3, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            AbstractLog log = (AbstractLog)tuple2._2();
            return log.config().compact() && log.parentDir().equals(dir$3.getAbsolutePath());
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ long $anonfun$new$21(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            AbstractLog log = (AbstractLog)tuple2._2();
            return log.sizeDetailsAsyncUpdated().localSize();
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ long $anonfun$new$19(LogCleanerManager $this, File dir$3) {
        return BoxesRunTime.unboxToLong(((IterableOnceOps)((IterableOps)$this.logs().filter((Function1<Tuple2, Object> & Serializable)x0$3 -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$new$20(dir$3, x0$3)))).map((Function1<Tuple2, Object> & Serializable)x0$4 -> BoxesRunTime.boxToLong(LogCleanerManager.$anonfun$new$21(x0$4)))).sum(Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$new$24(File dir$3, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            AbstractLog log = (AbstractLog)tuple2._2();
            return log.config().compact() && log.parentDir().equals(dir$3.getAbsolutePath());
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ long $anonfun$new$25(Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            AbstractLog log = (AbstractLog)tuple2._2();
            return log.sizeDetailsAsyncUpdated().tieredSize();
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ long $anonfun$new$23(LogCleanerManager $this, File dir$3) {
        return BoxesRunTime.unboxToLong(((IterableOnceOps)((IterableOps)$this.logs().filter((Function1<Tuple2, Object> & Serializable)x0$5 -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$new$24(dir$3, x0$5)))).map((Function1<Tuple2, Object> & Serializable)x0$6 -> BoxesRunTime.boxToLong(LogCleanerManager.$anonfun$new$25(x0$6)))).sum(Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$new$14(LogCleanerManager $this, File dir) {
        java.util.Map<String, String> metricTag = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("logDirectory"), dir.getAbsolutePath())}))).asJava();
        $this.metricsGroup().newGauge(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$CompactedPartitionBytes(), () -> BoxesRunTime.boxToLong(LogCleanerManager.$anonfun$new$15($this, dir)), metricTag);
        ((List)$this.gaugeMetricNameWithTag().computeIfAbsent(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$CompactedPartitionBytes(), k -> new ArrayList())).add(metricTag);
        $this.metricsGroup().newGauge(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$CompactedPartitionLocalBytes(), () -> BoxesRunTime.boxToLong(LogCleanerManager.$anonfun$new$19($this, dir)), metricTag);
        ((List)$this.gaugeMetricNameWithTag().computeIfAbsent(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$CompactedPartitionLocalBytes(), k -> new ArrayList())).add(metricTag);
        $this.metricsGroup().newGauge(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$CompactedPartitionTieredBytes(), () -> BoxesRunTime.boxToLong(LogCleanerManager.$anonfun$new$23($this, dir)), metricTag);
        return ((List)$this.gaugeMetricNameWithTag().computeIfAbsent(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$CompactedPartitionTieredBytes(), k -> new ArrayList())).add(metricTag);
    }

    public static final /* synthetic */ long $anonfun$new$27(LogCleanerManager $this) {
        return Time.SYSTEM.milliseconds() - $this.timeOfLastRun();
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            AbstractLog log = (AbstractLog)tuple2._2();
            return log.isLocallyCompactable();
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$3(LogCleanerManager $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            AbstractLog log = (AbstractLog)tuple2._2();
            return $this.isUncleanablePartition(log, topicPartition) || log.isFrozenLogStartOffsetState();
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$6(LogToClean ltc) {
        return ltc.totalBytes() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$10(LogCleanerManager $this, LogToClean logToClean) {
        return $this.inProgress().contains(logToClean.topicPartition());
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$11(LogToClean ltc) {
        return ltc.needCompactionNow() && ltc.cleanableBytes() > 0L || ltc.cleanableRatio() > ltc.log().config().minCleanableRatio;
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            AbstractLog log = (AbstractLog)tuple2._2();
            return !log.isLocallyCompactable();
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$3(LogCleanerManager $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            return $this.inProgress().contains(topicPartition);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$2(LogCleanerManager $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            AbstractLog log = (AbstractLog)tuple2._2();
            return !$this.inProgress().contains(topicPartition) && log.isLocallyCompactable() && !$this.isUncleanablePartition(log, topicPartition);
        }
        throw new MatchError(tuple2);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$abortAndPauseCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$2) {
        block7: {
            block6: {
                var3_2 = false;
                var4_3 = null;
                var5_4 = $this.inProgress().get(topicPartition$2);
                if (!None$.MODULE$.equals(var5_4)) break block6;
                $this.inProgress().put(topicPartition$2, new LogCleaningPaused(1));
                break block7;
            }
            if (!(var5_4 instanceof Some)) ** GOTO lbl-1000
            var3_2 = true;
            var4_3 = (Some)var5_4;
            var6_5 = (LogCleaningState)var4_3.value();
            if (LogCleaningInProgress$.MODULE$.equals(var6_5)) {
                $this.inProgress().put(topicPartition$2, LogCleaningAborted$.MODULE$);
            } else if (var3_2 && (var7_6 = (LogCleaningState)var4_3.value()) instanceof LogCleaningPaused) {
                var8_7 = (LogCleaningPaused)var7_6;
                count = var8_7.pausedCount();
                $this.inProgress().put(topicPartition$2, new LogCleaningPaused(count + 1));
            } else {
                if (var3_2) {
                    s = (LogCleaningState)var4_3.value();
                    throw new IllegalStateException("Compaction for partition " + topicPartition$2 + " cannot be aborted and paused since it is in " + s + " state.");
                }
                throw new MatchError(var5_4);
            }
        }
        while (!$this.isCleaningInStatePaused(topicPartition$2)) {
            $this.pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateCheckpoints$2(LogCleanerManager $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            return $this.logs().keys().contains(tp);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$handleLogDirFailure$3(String dir$4, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            File k = (File)tuple2._1();
            String string = k.getAbsolutePath();
            String string2 = dir$4;
            return string == null ? string2 != null : !string.equals(string2);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$maybeTruncateCheckpoint$2(AbstractLog x$9) {
        return x$9.config().compact();
    }

    public static final /* synthetic */ boolean $anonfun$maintainUncleanablePartitions$3(LogCleanerManager $this, TopicPartition id) {
        return $this.logs().contains(id);
    }

    public static final /* synthetic */ boolean $anonfun$maintainUncleanablePartitions$4(String x0$1, Set x1$1) {
        Tuple2<String, Set> tuple2 = new Tuple2<String, Set>(x0$1, x1$1);
        if (tuple2 != null) {
            Set partitions = tuple2._2();
            return partitions.nonEmpty();
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$1(LogCleanerManager $this, String name) {
        $this.metricsGroup().removeMetric(name);
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$2(LogCleanerManager $this, String name) {
        $this.metricsGroup().removeMetric(name);
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$4(LogCleanerManager $this, Tuple2 metricNameAndTags$1, java.util.Map tag) {
        $this.metricsGroup().removeMetric((String)metricNameAndTags$1._1(), tag);
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$3(LogCleanerManager $this, Tuple2 metricNameAndTags) {
        CollectionConverters$.MODULE$.ListHasAsScala((List)metricNameAndTags._2()).asScala().foreach((Function1<java.util.Map, Object> & Serializable)tag -> {
            LogCleanerManager.$anonfun$removeMetrics$4($this, metricNameAndTags, tag);
            return BoxedUnit.UNIT;
        });
    }

    public LogCleanerManager(Seq<File> logDirs, Pool<TopicPartition, AbstractLog> logs, LogDirFailureChannel logDirFailureChannel) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.checkpoints = ((IterableOnceOps)logDirs.map((Function1<File, Tuple2> & Serializable)dir -> new Tuple2<File, OffsetCheckpointFile>((File)dir, new OffsetCheckpointFile(new File((File)dir, this.offsetCheckpointFile()), this.logDirFailureChannel())))).toMap($less$colon$less$.MODULE$.refl());
        this.inProgress = (scala.collection.mutable.HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.uncleanablePartitions = (scala.collection.mutable.HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.pausedCleaningCond = this.lock().newCondition();
        this.cleanBytesLast = new AtomicLong(0L);
        this.cleanableBytesLast = new AtomicLong(0L);
        this.uncleanableBytesLast = new AtomicLong(0L);
        this.dirtiestLogCleanableRatio = 0.0;
        this.gaugeMetricNameWithTag = new HashMap();
        logDirs.foreach((Function1<File, Object> & Serializable)dir -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$new$1(this, dir)));
        logDirs.foreach((Function1<File, Object> & Serializable)dir -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$new$7(this, dir)));
        logDirs.foreach((Function1<File, Object> & Serializable)dir -> BoxesRunTime.boxToBoolean(LogCleanerManager.$anonfun$new$14(this, dir)));
        this.timeOfLastRun = Time.SYSTEM.milliseconds();
        this.metricsGroup().newGauge(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$TimeSinceLastRunMsMetricName(), () -> BoxesRunTime.boxToLong(LogCleanerManager.$anonfun$new$27(this)));
        this.achievedCleaningRatio = this.metricsGroup().newHistogram(LogCleanerManager$.MODULE$.kafka$log$LogCleanerManager$$AchievedCleaningRatio());
    }
}

