/*
 * Decompiled with CFR 0.152.
 */
package kafka.log.remote;

import com.yammer.metrics.core.Timer;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import kafka.log.remote.RemoteLogManager;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.server.log.remote.quota.RLMQuotaManager;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.RemoteLogReadResult;
import org.apache.kafka.storage.internals.log.RemoteStorageFetchInfo;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteLogReader
implements Callable<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteLogReader.class);
    private final RemoteStorageFetchInfo fetchInfo;
    private final RemoteLogManager rlm;
    private final BrokerTopicStats brokerTopicStats;
    private final Consumer<RemoteLogReadResult> callback;
    private final RLMQuotaManager quotaManager;
    private final Timer remoteReadTimer;

    public RemoteLogReader(RemoteStorageFetchInfo fetchInfo, RemoteLogManager rlm, Consumer<RemoteLogReadResult> callback, BrokerTopicStats brokerTopicStats, RLMQuotaManager quotaManager, Timer remoteReadTimer) {
        this.fetchInfo = fetchInfo;
        this.rlm = rlm;
        this.brokerTopicStats = brokerTopicStats;
        this.callback = callback;
        this.brokerTopicStats.topicStats(fetchInfo.topicPartition.topic()).remoteFetchRequestRate().mark();
        this.brokerTopicStats.allTopicsStats().remoteFetchRequestRate().mark();
        this.quotaManager = quotaManager;
        this.remoteReadTimer = remoteReadTimer;
    }

    @Override
    public Void call() {
        RemoteLogReadResult result;
        try {
            LOGGER.debug("Reading records from remote storage for topic partition {}", (Object)this.fetchInfo.topicPartition);
            FetchDataInfo fetchDataInfo2 = this.remoteReadTimer.time(() -> this.rlm.read(this.fetchInfo));
            this.brokerTopicStats.topicStats(this.fetchInfo.topicPartition.topic()).remoteFetchBytesRate().mark(fetchDataInfo2.records.sizeInBytes());
            this.brokerTopicStats.allTopicsStats().remoteFetchBytesRate().mark(fetchDataInfo2.records.sizeInBytes());
            result = new RemoteLogReadResult(Optional.of(fetchDataInfo2), Optional.empty());
        }
        catch (OffsetOutOfRangeException e) {
            result = new RemoteLogReadResult(Optional.empty(), Optional.of(e));
        }
        catch (Exception e) {
            this.brokerTopicStats.topicStats(this.fetchInfo.topicPartition.topic()).failedRemoteFetchRequestRate().mark();
            this.brokerTopicStats.allTopicsStats().failedRemoteFetchRequestRate().mark();
            LOGGER.error("Error occurred while reading the remote data for {}", (Object)this.fetchInfo.topicPartition, (Object)e);
            result = new RemoteLogReadResult(Optional.empty(), Optional.of(e));
        }
        LOGGER.debug("Finished reading records from remote storage for topic partition {}", (Object)this.fetchInfo.topicPartition);
        this.quotaManager.record(result.fetchDataInfo.map(fetchDataInfo -> fetchDataInfo.records.sizeInBytes()).orElse(0).intValue());
        this.callback.accept(result);
        return null;
    }
}

