/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.rpo;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.MergedLog;
import kafka.restore.rpo.PartitionRpo;
import kafka.restore.rpo.RpoValue;
import kafka.tier.TierReplicaManager;
import kafka.tier.TopicIdPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class RpoMetricsManager
implements TierReplicaManager.ChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpoMetricsManager.class);
    private static final String RPO_METRICS_GROUP = "kafka.restore";
    private static final String RPO_METRICS_TYPE = "Rpo";
    private final Time time;
    private final Map<TopicIdPartition, PartitionRpo> segmentMap = new ConcurrentHashMap<TopicIdPartition, PartitionRpo>();
    Gauge<Long> rpoP50;
    Gauge<Long> rpoP99;
    Gauge<Long> rpoMax;
    private volatile RpoValue[] rpoValues;

    public synchronized void updateRpoValues(LogManager logManager) {
        try {
            this.rpoValues = (RpoValue[])this.segmentMap.values().stream().map(partitionRpo -> {
                Option<AbstractLog> logOpt = logManager.getLog(partitionRpo.topicIdPartition.topicPartition(), false);
                if (logOpt != null && logOpt.isDefined()) {
                    MergedLog log = (MergedLog)logOpt.get();
                    partitionRpo.mayLoadPartitionRpo(log);
                    partitionRpo.removeSegmentByFirstUntieredOffset(log.firstUntieredOffset());
                    if (logOpt.get().logEndOffset() == log.firstUntieredOffset()) {
                        return new RpoValue(partitionRpo.topicIdPartition, 0L);
                    }
                    return new RpoValue(partitionRpo.topicIdPartition, partitionRpo.rpo());
                }
                LOGGER.warn("{}: log is null or is not defined", (Object)partitionRpo.topicIdPartition);
                return new RpoValue(partitionRpo.topicIdPartition, 0L);
            }).sorted().toArray(RpoValue[]::new);
        }
        catch (Throwable t) {
            LOGGER.warn("error in update rpo values", t);
        }
        LOGGER.debug("update rpoValues, current values as {}", (Object)Arrays.toString(this.rpoValues));
    }

    public RpoMetricsManager(Time time) {
        this.time = time;
        this.rpoP50 = this.newRpoGauge("P50", 0.5);
        this.rpoP99 = this.newRpoGauge("P99", 0.99);
        this.rpoMax = this.newRpoGauge("Max", 1.0);
    }

    public void registerTopicIdPartition(TopicIdPartition topicIdPartition) {
        if (this.shouldIgnore(topicIdPartition.topic())) {
            return;
        }
        this.segmentMap.computeIfAbsent(topicIdPartition, tp -> new PartitionRpo((TopicIdPartition)tp, this.time));
        LOGGER.info("{}: register for RPO metrics", (Object)topicIdPartition);
    }

    public void unregisterTopicIdPartition(TopicIdPartition topicIdPartition) {
        PartitionRpo partitionRpo = this.segmentMap.remove(topicIdPartition);
        if (partitionRpo != null) {
            LOGGER.info("{}: unregistered for RPO metrics", (Object)topicIdPartition);
        }
    }

    public void addNewSegment(TopicIdPartition topicIdPartition, long baseOffset) {
        PartitionRpo partitionRpo = this.segmentMap.get(topicIdPartition);
        if (partitionRpo != null) {
            long rollTimestamp = this.time.milliseconds();
            partitionRpo.mayAddSegmentAndCreateTime(baseOffset, rollTimestamp);
        }
    }

    public PartitionRpo partitionRpo(TopicIdPartition topicIdPartition) {
        return this.segmentMap.get(topicIdPartition);
    }

    protected static long getValue(RpoValue[] values, double quantile) {
        if (quantile < 0.0 || quantile > 1.0) {
            throw new IllegalArgumentException(quantile + " is not in [0..1]");
        }
        if (values == null || values.length == 0) {
            return 0L;
        }
        double pos = quantile * (double)(values.length + 1);
        if (pos < 1.0) {
            return values[0].rpo;
        }
        if (pos >= (double)values.length) {
            return values[values.length - 1].rpo;
        }
        long lower = values[(int)pos - 1].rpo;
        long upper = values[(int)pos].rpo;
        return lower + (long)(pos - Math.floor(pos)) * (upper - lower);
    }

    private Gauge<Long> newRpoGauge(String name, double percentile) {
        MetricName metricName = KafkaMetricsGroup.explicitMetricName(RPO_METRICS_GROUP, RPO_METRICS_TYPE, name, Collections.emptyMap());
        KafkaMetricsGroup metricsGroup = new KafkaMetricsGroup(this.getClass());
        return metricsGroup.newGauge(metricName, () -> RpoMetricsManager.getValue(this.rpoValues, percentile));
    }

    private boolean shouldIgnore(String topic) {
        if (topic.startsWith("_")) {
            return true;
        }
        return topic.contains("__confluent-");
    }

    @Override
    public void onBecomeLeader(TopicIdPartition topicIdPartition, int leaderEpoch) {
        this.registerTopicIdPartition(topicIdPartition);
    }

    @Override
    public void onBecomeFollower(TopicIdPartition topicIdPartition) {
        this.unregisterTopicIdPartition(topicIdPartition);
    }

    @Override
    public void onDelete(TopicIdPartition topicIdPartition) {
        this.unregisterTopicIdPartition(topicIdPartition);
    }
}

