/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import kafka.restore.messages.CopyObjectInStoreRequest;
import kafka.restore.messages.CopyObjectInStoreResponse;
import kafka.restore.messages.MessageResult;
import kafka.restore.messages.MessageStatusCode;
import kafka.restore.messages.MultipleResponseHandler;
import kafka.restore.schedulers.RetryableException;
import kafka.restore.schedulers.SchedulerUtil;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.VersionInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyObjectOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyObjectOperator.class);
    private final CopyObjectInStoreRequest request;
    private final MultipleResponseHandler responseHandler;
    private final TierObjectStore tierObjectStore;
    private final ThreadPoolExecutor executor;

    public CopyObjectOperator(CopyObjectInStoreRequest request, MultipleResponseHandler restoreHandler, TierObjectStore tierObjectStore, ThreadPoolExecutor executor) {
        this.request = request;
        this.responseHandler = restoreHandler;
        this.tierObjectStore = tierObjectStore;
        this.executor = executor;
    }

    public CompletableFuture<Void> restoreObjectByCopy() {
        LOGGER.debug(SchedulerUtil.getThreadPoolExecutorStatus("in restoreObjectByCopy", this.executor));
        return CompletableFuture.runAsync(() -> {
            try {
                LOGGER.debug("call restoreObjectByCopy for: " + this.request.getObjectPath() + "(" + this.request.getSourceVersionId() + "), in thread: " + Thread.currentThread().getName());
                this.tierObjectStore.restoreObjectByCopy(this.request.getObjectMetadata(), this.request.getObjectPath(), new VersionInformation(this.request.getSourceVersionId()));
                LOGGER.debug("call restoreObjectByCopy for: " + this.request.getObjectPath() + ", in thread: " + Thread.currentThread().getName());
                this.responseHandler.addReceivedResponse(new CopyObjectInStoreResponse(0, this.request.getTopic(), this.request.getPartition(), this.request.getUuid(), MessageStatusCode.OK, MessageResult.SUCCESS, this.request.getSegmentId(), this.request.getObjectPath()));
            }
            catch (TierObjectStoreRetriableException ex) {
                String errorMessage = "call restoreObjectByCopy failed for: " + this.request.getObjectPath() + "(" + this.request.getSourceVersionId() + "), error as: " + ex.getCause().getMessage();
                throw new RetryableException(errorMessage, ex);
            }
        }, this.executor);
    }
}

