/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.snapshot;

import io.confluent.kafka.storage.checksum.CheckedFileIO;
import io.confluent.rest.TierRecordMetadataResponse;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.restore.RestoreMetricsManager;
import kafka.restore.operators.FtpsSegmentView;
import kafka.restore.operators.SegmentStateAndPath;
import kafka.restore.operators.SegmentStateIterator;
import kafka.restore.snapshot.SnapshotObjectStoreUtils;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierCompactionCommitAndSwap;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.domain.TierPartitionUnfreezeLogStartOffset;
import kafka.tier.domain.TierRecordType;
import kafka.tier.state.CompactStats;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.state.TierUtils;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpsStateForRestore {
    private static final Logger log = LoggerFactory.getLogger(FtpsStateForRestore.class);
    public final TopicIdPartition topicIdPartition;
    public final long fromTimestamp;
    public final long revertSinceTimestamp;
    public final Path ftpsSnapshot;
    public final FileTierPartitionState updatedFtpsState;
    public final Map<UUID, SegmentStateAndPath> compactSegmentsToRestore = new HashMap<UUID, SegmentStateAndPath>();
    public final Map<UUID, SegmentStateAndPath> compactSegmentsToDelete = new HashMap<UUID, SegmentStateAndPath>();
    public final Map<UUID, SegmentStateAndPath> retentionSegmentsToRestore = new HashMap<UUID, SegmentStateAndPath>();
    public Queue<ConsumerRecord<byte[], byte[]>> liveConsumerRecords;
    private OffsetAndEpoch revertCompactionSinceOffset;
    private final SnapshotObjectStoreUtils snapshotUtils;
    private final long ftpsHeaderSize;
    private TierRecordMetadataResponse fenceEventRecordMetadata;
    private Path updatedFtpsStateBackup;
    private long compactDirtyStartOffsetBeforeRevert;
    private CompactStats lastCompactStatsBeforeRevert;
    private CompactStats accumulatedCompactStatsBeforeRevert;
    private RestoreMetricsManager metricsManager;
    private static final long WAIT_FOR_FENCE_EVENT_IN_MS = 2000L;
    private static final int MAX_RETRY_COUNT_FOR_FENCE_EVENT = 30;

    public FtpsStateForRestore(TopicIdPartition topicIdPartition, Path ftpsSnapshot, FileTierPartitionState ftps, long fromTimestamp, long revertSinceTimestamp, SnapshotObjectStoreUtils snapshotUtils, RestoreMetricsManager metricsManager) throws IOException {
        this.topicIdPartition = topicIdPartition;
        this.ftpsSnapshot = ftpsSnapshot;
        this.updatedFtpsState = ftps;
        this.updatedFtpsStateBackup = this.getFtpsBackupPath(this.updatedFtpsState);
        this.fromTimestamp = fromTimestamp;
        this.revertSinceTimestamp = revertSinceTimestamp;
        this.snapshotUtils = snapshotUtils;
        this.saveCompactStates();
        this.ftpsHeaderSize = this.getFtpsHeaderSize(this.updatedFtpsState);
        this.updatedFtpsState.setTieredPartitionRecoveryWorkflowCb(op -> log.info(String.format("[%s]: Received %s", topicIdPartition, op)));
        this.metricsManager = metricsManager;
    }

    public void setFenceEventRecordMetadata(TierRecordMetadataResponse fenceEventRecordMetadata) {
        this.fenceEventRecordMetadata = fenceEventRecordMetadata;
    }

    public void applyEvent(AbstractTierMetadata event, OffsetAndEpoch offsetAndEpoch) throws InterruptedException {
        if (!event.topicIdPartition().equals(this.topicIdPartition)) {
            log.warn(String.format("[%s]: topicIdPartition not match, skip applying the event: %s", this.topicIdPartition, event.topicIdPartition()));
            return;
        }
        if (this.revertCompactionSinceOffset == null && event.timestamp() >= this.revertSinceTimestamp) {
            this.revertCompactionSinceOffset = offsetAndEpoch;
        }
        boolean needsRevert = this.revertCompactionSinceOffset != null ? offsetAndEpoch.offset() >= this.revertCompactionSinceOffset.offset() : false;
        this.applyEvent(event, offsetAndEpoch, needsRevert, this.snapshotUtils);
    }

    public Map<UUID, SegmentStateAndPath> restore() throws Exception {
        this.applyLiveEventsToFenceEvent();
        log.info(String.format("[%s]: replayed events stats: success = %s, fail = %s, CommitAndSwap = %s, ForceRestore And Unfreeze = %s.", this.topicIdPartition.topicPartition(), this.metricsManager.readGauge("RestoreEventsReplayedCount"), this.metricsManager.readGauge("RestoreEventsReplayFailedCount"), this.metricsManager.readGauge("RestoreEventsCommitAndSwapCount"), this.metricsManager.readGauge("RestoreEventsForceRestoreOrUnfreezeCount")));
        Path updatedFtpsStateFilePath = Paths.get(this.updatedFtpsState.flushedPath(), new String[0]);
        this.updatedFtpsState.close();
        this.backupUpdatedFtps();
        CheckedFileIO fileChannel = CheckedFileIO.open(updatedFtpsStateFilePath, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.restoreCompactSegments(fileChannel);
        this.restoreRetentionDeletedSegments(fileChannel);
        this.updateFtpsHeader(fileChannel);
        return Stream.concat(this.compactSegmentsToRestore.entrySet().stream(), this.retentionSegmentsToRestore.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<UUID, String> revertRestore() throws IOException {
        Files.copy(this.updatedFtpsStateBackup, Paths.get(this.updatedFtpsState.flushedPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        FtpsSegmentView ftpsSegmentView = new FtpsSegmentView(this.topicIdPartition.topicPartition(), new File(this.updatedFtpsState.flushedPath()), this.fromTimestamp, false);
        HashMap<UUID, String> segmentPathMap = new HashMap<UUID, String>();
        for (int index = 0; index < ftpsSegmentView.segmentStateList().size(); ++index) {
            SegmentState segmentState = ftpsSegmentView.segmentStateList().get(index);
            if (!this.compactSegmentsToRestore.containsKey(segmentState.objectId()) && !this.retentionSegmentsToRestore.containsKey(segmentState.objectId())) continue;
            TierUtils.updateSegmentState(ftpsSegmentView.topicIdPartition(), segmentState, TierObjectMetadata.State.SEGMENT_FENCED, ftpsSegmentView.stateFileChannel(), false, Long.MAX_VALUE);
            ObjectMetadata objectMetadata = new ObjectMetadata(ftpsSegmentView.topicIdPartition(), segmentState);
            segmentPathMap.put(segmentState.objectId(), objectMetadata.toFragmentLocation("", FragmentType.SEGMENT).get().objectPath());
            log.debug(String.format("[%s]: changed segment %s to SEGMENT_FENCED", this.topicIdPartition.topicPartition(), segmentState.objectId()));
        }
        ftpsSegmentView.close();
        return segmentPathMap;
    }

    private void restoreCompactSegments(CheckedFileIO ftpsChannel) throws IOException {
        SegmentStateIterator segmentStateIterator = new SegmentStateIterator(this.topicIdPartition, ftpsChannel, this.ftpsHeaderSize);
        while (segmentStateIterator.hasNext()) {
            SegmentState segmentState = (SegmentState)segmentStateIterator.next();
            UUID segmentId = segmentState.objectId();
            long stateChangeTimestamp = System.currentTimeMillis();
            log.debug(String.format("[%s]: checking segment: %s with state: %s", new Object[]{this.topicIdPartition.topicPartition(), segmentId, segmentState.state()}));
            if (this.compactSegmentsToRestore.containsKey(segmentId)) {
                if (segmentState.state() == TierObjectMetadata.State.SEGMENT_DELETE_INITIATE || segmentState.state() == TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE || segmentState.state() == TierObjectMetadata.State.SEGMENT_COMPACTED) {
                    this.compactSegmentsToRestore.put(segmentId, new SegmentStateAndPath(this.topicIdPartition, segmentState));
                }
                TierUtils.updateSegmentState(this.topicIdPartition, segmentState, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, ftpsChannel, false, stateChangeTimestamp);
                log.debug(String.format("[%s]: change segment %s to state SEGMENT_UPLOAD_COMPLETE", this.topicIdPartition.topicPartition(), segmentId));
            }
            if (!this.compactSegmentsToDelete.containsKey(segmentId)) continue;
            if (segmentState.state() == TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE) {
                this.compactSegmentsToDelete.put(segmentId, new SegmentStateAndPath(this.topicIdPartition, segmentState));
            }
            TierUtils.updateSegmentState(this.topicIdPartition, segmentState, TierObjectMetadata.State.SEGMENT_FENCED, ftpsChannel, false, stateChangeTimestamp);
            log.debug(String.format("[%s]: change segment %s to state SEGMENT_FENCED", this.topicIdPartition.topicPartition(), segmentId));
        }
        log.debug("before removing null segments, compactSegmentsToRestore has " + this.compactSegmentsToRestore.size() + " segments, compactSegmentsToDelete has " + this.compactSegmentsToDelete.size() + " segments.");
        this.compactSegmentsToRestore.forEach((k, v) -> {
            if (v == null) {
                log.debug("segment: " + String.valueOf(k) + " has no value.");
            }
        });
        this.compactSegmentsToDelete.forEach((k, v) -> {
            if (v == null) {
                log.debug("segment: " + String.valueOf(k) + " has no value.");
            }
        });
        this.compactSegmentsToRestore.values().removeIf(Objects::isNull);
        this.compactSegmentsToDelete.values().removeIf(Objects::isNull);
        log.info(String.format("[%s]: compactSegmentsToRestore segment number: %s, compactSegmentsToDelete segment number: %s", this.topicIdPartition.topicPartition(), this.compactSegmentsToRestore.size(), this.compactSegmentsToDelete.size()));
    }

    private void restoreRetentionDeletedSegments(CheckedFileIO ftpsChannel) throws IOException {
        SegmentStateIterator segmentStateIterator = new SegmentStateIterator(this.topicIdPartition, ftpsChannel, this.ftpsHeaderSize);
        while (segmentStateIterator.hasNext()) {
            SegmentState segmentState = (SegmentState)segmentStateIterator.next();
            if (segmentState.maxTimestamp() < this.fromTimestamp || segmentState.state() != TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE && segmentState.state() != TierObjectMetadata.State.SEGMENT_DELETE_INITIATE || segmentState.stateBeforeDeletion() != TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE) continue;
            long stateChangeTimestamp = System.currentTimeMillis();
            TierUtils.updateSegmentState(this.topicIdPartition, segmentState, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, ftpsChannel, false, stateChangeTimestamp);
            this.retentionSegmentsToRestore.put(segmentState.objectId(), new SegmentStateAndPath(this.topicIdPartition, segmentState));
            log.debug(String.format("[%s]: change segment %s to state SEGMENT_UPLOAD_COMPLETE", this.topicIdPartition.topicPartition(), segmentState.objectId()));
        }
        this.retentionSegmentsToRestore.values().removeIf(Objects::isNull);
        log.info(String.format("[%s]: retentionSegmentsToRestore segment number: %s", this.topicIdPartition.topicPartition(), this.retentionSegmentsToRestore.size()));
    }

    private void applyEvent(AbstractTierMetadata event, OffsetAndEpoch offsetAndEpoch, boolean needsRevert, SnapshotObjectStoreUtils snapshotUtils) throws InterruptedException {
        switch (event.type()) {
            case PartitionForceRestore: {
                TierPartitionForceRestore forceRestoreEvent = (TierPartitionForceRestore)event;
                ByteBuffer targetState = snapshotUtils.fetchRecoverSnapshot(forceRestoreEvent);
                TierPartitionState.RestoreResult restoreResult = this.updatedFtpsState.processRestoreEvents(forceRestoreEvent, Optional.of(targetState), TierPartitionStatus.ONLINE, offsetAndEpoch);
                log.info(String.format("[%s]: apply PartitionForceRestore event (%s) at offset %s with result: %s", new Object[]{this.topicIdPartition.topicPartition(), forceRestoreEvent, offsetAndEpoch.offset(), restoreResult}));
                this.metricsManager.recordReplayedEventMetrics(event.type(), restoreResult == TierPartitionState.RestoreResult.SUCCEEDED);
                break;
            }
            case PartitionUnfreezeLogStartOffset: {
                TierPartitionUnfreezeLogStartOffset unfreezeEvent = (TierPartitionUnfreezeLogStartOffset)event;
                TierPartitionState.RestoreResult unfreezeResult = this.updatedFtpsState.processRestoreEvents(unfreezeEvent, Optional.empty(), TierPartitionStatus.ONLINE, offsetAndEpoch);
                log.info(String.format("[%s]: apply PartitionUnfreezeLogStartOffset event (%s) at offset %s with result: %s", new Object[]{this.topicIdPartition.topicPartition(), unfreezeEvent, offsetAndEpoch.offset(), unfreezeResult}));
                this.metricsManager.recordReplayedEventMetrics(event.type(), unfreezeResult == TierPartitionState.RestoreResult.SUCCEEDED);
                break;
            }
            default: {
                TierPartitionState.AppendResult result = this.updatedFtpsState.append(event, offsetAndEpoch);
                log.debug(String.format("[%s]: apply tier event (%s) at offset %s with result: %s", new Object[]{this.topicIdPartition.topicPartition(), event, offsetAndEpoch.offset(), result}));
                this.metricsManager.recordReplayedEventMetrics(event.type(), result == TierPartitionState.AppendResult.ACCEPTED);
                if (result == TierPartitionState.AppendResult.ACCEPTED) {
                    if (needsRevert) {
                        int i;
                        if (event.type() != TierRecordType.CompactionCommitAndSwap) break;
                        TierCompactionCommitAndSwap commitAndSwap = (TierCompactionCommitAndSwap)event;
                        for (i = 0; i < commitAndSwap.destinationObjectIdsLength(); ++i) {
                            UUID dstSegmentId = commitAndSwap.destinationObjectIdsGet(i);
                            this.compactSegmentsToDelete.put(dstSegmentId, null);
                            log.debug(String.format("[%s]: add segment (%s) into compactSegmentsToDelete", this.topicIdPartition.topicPartition(), dstSegmentId));
                            this.metricsManager.update("RestoreEventsSegmentsToDeleteCount", 1L);
                        }
                        for (i = 0; i < commitAndSwap.sourceObjectIdsLength(); ++i) {
                            UUID srcSegmentId = commitAndSwap.sourceObjectIdsGet(i);
                            if (this.compactSegmentsToDelete.containsKey(srcSegmentId)) continue;
                            this.compactSegmentsToRestore.put(srcSegmentId, null);
                            log.debug(String.format("[%s]: add segment (%s) into compactSegmentsToRestore", this.topicIdPartition.topicPartition(), srcSegmentId));
                            this.metricsManager.update("RestoreEventsSegmentsToRestoreCount", 1L);
                        }
                        break;
                    }
                    this.saveCompactStates();
                    break;
                }
                log.warn(String.format("[%s]: failed to apply tier event (%s) at offset %s with result: %s", new Object[]{this.topicIdPartition.topicPartition(), event, offsetAndEpoch.offset(), result}));
            }
        }
    }

    private void applyLiveEventsToFenceEvent() throws InterruptedException {
        if (this.liveConsumerRecords == null) {
            log.info(String.format("[%s]: no live events to apply", this.topicIdPartition.topicPartition()));
            return;
        }
        int retry = 0;
        long previousRecordOffset = 0L;
        while (true) {
            ConsumerRecord<byte[], byte[]> record;
            if ((record = this.liveConsumerRecords.poll()) == null) {
                if (this.updatedFtpsState.status() == TierPartitionStatus.FROZEN_LOG_START_OFFSET && previousRecordOffset >= this.fenceEventRecordMetadata.offset()) break;
                log.info(String.format("[%s]: ftps is not fenced yet, wait for another %s ms to check live events again (retry: %s).the last applied event offset: %s, which need be == or >= injected fence event offset: %s to stop.", this.topicIdPartition.topicPartition(), 2000L, retry, previousRecordOffset, this.fenceEventRecordMetadata.offset()));
                Thread.sleep(2000L);
                if (++retry < 30) continue;
                throw new IllegalStateException(String.format("[%s]: ftps is not fenced yet after %s number of retries.", this.topicIdPartition.topicPartition(), retry));
            }
            AbstractTierMetadata event = SnapshotObjectStoreUtils.deserializeRecord(record);
            OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(record.offset(), record.leaderEpoch());
            this.applyEvent(event, offsetAndEpoch);
            previousRecordOffset = record.offset();
            retry = 0;
        }
        log.info(String.format("[%s]: done with applying live events, the last applied event offset: %s, which is == or >= injected fence event offset: %s.", this.topicIdPartition.topicPartition(), previousRecordOffset, this.fenceEventRecordMetadata.offset()));
    }

    private void saveCompactStates() {
        this.compactDirtyStartOffsetBeforeRevert = this.updatedFtpsState.compactDirtyStartOffset();
        this.lastCompactStatsBeforeRevert = this.updatedFtpsState.lastCompactStats();
        this.accumulatedCompactStatsBeforeRevert = this.updatedFtpsState.accumulatedCompactStats();
        log.debug(String.format("[%s]: saved compact states, compactDirtyStartOffset = %s, lastCompactStats = %s, accumulatedCompactStats = %s", this.topicIdPartition, this.compactDirtyStartOffsetBeforeRevert, this.lastCompactStatsBeforeRevert, this.accumulatedCompactStatsBeforeRevert));
    }

    private long getFtpsHeaderSize(FileTierPartitionState ftps) throws IOException {
        if (ftps == null || ftps.checkedFileIO() == null) {
            log.warn(String.format("[%s]: Input state is null, no header found", this.topicIdPartition.topicPartition()));
            return -1L;
        }
        Optional<Header> headerOpt = FileTierPartitionState.readHeader(ftps.checkedFileIO());
        if (!headerOpt.isPresent()) {
            log.error(String.format("[%s]: Input state file is not valid, no header found, file path: %s", this.topicIdPartition.topicPartition(), ftps.flushedPath()));
            return -1L;
        }
        return headerOpt.get().size();
    }

    private void updateFtpsHeader(CheckedFileIO fileChannel) throws IOException {
        Optional<Header> headerOpt = FileTierPartitionState.readHeader(fileChannel);
        if (!headerOpt.isPresent()) {
            throw new IllegalStateException("Input state file is not valid.");
        }
        Header currentHeader = headerOpt.get();
        log.debug(String.format("[%s]: before update ftps header: %s", this.topicIdPartition.topicPartition(), currentHeader));
        Long newLogStartOffset = currentHeader.startOffset();
        for (SegmentStateAndPath segmentStateAndPath : this.compactSegmentsToRestore.values()) {
            if (segmentStateAndPath.segmentState().baseOffset() >= newLogStartOffset) continue;
            newLogStartOffset = segmentStateAndPath.segmentState().baseOffset();
        }
        for (SegmentStateAndPath segmentStateAndPath : this.retentionSegmentsToRestore.values()) {
            if (segmentStateAndPath.segmentState().baseOffset() >= newLogStartOffset) continue;
            newLogStartOffset = segmentStateAndPath.segmentState().baseOffset();
        }
        log.debug(String.format("[%s]: update header with values: startOffset = %s, compactDirtyStartOffset = %s, lastCompactStats = %s, accumulatedCompactStats = %s", this.topicIdPartition.topicPartition(), newLogStartOffset, this.compactDirtyStartOffsetBeforeRevert, this.lastCompactStatsBeforeRevert, this.accumulatedCompactStatsBeforeRevert));
        Header updatedHeader = new Header(currentHeader.topicId(), currentHeader.versionInByte(), currentHeader.tierEpoch(), currentHeader.status(), newLogStartOffset, currentHeader.endOffset(), currentHeader.globalMaterializedOffsetAndEpoch(), currentHeader.localMaterializedOffsetAndEpoch(), currentHeader.errorOffsetAndEpoch(), currentHeader.restoreOffsetAndEpoch(), true, this.compactDirtyStartOffsetBeforeRevert, this.lastCompactStatsBeforeRevert, this.accumulatedCompactStatsBeforeRevert, currentHeader.hasStateChangeTimestamp(), true, currentHeader.lastSnapshotTimestampMs(), currentHeader.lastSnapshotId());
        log.debug(String.format("[%s]: the new ftps header: %s", this.topicIdPartition.topicPartition(), updatedHeader));
        if (currentHeader.size() != updatedHeader.size()) {
            String errorMessage = String.format("[%s]: header size not matching. old ftps header size: %s, new ftps header size: %s", this.topicIdPartition.topicPartition(), currentHeader.size(), updatedHeader.size());
            log.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        FileTierPartitionState.writeHeader(fileChannel, updatedHeader);
        fileChannel.flush();
        fileChannel.close();
    }

    private Path getFtpsBackupPath(FileTierPartitionState ftps) {
        return Paths.get(ftps.flushedPath() + ".backup", new String[0]);
    }

    private void backupUpdatedFtps() throws IOException {
        Files.copy(Paths.get(this.updatedFtpsState.flushedPath(), new String[0]), this.updatedFtpsStateBackup, StandardCopyOption.REPLACE_EXISTING);
    }
}

