/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kafka.metrics.BrokerLoad;
import kafka.network.RequestChannel;
import kafka.server.ActiveTenantsManager;
import kafka.server.AllRequests$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientSensors;
import kafka.server.ExemptRequest$;
import kafka.server.NonExemptRequest$;
import kafka.server.RequestQueueSizePercentiles;
import kafka.server.RequestType;
import kafka.server.ThreadUsageMetrics;
import kafka.server.ThreadUsageSensors;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.config.BrokerBackpressureConfig;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.quota.QuotaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.immutable.Map;
import scala.jdk.javaapi.CollectionConverters;
import scala.jdk.javaapi.OptionConverters;

public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientRequestQuotaManager.class);
    static final double NANOS_TO_PERCENTAGE_PER_SECOND = 100.0 / (double)TimeUnit.SECONDS.toNanos(1L);
    private static final long DEFAULT_INACTIVE_EXEMPT_SENSOR_EXPIRATION_TIME_SECONDS = Long.MAX_VALUE;
    private static final String EXEMPT_SENSOR_NAME = "exempt-" + String.valueOf((Object)QuotaType.REQUEST);
    private final long maxThrottleTimeMs;
    private final Metrics metrics;
    private final MetricName exemptMetricName;
    private final Sensor exemptSensor;
    private final ThreadUsageSensors threadUsageSensors;
    private double lastLimitCorrection;
    private final Optional<BrokerLoad> brokerLoadOpt;

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Optional<ClientQuotaCallback> quotaCallback, Optional<ActiveTenantsManager> activeTenantsManager, Optional<BrokerLoad> brokerLoadOpt) {
        super(config, metrics, QuotaType.REQUEST, time, threadNamePrefix, OptionConverters.toScala(quotaCallback), OptionConverters.toScala(activeTenantsManager));
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds);
        this.metrics = metrics;
        this.threadUsageSensors = new ThreadUsageSensors(metrics);
        this.lastLimitCorrection = 0.0;
        super.updateClientQuotaMaxThrottleTimeMs(TimeUnit.SECONDS.toMillis(this.clientQuotaManagerConfig().quotaWindowSizeSeconds));
        this.exemptMetricName = metrics.metricName("exempt-request-time", QuotaType.REQUEST.toString(), "Tracking exempt-request-time utilization percentage");
        this.exemptSensor = this.getOrCreateSensor(EXEMPT_SENSOR_NAME, Long.MAX_VALUE, sensor -> sensor.add(this.exemptMetricName, new Rate()));
        this.brokerLoadOpt = brokerLoadOpt;
    }

    public Sensor exemptSensor() {
        return this.exemptSensor;
    }

    Sensor nonExemptCapacitySensor() {
        return this.getOrCreateValueSensor("non-exempt-capacity", BrokerBackpressureConfig.nonExemptRequestCapacityMetricName(this.metrics));
    }

    private void recordExemptNetworkThread(double value, String listenerName, long timeMs) {
        this.exemptSensor.record(value, timeMs, false);
        this.recordNetworkUsage(value, listenerName, ExemptRequest$.MODULE$, timeMs);
    }

    private void recordExemptIoThread(double value, long timeMs) {
        this.exemptSensor.record(value, timeMs, false);
        this.recordIoThreadUsage(value, ExemptRequest$.MODULE$, timeMs);
    }

    public void addListenerMetrics(String listenerName) {
        this.threadUsageSensors.addListenerMetrics(listenerName);
    }

    void removeListenerMetrics(String listenerName) {
        this.threadUsageSensors.removeListenerMetrics(listenerName);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request, long timeMs) {
        return this.maybeRecordAndGetThrottleTimeMs(request, timeMs, false);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request, long timeMs, boolean forThrottleTimeInResponse) {
        double reqIoThreadPercentage = ClientRequestQuotaManager.nanosToPercentage(request.requestThreadTimeNanos());
        String listenerName = request.context().listenerName.value();
        this.recordIoThreadUsage(reqIoThreadPercentage, NonExemptRequest$.MODULE$, timeMs);
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(request.session(), request.header().clientId());
            request.setRecordNetworkThreadTimeCallback(timeNanos -> {
                long timeMsThrottle = this.time().milliseconds();
                this.recordNoThrottle(clientSensors, ClientRequestQuotaManager.nanosToPercentage(timeNanos), timeMsThrottle);
                this.recordNetworkUsage(ClientRequestQuotaManager.nanosToPercentage(timeNanos), listenerName, NonExemptRequest$.MODULE$, timeMsThrottle);
            });
            if (forThrottleTimeInResponse) {
                return this.recordAndGetThrottleTimeInResponseMs(clientSensors, reqIoThreadPercentage, timeMs);
            }
            return this.recordAndGetThrottleTimeMs(clientSensors, reqIoThreadPercentage, timeMs);
        }
        request.setRecordNetworkThreadTimeCallback(timeNanos -> this.recordNetworkUsage(ClientRequestQuotaManager.nanosToPercentage(timeNanos), listenerName, NonExemptRequest$.MODULE$, this.time().milliseconds()));
        return 0;
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        long currentTimeMs = this.time().milliseconds();
        double reqIoThreadPercentage = ClientRequestQuotaManager.nanosToPercentage(request.requestThreadTimeNanos());
        String listenerName = request.context().listenerName.value();
        if (this.quotasEnabled()) {
            request.setRecordNetworkThreadTimeCallback(timeNanos -> this.recordExemptNetworkThread(ClientRequestQuotaManager.nanosToPercentage(timeNanos), listenerName, this.time().milliseconds()));
            this.recordExemptIoThread(reqIoThreadPercentage, currentTimeMs);
        } else {
            request.setRecordNetworkThreadTimeCallback(timeNanos -> this.recordNetworkUsage(ClientRequestQuotaManager.nanosToPercentage(timeNanos), listenerName, ExemptRequest$.MODULE$, this.time().milliseconds()));
            this.recordIoThreadUsage(reqIoThreadPercentage, ExemptRequest$.MODULE$, currentTimeMs);
        }
    }

    @Override
    public boolean backpressureEnabled() {
        return this.dynamicBackpressureConfig().backpressureEnabledInConfig && !this.dynamicBackpressureConfig().tenantEndpointListenerNames.isEmpty();
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics.metricName("request-time", QuotaType.REQUEST.toString(), "Tracking request-time per user/client-id", CollectionConverters.asJava(quotaMetricTags));
    }

    public static double nanosToPercentage(long nanos) {
        return (double)nanos * NANOS_TO_PERCENTAGE_PER_SECOND;
    }

    @Override
    public double getBrokerQuotaLimit() {
        Option<KafkaMetric> metricOpt = Option.apply(this.metrics.metric(BrokerBackpressureConfig.nonExemptRequestCapacityMetricName(this.metrics)));
        if (metricOpt.isDefined()) {
            return (Double)metricOpt.get().metricValue();
        }
        return Double.MAX_VALUE;
    }

    private void recordIoThreadUsage(double value, RequestType requestType, long timeMs) {
        if (this.quotasEnabled()) {
            this.threadUsageSensors.recordIoThreadUsage(value, timeMs, requestType);
        } else {
            this.threadUsageSensors.recordIoThreadUsage(value, timeMs, AllRequests$.MODULE$);
        }
    }

    private void recordNetworkUsage(double value, String listenerName, RequestType requestType, long timeMs) {
        if (this.quotasEnabled()) {
            this.threadUsageSensors.recordNetworkThreadUsage(value, timeMs, listenerName, requestType);
        } else {
            this.threadUsageSensors.recordNetworkThreadUsage(value, timeMs, listenerName, AllRequests$.MODULE$);
        }
    }

    @Override
    public void updateBrokerQuotaLimit(long timeMs) {
        List<String> tenantEndpointsListenerNames = this.dynamicBackpressureConfig().tenantEndpointListenerNames;
        if (this.quotasEnabled() && !tenantEndpointsListenerNames.isEmpty()) {
            double nonExemptIoThreadUsage = ThreadUsageMetrics.ioThreadsUsage(this.metrics, NonExemptRequest$.MODULE$);
            double ioThreadUsage = ThreadUsageMetrics.ioThreadsUsage(this.metrics, AllRequests$.MODULE$);
            double nonExemptNetworkThreadUsage = ThreadUsageMetrics.networkThreadsUsage(this.metrics, CollectionConverters.asScala(tenantEndpointsListenerNames), NonExemptRequest$.MODULE$);
            double networkThreadUsage = ThreadUsageMetrics.networkThreadsUsage(this.metrics, CollectionConverters.asScala(tenantEndpointsListenerNames), AllRequests$.MODULE$);
            double nonExemptIoThreadLimit = this.nonExemptThreadUsageLimit(nonExemptIoThreadUsage, ioThreadUsage, ThreadUsageMetrics.ioThreadsCapacity(this.metrics));
            double nonExemptNetworkThreadLimit = this.nonExemptThreadUsageLimit(nonExemptNetworkThreadUsage, networkThreadUsage, ThreadUsageMetrics.networkThreadsCapacity(this.metrics, CollectionConverters.asScala(tenantEndpointsListenerNames)));
            double nonExemptTotalThreadLimit = nonExemptIoThreadLimit + nonExemptNetworkThreadLimit;
            double brokerRequestQuotaLimit = ioThreadUsage >= nonExemptIoThreadLimit && networkThreadUsage >= nonExemptNetworkThreadLimit || ioThreadUsage < nonExemptIoThreadLimit && networkThreadUsage < nonExemptNetworkThreadLimit ? nonExemptTotalThreadLimit : Math.min(networkThreadUsage, nonExemptNetworkThreadLimit) + Math.min(ioThreadUsage, nonExemptIoThreadLimit);
            double correctedLimit = this.updateAdjustedCapacity(brokerRequestQuotaLimit, nonExemptTotalThreadLimit);
            this.nonExemptCapacitySensor().record(correctedLimit);
        }
    }

    double nonExemptThreadUsageLimit(double nonExemptUsage, double totalUsage, double totalCapacity) {
        double exemptUsage = totalUsage - nonExemptUsage;
        double nonExemptCapacity = totalCapacity * 0.8 - exemptUsage;
        double minNonExemptCapacity = totalCapacity * 0.3;
        return Math.max(nonExemptCapacity, minNonExemptCapacity);
    }

    double updateAdjustedCapacity(double brokerRequestLimit, double nonExemptTotalThreadLimit) {
        Option<Metric> brokerLoadMetric;
        double queueSize = RequestQueueSizePercentiles.dataPlaneQueueSize(this.metrics, this.dynamicBackpressureConfig().queueSizePercentile, CollectionConverters.asScala(Collections.emptyMap()));
        double brokerLoad = 0.0;
        if (this.brokerLoadOpt.isPresent() && (brokerLoadMetric = this.brokerLoadOpt.get().brokerLoadMetric()).isDefined()) {
            brokerLoad = (Double)brokerLoadMetric.get().metricValue();
        }
        double minAdjustment = 25.0;
        double increaseAdjustment = Math.max(minAdjustment, nonExemptTotalThreadLimit * 0.02);
        double decreaseAdjustment = Math.max(minAdjustment, nonExemptTotalThreadLimit * 0.1);
        double minCap = this.dynamicBackpressureConfig().minBrokerRequestQuota;
        if (this.isBrokerOverloaded(queueSize, brokerLoad)) {
            double maxAdjustmentLimit = Math.max(brokerRequestLimit - minCap, 0.0);
            this.lastLimitCorrection = Math.min(maxAdjustmentLimit, this.lastLimitCorrection + decreaseAdjustment);
        } else {
            this.lastLimitCorrection = Math.max(0.0, this.lastLimitCorrection - increaseAdjustment);
        }
        LOGGER.debug("queueSize(p95)={} (cap:{}), brokerLoad={} (cap:{}, lastLimitCorrection={}", queueSize, this.dynamicBackpressureConfig().queueSizeCap(), brokerLoad, this.dynamicBackpressureConfig().brokerLoadCap(), this.lastLimitCorrection);
        return Math.max(brokerRequestLimit - this.lastLimitCorrection, minCap);
    }

    private boolean isBrokerOverloaded(double queueSize, double brokerLoad) {
        return queueSize >= this.dynamicBackpressureConfig().queueSizeCap() || brokerLoad >= this.dynamicBackpressureConfig().brokerLoadCap();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.threadUsageSensors.close();
    }
}

