/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.server.ReplicaManager;
import kafka.tier.fetcher.PendingOffsetForTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.purgatory.DelayedOperation;
import org.apache.kafka.storage.internals.log.FetchedTimestampAndOffset;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000594Aa\u0003\u0007\u0001#!Aa\u0004\u0001B\u0001B\u0003%q\u0004\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011!I\u0003A!A!\u0002\u0013Q\u0003\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u00119\u0003!\u0011!Q\u0001\n=C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\u0006A\u0002!\t!\u0019\u0005\u0006S\u0002!\tE\u001b\u0005\u0006W\u0002!\t\u0005\u001c\u0005\u0006[\u0002!\t\u0005\u001c\u0002\u0013\t\u0016d\u0017-_3e\u0019&\u001cHo\u00144gg\u0016$8O\u0003\u0002\u000e\u001d\u000511/\u001a:wKJT\u0011aD\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u001495\tAC\u0003\u0002\u0016-\u0005I\u0001/\u001e:hCR|'/\u001f\u0006\u0003\u001b]Q!a\u0004\r\u000b\u0005eQ\u0012AB1qC\u000eDWMC\u0001\u001c\u0003\ry'oZ\u0005\u0003;Q\u0011\u0001\u0003R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8\u0002\u000f\u0011,G.Y=NgB\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t!Aj\u001c8h\u0003M1W\r^2i\u001f:d\u0017P\u0012:p[2+\u0017\rZ3s!\t\u0001s%\u0003\u0002)C\t9!i\\8mK\u0006t\u0017A\u00037pG\u0006dG*[:ugB!1\u0006\r\u001a9\u001b\u0005a#BA\u0017/\u0003\u0011)H/\u001b7\u000b\u0003=\nAA[1wC&\u0011\u0011\u0007\f\u0002\b\u0011\u0006\u001c\b.T1q!\t\u0019d'D\u00015\u0015\t)t#\u0001\u0004d_6lwN\\\u0005\u0003oQ\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u0002!smJ!AO\u0011\u0003\r=\u0003H/[8o!\ta4)D\u0001>\u0015\tqt(A\u0002m_\u001eT!\u0001Q!\u0002\u0013%tG/\u001a:oC2\u001c(B\u0001\"\u0018\u0003\u001d\u0019Ho\u001c:bO\u0016L!\u0001R\u001f\u00033\u0019+Go\u00195fIRKW.Z:uC6\u0004\u0018I\u001c3PM\u001a\u001cX\r^\u0001\ba\u0016tG-\u001b8h!\t9E*D\u0001I\u0015\tI%*A\u0004gKR\u001c\u0007.\u001a:\u000b\u0005-s\u0011\u0001\u0002;jKJL!!\u0014%\u00033A+g\u000eZ5oO>3gm]3u\r>\u0014H+[7fgR\fW\u000e]\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\t\u0001\u0016+D\u0001\r\u0013\t\u0011FB\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002!I,7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0003\u0002\u0011V/vK!AV\u0011\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003\u0002-\\eaj\u0011!\u0017\u0006\u00035\u0006\n!bY8mY\u0016\u001cG/[8o\u0013\ta\u0016LA\u0002NCB\u0004\"\u0001\t0\n\u0005}\u000b#\u0001B+oSR\fa\u0001P5oSRtDc\u00022dI\u00164w\r\u001b\t\u0003!\u0002AQAH\u0004A\u0002}AQ!J\u0004A\u0002\u0019BQ!K\u0004A\u0002)BQ!R\u0004A\u0002\u0019CQAT\u0004A\u0002=CQaU\u0004A\u0002Q\u000b1\u0002\u001e:z\u0007>l\u0007\u000f\\3uKR\ta%\u0001\u0007p]\u0016C\b/\u001b:bi&|g\u000eF\u0001^\u0003)ygnQ8na2,G/\u001a")
public class DelayedListOffsets
extends DelayedOperation {
    private final boolean fetchOnlyFromLeader;
    private final HashMap<TopicPartition, Option<FetchedTimestampAndOffset>> localLists;
    private final PendingOffsetForTimestamp pending;
    private final ReplicaManager replicaManager;
    private final Function1<Map<TopicPartition, Option<FetchedTimestampAndOffset>>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        CollectionConverters$.MODULE$.MapHasAsScala(this.localLists).asScala().withFilter((Function1<Tuple2<TopicPartition, Option<FetchedTimestampAndOffset>>, Object>)(Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(DelayedListOffsets.$anonfun$tryComplete$1(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object object;
                TopicPartition tp = (TopicPartition)tuple2._1();
                Option v = (Option)tuple2._2();
                try {
                    Partition partition = $this.replicaManager.getPartitionOrException(tp);
                    Optional<Integer> leaderEpoch = ((FetchedTimestampAndOffset)v.get()).leaderEpoch();
                    object = partition.localLogWithEpochOrThrow(leaderEpoch, $this.fetchOnlyFromLeader);
                }
                catch (Exception e) {
                    $this.pending.completeExceptionally(tp, e);
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            throw new MatchError(tuple2);
        });
        if (this.pending.isDone()) {
            return this.forceComplete();
        }
        return false;
    }

    @Override
    public void onExpiration() {
        this.pending.cancel();
    }

    @Override
    public void onComplete() {
        scala.collection.mutable.Map tierResponses = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(this.pending.tierTimestampAndOffsets()).asScala().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                Option<FetchedTimestampAndOffset> timestampAndOffset = OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional($this.pending.results().getOrDefault(topicPartition, Optional.of(new FetchedTimestampAndOffset(Errors.REQUEST_TIMED_OUT.exception())))));
                return new Tuple2<TopicPartition, Option<FetchedTimestampAndOffset>>(topicPartition, timestampAndOffset);
            }
            throw new MatchError(tuple2);
        });
        this.responseCallback.apply((Map<TopicPartition, Option<FetchedTimestampAndOffset>>)CollectionConverters$.MODULE$.MapHasAsScala(this.localLists).asScala().$plus$plus(tierResponses));
    }

    public static final /* synthetic */ boolean $anonfun$tryComplete$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public DelayedListOffsets(long delayMs, boolean fetchOnlyFromLeader, HashMap<TopicPartition, Option<FetchedTimestampAndOffset>> localLists, PendingOffsetForTimestamp pending, ReplicaManager replicaManager, Function1<Map<TopicPartition, Option<FetchedTimestampAndOffset>>, BoxedUnit> responseCallback) {
        this.fetchOnlyFromLeader = fetchOnlyFromLeader;
        this.localLists = localLists;
        this.pending = pending;
        this.replicaManager = replicaManager;
        this.responseCallback = responseCallback;
        super(delayMs);
    }
}

