/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.client.InternalClientInfo;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00014A\u0001C\u0005\u0001\u001d!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011!I\u0005A!A!\u0002\u0013Q\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u000b9\u0003A\u0011A(\t\u000bU\u0003A\u0011\t,\t\u000be\u0003A\u0011\u0001.\u00037%sG/\u001a:oC2\fE-\\5o\u00072LWM\u001c;TkB\u0004H.[3s\u0015\tQ1\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0019\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u0010/A\u0011\u0001#F\u0007\u0002#)\u0011!cE\u0001\u0005Y\u0006twMC\u0001\u0015\u0003\u0011Q\u0017M^1\n\u0005Y\t\"AB(cU\u0016\u001cG\u000f\u0005\u0003\u0019;}aS\"A\r\u000b\u0005iY\u0012\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0005q\u0019\u0012\u0001B;uS2L!AH\r\u0003\u0011\u0019+hn\u0019;j_:\u0004\"\u0001I\u0015\u000f\u0005\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u000e\u0003\u0019a$o\\8u})\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\u00051\u0001K]3eK\u001aL!AK\u0016\u0003\rM#(/\u001b8h\u0015\tAS\u0005\u0005\u0002.o5\taF\u0003\u00020a\u0005)\u0011\rZ7j]*\u0011\u0011GM\u0001\bG2LWM\u001c;t\u0015\ta1G\u0003\u00025k\u00051\u0011\r]1dQ\u0016T\u0011AN\u0001\u0004_J<\u0017B\u0001\u001d/\u0005\u0015\tE-\\5o\u0003\u0019\u0019wN\u001c4jOB\u00111\bP\u0007\u0002\u0013%\u0011Q(\u0003\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u000bnKR\fG-\u0019;b\u00136\fw-Z*vaBd\u0017.\u001a:\u0011\u0007\u0001\u000b5)D\u0001&\u0013\t\u0011UEA\u0005Gk:\u001cG/[8oaA\u0011AiR\u0007\u0002\u000b*\u0011aIM\u0001\u0006S6\fw-Z\u0005\u0003\u0011\u0016\u0013Q\"T3uC\u0012\fG/Y%nC\u001e,\u0017A\u0006;ss\u000e{g\u000e\u001e:pY2,'OQ8piN$(/\u00199\u0011\u0005\u0001[\u0015B\u0001'&\u0005\u001d\u0011un\u001c7fC:\f!\u0003\u001e:z\u0005J|7.\u001a:C_>$8\u000f\u001e:ba\u00061A(\u001b8jiz\"R\u0001U)S'R\u0003\"a\u000f\u0001\t\u000be*\u0001\u0019\u0001\u001e\t\u000by*\u0001\u0019A \t\u000b%+\u0001\u0019\u0001&\t\u000b5+\u0001\u0019\u0001&\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u00051:\u0006\"\u0002-\u0007\u0001\u0004y\u0012\u0001C2mS\u0016tG/\u00133\u0002\u001b\u001d,G\u000f\u0015:pa\u0016\u0014H/[3t)\tYv\f\u0005\u0002];6\t1$\u0003\u0002_7\tQ\u0001K]8qKJ$\u0018.Z:\t\u000ba;\u0001\u0019A\u0010")
public class InternalAdminClientSupplier
implements Function<String, Admin> {
    private final KafkaConfig config;
    private final Function0<MetadataImage> metadataImageSupplier;
    private final boolean tryControllerBootstrap;
    private final boolean tryBrokerBootstrap;

    @Override
    public <V> Function<V, Admin> compose(Function<? super V, ? extends String> x$1) {
        return Function.super.compose(x$1);
    }

    @Override
    public <V> Function<String, V> andThen(Function<? super Admin, ? extends V> x$1) {
        return Function.super.andThen(x$1);
    }

    @Override
    public Admin apply(String clientId) {
        Properties properties = this.getProperties(clientId);
        return Admin.create(properties);
    }

    public Properties getProperties(String clientId) {
        InternalClientInfo clientInfo = new InternalClientInfo.Builder().setNodeId(this.config.nodeId()).setMetadataImage(this.metadataImageSupplier.apply()).setTryControllerBootstrap(this.tryControllerBootstrap).setTryBrokerBootstrap(this.tryBrokerBootstrap).setFirstControllerEndpointName((String)this.config.controllerListenerNames().head()).setInterBrokerEndpointName(this.config.interBrokerListenerName().value()).build();
        Map<String, Object> configMap = ConfluentConfigs.clientConfigsForEndpoint(this.config.originals(), this.config.values(), new ListenerName(clientInfo.endpointName()), clientInfo.securityProtocol());
        Properties properties = new Properties();
        properties.setProperty("client.id", clientId);
        configMap.forEach((k, v) -> properties.setProperty((String)k, v.toString()));
        Object object = clientInfo.usingControllerBootstrap() ? properties.setProperty("bootstrap.controllers", clientInfo.bootstrapString()) : properties.setProperty("bootstrap.servers", clientInfo.bootstrapString());
        return properties;
    }

    public InternalAdminClientSupplier(KafkaConfig config, Function0<MetadataImage> metadataImageSupplier, boolean tryControllerBootstrap, boolean tryBrokerBootstrap) {
        this.config = config;
        this.metadataImageSupplier = metadataImageSupplier;
        this.tryControllerBootstrap = tryControllerBootstrap;
        this.tryBrokerBootstrap = tryBrokerBootstrap;
    }
}

