/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.EnumSet;
import java.util.Optional;
import java.util.OptionalInt;
import kafka.log.MergedLog$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.bootstrap.BootstrapDirectory;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.server.config.ServerTopicConfigSynonyms;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.slf4j.Logger;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class KafkaRaftServer$ {
    public static final KafkaRaftServer$ MODULE$ = new KafkaRaftServer$();
    private static final String MetadataTopic = "__cluster_metadata";
    private static final TopicPartition MetadataPartition = Topic.CLUSTER_METADATA_TOPIC_PARTITION;
    private static final Uuid MetadataTopicId = Uuid.METADATA_TOPIC_ID;
    private static final KafkaConfigSchema configSchema = new KafkaConfigSchema(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ConfigResource.Type.BROKER), new ConfigDef(KafkaConfig$.MODULE$.configDef())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ConfigResource.Type.TOPIC), LogConfig.configDefCopy()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ConfigResource.Type.CLUSTER_LINK), ClusterLinkConfig$.MODULE$.configDefCopy())}))).asJava(), ServerTopicConfigSynonyms.ALL_TOPIC_CONFIG_SYNONYMS);

    public String MetadataTopic() {
        return MetadataTopic;
    }

    public TopicPartition MetadataPartition() {
        return MetadataPartition;
    }

    public Uuid MetadataTopicId() {
        return MetadataTopicId;
    }

    public Tuple2<MetaPropertiesEnsemble, BootstrapMetadata> initializeLogDirs(KafkaConfig config, Logger log, String logPrefix) {
        MetaPropertiesEnsemble.Loader loader = new MetaPropertiesEnsemble.Loader();
        loader.addMetadataLogDir(config.metadataLogDir()).addLogDirs(CollectionConverters$.MODULE$.SeqHasAsJava(config.logDirs()).asJava());
        MetaPropertiesEnsemble initialMetaPropsEnsemble = loader.load();
        EnumSet<MetaPropertiesEnsemble.VerificationFlag> verificationFlags = EnumSet.of(MetaPropertiesEnsemble.VerificationFlag.REQUIRE_AT_LEAST_ONE_VALID, MetaPropertiesEnsemble.VerificationFlag.REQUIRE_METADATA_LOG_DIR);
        initialMetaPropsEnsemble.verify(Optional.empty(), OptionalInt.of(config.nodeId()), verificationFlags);
        String metadataPartitionDirName = MergedLog$.MODULE$.logDirName(this.MetadataPartition());
        initialMetaPropsEnsemble.logDirProps().keySet().forEach(logDir -> {
            if (!logDir.equals(config.metadataLogDir())) {
                File clusterMetadataTopic = new File((String)logDir, metadataPartitionDirName);
                if (clusterMetadataTopic.exists()) {
                    throw new KafkaException("Found unexpected metadata location in data directory `" + clusterMetadataTopic + "` (the configured metadata directory is " + config.metadataLogDir() + ").");
                }
                return;
            }
        });
        MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(initialMetaPropsEnsemble);
        initialMetaPropsEnsemble.nonFailedDirectoryProps().forEachRemaining(e -> {
            String logDir2 = (String)e.getKey();
            Optional metaProps = (Optional)e.getValue();
            if (!metaProps.isPresent()) {
                throw new RuntimeException("No `meta.properties` found in " + logDir2 + " (have you run `kafka-storage.sh` to format the directory?)");
            }
            if (!((MetaProperties)metaProps.get()).nodeId().isPresent()) {
                throw new RuntimeException("Error: node ID not found in " + logDir2);
            }
            if (!((MetaProperties)metaProps.get()).clusterId().isPresent()) {
                throw new RuntimeException("Error: cluster ID not found in " + logDir2);
            }
            MetaProperties.Builder builder = new MetaProperties.Builder((MetaProperties)metaProps.get());
            Object object = !builder.directoryId().isPresent() ? builder.setDirectoryId(copier.generateValidDirectoryId()) : BoxedUnit.UNIT;
            copier.setLogDirProps(logDir2, builder.build());
            copier.setPreWriteHandler((logDir, x$9, x$10) -> log.info("{}Rewriting {}{}meta.properties", logPrefix, logDir, File.separator));
        });
        copier.writeLogDirChanges();
        MetaPropertiesEnsemble metaPropsEnsemble = copier.copy();
        BootstrapDirectory bootstrapDirectory = new BootstrapDirectory(config.metadataLogDir());
        BootstrapMetadata bootstrapMetadata = bootstrapDirectory.read();
        return new Tuple2<MetaPropertiesEnsemble, BootstrapMetadata>(metaPropsEnsemble, bootstrapMetadata);
    }

    public KafkaConfigSchema configSchema() {
        return configSchema;
    }

    private KafkaRaftServer$() {
    }
}

