/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.network.ConnectionQuotas;
import kafka.network.FetchRequestInterceptor;
import kafka.network.ProduceRequestInterceptor;
import kafka.server.ConfigHandler;
import kafka.server.MetadataRequestMinimumThrottleConfig;
import kafka.utils.Logging;
import org.apache.kafka.server.authorizer.AuthorizerConfig;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005=a\u0001B\b\u0011\u0001UA\u0001B\n\u0001\u0003\u0006\u0004%Ia\n\u0005\t]\u0001\u0011\t\u0011)A\u0005Q!Aq\u0006\u0001BC\u0002\u0013%\u0001\u0007\u0003\u0005A\u0001\t\u0005\t\u0015!\u00032\u0011!\t\u0005A!b\u0001\n\u0013\u0011\u0005\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u0011\u001d\u0003!Q1A\u0005\n!C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\t)\u0002\u0011)\u0019!C\u0005+\"A!\f\u0001B\u0001B\u0003%a\u000b\u0003\u0005\\\u0001\t\u0015\r\u0011\"\u0003]\u0011!\t\u0007A!A!\u0002\u0013i\u0006\"\u00022\u0001\t\u0003\u0019\u0007\"B6\u0001\t\u0003a'a\u0005+f]\u0006tGoQ8oM&<\u0007*\u00198eY\u0016\u0014(BA\t\u0013\u0003\u0019\u0019XM\u001d<fe*\t1#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u00011B\u0004\t\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005uqR\"\u0001\t\n\u0005}\u0001\"!D\"p]\u001aLw\rS1oI2,'\u000f\u0005\u0002\"I5\t!E\u0003\u0002$%\u0005)Q\u000f^5mg&\u0011QE\t\u0002\b\u0019><w-\u001b8h\u0003A\u0019wN\u001c8fGRLwN\\)v_R\f7/F\u0001)!\tIC&D\u0001+\u0015\tY##A\u0004oKR<xN]6\n\u00055R#\u0001E\"p]:,7\r^5p]F+x\u000e^1t\u0003E\u0019wN\u001c8fGRLwN\\)v_R\f7\u000fI\u0001\u001baJ|G-^2feN#\u0018\r^3NC:\fw-\u001a:D_:4\u0017nZ\u000b\u0002cA\u0011!GP\u0007\u0002g)\u0011A'N\u0001\u0004Y><'B\u0001\u001c8\u0003%Ig\u000e^3s]\u0006d7O\u0003\u00029s\u000591\u000f^8sC\u001e,'BA\n;\u0015\tYD(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002{\u0005\u0019qN]4\n\u0005}\u001a$A\u0007)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'oQ8oM&<\u0017a\u00079s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'oQ8oM&<\u0007%\u0001\u0013nKR\fG-\u0019;b%\u0016\fX/Z:u\u001b&t\u0017.\\;n)\"\u0014x\u000e\u001e;mK\u000e{gNZ5h+\u0005\u0019\u0005CA\u000fE\u0013\t)\u0005C\u0001\u0013NKR\fG-\u0019;b%\u0016\fX/Z:u\u001b&t\u0017.\\;n)\"\u0014x\u000e\u001e;mK\u000e{gNZ5h\u0003\u0015jW\r^1eCR\f'+Z9vKN$X*\u001b8j[VlG\u000b\u001b:piRdWmQ8oM&<\u0007%A\nbkRDwN]5{KJ\u001cuN\u001c4jO>\u0003H/F\u0001J!\r9\"\nT\u0005\u0003\u0017b\u0011aa\u00149uS>t\u0007CA'R\u001b\u0005q%BA(Q\u0003)\tW\u000f\u001e5pe&TXM\u001d\u0006\u0003#eJ!A\u0015(\u0003!\u0005+H\u000f[8sSj,'oQ8oM&<\u0017\u0001F1vi\"|'/\u001b>fe\u000e{gNZ5h\u001fB$\b%\u0001\u000egKR\u001c\u0007NU3rk\u0016\u001cH/\u00138uKJ\u001cW\r\u001d;pe>\u0003H/F\u0001W!\r9\"j\u0016\t\u0003SaK!!\u0017\u0016\u0003/\u0019+Go\u00195SKF,Xm\u001d;J]R,'oY3qi>\u0014\u0018a\u00074fi\u000eD'+Z9vKN$\u0018J\u001c;fe\u000e,\u0007\u000f^8s\u001fB$\b%\u0001\u000fqe>$WoY3SKF,Xm\u001d;J]R,'oY3qi>\u0014x\n\u001d;\u0016\u0003u\u00032a\u0006&_!\tIs,\u0003\u0002aU\tI\u0002K]8ek\u000e,'+Z9vKN$\u0018J\u001c;fe\u000e,\u0007\u000f^8s\u0003u\u0001(o\u001c3vG\u0016\u0014V-];fgRLe\u000e^3sG\u0016\u0004Ho\u001c:PaR\u0004\u0013A\u0002\u001fj]&$h\bF\u0004eK\u001a<\u0007.\u001b6\u0011\u0005u\u0001\u0001\"\u0002\u0014\u000e\u0001\u0004A\u0003\"B\u0018\u000e\u0001\u0004\t\u0004\"B!\u000e\u0001\u0004\u0019\u0005\"B$\u000e\u0001\u0004I\u0005\"\u0002+\u000e\u0001\u00041\u0006\"B.\u000e\u0001\u0004i\u0016\u0001\u00069s_\u000e,7o]\"p]\u001aLwm\u00115b]\u001e,7\u000fF\u0002nav\u0004\"a\u00068\n\u0005=D\"\u0001B+oSRDQ!\u001d\bA\u0002I\fa\u0001^3oC:$\bCA:{\u001d\t!\b\u0010\u0005\u0002v15\taO\u0003\u0002x)\u00051AH]8pizJ!!\u001f\r\u0002\rA\u0013X\rZ3g\u0013\tYHP\u0001\u0004TiJLgn\u001a\u0006\u0003sbAQA \bA\u0002}\faaY8oM&<\u0007\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0005kRLGN\u0003\u0002\u0002\n\u0005!!.\u0019<b\u0013\u0011\ti!a\u0001\u0003\u0015A\u0013x\u000e]3si&,7\u000f")
public class TenantConfigHandler
implements ConfigHandler,
Logging {
    private final ConnectionQuotas connectionQuotas;
    private final ProducerStateManagerConfig producerStateManagerConfig;
    private final MetadataRequestMinimumThrottleConfig metadataRequestMinimumThrottleConfig;
    private final Option<AuthorizerConfig> authorizerConfigOpt;
    private final Option<FetchRequestInterceptor> fetchRequestInterceptorOpt;
    private final Option<ProduceRequestInterceptor> produceRequestInterceptorOpt;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TenantConfigHandler tenantConfigHandler = this;
        synchronized (tenantConfigHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    private MetadataRequestMinimumThrottleConfig metadataRequestMinimumThrottleConfig() {
        return this.metadataRequestMinimumThrottleConfig;
    }

    private Option<AuthorizerConfig> authorizerConfigOpt() {
        return this.authorizerConfigOpt;
    }

    private Option<FetchRequestInterceptor> fetchRequestInterceptorOpt() {
        return this.fetchRequestInterceptorOpt;
    }

    private Option<ProduceRequestInterceptor> produceRequestInterceptorOpt() {
        return this.produceRequestInterceptorOpt;
    }

    @Override
    public void processConfigChanges(String tenant, Properties config) {
        String string = tenant;
        String string2 = "<default>";
        None$ updatedTenant = (string == null ? string2 != null : !string.equals(string2)) ? new Some<String>(tenant) : None$.MODULE$;
        Option<Object> tenantConnectionRateQuota = config.containsKey("connection_creation_rate") ? Option$.MODULE$.apply(config.getProperty("connection_creation_rate")).map((Function1<String, Object> & Serializable)x$6 -> BoxesRunTime.boxToDouble(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x$6)))) : Option$.MODULE$.empty();
        this.info((Function0<String> & Serializable)() -> "Setting tenant-level connection rate for tenant " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(updatedTenant)) + " to " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(tenantConnectionRateQuota)));
        this.connectionQuotas().updateTenantConnectionRateQuota(updatedTenant, tenantConnectionRateQuota);
        Option tenantProducerIdExpirationMsConfig = config.containsKey("producer_id_expiration_ms") ? Option$.MODULE$.apply(config.getProperty("producer_id_expiration_ms")).map((Function1<String, Object> & Serializable)x$7 -> BoxesRunTime.boxToDouble(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x$7)))).map(x$8 -> (int)x$8).map((Function1<Object, Integer> & Serializable)x -> TenantConfigHandler.$anonfun$processConfigChanges$8(BoxesRunTime.unboxToInt(x))) : Option$.MODULE$.empty();
        this.info((Function0<String> & Serializable)() -> "Setting tenant-level producer ID expiration for tenant " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(updatedTenant)) + " to " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(tenantProducerIdExpirationMsConfig)));
        this.producerStateManagerConfig().setProducerIdExpirationMs(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(updatedTenant)), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(tenantProducerIdExpirationMsConfig)));
        Option<Object> metadataRequestMinimumThrottleMsConfig = config.containsKey("metadata_request_minimum_throttle_ms") ? Option$.MODULE$.apply(config.getProperty("metadata_request_minimum_throttle_ms")).map((Function1<String, Object> & Serializable)x$9 -> BoxesRunTime.boxToDouble(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x$9)))).map(x$10 -> (int)x$10) : Option$.MODULE$.empty();
        this.info((Function0<String> & Serializable)() -> "Setting tenant-level metadata request minimum throttle for tenant " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(updatedTenant)) + " to " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(metadataRequestMinimumThrottleMsConfig)));
        this.metadataRequestMinimumThrottleConfig().setMinimumThrottle(updatedTenant, metadataRequestMinimumThrottleMsConfig);
        this.debug((Function0<String> & Serializable)() -> String.valueOf(this.metadataRequestMinimumThrottleConfig()));
        Option<Object> tenantConnectionCountQuota = config.containsKey("connection_creation_count") ? Option$.MODULE$.apply(config.getProperty("connection_creation_count")).map((Function1<String, Object> & Serializable)x$11 -> BoxesRunTime.boxToDouble(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x$11)))).map(x$12 -> (int)x$12) : Option$.MODULE$.empty();
        this.info((Function0<String> & Serializable)() -> "Setting tenant-level connection count limit for tenant " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(updatedTenant)) + " to " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(tenantConnectionCountQuota)));
        this.connectionQuotas().updateTenantConnectionCountQuota(updatedTenant, tenantConnectionCountQuota);
        Option maxAcls = config.containsKey("acl_count") ? Option$.MODULE$.apply(config.getProperty("acl_count")).map((Function1<String, Object> & Serializable)x$13 -> BoxesRunTime.boxToDouble(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x$13)))).map(x$14 -> (int)x$14) : Option$.MODULE$.empty();
        this.authorizerConfigOpt().foreach((Function1<AuthorizerConfig, Object> & Serializable)authorizerConfig -> {
            TenantConfigHandler.$anonfun$processConfigChanges$19(this, updatedTenant, maxAcls, authorizerConfig);
            return BoxedUnit.UNIT;
        });
        Option shouldRejectReads = config.containsKey("reject_all_fetches") ? Option$.MODULE$.apply(config.getProperty("reject_all_fetches")).map((Function1<String, Object> & Serializable)x$15 -> BoxesRunTime.boxToDouble(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x$15)))) : Option$.MODULE$.empty();
        this.fetchRequestInterceptorOpt().foreach((Function1<FetchRequestInterceptor, Object> & Serializable)fetchRequestInterceptor -> {
            TenantConfigHandler.$anonfun$processConfigChanges$23(this, shouldRejectReads, updatedTenant, tenant, fetchRequestInterceptor);
            return BoxedUnit.UNIT;
        });
        Option shouldRejectWrites = config.containsKey("reject_all_produces") ? Option$.MODULE$.apply(config.getProperty("reject_all_produces")).map((Function1<String, Object> & Serializable)x$16 -> BoxesRunTime.boxToDouble(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x$16)))) : Option$.MODULE$.empty();
        this.produceRequestInterceptorOpt().foreach((Function1<ProduceRequestInterceptor, Object> & Serializable)produceRequestInterceptor -> {
            TenantConfigHandler.$anonfun$processConfigChanges$27(this, shouldRejectWrites, updatedTenant, tenant, produceRequestInterceptor);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Integer $anonfun$processConfigChanges$8(int x) {
        return BoxesRunTime.boxToInteger(x);
    }

    public static final /* synthetic */ Integer $anonfun$processConfigChanges$21(int x) {
        return BoxesRunTime.boxToInteger(x);
    }

    public static final /* synthetic */ void $anonfun$processConfigChanges$19(TenantConfigHandler $this, Option updatedTenant$1, Option maxAcls$1, AuthorizerConfig authorizerConfig) {
        $this.info((Function0<String> & Serializable)() -> "Setting tenant-level max acl count limit for tenant " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(updatedTenant$1)) + " to " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(maxAcls$1)));
        authorizerConfig.setTenantMaxAcls(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(updatedTenant$1)), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(maxAcls$1.map((Function1<Object, Integer> & Serializable)x -> TenantConfigHandler.$anonfun$processConfigChanges$21(BoxesRunTime.unboxToInt(x))))));
    }

    public static final /* synthetic */ void $anonfun$processConfigChanges$23(TenantConfigHandler $this, Option shouldRejectReads$1, Option updatedTenant$1, String tenant$1, FetchRequestInterceptor fetchRequestInterceptor) {
        if (shouldRejectReads$1.isDefined() && BoxesRunTime.unboxToDouble(shouldRejectReads$1.get()) == 1.0) {
            $this.info((Function0<String> & Serializable)() -> "Setting tenant-level config to intercept fetch requests from tenant " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(updatedTenant$1)));
            fetchRequestInterceptor.ignoreRequestsFromTenant(tenant$1);
            return;
        }
        $this.info((Function0<String> & Serializable)() -> "Setting tenant-level config to accept fetch requests from tenant " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(updatedTenant$1)));
        fetchRequestInterceptor.acceptRequestsFromTenant(tenant$1);
    }

    public static final /* synthetic */ void $anonfun$processConfigChanges$27(TenantConfigHandler $this, Option shouldRejectWrites$1, Option updatedTenant$1, String tenant$1, ProduceRequestInterceptor produceRequestInterceptor) {
        if (shouldRejectWrites$1.isDefined() && BoxesRunTime.unboxToDouble(shouldRejectWrites$1.get()) == 1.0) {
            $this.info((Function0<String> & Serializable)() -> "Setting tenant-level config to intercept produce requests from tenant " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(updatedTenant$1)));
            produceRequestInterceptor.ignoreRequestsFromTenant(tenant$1);
            return;
        }
        $this.info((Function0<String> & Serializable)() -> "Setting tenant-level config to accept produce requests from tenant " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(updatedTenant$1)));
        produceRequestInterceptor.acceptRequestsFromTenant(tenant$1);
    }

    public TenantConfigHandler(ConnectionQuotas connectionQuotas, ProducerStateManagerConfig producerStateManagerConfig, MetadataRequestMinimumThrottleConfig metadataRequestMinimumThrottleConfig, Option<AuthorizerConfig> authorizerConfigOpt, Option<FetchRequestInterceptor> fetchRequestInterceptorOpt, Option<ProduceRequestInterceptor> produceRequestInterceptorOpt) {
        this.connectionQuotas = connectionQuotas;
        this.producerStateManagerConfig = producerStateManagerConfig;
        this.metadataRequestMinimumThrottleConfig = metadataRequestMinimumThrottleConfig;
        this.authorizerConfigOpt = authorizerConfigOpt;
        this.fetchRequestInterceptorOpt = fetchRequestInterceptorOpt;
        this.produceRequestInterceptorOpt = produceRequestInterceptorOpt;
        Logging.$init$(this);
    }
}

