/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ActiveClusterLink$;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkCheckAvailabilityTaskType$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionChecker$;
import kafka.server.link.ClusterLinkConnectionCheckerResult;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.InvalidBootstrapInternalEndpointUnavailableLinkReason;
import kafka.server.link.LinkState;
import kafka.server.link.RemoteLinkState;
import kafka.server.link.RemoteLinkState$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.UnauthorizedBootstrapFailedLinkReason$;
import kafka.server.link.UnavailableLinkReason;
import kafka.server.link.UnavailableLinkReason$;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0$mcZ$sp;

@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001B\u0010!\u0001\u001dB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!Aa\b\u0001B\u0001B\u0003%q\bC\u0005C\u0001\t\u0005\t\u0015!\u0003D\r\"A\u0001\n\u0001BC\u0002\u0013\u0005\u0011\nC\u0005N\u0001\t\u0005\t\u0015!\u0003K\u001d\"A\u0001\u000b\u0001BC\u0002\u0013\u0005\u0011\u000b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003S\u0011!1\u0006A!A!\u0002\u00139\u0006\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u0013m\u0003!\u0011!Q\u0001\nqK\u0007\"\u00036\u0001\u0005\u0003\u0005\u000b\u0011B6p\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u001di\bA1A\u0005\nyDq!!\u0006\u0001A\u0003%q\u0010C\u0005\u0002\u0018\u0001\u0001\r\u0011\"\u0003\u0002\u001a!I\u00111\u0004\u0001A\u0002\u0013%\u0011Q\u0004\u0005\b\u0003S\u0001\u0001\u0015)\u0003D\u0011%\tY\u0003\u0001a\u0001\n\u0013\ti\u0003C\u0005\u0002<\u0001\u0001\r\u0011\"\u0003\u0002>!A\u0011\u0011\t\u0001!B\u0013\ty\u0003\u0003\u0005\u0002L\u0001!\t\u0006IA'\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003KBq!!\u001c\u0001\t\u0013\ty\u0007C\u0004\u0002\b\u0002!I!!#\t\u000f\u0005e\u0006\u0001\"\u0015\u0002<\"9\u0011q\u0019\u0001\u0005B\u0005%\u0007bBAf\u0001\u0011%\u0011Q\u001a\u0005\b\u0003#\u0004A\u0011BAj\u0011\u001d\t)\u000f\u0001C\u0005\u0003O\u0014\u0001e\u00117vgR,'\u000fT5oW\u000eCWmY6MS:\\\u0017I^1jY\u0006\u0014\u0017\u000e\\5us*\u0011\u0011EI\u0001\u0005Y&t7N\u0003\u0002$I\u000511/\u001a:wKJT\u0011!J\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*[9\u0011!fK\u0007\u0002A%\u0011A\u0006I\u0001\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\n\u00059z#\u0001\u0004)fe&|G-[2UCN\\'B\u0001\u0017!\u0003)a\u0017N\\6D_:4\u0017n\u001a\t\u0004eU:T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0001\u00169\u0013\tI\u0004EA\tDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\fq!\\3ue&\u001c7\u000f\u0005\u0002+y%\u0011Q\b\t\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/\u0001\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014\bC\u0001\u0016A\u0013\t\t\u0005E\u0001\nDYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014\u0018AC5oi\u0016\u0014h/\u00197NgB\u0011!\u0007R\u0005\u0003\u000bN\u00121!\u00138u\u0013\t9U&A\tsKN\u001c\u0007.\u001a3vY\u0016$U\r\\1z\u001bN\f1b\u00197TG\",G-\u001e7feV\t!\n\u0005\u0002+\u0017&\u0011A\n\t\u0002\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\u0002\u0019\rd7k\u00195fIVdWM\u001d\u0011\n\u0005=k\u0013!C:dQ\u0016$W\u000f\\3s\u0003!a\u0017N\\6ECR\fW#\u0001*\u0011\u0005)\u001a\u0016B\u0001+!\u0005=\u0019E.^:uKJd\u0015N\\6ECR\f\u0017!\u00037j].$\u0015\r^1!\u0003-\u0011X-\\8uK\u0006#W.\u001b8\u0011\u0005)B\u0016BA-!\u0005U\u0019E.^:uKJd\u0015N\\6CCR\u001c\u0007.\u00113nS:\f!\u0002\\8dC2\fE-\\5o\u0003\u0011!\u0018.\\3\u0011\u0005u;W\"\u00010\u000b\u0005}\u0003\u0017!B;uS2\u001c(BA1c\u0003\u0019\u0019w.\\7p]*\u0011Qe\u0019\u0006\u0003I\u0016\fa!\u00199bG\",'\"\u00014\u0002\u0007=\u0014x-\u0003\u0002i=\n!A+[7f\u0013\tYV&A\u0003rk>$\u0018\r\u0005\u0002m[6\t!%\u0003\u0002oE\t92\t\\;ti\u0016\u0014H*\u001b8l%\u0016\fX/Z:u#V|G/Y\u0005\u0003U6\na\u0001P5oSRtDc\u0003:tiV4x\u000f_={wr\u0004\"A\u000b\u0001\t\u000bAj\u0001\u0019A\u0019\t\u000bij\u0001\u0019A\u001e\t\u000byj\u0001\u0019A \t\u000b\tk\u0001\u0019A\"\t\u000b!k\u0001\u0019\u0001&\t\u000bAk\u0001\u0019\u0001*\t\u000bYk\u0001\u0019A,\t\u000bik\u0001\u0019A,\t\u000bmk\u0001\u0019\u0001/\t\u000b)l\u0001\u0019A6\u0002\u00111Lgn\u001b(b[\u0016,\u0012a \t\u0005\u0003\u0003\tyA\u0004\u0003\u0002\u0004\u0005-\u0001cAA\u0003g5\u0011\u0011q\u0001\u0006\u0004\u0003\u00131\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u000eM\na\u0001\u0015:fI\u00164\u0017\u0002BA\t\u0003'\u0011aa\u0015;sS:<'bAA\u0007g\u0005IA.\u001b8l\u001d\u0006lW\rI\u0001\nM\u0006LGnQ8v]R,\u0012aQ\u0001\u000eM\u0006LGnQ8v]R|F%Z9\u0015\t\u0005}\u0011Q\u0005\t\u0004e\u0005\u0005\u0012bAA\u0012g\t!QK\\5u\u0011!\t9#EA\u0001\u0002\u0004\u0019\u0015a\u0001=%c\u0005Qa-Y5m\u0007>,h\u000e\u001e\u0011\u0002\u0011Q\f7o\u001b#fg\u000e,\"!a\f\u0011\u000bI\n\t$!\u000e\n\u0007\u0005M2G\u0001\u0004PaRLwN\u001c\t\u0004U\u0005]\u0012bAA\u001dA\tyA+Y:l\t\u0016\u001c8M]5qi&|g.\u0001\u0007uCN\\G)Z:d?\u0012*\u0017\u000f\u0006\u0003\u0002 \u0005}\u0002\"CA\u0014)\u0005\u0005\t\u0019AA\u0018\u0003%!\u0018m]6EKN\u001c\u0007\u0005K\u0002\u0016\u0003\u000b\u00022AMA$\u0013\r\tIe\r\u0002\tm>d\u0017\r^5mK\u0006\u0019!/\u001e8\u0015\u0005\u0005=\u0003\u0003BA)\u0003?r1!a\u0015,\u001d\u0011\t)&!\u0018\u000f\t\u0005]\u00131\f\b\u0005\u0003\u000b\tI&C\u0001&\u0013\t\u0019C%\u0003\u0002\"E%\u0019\u0011\u0011M\u0018\u0003\u0015Q\u000b7o\u001b*fgVdG/A\u000etW&\u0004(+Z7pi\u0016\fe/Y5mC\nLG.\u001b;z\u0007\",7m[\u000b\u0003\u0003O\u00022AMA5\u0013\r\tYg\r\u0002\b\u0005>|G.Z1o\u0003mA\u0017M\u001c3mK\u0012+7o\u0019:jE\u0016\u001cE.^:uKJ\u0014Vm];miR1\u0011qJA9\u0003wBq!a\u001d\u0019\u0001\u0004\t)(A\u0006uCN\\7i\u001c8uKb$\b\u0003BA)\u0003oJ1!!\u001f0\u0005-!\u0016m]6D_:$X\r\u001f;\t\u000f\u0005u\u0004\u00041\u0001\u0002\u0000\u00059S.Y=cK\u000ecWo\u001d;fe2Kgn[\"p]:,7\r^5p]\u000eCWmY6feJ+7/\u001e7u!\u0015\u0011\u0014\u0011GAA!\rQ\u00131Q\u0005\u0004\u0003\u000b\u0003#AI\"mkN$XM\u001d'j].\u001cuN\u001c8fGRLwN\\\"iK\u000e\\WM\u001d*fgVdG/A\u0013iC:$G.\u001a'pG\u0006dG)Z:de&\u0014Wm\u00117vgR,'\u000fT5oWN\u0014Vm];miR1\u0011qJAF\u0003\u001bCq!a\u001d\u001a\u0001\u0004\t)\bC\u0004\u0002\u0010f\u0001\r!!%\u0002'\u0011,7o\u0019:jE\u0016d\u0015N\\6t\rV$XO]3\u0011\r\u0005M\u0015QSAM\u001b\u0005\u0001\u0017bAALA\nY1*\u00194lC\u001a+H/\u001e:f!\u0019\tY*!*\u0002*6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b\t+\u0001\u0003vi&d'BAAR\u0003\u0011Q\u0017M^1\n\t\u0005\u001d\u0016Q\u0014\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0003BAV\u0003kk!!!,\u000b\t\u0005=\u0016\u0011W\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0004\u0003g\u0013\u0017aB2mS\u0016tGo]\u0005\u0005\u0003o\u000biK\u0001\fDYV\u001cH/\u001a:MS:\\G)Z:de&\u0004H/[8o\u00031ygnQ8na2,G/[8o)\u0011\ty\"!0\t\u000f\u0005}&\u00041\u0001\u0002B\u00061!/Z:vYR\u00042!KAb\u0013\r\t)m\f\u0002\u0014\u0007>l\u0007\u000f\\3uK\u0012$\u0016m]6SKN,H\u000e^\u0001\u0010i\u0006\u001c8\u000eR3tGJL\u0007\u000f^5p]R\u0011\u0011qF\u0001\u0016Y&\u001cHOU3n_R,7\t\\;ti\u0016\u0014H*\u001b8l)\u0011\ty%a4\t\u000f\u0005MD\u00041\u0001\u0002v\u0005!\u0002.\u00198eY\u0016d\u0015n\u001d;MS:\\'+Z:vYR$b!a\u0014\u0002V\u0006]\u0007bBA:;\u0001\u0007\u0011Q\u000f\u0005\b\u00033l\u0002\u0019AAn\u0003\u00191W\u000f^;sKB1\u00111SAK\u0003;\u0004b!a'\u0002&\u0006}\u0007\u0003BAV\u0003CLA!a9\u0002.\n\u00112\t\\;ti\u0016\u0014H*\u001b8l\u0019&\u001cH/\u001b8h\u0003Qawn\u001a'j].$Um]2sS\n,WI\u001d:peR1\u0011qDAu\u0003\u007fDq!a;\u001f\u0001\u0004\ti/A\u0001f!\u0011\ty/!?\u000f\t\u0005E\u0018Q\u001f\b\u0005\u0003\u000b\t\u00190C\u00015\u0013\r\t9pM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY0!@\u0003\u0013QC'o\\<bE2,'bAA|g!1!\u0011\u0001\u0010A\u0002}\f\u0001\u0002\\5oW\u0012+7o\u0019")
public class ClusterLinkCheckLinkAvailability
extends ClusterLinkScheduler.PeriodicTask {
    private final Function0<ClusterLinkConfig> linkConfig;
    private final ClusterLinkMetrics metrics;
    private final ClusterLinkManager clusterLinkManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkBatchAdmin remoteAdmin;
    private final ClusterLinkBatchAdmin localAdmin;
    private final String linkName;
    private int failCount;
    private volatile Option<TaskDescription> taskDesc;

    public ClusterLinkScheduler clScheduler() {
        return super.scheduler();
    }

    public ClusterLinkData linkData() {
        return this.linkData;
    }

    private String linkName() {
        return this.linkName;
    }

    private int failCount() {
        return this.failCount;
    }

    private void failCount_$eq(int x$1) {
        this.failCount = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty());
        if (this.skipRemoteAvailabilityCheck()) {
            KafkaFuture<Collection<ClusterLinkDescription>> describeLinksFuture = this.localAdmin.describeClusterLink(this.linkName()).result();
            this.scheduleWhenComplete(describeLinksFuture, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleLocalDescribeClusterLinksResult((ClusterLinkScheduler.TaskContext)tc, describeLinksFuture), new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty())));
            return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
        }
        DescribeClusterResult describeClusterResult = ClusterLinkConnectionChecker$.MODULE$.doBasicDescribeCluster(this.remoteAdmin);
        JFunction0$mcZ$sp intranetConnectivityDeniedChecker = () -> $this.clusterLinkManager.isIntranetConnectivityDeniedForOrg(this.linkData().tenantPrefix().map((Function1<String, String> & Serializable)tenantPrefix -> ClusterLinkUtils$.MODULE$.logicalCluster((String)tenantPrefix)));
        this.scheduleWhenComplete(describeClusterResult.clusterId(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleDescribeClusterResult((ClusterLinkScheduler.TaskContext)tc, ClusterLinkConnectionChecker$.MODULE$.check(describeClusterResult, $this.linkConfig.apply(), Option$.MODULE$.apply($this.metrics), true, intranetConnectivityDeniedChecker, this.linkData().tenantPrefix())), new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty())));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private boolean skipRemoteAvailabilityCheck() {
        ConfluentConfigs.ClusterLinkAvailabilityCheckMode clusterLinkAvailabilityCheckMode = this.clusterLinkManager.brokerConfig().clusterLinkAvailabilityCheckMode();
        ConfluentConfigs.ClusterLinkAvailabilityCheckMode clusterLinkAvailabilityCheckMode2 = ConfluentConfigs.ClusterLinkAvailabilityCheckMode.LINK_COORDINATOR;
        return !(clusterLinkAvailabilityCheckMode != null ? !((Object)((Object)clusterLinkAvailabilityCheckMode)).equals((Object)clusterLinkAvailabilityCheckMode2) : clusterLinkAvailabilityCheckMode2 != null) && !this.clusterLinkManager.metadataManager().isLinkCoordinator(this.linkName());
    }

    private ClusterLinkScheduler.TaskResult handleDescribeClusterResult(ClusterLinkScheduler.TaskContext taskContext, Option<ClusterLinkConnectionCheckerResult> maybeClusterLinkConnectionCheckerResult) {
        if (Predef$.MODULE$.Boolean2boolean(this.linkConfig.apply().clusterLinkPaused())) {
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)package$.MODULE$.Seq().empty());
        }
        String linkName = this.metrics.linkName();
        Option<ClusterLinkConnectionCheckerResult> option = maybeClusterLinkConnectionCheckerResult;
        if (None$.MODULE$.equals(option)) {
            this.failCount_$eq(0);
            this.debug((Function0<String> & Serializable)() -> "Link " + linkName + " availability check succeeded");
            this.clusterLinkManager.reportAvailableLink(linkName);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            ClusterLinkConnectionCheckerResult linkUnavailableResult = (ClusterLinkConnectionCheckerResult)some.value();
            this.failCount_$eq(this.failCount() + 1);
            this.metrics.linkUnavailableSensor().record();
            UnavailableLinkReason unavailableLinkReason = linkUnavailableResult.unavailableLinkReason();
            if (unavailableLinkReason instanceof InvalidBootstrapInternalEndpointUnavailableLinkReason) {
                this.error((Function0<String> & Serializable)() -> "Link " + linkName + " availability check failed with authorization error");
                this.clusterLinkManager.failClusterLink(linkName, linkUnavailableResult.throwable(), UnauthorizedBootstrapFailedLinkReason$.MODULE$, this.linkConfig.apply());
            } else {
                LinkState linkState;
                if (this.failCount() >= Predef$.MODULE$.Integer2int(this.linkConfig.apply().availabilityCheckConsecutiveFailureThreshold())) {
                    this.debug((Function0<String> & Serializable)() -> "Reporting " + linkName + " as unavailable with exception " + linkUnavailableResult.throwable().getCause() + " and reason " + linkUnavailableResult.unavailableLinkReason() + " failCount " + this.failCount());
                    this.clusterLinkManager.reportUnavailableLink(linkName, linkUnavailableResult.unavailableLinkReason());
                }
                LinkState linkState2 = linkState = this.clusterLinkManager.linkState(linkName);
                ActiveClusterLink$ activeClusterLink$ = ActiveClusterLink$.MODULE$;
                if (!(linkState2 != null ? !linkState2.equals(activeClusterLink$) : activeClusterLink$ != null)) {
                    this.info((Function0<String> & Serializable)() -> "Link " + linkName + " availability check failed " + this.failCount() + " times", (Function0<Throwable> & Serializable)() -> linkUnavailableResult.throwable());
                } else {
                    this.debug((Function0<String> & Serializable)() -> "Link " + linkName + " availability check in state " + linkState + " failed " + this.failCount() + " times with exception " + linkUnavailableResult.throwable().getCause() + " and reason code " + linkUnavailableResult.unavailableLinkReason());
                }
            }
        } else {
            throw new MatchError(option);
        }
        if (!this.linkConfig.apply().remoteIsUnmanaged()) {
            if (this.failCount() == 0) {
                return this.listRemoteClusterLink(taskContext);
            }
            this.clusterLinkManager.updateRemoteLinkState(linkName, new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.UNKNOWN, new Some<String>("Failed to obtain remote link state since cluster link is unavailable"), super.time().milliseconds()));
            return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
        }
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleLocalDescribeClusterLinksResult(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Collection<ClusterLinkDescription>> describeLinksFuture) {
        if (Predef$.MODULE$.Boolean2boolean(this.linkConfig.apply().clusterLinkPaused())) {
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)package$.MODULE$.Seq().empty());
        }
        Tuple2 tuple2 = this.liftedTree1$1(describeLinksFuture);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Collection links = (Collection)tuple2._1();
        Option errOpt = (Option)tuple2._2();
        Tuple2<Collection, Option> tuple22 = new Tuple2<Collection, Option>(links, errOpt);
        Collection links2 = tuple22._1();
        Option errOpt2 = tuple22._2();
        links2.forEach(link -> {
            if (!$this.clusterLinkManager.metadataManager().isLinkCoordinator(link.linkName())) {
                RemoteLinkState remoteLinkState = new RemoteLinkState(link.remoteLinkState(), link.remoteLinkError(), Option$.MODULE$.apply(link.remoteLinkErrorMessage()), link.remoteLinkStateTimeMs());
                ClusterLinkDescription.LinkState linkState = link.linkState();
                if (((Object)((Object)ClusterLinkDescription.LinkState.ACTIVE)).equals((Object)linkState)) {
                    this.debug((Function0<String> & Serializable)() -> "Link " + link.linkName() + "(" + link.clusterLinkId() + ") is active");
                    $this.clusterLinkManager.reportAvailableLink(link.linkName());
                } else if (((Object)((Object)ClusterLinkDescription.LinkState.UNAVAILABLE)).equals((Object)linkState)) {
                    UnavailableLinkReason reason = UnavailableLinkReason$.MODULE$.fromError(link.clusterLinkError(), link.linkErrorMessage());
                    this.debug((Function0<String> & Serializable)() -> "Link " + link.linkName() + "(" + link.clusterLinkId() + ") is unavailable, reason " + reason);
                    $this.metrics.linkUnavailableSensor().record();
                    $this.clusterLinkManager.reportUnavailableLink(link.linkName(), reason);
                } else {
                    this.debug((Function0<String> & Serializable)() -> "Link " + link.linkName() + "(" + link.clusterLinkId() + ") has state " + linkState + ", ignoring.");
                }
                $this.clusterLinkManager.updateRemoteLinkState(link.linkName(), remoteLinkState);
                return;
            }
            this.trace((Function0<String> & Serializable)() -> "Ignoring link state of " + link.linkName() + " since this broker has already processed the state as link coordinator");
        });
        Option option = errOpt2;
        if (option instanceof Some) {
            Some some = (Some)option;
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)some.value();
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$)));
        }
        if (None$.MODULE$.equals(option)) {
            return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
        }
        throw new MatchError(option);
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String> & Serializable)() -> "Completed with task result " + result);
        this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkCheckAvailabilityTaskType$.MODULE$, false, "run the availability check task"));
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    private ClusterLinkScheduler.TaskResult listRemoteClusterLink(ClusterLinkScheduler.TaskContext taskContext) {
        KafkaFuture<Collection<ClusterLinkListing>> listLinkResult = this.remoteAdmin.listClusterLink(this.linkName()).result();
        this.scheduleWhenComplete(listLinkResult, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleListLinkResult((ClusterLinkScheduler.TaskContext)tc, listLinkResult), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleListLinkResult(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Collection<ClusterLinkListing>> future) {
        Seq<Nothing$> seq;
        Option option;
        RemoteLinkState remoteLinkState;
        block9: {
            Tuple2 tuple2;
            block8: {
                if (Predef$.MODULE$.Boolean2boolean(this.linkConfig.apply().clusterLinkPaused())) {
                    return ClusterLinkScheduler$.MODULE$.completedTask((Seq)package$.MODULE$.Seq().empty());
                }
                long now = super.time().milliseconds();
                tuple2 = this.liftedTree2$1(future, now);
                if (tuple2 == null) break block8;
                Option errOpt = (Option)tuple2._1();
                remoteLinkState = (RemoteLinkState)tuple2._2();
                if (errOpt == null) break block8;
                option = errOpt;
                if (remoteLinkState != null) break block9;
            }
            throw new MatchError(tuple2);
        }
        RemoteLinkState remoteLinkState2 = remoteLinkState;
        Tuple2<Option, RemoteLinkState> tuple2 = new Tuple2<Option, RemoteLinkState>(option, remoteLinkState2);
        Option errOpt = tuple2._1();
        RemoteLinkState remoteLinkState3 = tuple2._2();
        this.clusterLinkManager.updateRemoteLinkState(this.linkName(), remoteLinkState3);
        Option option2 = errOpt;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)some.value();
            seq = new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$);
        } else if (None$.MODULE$.equals(option2)) {
            seq = (Seq)package$.MODULE$.Seq().empty();
        } else {
            throw new MatchError(option2);
        }
        Seq<Nothing$> errs = seq;
        return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(errs));
    }

    private void logLinkDescribeError(Throwable e, String linkDesc) {
        Throwable cause;
        Throwable throwable = cause = e.getCause() == null ? e : e.getCause();
        if (this.failCount() == 0 && !(cause instanceof RetriableException)) {
            this.info((Function0<String> & Serializable)() -> linkDesc + " link state could not be determined for cluster link " + this.linkName(), (Function0<Throwable> & Serializable)() -> e);
            return;
        }
        this.debug((Function0<String> & Serializable)() -> linkDesc + " link state could not be determined for cluster link " + this.linkName(), (Function0<Throwable> & Serializable)() -> e);
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(KafkaFuture describeLinksFuture$2) {
        Tuple2 tuple2;
        try {
            tuple2 = new Tuple2(describeLinksFuture$2.get(), (Some<TaskErrorCodeAndMsg>)((Object)None$.MODULE$));
        }
        catch (Throwable e) {
            this.logLinkDescribeError(e, "Local");
            TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Failed to obtain local link state from the link coordinator.");
            tuple2 = new Tuple2(Collections.emptySet(), new Some<TaskErrorCodeAndMsg>(err));
        }
        return tuple2;
    }

    private final /* synthetic */ Tuple2 liftedTree2$1(KafkaFuture future$1, long now$1) {
        Tuple2<None$, RemoteLinkState> tuple2;
        try {
            Collection listing = (Collection)future$1.get();
            this.debug((Function0<String> & Serializable)() -> "handleListLinkResult " + this.linkName() + ": " + listing);
            if (listing.isEmpty()) {
                this.info((Function0<String> & Serializable)() -> "Remote link state is empty for cluster link " + this.linkName());
                ClusterLinkDescription.LinkState x$1 = ClusterLinkDescription.LinkState.REMOTE_LINK_NOT_FOUND;
                ClusterLinkError x$2 = ClusterLinkError.NO_ERROR;
                long x$3 = now$1;
                Option<String> x$4 = RemoteLinkState$.MODULE$.apply$default$3();
                Tuple2<None$, RemoteLinkState> tuple22 = new Tuple2<None$, RemoteLinkState>(None$.MODULE$, new RemoteLinkState(ClusterLinkDescription.LinkState.REMOTE_LINK_NOT_FOUND, ClusterLinkError.NO_ERROR, x$4, x$3));
                tuple2 = tuple22;
            } else {
                ClusterLinkListing remoteLink = (ClusterLinkListing)listing.iterator().next();
                tuple2 = new Tuple2<None$, RemoteLinkState>(None$.MODULE$, new RemoteLinkState(remoteLink.linkState(), remoteLink.clusterLinkError(), Option$.MODULE$.apply(remoteLink.linkErrorMessage()), now$1));
            }
        }
        catch (Throwable ex) {
            ApiException e = ClusterLinkUtils$.MODULE$.apiException(ex, "Remote link state could not be determined for cluster link " + this.linkName());
            this.logLinkDescribeError(e, "Remote");
            ApiException apiException = e;
            if (apiException instanceof AuthenticationException) {
                String errMsg = "Failed to obtain remote link state due to authentication failure. This failure may impact functioning of this link until credentials are updated.";
                tuple2 = new Tuple2<Some<TaskErrorCodeAndMsg>, RemoteLinkState>(new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg)), new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.AUTHENTICATION_ERROR, new Some<String>(errMsg), now$1));
            }
            if (apiException instanceof ClusterAuthorizationException) {
                String errMsg = "Failed to obtain remote link state due to Describe:Cluster authorization failure. This failure may impact functioning of this link until appropriate access is granted.";
                tuple2 = new Tuple2<Some<TaskErrorCodeAndMsg>, RemoteLinkState>(new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg)), new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.AUTHORIZATION_ERROR, new Some<String>(errMsg), now$1));
            }
            if (apiException != null) {
                String errMsg = "Failed to obtain remote link state for an unknown reason.";
                tuple2 = new Tuple2<Some<TaskErrorCodeAndMsg>, RemoteLinkState>(new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.UNKNOWN, new Some<String>(errMsg), now$1));
            }
            throw new MatchError((Object)apiException);
        }
        return tuple2;
    }

    public ClusterLinkCheckLinkAvailability(Function0<ClusterLinkConfig> linkConfig, ClusterLinkMetrics metrics, ClusterLinkManager clusterLinkManager, int intervalMs, ClusterLinkScheduler clScheduler, ClusterLinkData linkData, ClusterLinkBatchAdmin remoteAdmin, ClusterLinkBatchAdmin localAdmin, Time time, ClusterLinkRequestQuota quota) {
        this.linkConfig = linkConfig;
        this.metrics = metrics;
        this.clusterLinkManager = clusterLinkManager;
        this.linkData = linkData;
        this.remoteAdmin = remoteAdmin;
        this.localAdmin = localAdmin;
        super(clScheduler, "ClusterLinkCheckLinkAvailability", intervalMs, time, quota);
        this.linkName = linkData.linkName();
        this.failCount = 0;
        this.taskDesc = None$.MODULE$;
    }
}

