/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.metadata.MirrorTopic;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005}c\u0001\u0002\n\u0014\u0001iA\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\tm\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003:\u0011!i\u0004A!A!\u0002\u0013q\u0004\"B!\u0001\t\u0003\u0011\u0005bB$\u0001\u0005\u0004%I\u0001\u0013\u0005\u0007+\u0002\u0001\u000b\u0011B%\t\u000fY\u0003!\u0019!C\u0005/\"11\f\u0001Q\u0001\naCQ\u0001\u0018\u0001\u0005BuCQ!\u001b\u0001\u0005B)Dq!!\u0005\u0001\t\u0003\n\u0019\u0002C\u0004\u0002*\u0001!\t%a\u000b\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@!9\u00111\u000b\u0001\u0005\n\u0005U\u0003bBA*\u0001\u0011%\u00111\f\u0002\u001f\u00072,8\u000f^3s\u0019&t7nQ8pe\u0012Lg.\u0019;pe2K7\u000f^3oKJT!\u0001F\u000b\u0002\t1Lgn\u001b\u0006\u0003-]\taa]3sm\u0016\u0014(\"\u0001\r\u0002\u000b-\fgm[1\u0004\u0001M!\u0001aG\u0012,!\ta\u0012%D\u0001\u001e\u0015\tqr$\u0001\u0003mC:<'\"\u0001\u0011\u0002\t)\fg/Y\u0005\u0003Eu\u0011aa\u00142kK\u000e$\bC\u0001\u0013)\u001d\t)c%D\u0001\u0014\u0013\t93#\u0001\nDYV\u001cH/\u001a:MS:\\g)Y2u_JL\u0018BA\u0015+\u0005]a\u0015N\\6D_>\u0014H-\u001b8bi>\u0014H*[:uK:,'O\u0003\u0002('A\u0011AfL\u0007\u0002[)\u0011afF\u0001\u0006kRLGn]\u0005\u0003a5\u0012q\u0001T8hO&tw-A\u0006mS:\\W*\u00198bO\u0016\u0014X#A\u001a\u0011\u0005\u0015\"\u0014BA\u001b\u0014\u0005I\u0019E.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0002\u00191Lgn['b]\u0006<WM\u001d\u0011\u0002\u001f5,G/\u00193bi\u0006l\u0015M\\1hKJ,\u0012!\u000f\t\u0003KiJ!aO\n\u00035\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0002!5,G/\u00193bi\u0006l\u0015M\\1hKJ\u0004\u0013!C:dQ\u0016$W\u000f\\3s!\t)s(\u0003\u0002A'\t!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJ\fa\u0001P5oSRtD\u0003B\"E\u000b\u001a\u0003\"!\n\u0001\t\u000bE2\u0001\u0019A\u001a\t\u000b]2\u0001\u0019A\u001d\t\u000bu2\u0001\u0019\u0001 \u0002%-\u0014\u0018M\u001a;NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u000b\u0002\u0013B\u0019!*T(\u000e\u0003-S\u0011\u0001T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d.\u0013aa\u00149uS>t\u0007C\u0001)T\u001b\u0005\t&B\u0001*\u0016\u0003!iW\r^1eCR\f\u0017B\u0001+R\u0005IY%+\u00194u\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002'-\u0014\u0018M\u001a;NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0011\u0002\u001f!\f7o\u0013*bMR\u001cV\u000f\u001d9peR,\u0012\u0001\u0017\t\u0003\u0015fK!AW&\u0003\u000f\t{w\u000e\\3b]\u0006\u0001\u0002.Y:L%\u00064GoU;qa>\u0014H\u000fI\u0001\u0005]\u0006lW\rF\u0001_!\tyfM\u0004\u0002aIB\u0011\u0011mS\u0007\u0002E*\u00111-G\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015\\\u0015A\u0002)sK\u0012,g-\u0003\u0002hQ\n11\u000b\u001e:j]\u001eT!!Z&\u0002!=tW*\u001a;bI\u0006$\u0018-\u00169eCR,G#B6ow\u0006\u0005\u0001C\u0001&m\u0013\ti7J\u0001\u0003V]&$\b\"B8\r\u0001\u0004\u0001\u0018!D7fi\u0006$\u0017\r^1EK2$\u0018\r\u0005\u0002rs6\t!O\u0003\u0002ti\u0006)\u0011.\\1hK*\u0011\u0001$\u001e\u0006\u0003m^\fa!\u00199bG\",'\"\u0001=\u0002\u0007=\u0014x-\u0003\u0002{e\niQ*\u001a;bI\u0006$\u0018\rR3mi\u0006DQ\u0001 \u0007A\u0002u\f\u0001C\\3x\u001b\u0016$\u0018\rZ1uC&k\u0017mZ3\u0011\u0005Et\u0018BA@s\u00055iU\r^1eCR\f\u0017*\\1hK\"9\u00111\u0001\u0007A\u0002\u0005\u0015\u0011\u0001C7b]&4Wm\u001d;\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003s\u0003\u0019aw.\u00193fe&!\u0011qBA\u0005\u00059au.\u00193fe6\u000bg.\u001b4fgR\f\u0001c\u001c8Va\u0012\fG/Z'fi\u0006$\u0017\r^1\u0015\u0007-\f)\u0002C\u0004\u0002\u00185\u0001\r!!\u0007\u0002%5L'O]8s)>\u0004\u0018nY\"iC:<Wm\u001d\t\u0005\u00037\t\u0019C\u0004\u0003\u0002\u001e\u0005}Q\"A\u000b\n\u0007\u0005\u0005R#\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\n\t\u0005\u0015\u0012q\u0005\u0002\u0013\u001b&\u0014(o\u001c:U_BL7m\u00115b]\u001e,7OC\u0002\u0002\"U\t\u0001e\u001c8DYV\u001cH/\u001a:MS:\\7i\\8sI&t\u0017\r^8s\u000b2,7\r^5p]R\u00191.!\f\t\u000f\u0005=b\u00021\u0001\u00022\u0005)A.\u001b8lgB)q,a\r\u00028%\u0019\u0011Q\u00075\u0003\u0007M+G\u000fE\u0002&\u0003sI1!a\u000f\u0014\u0005=\u0019E.^:uKJd\u0015N\\6ECR\f\u0017aI8o\u00072,8\u000f^3s\u0019&t7nQ8pe\u0012Lg.\u0019;peJ+7/[4oCRLwN\u001c\u000b\u0004W\u0006\u0005\u0003bBA\"\u001f\u0001\u0007\u0011QI\u0001\nY&t7.\u00133TKR\u0004RaXA\u001a\u0003\u000f\u0002B!!\u0013\u0002P5\u0011\u00111\n\u0006\u0004\u0003\u001b\"\u0018AB2p[6|g.\u0003\u0003\u0002R\u0005-#\u0001B+vS\u0012\fqd\u00195fG.l\u0015N\u001d:peN#\u0018\r^3B]\u0012,\u00050Z2vi\u0016$\u0016m]6t)\rY\u0017q\u000b\u0005\u0007\u00033\u0002\u0002\u0019\u00019\u0002\u000b\u0011,G\u000e^1\u0015\u0007-\fi\u0006\u0003\u0004\u0015#\u0001\u0007\u0011q\u0007")
public class ClusterLinkCoordinatorListener
implements ClusterLinkFactory.LinkCoordinatorListener,
Logging {
    private final ClusterLinkManager linkManager;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkScheduler scheduler;
    private final Option<KRaftMetadataCache> kraftMetadataCache;
    private final boolean hasKRaftSupport;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ClusterLinkCoordinatorListener clusterLinkCoordinatorListener = this;
        synchronized (clusterLinkCoordinatorListener) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkManager linkManager() {
        return this.linkManager;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private Option<KRaftMetadataCache> kraftMetadataCache() {
        return this.kraftMetadataCache;
    }

    private boolean hasKRaftSupport() {
        return this.hasKRaftSupport;
    }

    @Override
    public String name() {
        return "ClusterLinkCoordinatorListener";
    }

    @Override
    public void onMetadataUpdate(MetadataDelta metadataDelta, MetadataImage newMetadataImage, LoaderManifest manifest) {
        this.scheduler.scheduleOnce("scheduleChangesForDeltaByClusterLinkLeaders", () -> this.checkMirrorStateAndExecuteTasks(metadataDelta));
    }

    @Override
    public void onUpdateMetadata(ReplicaManager.MirrorTopicChanges mirrorTopicChanges) {
        if (this.metadataManager().isLinkCoordinatorEnabled()) {
            mirrorTopicChanges.newMirrorStates().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
                ClusterLinkCoordinatorListener.$anonfun$onUpdateMetadata$1(this, mirrorTopicChanges, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void onClusterLinkCoordinatorElection(Set<ClusterLinkData> links) {
        this.debug((Function0<String> & Serializable)() -> "link coordinator elected for links: " + links.map((Function1<ClusterLinkData, String> & Serializable)x$1 -> x$1.linkName()));
        links.foreach((Function1<ClusterLinkData, Object> & Serializable)cld -> {
            Object object;
            block4: {
                try {
                    if (cld.isDeleted()) {
                        if (!this.hasKRaftSupport()) {
                            this.linkManager().processClusterLinkChanges(cld.linkId(), new Properties(), this.linkManager().processClusterLinkChanges$default$3());
                            object = BoxedUnit.UNIT;
                            break block4;
                        }
                        this.error((Function0<String> & Serializable)() -> "Found link " + cld.linkName() + " marked for deletion in KRaft mode");
                        throw new IllegalStateException("Found link " + cld.linkName() + " marked for deletion in KRaft mode");
                    }
                    this.checkMirrorStateAndExecuteTasks((ClusterLinkData)cld);
                    this.linkManager().connectionManager(cld.linkId()).foreach((Function1<ClusterLinkFactory.ConnectionManager, Object> & Serializable)x$2 -> {
                        x$2.onLinkMetadataPartitionLeaderChange();
                        return BoxedUnit.UNIT;
                    });
                    object = this.linkManager().maybeMigrateBootstrapOverride((ClusterLinkData)cld);
                }
                catch (Throwable ex) {
                    this.error((Function0<String> & Serializable)() -> "Unable to process link coordinator change for link " + cld.linkName(), (Function0<Throwable> & Serializable)() -> ex);
                    object = BoxedUnit.UNIT;
                }
            }
            return object;
        });
    }

    @Override
    public void onClusterLinkCoordinatorResignation(Set<Uuid> linkIdSet) {
        this.debug((Function0<String> & Serializable)() -> "link coordinator resigned for links: " + linkIdSet);
        linkIdSet.foreach((Function1<Uuid, Object> & Serializable)linkId -> {
            ClusterLinkCoordinatorListener.$anonfun$onClusterLinkCoordinatorResignation$2(this, linkId);
            return BoxedUnit.UNIT;
        });
    }

    private void checkMirrorStateAndExecuteTasks(MetadataDelta delta) {
        if (delta.topicsDelta() != null && !delta.topicsDelta().changedTopics().isEmpty()) {
            delta.topicsDelta().changedTopics().values().forEach(changedTopic -> {
                if (changedTopic.mirrorTopicDelta().changed()) {
                    changedTopic.latestMirrorTopicState().ifPresent(newState -> this.linkManager().processMirrorStateChange(changedTopic.name(), ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)newState), OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(changedTopic.image().mirrorTopic())).map((Function1<MirrorTopic, ClusterLinkTopicState> & Serializable)mirrorTopic -> ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)mirrorTopic))));
                    return;
                }
            });
            return;
        }
    }

    private void checkMirrorStateAndExecuteTasks(ClusterLinkData link) {
        if (this.metadataManager().isLinkCoordinatorEnabled()) {
            this.metadataManager().mirrorTopicStatesFromMetadataCache(link.linkId()).foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
                ClusterLinkCoordinatorListener.$anonfun$checkMirrorStateAndExecuteTasks$4(this, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$onUpdateMetadata$1(ClusterLinkCoordinatorListener $this, ReplicaManager.MirrorTopicChanges mirrorTopicChanges$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String topic = (String)tuple2._1();
            ClusterLinkTopicState newState = (ClusterLinkTopicState)tuple2._2();
            $this.linkManager().processMirrorStateChange(topic, newState, mirrorTopicChanges$1.oldMirrorStates().get(topic));
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$onClusterLinkCoordinatorResignation$6(Uuid linkId$1, ClusterLinkFactory.ClientManager x$4) {
        x$4.taskManager().onLinkCoordinatorResignation(linkId$1);
    }

    public static final /* synthetic */ void $anonfun$onClusterLinkCoordinatorResignation$2(ClusterLinkCoordinatorListener $this, Uuid linkId) {
        try {
            $this.linkManager().connectionManager(linkId).foreach((Function1<ClusterLinkFactory.ConnectionManager, Object> & Serializable)x$3 -> {
                x$3.onLinkMetadataPartitionLeaderChange();
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable ex) {
            $this.error((Function0<String> & Serializable)() -> "Connection manager unable to process link coordinator change for link " + linkId, (Function0<Throwable> & Serializable)() -> ex);
        }
        try {
            $this.linkManager().clientManager(linkId).foreach((Function1<ClusterLinkFactory.ClientManager, Object> & Serializable)x$4 -> {
                ClusterLinkCoordinatorListener.$anonfun$onClusterLinkCoordinatorResignation$6(linkId, x$4);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable ex) {
            $this.error((Function0<String> & Serializable)() -> "Task manager unable to process link coordinator change for link " + linkId, (Function0<Throwable> & Serializable)() -> ex);
        }
    }

    public static final /* synthetic */ void $anonfun$checkMirrorStateAndExecuteTasks$4(ClusterLinkCoordinatorListener $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String topic = (String)tuple2._1();
            ClusterLinkTopicState state = (ClusterLinkTopicState)tuple2._2();
            $this.linkManager().processMirrorStateChange(topic, state, None$.MODULE$);
            return;
        }
        throw new MatchError(tuple2);
    }

    public ClusterLinkCoordinatorListener(ClusterLinkManager linkManager, ClusterLinkMetadataManager metadataManager, ClusterLinkScheduler scheduler) {
        Option option;
        this.linkManager = linkManager;
        this.metadataManager = metadataManager;
        this.scheduler = scheduler;
        Logging.$init$(this);
        MetadataCache metadataCache = metadataManager.metadataCache();
        if (metadataCache instanceof KRaftMetadataCache) {
            KRaftMetadataCache kRaftMetadataCache = (KRaftMetadataCache)metadataCache;
            option = new Some<KRaftMetadataCache>(kRaftMetadataCache);
        } else {
            option = None$.MODULE$;
        }
        this.kraftMetadataCache = option;
        this.hasKRaftSupport = this.kraftMetadataCache().nonEmpty();
    }
}

