/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkInboundConnectionManager$;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.LazyResource;
import kafka.server.link.ReverseClient;
import kafka.server.link.ReverseClient$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.ClientInterceptor;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.clients.admin.internals.ConfluentAdminUtils;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.CoordinatorNotAvailableException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.InitiateReverseConnectionsRequestData;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ReverseChannel;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.requests.InitiateReverseConnectionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.Time;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\tux!B\u001b7\u0011\u0003id!B 7\u0011\u0003\u0001\u0005\"B$\u0002\t\u0003A\u0005bB%\u0002\u0005\u0004%\tA\u0013\u0005\u0007/\u0006\u0001\u000b\u0011B&\u0007\t}2\u0004\u0001\u0017\u0005\nG\u0016\u0011\t\u0011)A\u0005I\u001eD\u0001\u0002[\u0003\u0003\u0002\u0003\u0006I!\u001b\u0005\nY\u0016\u0011\t\u0011)A\u0005[bD\u0001\"_\u0003\u0003\u0002\u0003\u0006IA\u001f\u0005\u000b\u0003#)!\u0011!Q\u0001\n\u0005M\u0001BCA\r\u000b\t\u0005\t\u0015!\u0003\u0002\u001c!Q\u0011\u0011F\u0003\u0003\u0002\u0003\u0006I!a\u000b\t\u0015\u0005uRA!A!\u0002\u0013\ty\u0004\u0003\u0006\u0002F\u0015\u0011\t\u0011)A\u0005\u0003\u000fB!\"a\u0014\u0006\u0005\u0003\u0005\u000b\u0011BA)\u0011\u00199U\u0001\"\u0001\u0002b!I\u0011qO\u0003C\u0002\u0013%\u0011\u0011\u0010\u0005\t\u0003\u001f+\u0001\u0015!\u0003\u0002|!A\u0011\u0011S\u0003C\u0002\u0013%!\nC\u0004\u0002\u0014\u0016\u0001\u000b\u0011B&\t\u0011\u0005UUA1A\u0005\n)Cq!a&\u0006A\u0003%1\n\u0003\u0005\u0002\u001a\u0016\u0011\r\u0011\"\u0003K\u0011\u001d\tY*\u0002Q\u0001\n-C\u0011\"!(\u0006\u0001\u0004%I!a(\t\u0013\u0005\rV\u00011A\u0005\n\u0005\u0015\u0006\u0002CAY\u000b\u0001\u0006K!!)\t\u0013\u0005mVA1A\u0005\n\u0005u\u0006\u0002CAf\u000b\u0001\u0006I!a0\t\u0013\u00055WA1A\u0005\n\u0005=\u0007\u0002CAo\u000b\u0001\u0006I!!5\t\u000f\u0005}W\u0001\"\u0011\u0002b\"9\u00111]\u0003\u0005B\u0005\u0015\b\u0002\u0003B\u0001\u000b\u0011\u0005aGa\u0001\t\u000f\t%R\u0001\"\u0011\u0003,!9!\u0011I\u0003\u0005B\t\r\u0003b\u0002B<\u000b\u0011%!\u0011\u0010\u0005\b\u0005'+A\u0011\u0002BK\u0011\u001d\u0011Y+\u0002C!\u0005[CqA!/\u0006\t\u0003\n\t\u000fC\u0004\u0003<\u0016!I!!9\t\u000f\tuV\u0001\"\u0015\u0002b\"9!qX\u0003\u0005R\u0005\u0005\bb\u0002Ba\u000b\u0011\u0005\u0013\u0011\u001d\u0005\b\u0005\u0007,A\u0011\u0002Bc\u0011\u001d\u00119-\u0002C\u0005\u0003CDqA!3\u0006\t\u0003\u0011Y\rC\u0004\u0003P\u0016!\tE!5\t\u000f\tMW\u0001\"\u0011\u0003R\"9!Q[\u0003\u0005B\t]\u0007\"\u0004B{\u000bA\u0005\u0019\u0011!A\u0005\n\t]\b\u0010C\u0007\u0003z\u0016\u0001\n1!A\u0001\n\u0013\u0011YpZ\u0001$\u00072,8\u000f^3s\u0019&t7.\u00138c_VtGmQ8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3s\u0015\t9\u0004(\u0001\u0003mS:\\'BA\u001d;\u0003\u0019\u0019XM\u001d<fe*\t1(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005y\nQ\"\u0001\u001c\u0003G\rcWo\u001d;fe2Kgn[%oE>,h\u000eZ\"p]:,7\r^5p]6\u000bg.Y4feN\u0011\u0011!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0014\u0001\u0006(fqR\u0014VM^3sg\u0016\u0014V-];fgRLE-F\u0001L!\taU+D\u0001N\u0015\tqu*\u0001\u0004bi>l\u0017n\u0019\u0006\u0003!F\u000b!bY8oGV\u0014(/\u001a8u\u0015\t\u00116+\u0001\u0003vi&d'\"\u0001+\u0002\t)\fg/Y\u0005\u0003-6\u0013Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018!\u0006(fqR\u0014VM^3sg\u0016\u0014V-];fgRLE\rI\n\u0004\u000bec\u0006C\u0001 [\u0013\tYfG\u0001\u000fDYV\u001cH/\u001a:MS:\\7i\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u0011\u0005u\u0003gB\u0001 _\u0013\tyf'\u0001\nDYV\u001cH/\u001a:MS:\\g)Y2u_JL\u0018BA1c\u0005aIeNY8v]\u0012\u001cuN\u001c8fGRLwN\\'b]\u0006<WM\u001d\u0006\u0003?Z\n\u0001\u0002\\5oW\u0012\u000bG/\u0019\t\u0003}\u0015L!A\u001a\u001c\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006L!a\u0019.\u0002\u001b%t\u0017\u000e^5bY\u000e{gNZ5h!\tq$.\u0003\u0002lm\t\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0002'1|7-\u00197M_\u001eL7-\u00197DYV\u001cH/\u001a:\u0011\u00059,hBA8t!\t\u00018)D\u0001r\u0015\t\u0011H(\u0001\u0004=e>|GOP\u0005\u0003i\u000e\u000ba\u0001\u0015:fI\u00164\u0017B\u0001<x\u0005\u0019\u0019FO]5oO*\u0011AoQ\u0005\u0003Yj\u000b\u0011c\u00197jK:$\u0018J\u001c;fe\u000e,\u0007\u000f^8s!\r\u001150`\u0005\u0003y\u000e\u0013aa\u00149uS>t\u0007c\u0001@\u0002\u000e5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011aB2mS\u0016tGo\u001d\u0006\u0004w\u0005\u0015!\u0002BA\u0004\u0003\u0013\ta!\u00199bG\",'BAA\u0006\u0003\ry'oZ\u0005\u0004\u0003\u001fy(!E\"mS\u0016tG/\u00138uKJ\u001cW\r\u001d;pe\u00069Q.\u001a;sS\u000e\u001c\bc\u0001 \u0002\u0016%\u0019\u0011q\u0003\u001c\u0003%\rcWo\u001d;fe2Kgn['fiJL7m]\u0001\u0013e\u0016lw\u000e^3BI6LgNR1di>\u0014\u0018\u0010\u0005\u0005C\u0003;I\u0017\u0011EA\u0012\u0013\r\tyb\u0011\u0002\n\rVt7\r^5p]J\u0002\"AP\u0003\u0011\u0007y\n)#C\u0002\u0002(Y\u0012ac\u00117vgR,'\u000fT5oW\u0006#W.\u001b8DY&,g\u000e^\u0001\u0016Y>\u001c\u0017\r\\\"p]:\fE-\\5o\r\u0006\u001cGo\u001c:z!\u0019\u0011\u0015QF7\u00022%\u0019\u0011qF\"\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]r0A\u0003bI6Lg.\u0003\u0003\u0002<\u0005U\"\u0001E&bM.\f\u0017\tZ7j]\u000ec\u0017.\u001a8u\u0003=iW\r^1eCR\fW*\u00198bO\u0016\u0014\bc\u0001 \u0002B%\u0019\u00111\t\u001c\u00035\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0011\t\u0005%\u00131J\u0007\u0002q%\u0019\u0011Q\n\u001d\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0005i&lW\r\u0005\u0003\u0002T\u0005uSBAA+\u0015\u0011\t9&!\u0017\u0002\u000bU$\u0018\u000e\\:\u000b\t\u0005m\u00131A\u0001\u0007G>lWn\u001c8\n\t\u0005}\u0013Q\u000b\u0002\u0005)&lW\r\u0006\f\u0002\"\u0005\r\u0014QMA4\u0003S\nY'!\u001c\u0002p\u0005E\u00141OA;\u0011\u0015\u0019\u0007\u00031\u0001e\u0011\u0015A\u0007\u00031\u0001j\u0011\u0015a\u0007\u00031\u0001n\u0011\u0015I\b\u00031\u0001{\u0011\u001d\t\t\u0002\u0005a\u0001\u0003'Aq!!\u0007\u0011\u0001\u0004\tY\u0002C\u0004\u0002*A\u0001\r!a\u000b\t\u000f\u0005u\u0002\u00031\u0001\u0002@!9\u0011Q\t\tA\u0002\u0005\u001d\u0003bBA(!\u0001\u0007\u0011\u0011K\u0001\u0013G>tg.Z2uS>t'+Z9vKN$8/\u0006\u0002\u0002|AA\u0011QPA@\u0003\u0007\u000bI)D\u0001P\u0013\r\t\ti\u0014\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bc\u0001\"\u0002\u0006&\u0019\u0011qQ\"\u0003\u0007%sG\u000fE\u0002?\u0003\u0017K1!!$7\u00055\u0011VM^3sg\u0016\u001cE.[3oi\u0006\u00192m\u001c8oK\u000e$\u0018n\u001c8SKF,Xm\u001d;tA\u0005!b.\u001a=u%\u00164XM]:f%\u0016\fX/Z:u\u0013\u0012\fQC\\3yiJ+g/\u001a:tKJ+\u0017/^3ti&#\u0007%A\u000bqKJ\u001c\u0018n\u001d;f]R\u001cuN\u001c8fGRLwN\\:\u0002-A,'o]5ti\u0016tGoQ8o]\u0016\u001cG/[8og\u0002\n\u0001$Y2uSZ,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8t\u0003e\t7\r^5wKJ+g/\u001a:tK\u000e{gN\\3di&|gn\u001d\u0011\u0002-I,g/\u001a:tK\u000e{gN\\3di&|g.\u00113nS:,\"!!)\u0011\t\t[\u0018\u0011R\u0001\u001be\u00164XM]:f\u0007>tg.Z2uS>t\u0017\tZ7j]~#S-\u001d\u000b\u0005\u0003O\u000bi\u000bE\u0002C\u0003SK1!a+D\u0005\u0011)f.\u001b;\t\u0013\u0005=&$!AA\u0002\u0005\u0005\u0016a\u0001=%c\u00059\"/\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8BI6Lg\u000e\t\u0015\u00047\u0005U\u0006c\u0001\"\u00028&\u0019\u0011\u0011X\"\u0003\u0011Y|G.\u0019;jY\u0016\fa\u0002\\8dC2\u001cuN\u001c8BI6Lg.\u0006\u0002\u0002@B)a(!1\u0002F&\u0019\u00111\u0019\u001c\u0003\u00191\u000b'0\u001f*fg>,(oY3\u0011\t\u0005M\u0012qY\u0005\u0005\u0003\u0013\f)D\u0001\bD_:4G.^3oi\u0006#W.\u001b8\u0002\u001f1|7-\u00197D_:t\u0017\tZ7j]\u0002\na\u0004]3sg&\u001cH/\u001a8u\u0007>tg.Z2uS>t7k\\;sG\u0016dunY6\u0016\u0005\u0005E\u0007\u0003BAj\u00033l!!!6\u000b\u0007\u0005]7+\u0001\u0003mC:<\u0017\u0002BAn\u0003+\u0014aa\u00142kK\u000e$\u0018a\b9feNL7\u000f^3oi\u000e{gN\\3di&|gnU8ve\u000e,Gj\\2lA\u000591\u000f^1siV\u0004HCAAT\u0003E)g.\u00192mK\u000ecWo\u001d;fe2Kgn\u001b\u000b\u0007\u0003O\u000b9/!=\t\u000f\u0005%\u0018\u00051\u0001\u0002l\u0006ia.\u001a;x_J\\7\t\\5f]R\u00042APAw\u0013\r\tyO\u000e\u0002\u0019\u00072,8\u000f^3s\u0019&t7NT3uo>\u00148n\u00117jK:$\bbBA\u001fC\u0001\u0007\u00111\u001f\t\u0005\u0005n\f)\u0010\u0005\u0003\u0002x\u0006uXBAA}\u0015\u0011\tY0!\u000e\u0002\u0013%tG/\u001a:oC2\u001c\u0018\u0002BA\u0000\u0003s\u0014A#\u00113nS:lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018!\u0007:fm\u0016\u00148/Z\"p]:,7\r^5p]B\u0013xN^5eKJ$\u0002B!\u0002\u0003\u001c\t\r\"Q\u0005\t\u0005\u0005n\u00149\u0001\u0005\u0003\u0003\n\tUa\u0002\u0002B\u0006\u0005#i!A!\u0004\u000b\t\t=\u0011\u0011L\u0001\b]\u0016$xo\u001c:l\u0013\u0011\u0011\u0019B!\u0004\u0002\u0017I+g/\u001a:tK:{G-Z\u0005\u0005\u0005/\u0011IB\u0001\nD_:tWm\u0019;j_:\u0004&o\u001c<jI\u0016\u0014(\u0002\u0002B\n\u0005\u001bAq!!;#\u0001\u0004\u0011i\u0002E\u0002\u007f\u0005?I1A!\t\u0000\u00055qU\r^<pe.\u001cE.[3oi\"9\u0011Q\b\u0012A\u0002\u0005M\bB\u0002B\u0014E\u0001\u0007Q.\u0001\u0005dY&,g\u000e^%e\u0003a\u0001(o\\2fgN\u0014VM^3sg\u0016\u001cuN\u001c8fGRLwN\u001c\u000b\u0007\u0003O\u0013iCa\u000e\t\u000f\t=2\u00051\u0001\u00032\u000591\r[1o]\u0016d\u0007\u0003\u0002B\u0006\u0005gIAA!\u000e\u0003\u000e\ta1*\u00194lC\u000eC\u0017M\u001c8fY\"9!\u0011H\u0012A\u0002\tm\u0012a\u0003:fm\u0016\u00148/\u001a(pI\u0016\u0004BAa\u0003\u0003>%!!q\bB\u0007\u0005-\u0011VM^3sg\u0016tu\u000eZ3\u00025%t\u0017\u000e^5bi\u0016\u0014VM^3sg\u0016\u001cuN\u001c8fGRLwN\\:\u0015\r\t\u0015#Q\fB7!\u0019\u00119E!\u0014\u0003R5\u0011!\u0011\n\u0006\u0004\u0005\u0017\u001a\u0015AC2pY2,7\r^5p]&!!q\nB%\u0005\r\u0019V-\u001d\t\u0007\u0003{\u0012\u0019Fa\u0016\n\u0007\tUsJA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004B!a5\u0003Z%!!1LAk\u0005\u00111v.\u001b3\t\u000f\t}C\u00051\u0001\u0003b\u0005I\u0012N\\5uS\u0006$XmQ8o]\u0016\u001cG/[8o%\u0016\fX/Z:u!\u0011\u0011\u0019G!\u001b\u000e\u0005\t\u0015$\u0002\u0002B4\u00033\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0005W\u0012)GA\u0011J]&$\u0018.\u0019;f%\u00164XM]:f\u0007>tg.Z2uS>t7OU3rk\u0016\u001cH\u000fC\u0004\u0003p\u0011\u0002\rA!\u001d\u0002\u001dI,\u0017/^3ti\u000e{g\u000e^3yiB!!1\rB:\u0013\u0011\u0011)H!\u001a\u0003\u001dI+\u0017/^3ti\u000e{g\u000e^3yi\u0006A\"/Z9vKN$(+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8\u0015\u0015\u0005\u001d&1\u0010B@\u0005\u0007\u0013y\tC\u0004\u0003~\u0015\u0002\r!a!\u0002\u0013I,\u0017/^3ti&#\u0007b\u0002BAK\u0001\u0007\u0011\u0011R\u0001\u0007G2LWM\u001c;\t\u000f\t\u0015U\u00051\u0001\u0003\b\u0006Q1o\\;sG\u0016tu\u000eZ3\u0011\t\t%%1R\u0007\u0003\u00033JAA!$\u0002Z\t!aj\u001c3f\u0011\u001d\u0011\t*\na\u0001\u0003\u0007\u000bA\u0002Z3ti\n\u0013xn[3s\u0013\u0012\f!DZ8so\u0006\u0014H\rV8SK6|G/Z\"p_J$\u0017N\\1u_J$b!a*\u0003\u0018\n\u001d\u0006b\u0002BMM\u0001\u0007!1T\u0001\fe\u0016\fX/Z:u\t\u0006$\u0018\r\u0005\u0003\u0003\u001e\n\rVB\u0001BP\u0015\u0011\u0011\t+!\u0017\u0002\u000f5,7o]1hK&!!Q\u0015BP\u0005\u0015Je.\u001b;jCR,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8t%\u0016\fX/Z:u\t\u0006$\u0018\rC\u0004\u0003*\u001a\u0002\rA!\u0012\u0002\u000f\u0019,H/\u001e:fg\u0006\u0011rN\\\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\\4f)\u0011\t9Ka,\t\u000f\tEv\u00051\u0001\u00034\u0006\u0011\u0012n]!di&4XmQ8oiJ|G\u000e\\3s!\r\u0011%QW\u0005\u0004\u0005o\u001b%a\u0002\"p_2,\u0017M\\\u0001$_:d\u0015N\\6NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:dU-\u00193fe\u000eC\u0017M\\4f\u0003ui\u0017-\u001f2f!J|7-Z:t\u0007>|'\u000fZ5oCR|'o\u00115b]\u001e,\u0017aG2m_N,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8BI6Lg.\u0001\u000fde\u0016\fG/\u001a*fm\u0016\u00148/Z\"p]:,7\r^5p]\u0006#W.\u001b8\u0002\u0011MDW\u000f\u001e3po:\fAc\u0019:fCR,Gj\\2bY\u000e{gN\\!e[&tGCAAc\u0003Yi\u0017-\u001f2f\u0007J,\u0017\r^3SK6|G/Z!e[&t\u0017a\u0006:fm\u0016\u00148/Z\"p]:,7\r^5p]\u000ec\u0017.\u001a8u+\t\u0011i\r\u0005\u0003Cw\nu\u0011!\u00079feNL7\u000f^3oi\u000e{gN\\3di&|gnQ8v]R,\"!a!\u0002-I,g/\u001a:tK\u000e{gN\\3di&|gnQ8v]R\fQ\u0002\\1{sJ+7o\\;sG\u0016\u001cXC\u0001Bm!\u0019\u00119E!\u0014\u0003\\B\"!Q\u001cBr!\u0015q\u0014\u0011\u0019Bp!\u0011\u0011\tOa9\r\u0001\u0011Y!Q\u001d\u001a\u0002\u0002\u0003\u0005)\u0011\u0001Bt\u0005\ryF%M\t\u0005\u0005S\u0014y\u000fE\u0002C\u0005WL1A!<D\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A\u0011By\u0013\r\u0011\u0019p\u0011\u0002\u0004\u0003:L\u0018!G:va\u0016\u0014H\u0005\\8dC2dunZ5dC2\u001cE.^:uKJ,\u0012!\\\u0001\u000fgV\u0004XM\u001d\u0013mS:\\G)\u0019;b+\u0005!\u0007")
public class ClusterLinkInboundConnectionManager
extends ClusterLinkConnectionManager
implements ClusterLinkFactory.InboundConnectionManager {
    private final ClusterLinkConfig initialConfig;
    private final Option<ClientInterceptor> clientInterceptor;
    private final ClusterLinkMetrics metrics;
    private final Function2<ClusterLinkConfig, ClusterLinkInboundConnectionManager, ClusterLinkAdminClient> remoteAdminFactory;
    private final Function1<String, KafkaAdminClient> localConnAdminFactory;
    private final KafkaConfig brokerConfig;
    private final Time time;
    private final ConcurrentHashMap<Object, ReverseClient> connectionRequests;
    private final AtomicInteger nextReverseRequestId;
    private final AtomicInteger persistentConnections;
    private final AtomicInteger activeReverseConnections;
    private volatile Option<ReverseClient> reverseConnectionAdmin;
    private final LazyResource<ConfluentAdmin> localConnAdmin;
    private final Object persistentConnectionSourceLock;

    public static AtomicInteger NextReverseRequestId() {
        return ClusterLinkInboundConnectionManager$.MODULE$.NextReverseRequestId();
    }

    private /* synthetic */ String super$localLogicalCluster() {
        return super.localLogicalCluster();
    }

    private /* synthetic */ ClusterLinkData super$linkData() {
        return super.linkData();
    }

    private ConcurrentHashMap<Object, ReverseClient> connectionRequests() {
        return this.connectionRequests;
    }

    private AtomicInteger nextReverseRequestId() {
        return this.nextReverseRequestId;
    }

    private AtomicInteger persistentConnections() {
        return this.persistentConnections;
    }

    private AtomicInteger activeReverseConnections() {
        return this.activeReverseConnections;
    }

    private Option<ReverseClient> reverseConnectionAdmin() {
        return this.reverseConnectionAdmin;
    }

    private void reverseConnectionAdmin_$eq(Option<ReverseClient> x$1) {
        this.reverseConnectionAdmin = x$1;
    }

    private LazyResource<ConfluentAdmin> localConnAdmin() {
        return this.localConnAdmin;
    }

    private Object persistentConnectionSourceLock() {
        return this.persistentConnectionSourceLock;
    }

    @Override
    public void startup() {
        ConnectionMode connectionMode = this.initialConfig.connectionMode();
        ConnectionMode$Outbound$ connectionMode$Outbound$ = ConnectionMode$Outbound$.MODULE$;
        if (!(connectionMode != null ? !connectionMode.equals(connectionMode$Outbound$) : connectionMode$Outbound$ != null)) {
            throw new IllegalStateException("Inbound connection manager created in outbound connection mode");
        }
        super.startup();
    }

    @Override
    public void enableClusterLink(ClusterLinkNetworkClient networkClient, Option<AdminMetadataManager> metadataManager) {
        KafkaClient kafkaClient = networkClient.networkClient();
        if (kafkaClient instanceof NetworkClient) {
            NetworkClient networkClient2 = (NetworkClient)kafkaClient;
            networkClient2.enableClusterLinkRequests(super.linkData().linkId(), (ClientInterceptor)this.clientInterceptor.orNull($less$colon$less$.MODULE$.refl()), (ReverseNode.ConnectionProvider)this.reverseConnectionProvider(networkClient2, metadataManager, networkClient.clientId()).orNull($less$colon$less$.MODULE$.refl()));
            return;
        }
        ConnectionMode connectionMode = this.currentConfig().connectionMode();
        ConnectionMode$Inbound$ connectionMode$Inbound$ = ConnectionMode$Inbound$.MODULE$;
        if (!(connectionMode != null ? !connectionMode.equals(connectionMode$Inbound$) : connectionMode$Inbound$ != null)) {
            throw new IllegalStateException("Reverse connections are supported only with NetworkClient");
        }
    }

    public Option<ReverseNode.ConnectionProvider> reverseConnectionProvider(NetworkClient networkClient, Option<AdminMetadataManager> metadataManager, String clientId) {
        ConnectionMode connectionMode = this.currentConfig().connectionMode();
        ConnectionMode$Inbound$ connectionMode$Inbound$ = ConnectionMode$Inbound$.MODULE$;
        if (!(connectionMode != null ? !connectionMode.equals(connectionMode$Inbound$) : connectionMode$Inbound$ != null)) {
            NetworkClient x$1 = networkClient;
            Option<AdminMetadataManager> x$2 = metadataManager;
            String x$3 = clientId;
            Option<ClusterLinkAdminClient> x$4 = ReverseClient$.MODULE$.$lessinit$greater$default$3();
            ReverseClient reverseClient = new ReverseClient(x$1, x$2, x$4, x$3);
            ReverseNode.ConnectionProvider provider = node -> this.requestReverseConnection(this.nextReverseRequestId().incrementAndGet(), reverseClient, node, $this.brokerConfig.brokerId());
            return new Some<ReverseNode.ConnectionProvider>(provider);
        }
        return None$.MODULE$;
    }

    @Override
    public void processReverseConnection(KafkaChannel channel2, ReverseNode reverseNode) {
        Tuple2<Option<ReverseClient>, Boolean> tuple2;
        this.debug((Function0<String> & Serializable)() -> "Process reverse connection in destination cluster : " + channel2 + " " + reverseNode);
        this.ensureReverseConnectionsEnabled();
        if (!reverseNode.requestId().isPresent()) {
            this.maybeCreateRemoteAdmin();
            v0 = new Tuple2<Option<ReverseClient>, Boolean>(this.reverseConnectionAdmin(), BoxesRunTime.boxToBoolean(true));
        } else {
            v0 = tuple2 = new Tuple2<Option<ReverseClient>, Boolean>(Option$.MODULE$.apply(this.connectionRequests().remove(reverseNode.requestId().get())), BoxesRunTime.boxToBoolean(false));
        }
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option<ReverseClient> remoteClient = tuple2._1();
        boolean isPersistentConnection = tuple2._2$mcZ$sp();
        Tuple2<Option<ReverseClient>, Boolean> tuple22 = new Tuple2<Option<ReverseClient>, Boolean>(remoteClient, BoxesRunTime.boxToBoolean(isPersistentConnection));
        Option<ReverseClient> remoteClient2 = tuple22._1();
        boolean isPersistentConnection2 = tuple22._2$mcZ$sp();
        Option<ReverseClient> option = remoteClient2;
        if (option instanceof Some) {
            Some some = (Some)option;
            ReverseClient client = (ReverseClient)some.value();
            Consumer<KafkaChannel> closeCallback = channel -> {
                this.debug((Function0<String> & Serializable)() -> "Reverse channel " + channel + " has been disconnected");
                $this.metrics.reverseConnectionClosedSensor().record();
                this.activeReverseConnections().decrementAndGet();
                if (isPersistentConnection2) {
                    Object object = this.persistentConnectionSourceLock();
                    synchronized (object) {
                        if (this.persistentConnections().decrementAndGet() <= 0) {
                            client.persistentConnectionSource_$eq(None$.MODULE$);
                            if (this.isLinkCoordinator()) {
                                this.info((Function0<String> & Serializable)() -> "Persistent connection to source link coordinator was disconnected, awaiting new connection.");
                            }
                        }
                    }
                    return;
                }
            };
            this.activeReverseConnections().incrementAndGet();
            if (isPersistentConnection2) {
                Object object = this.persistentConnectionSourceLock();
                synchronized (object) {
                    this.persistentConnections().incrementAndGet();
                    client.persistentConnectionSource_$eq(new Some<Integer>(Predef$.MODULE$.int2Integer(reverseNode.remoteBrokerId())));
                }
            }
            this.metrics.reverseConnectionCreatedSensor().record();
            ReverseChannel reverseChannel = new ReverseChannel(channel2, reverseNode, closeCallback);
            client.networkClient().reverseAndAdd(reverseChannel);
            client.bootstrapWithReverseChannel(reverseChannel, this.time.milliseconds());
            this.info((Function0<String> & Serializable)() -> "Added reverse channel " + reverseChannel + " from source to network client, requestId=" + reverseNode.requestId());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new NetworkException("Reverse connection is no longer required");
        }
        throw new MatchError(option);
    }

    @Override
    public Seq<CompletableFuture<Void>> initiateReverseConnections(InitiateReverseConnectionsRequest initiateConnectionRequest, RequestContext requestContext) {
        this.debug((Function0<String> & Serializable)() -> "Initiate or forward reverse connection request: localCluster=" + this.super$localLogicalCluster() + " request=" + initiateConnectionRequest);
        this.ensureReverseConnectionsEnabled();
        InitiateReverseConnectionsRequestData connData = initiateConnectionRequest.data();
        List futures = (List)package$.MODULE$.List().fill(connData.entries().size(), (Function0<CompletableFuture> & Serializable)() -> new CompletableFuture());
        try {
            String string = super.localLogicalCluster();
            String string2 = connData.sourceClusterId();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new InvalidRequestException("Cannot initiate reverse connection from destination cluster " + super.localLogicalCluster() + " to itself");
            }
            this.forwardToRemoteCoordinator(connData, futures);
        }
        catch (Throwable e) {
            this.error((Function0<String> & Serializable)() -> "Failing reverse connection request", (Function0<Throwable> & Serializable)() -> e);
            futures.foreach((Function1<CompletableFuture, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(x$4.completeExceptionally(e)));
        }
        return futures;
    }

    private void requestReverseConnection(int requestId, ReverseClient client, Node sourceNode, int destBrokerId) {
        this.debug((Function0<String> & Serializable)() -> "Requesting reverse connection for dest broker " + destBrokerId + " with requestId " + requestId + " to source node " + sourceNode + " for client " + client.clientId());
        this.ensureReverseConnectionsEnabled();
        if (this.reverseConnectionAdmin().exists((Function1<ReverseClient, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(ClusterLinkInboundConnectionManager.$anonfun$requestReverseConnection$2(client, x$5)))) {
            throw new NetworkException("Waiting for persistent connection to request reverse connection for request id " + requestId);
        }
        InitiateReverseConnectionsRequestData.EntryData entry = new InitiateReverseConnectionsRequestData.EntryData().setInitiateRequestId(requestId).setSourceBrokerId(sourceNode.id()).setTargetBrokerId(destBrokerId);
        InitiateReverseConnectionsRequestData requestData = new InitiateReverseConnectionsRequestData().setClusterLinkId(this.linkId()).setForwardToBroker(true).setTimeoutMs(Predef$.MODULE$.Integer2int(this.currentConfig().reverseConnectionSetupTimeoutMs())).setSourceClusterId((String)super.linkData().clusterId().orNull($less$colon$less$.MODULE$.refl())).setTargetClusterId(super.localLogicalCluster()).setEntries(Collections.singletonList(entry));
        this.connectionRequests().put(BoxesRunTime.boxToInteger(requestId), client);
        try {
            if (this.isLinkCoordinator() || this.persistentConnectionCount() > 0) {
                CompletableFuture future = new CompletableFuture();
                this.forwardToRemoteCoordinator(requestData, new $colon$colon<Nothing$>((Nothing$)((Object)future), Nil$.MODULE$));
                future.whenComplete((x$6, e) -> this.onCompletion$1((Throwable)e, requestId, client, sourceNode));
            } else {
                int linkCoordinatorId = BoxesRunTime.unboxToInt(this.linkCoordinatorId().getOrElse((Function0<Nothing$> & Serializable)() -> {
                    throw new CoordinatorNotAvailableException("Cluster link coordinator not available for " + this.super$linkData().linkName());
                }));
                ConfluentAdminUtils.initiateReverseConnections(this.localConnAdmin().getOrCreate(true), requestData, Predef$.MODULE$.int2Integer(linkCoordinatorId)).get(BoxesRunTime.boxToInteger(requestId)).whenComplete((x$7, e) -> this.onCompletion$1((Throwable)e, requestId, client, sourceNode));
            }
        }
        catch (Throwable e2) {
            this.connectionRequests().remove(BoxesRunTime.boxToInteger(requestId));
            throw e2;
        }
    }

    private void forwardToRemoteCoordinator(InitiateReverseConnectionsRequestData requestData, Seq<CompletableFuture<Void>> futures) {
        boolean isLinkCoordinator = this.isLinkCoordinator();
        ConfluentAdmin admin = (ConfluentAdmin)this.reverseConnectionAdmin().flatMap((Function1<ReverseClient, Option> & Serializable)x$8 -> x$8.adminClient().map((Function1<ClusterLinkAdminClient, ConfluentAdmin> & Serializable)x$9 -> x$9.admin())).getOrElse((Function0<Nothing$> & Serializable)() -> {
            if (isLinkCoordinator) {
                throw new NetworkException("Request cannot be forwarded to remote link coordinator at this time.");
            }
            throw new NotControllerException("Request cannot be forwarded to remote link coordinator since this broker is not the local link coordinator.");
        });
        Integer remoteCoordinator = (Integer)this.reverseConnectionAdmin().flatMap((Function1<ReverseClient, Option> & Serializable)x$10 -> x$10.persistentConnectionSource()).getOrElse((Function0<Nothing$> & Serializable)() -> {
            throw new NetworkException("Request cannot be forwarded to remote link coordinator because persistent connection is not yet available");
        });
        this.debug((Function0<String> & Serializable)() -> "Forward initiate reverse connection request to remote link coordinator: " + requestData + " remoteCoordinator=" + remoteCoordinator);
        Map<Integer, KafkaFutureImpl<Void>> requestFutures = ConfluentAdminUtils.initiateReverseConnections(admin, requestData, remoteCoordinator);
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(requestData.entries()).asScala().zip(futures)).foreach((Function1<Tuple2, KafkaFuture> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                InitiateReverseConnectionsRequestData.EntryData entry = (InitiateReverseConnectionsRequestData.EntryData)tuple2._1();
                CompletableFuture future = (CompletableFuture)tuple2._2();
                return ((KafkaFutureImpl)requestFutures.get(BoxesRunTime.boxToInteger(entry.initiateRequestId()))).whenComplete((x0$2, x1$1) -> {
                    Tuple2<Void, Throwable> tuple2 = new Tuple2<Void, Throwable>((Void)x0$2, (Throwable)x1$1);
                    if (tuple2 != null) {
                        Void v = tuple2._1();
                        Throwable e = tuple2._2();
                        if (e != null) {
                            this.warn((Function0<String> & Serializable)() -> "Initiate reverse connection request failed for requestId=" + entry.initiateRequestId(), (Function0<Throwable> & Serializable)() -> e);
                            future.completeExceptionally(e);
                            return;
                        }
                        this.debug((Function0<String> & Serializable)() -> "Completed InitiateReverseConnectionsRequest for requestId=" + entry.initiateRequestId());
                        future.complete(v);
                        return;
                    }
                    throw new MatchError(tuple2);
                });
            }
            throw new MatchError(tuple2);
        });
    }

    @Override
    public void onControllerChange(boolean isActiveController) {
        this.maybeProcessCoordinatorChange();
    }

    @Override
    public void onLinkMetadataPartitionLeaderChange() {
        this.maybeProcessCoordinatorChange();
    }

    private void maybeProcessCoordinatorChange() {
        Object object = this.stateChangeLock();
        synchronized (object) {
            boolean isCoordinator = this.isLinkCoordinator();
            this.debug((Function0<String> & Serializable)() -> "Process controller or metadata partition leader change isCoordinator=" + isCoordinator);
            if (this.reverseConnectionAdmin().isEmpty()) {
                if (isCoordinator) {
                    this.resetReverseConnectionAdmin();
                }
            } else if (!isCoordinator) {
                this.closeReverseConnectionAdmin();
            }
        }
    }

    @Override
    public void closeReverseConnectionAdmin() {
        this.debug((Function0<String> & Serializable)() -> "Closing reverse connection admin");
        Option<ReverseClient> connAdmin = this.reverseConnectionAdmin();
        connAdmin.flatMap((Function1<ReverseClient, Option> & Serializable)x$11 -> x$11.adminClient()).foreach((Function1<ClusterLinkAdminClient, Object> & Serializable)admin -> {
            CoreUtils$.MODULE$.swallow(() -> admin.close(), this, CoreUtils$.MODULE$.swallow$default$3());
            return BoxedUnit.UNIT;
        });
        this.reverseConnectionAdmin_$eq(None$.MODULE$);
        if (!this.isActive()) {
            this.localConnAdmin().closeResource();
            return;
        }
    }

    @Override
    public void createReverseConnectionAdmin() {
        this.debug((Function0<String> & Serializable)() -> "Recreate admin client used to initiate connection reversal requests");
        this.maybeCreateRemoteAdmin();
    }

    @Override
    public void shutdown() {
        this.localConnAdmin().shutdown();
        super.shutdown();
    }

    private ConfluentAdmin createLocalConnAdmin() {
        this.ensureReverseConnectionsEnabled();
        return this.localConnAdminFactory.apply(super.linkData().linkName());
    }

    private void maybeCreateRemoteAdmin() {
        Object object = this.stateChangeLock();
        synchronized (object) {
            if (this.reverseConnectionAdmin().isEmpty() && this.isLinkCoordinator()) {
                ClusterLinkAdminClient admin = this.remoteAdminFactory.apply(this.currentConfig(), this);
                this.reverseConnectionAdmin_$eq(new Some<ReverseClient>(new ReverseClient(admin.networkClient(), new Some<AdminMetadataManager>(admin.metadataManager()), new Some<ClusterLinkAdminClient>(admin), admin.clientId())));
            }
        }
    }

    public Option<NetworkClient> reverseConnectionClient() {
        return this.reverseConnectionAdmin().map((Function1<ReverseClient, NetworkClient> & Serializable)x$12 -> x$12.networkClient());
    }

    @Override
    public int persistentConnectionCount() {
        if (this.isLinkCoordinator()) {
            return this.persistentConnections().get();
        }
        return 0;
    }

    @Override
    public int reverseConnectionCount() {
        return this.activeReverseConnections().get();
    }

    @Override
    public Seq<LazyResource<?>> lazyResources() {
        return new $colon$colon<Nothing$>((Nothing$)((Object)this.localConnAdmin()), Nil$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$requestReverseConnection$2(ReverseClient client$2, ReverseClient x$5) {
        return x$5.networkClient() == client$2.networkClient();
    }

    private final void onCompletion$1(Throwable e, int requestId$1, ReverseClient client$2, Node sourceNode$1) {
        if (e != null) {
            this.warn((Function0<String> & Serializable)() -> "Failed to create reverse connection for requestId=" + requestId$1, (Function0<Throwable> & Serializable)() -> e);
            this.connectionRequests().remove(BoxesRunTime.boxToInteger(requestId$1));
            client$2.networkClient().processReverseConnectionFailure(sourceNode$1);
            return;
        }
        this.debug((Function0<String> & Serializable)() -> "Reverse connection has been created for requestId=" + requestId$1);
    }

    public ClusterLinkInboundConnectionManager(ClusterLinkData linkData, ClusterLinkConfig initialConfig, String localLogicalCluster, Option<ClientInterceptor> clientInterceptor, ClusterLinkMetrics metrics, Function2<ClusterLinkConfig, ClusterLinkInboundConnectionManager, ClusterLinkAdminClient> remoteAdminFactory, Function1<String, KafkaAdminClient> localConnAdminFactory, ClusterLinkMetadataManager metadataManager, KafkaConfig brokerConfig, Time time) {
        this.initialConfig = initialConfig;
        this.clientInterceptor = clientInterceptor;
        this.metrics = metrics;
        this.remoteAdminFactory = remoteAdminFactory;
        this.localConnAdminFactory = localConnAdminFactory;
        this.brokerConfig = brokerConfig;
        this.time = time;
        super(linkData, initialConfig, localLogicalCluster, metadataManager, metrics, brokerConfig);
        this.connectionRequests = new ConcurrentHashMap();
        this.nextReverseRequestId = ClusterLinkInboundConnectionManager$.MODULE$.NextReverseRequestId();
        this.persistentConnections = new AtomicInteger();
        this.activeReverseConnections = new AtomicInteger();
        this.reverseConnectionAdmin = None$.MODULE$;
        this.localConnAdmin = new LazyResource((Function0<ConfluentAdmin> & Serializable)() -> this.createLocalConnAdmin(), (Function1<ConfluentAdmin, Object> & Serializable)x$2 -> {
            x$2.close(Duration.ZERO);
            return BoxedUnit.UNIT;
        }, time, () -> this.currentConfig().clientsMaxIdleMs());
        this.persistentConnectionSourceLock = new Object();
        this.logIdent_$eq("[ClusterLinkInboundConnectionManager-" + super.linkData().linkName() + "-broker-" + brokerConfig.brokerId() + "] ");
    }
}

