/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkReverseAndSwapMirror$;
import kafka.server.link.ClusterLinkReverseAndSwapMirrorTopicType$;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TopicLinkPendingSynchronizeMirror$;
import kafka.server.link.TopicLinkState;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tMe\u0001B\u00181\u0001]B\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003T\u0011%9\u0006A!A!\u0002\u0013AV\rC\u0005g\u0001\t\u0005\t\u0015!\u0003hW\"IA\u000e\u0001B\u0001B\u0003%Q.\u001d\u0005\u0006g\u0002!\t\u0001\u001e\u0005\b{\u0002\u0011\r\u0011\"\u0003\u007f\u0011\u001d\t)\u0001\u0001Q\u0001\n}D1\"a\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\n!Y\u0011\u0011\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u000e\u0011-\t9\u0003\u0001a\u0001\u0002\u0003\u0006K!a\u0003\t\u0013\u0005%\u0002A1A\u0005\n\u0005-\u0002\u0002CA'\u0001\u0001\u0006I!!\f\t\u0013\u0005=\u0003A1A\u0005\n\u0005E\u0003\u0002CA-\u0001\u0001\u0006I!a\u0015\t\u0013\u0005m\u0003\u00011A\u0005\n\u0005u\u0003\"CA3\u0001\u0001\u0007I\u0011BA4\u0011!\tY\u0007\u0001Q!\n\u0005}\u0003\"CA7\u0001\u0001\u0007I\u0011BA/\u0011%\ty\u0007\u0001a\u0001\n\u0013\t\t\b\u0003\u0005\u0002v\u0001\u0001\u000b\u0015BA0\u0011%\t9\b\u0001a\u0001\n\u0013\tI\bC\u0005\u0002\b\u0002\u0001\r\u0011\"\u0003\u0002\n\"A\u0011Q\u0012\u0001!B\u0013\tY\bC\u0004\u0002\u0018\u0002!\t&!'\t\u000f\u0005=\u0006\u0001\"\u0003\u00022\"9\u0011Q\u0018\u0001\u0005\n\u0005}\u0006bBAb\u0001\u0011%\u0011Q\u0019\u0005\b\u0003'\u0004A\u0011BAk\u0011\u001d\t\u0019\u000f\u0001C\u0005\u0003KDq!!<\u0001\t\u0013\ty\u000fC\u0004\u0002t\u0002!I!!>\t\u000f\u0005m\b\u0001\"\u0003\u0002~\"9!Q\u0002\u0001\u0005\n\t=\u0001b\u0002B\n\u0001\u0011%!Q\u0003\u0005\b\u0005G\u0001A\u0011\tB\u0013\u0011\u001d\u00119\u0003\u0001C\u0005\u0005SAqAa\n\u0001\t#\u0012i\u0003C\u0004\u0003:\u0001!IAa\u000f\t\u001b\t%\u0004\u0001%A\u0002\u0002\u0003%IAa\u001br\u000f%\u0011i\u0007MA\u0001\u0012\u0003\u0011yG\u0002\u00050a\u0005\u0005\t\u0012\u0001B9\u0011\u0019\u0019H\u0006\"\u0001\u0003z!I!1\u0010\u0017\u0012\u0002\u0013\u0005!Q\u0010\u0002 \u00072,8\u000f^3s\u0019&t7NU3wKJ\u001cX-\u00118e'^\f\u0007/T5se>\u0014(BA\u00193\u0003\u0011a\u0017N\\6\u000b\u0005M\"\u0014AB:feZ,'OC\u00016\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u001d\u0011\u0005ejdB\u0001\u001e<\u001b\u0005\u0001\u0014B\u0001\u001f1\u0003Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe&\u0011ah\u0010\u0002\r!\u0016\u0014\u0018n\u001c3jGR\u000b7o\u001b\u0006\u0003yA\nQ\u0001^8qS\u000e\u0004\"AQ&\u000f\u0005\rK\u0005C\u0001#H\u001b\u0005)%B\u0001$7\u0003\u0019a$o\\8u})\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\u00061\u0001K]3eK\u001aL!\u0001T'\u0003\rM#(/\u001b8h\u0015\tQu)A\u0007dY&,g\u000e^'b]\u0006<WM\u001d\t\u0003uAK!!\u0015\u0019\u00039\rcWo\u001d;fe2Kgn\u001b#fgR\u001cE.[3oi6\u000bg.Y4fe\u0006Y!/Z7pi\u0016\fE-\\5o!\tQD+\u0003\u0002Va\t)2\t\\;ti\u0016\u0014H*\u001b8l\u0005\u0006$8\r[!e[&t\u0017A\u00037pG\u0006d\u0017\tZ7j]\u0006!A/[7f!\tI6-D\u0001[\u0015\tYF,A\u0003vi&d7O\u0003\u0002^=\u000611m\\7n_:T!!N0\u000b\u0005\u0001\f\u0017AB1qC\u000eDWMC\u0001c\u0003\ry'oZ\u0005\u0003Ij\u0013A\u0001V5nK&\u0011q+P\u0001\u0006cV|G/\u0019\t\u0003Q&l\u0011AM\u0005\u0003UJ\u0012qc\u00117vgR,'\u000fT5oWJ+\u0017/^3tiF+x\u000e^1\n\u0005\u0019l\u0014AC5oi\u0016\u0014h/\u00197NgB\u0011an\\\u0007\u0002\u000f&\u0011\u0001o\u0012\u0002\u0004\u0013:$\u0018B\u0001:>\u0003E\u0011Xm]2iK\u0012,H.\u001a#fY\u0006LXj]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011U4x\u000f_={wr\u0004\"A\u000f\u0001\t\u000b\u0001C\u0001\u0019A!\t\u000b9C\u0001\u0019A(\t\u000bIC\u0001\u0019A*\t\u000bYC\u0001\u0019A*\t\u000b]C\u0001\u0019\u0001-\t\u000b\u0019D\u0001\u0019A4\t\u000f1D\u0001\u0013!a\u0001[\u0006yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'/F\u0001\u0000!\rQ\u0014\u0011A\u0005\u0004\u0003\u0007\u0001$AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018\u0001E7fi\u0006$\u0017\r^1NC:\fw-\u001a:!\u0003)\u0001\u0018M\u001d;ji&|gn]\u000b\u0003\u0003\u0017\u0001RAQA\u0007\u0003#I1!a\u0004N\u0005\r\u0019V\r\u001e\t\u0005\u0003'\t)\"D\u0001]\u0013\r\t9\u0002\u0018\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u00039\u0001\u0018M\u001d;ji&|gn]0%KF$B!!\b\u0002$A\u0019a.a\b\n\u0007\u0005\u0005rI\u0001\u0003V]&$\b\"CA\u0013\u0019\u0005\u0005\t\u0019AA\u0006\u0003\rAH%M\u0001\fa\u0006\u0014H/\u001b;j_:\u001c\b%A\u000fsK6|G/\u001a*fa2L7-Y*uCR,8\u000fU1si&$\u0018n\u001c8t+\t\ti\u0003\u0005\u0005\u00020\u0005e\u0012\u0011CA\u001f\u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012\u0001B;uS2T!!a\u000e\u0002\t)\fg/Y\u0005\u0005\u0003w\t\tDA\u0002NCB\u0004B!a\u0010\u0002J5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%A\u0003bI6LgNC\u0002\u0002Hy\u000bqa\u00197jK:$8/\u0003\u0003\u0002L\u0005\u0005#a\u0004)beRLG/[8o%\u0016\u001cX\u000f\u001c;\u0002=I,Wn\u001c;f%\u0016\u0004H.[2b'R\fG/^:QCJ$\u0018\u000e^5p]N\u0004\u0013aF3yG\u0016\u001c8/\u001b<f\u0019><w-\u001b8h\u0011\u0006tG\r\\3s+\t\t\u0019\u0006E\u0002;\u0003+J1!a\u00161\u0005])\u0005pY3tg&4X\rT8hO&tw\rS1oI2,'/\u0001\rfq\u000e,7o]5wK2{wmZ5oO\"\u000bg\u000e\u001a7fe\u0002\nQ\u0005\\8dC2l\u0015N\u001d:peR{\u0007/[2DCV<\u0007\u000e^+q)>\u0014V-\\8uKR{\u0007/[2\u0016\u0005\u0005}\u0003c\u00018\u0002b%\u0019\u00111M$\u0003\u000f\t{w\u000e\\3b]\u0006ICn\\2bY6K'O]8s)>\u0004\u0018nY\"bk\u001eDG/\u00169U_J+Wn\u001c;f)>\u0004\u0018nY0%KF$B!!\b\u0002j!I\u0011QE\n\u0002\u0002\u0003\u0007\u0011qL\u0001'Y>\u001c\u0017\r\\'jeJ|'\u000fV8qS\u000e\u001c\u0015-^4iiV\u0003Hk\u001c*f[>$X\rV8qS\u000e\u0004\u0013\u0001\t4j]\u0006d'+\u001a9mS\u000e\f7\u000b^1ukN\u001c\u0005.Z2l\u0007>l\u0007\u000f\\3uK\u0012\fAEZ5oC2\u0014V\r\u001d7jG\u0006\u001cF/\u0019;vg\u000eCWmY6D_6\u0004H.\u001a;fI~#S-\u001d\u000b\u0005\u0003;\t\u0019\bC\u0005\u0002&Y\t\t\u00111\u0001\u0002`\u0005\tc-\u001b8bYJ+\u0007\u000f\\5dCN#\u0018\r^;t\u0007\",7m[\"p[BdW\r^3eA\u0005AA/Y:l\t\u0016\u001c8-\u0006\u0002\u0002|A)a.! \u0002\u0002&\u0019\u0011qP$\u0003\r=\u0003H/[8o!\rQ\u00141Q\u0005\u0004\u0003\u000b\u0003$a\u0004+bg.$Um]2sSB$\u0018n\u001c8\u0002\u0019Q\f7o\u001b#fg\u000e|F%Z9\u0015\t\u0005u\u00111\u0012\u0005\n\u0003KI\u0012\u0011!a\u0001\u0003w\n\u0011\u0002^1tW\u0012+7o\u0019\u0011)\u0007i\t\t\nE\u0002o\u0003'K1!!&H\u0005!1x\u000e\\1uS2,\u0017a\u0001:v]R\u0011\u00111\u0014\t\u0005\u0003;\u000bYKD\u0002\u0002 nrA!!)\u0002*:!\u00111UAT\u001d\r!\u0015QU\u0005\u0002k%\u00111\u0007N\u0005\u0003cIJ1!!,@\u0005)!\u0016m]6SKN,H\u000e^\u0001\u000biJ\fgn]5uS>tG\u0003BAN\u0003gCq!!.\u001d\u0001\u0004\t9,A\u0006uCN\\7i\u001c8uKb$\b\u0003BAO\u0003sK1!a/@\u0005-!\u0016m]6D_:$X\r\u001f;\u00021\r\f7\r[3SK6|G/\u001a*fa2L7-Y*uCR,8\u000f\u0006\u0003\u0002\u001c\u0006\u0005\u0007bBA[;\u0001\u0007\u0011qW\u0001\u001aQ\u0006tG\r\\3SK6|G/\u001a*fa2L7-Y*uCR,8\u000f\u0006\u0004\u0002\u001c\u0006\u001d\u0017\u0011\u001a\u0005\b\u0003ks\u0002\u0019AA\\\u0011\u001d\tYM\ba\u0001\u0003\u001b\f\u0011D]3n_R,'+\u001a9mS\u000e\f7\u000b^1ukN\u0014Vm];miB!\u0011qHAh\u0013\u0011\t\t.!\u0011\u0003'I+\u0007\u000f\\5dCN#\u0018\r^;t%\u0016\u001cX\u000f\u001c;\u0002/\rDWmY6M_\u000e\fGNU3qY&\u001c\u0017m\u0015;biV\u001cHCBAN\u0003/\fI\u000eC\u0004\u00026~\u0001\r!a.\t\u000f\u0005mw\u00041\u0001\u0002^\u0006a\u0002.\u00198eY\u0016dunY1m%\u0016\u0004H.[2b'R\fG/^:Gk:\u001c\u0007#\u00038\u0002`\u0006]\u0016QZAN\u0013\r\t\to\u0012\u0002\n\rVt7\r^5p]J\n\u0001\u0004[1oI2,Gj\\2bYJ+\u0007\u000f\\5dCN#\u0018\r^;t)\u0019\tY*a:\u0002j\"9\u0011Q\u0017\u0011A\u0002\u0005]\u0006bBAvA\u0001\u0007\u0011QZ\u0001\u0019Y>\u001c\u0017\r\u001c*fa2L7-Y*uCR,8OU3tk2$\u0018!\b4j]\u0006d'+Z7pi\u0016\u0014V\r\u001d7jG\u0006\u001cF/\u0019;vg\u000eCWmY6\u0015\t\u0005m\u0015\u0011\u001f\u0005\b\u0003k\u000b\u0003\u0019AA\\\u0003q1\u0017N\\1m\u0019>\u001c\u0017\r\u001c*fa2L7-Y*uCR,8o\u00115fG.$b!a'\u0002x\u0006e\bbBA[E\u0001\u0007\u0011q\u0017\u0005\b\u0003W\u0014\u0003\u0019AAg\u00035I7\u000fT1h\u0007\u0006,x\r\u001b;VaRQ\u0011qLA\u0000\u0005\u0007\u00119Aa\u0003\t\u000f\t\u00051\u00051\u0001\u0002\u0012\u0005\u0011A\u000f\u001d\u0005\b\u0005\u000b\u0019\u0003\u0019AA\u001f\u0003QawnY1m!\u0006\u0014H/\u001b;j_:\u0014Vm];mi\"9!\u0011B\u0012A\u0002\u0005u\u0012!\u0006:f[>$X\rU1si&$\u0018n\u001c8SKN,H\u000e\u001e\u0005\b\u0003k\u001b\u0003\u0019AA\\\u0003]\u0001(o\\7pi\u0016dunY1m\u001b&\u0014(o\u001c:U_BL7\r\u0006\u0003\u0002\u001c\nE\u0001bBA[I\u0001\u0007\u0011qW\u0001\u001eQ\u0006tG\r\\3Qe>lw\u000e^3M_\u000e\fG.T5se>\u0014Hk\u001c9jGR1\u00111\u0014B\f\u00053Aq!!.&\u0001\u0004\t9\fC\u0004\u0003\u001c\u0015\u0002\rA!\b\u0002+M$x\u000e]'jeJ|'\u000fV8qS\u000e\u0014Vm];miB!\u0011q\bB\u0010\u0013\u0011\u0011\t#!\u0011\u0003%\u0005cG/\u001a:NSJ\u0014xN]:SKN,H\u000e^\u0001\u0010i\u0006\u001c8\u000eR3tGJL\u0007\u000f^5p]R\u0011\u00111P\u0001\r_:\u001cu.\u001c9mKRLwN\u001c\u000b\u0005\u00037\u0013Y\u0003C\u0004\u00026\u001e\u0002\r!a.\u0015\t\u0005u!q\u0006\u0005\b\u0005cA\u0003\u0019\u0001B\u001a\u0003\u0019\u0011Xm];miB\u0019\u0011H!\u000e\n\u0007\t]rHA\nD_6\u0004H.\u001a;fIR\u000b7o\u001b*fgVdG/A\nuCN\\WI\u001d:pe\u000e{G-Z!oI6\u001bx\r\u0006\u0005\u0003>\t\r#q\tB&!\rQ$qH\u0005\u0004\u0005\u0003\u0002$a\u0005+bg.,%O]8s\u0007>$W-\u00118e\u001bN<\u0007B\u0002B#S\u0001\u0007\u0011)\u0001\u0007feJl5o\u001a)sK\u001aL\u0007\u0010C\u0004\u0003J%\u0002\r!a\u0018\u0002\u001d1|7-\u00197BI6Lg.V:fI\"9!QJ\u0015A\u0002\t=\u0013AA3y!\u0011\u0011\tFa\u0019\u000f\t\tM#Q\f\b\u0005\u0005+\u0012IFD\u0002E\u0005/J\u0011\u0001S\u0005\u0004\u00057:\u0015AC2p]\u000e,(O]3oi&!!q\fB1\u0003\u001d\u0001\u0018mY6bO\u0016T1Aa\u0017H\u0013\u0011\u0011)Ga\u001a\u0003%\u0015CXmY;uS>tW\t_2faRLwN\u001c\u0006\u0005\u0005?\u0012\t'A\ftkB,'\u000f\n:fg\u000eDW\rZ;mK\u0012+G.Y=NgV\tQ.A\u0010DYV\u001cH/\u001a:MS:\\'+\u001a<feN,\u0017I\u001c3To\u0006\u0004X*\u001b:s_J\u0004\"A\u000f\u0017\u0014\u00071\u0012\u0019\bE\u0002o\u0005kJ1Aa\u001eH\u0005\u0019\te.\u001f*fMR\u0011!qN\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t}$fA7\u0003\u0002.\u0012!1\u0011\t\u0005\u0005\u000b\u0013y)\u0004\u0002\u0003\b*!!\u0011\u0012BF\u0003%)hn\u00195fG.,GMC\u0002\u0003\u000e\u001e\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tJa\"\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class ClusterLinkReverseAndSwapMirror
extends ClusterLinkScheduler.PeriodicTask {
    private final String topic;
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkBatchAdmin remoteAdmin;
    private final ClusterLinkBatchAdmin localAdmin;
    private final ClusterLinkMetadataManager metadataManager;
    private Set<TopicPartition> partitions;
    private final Map<TopicPartition, PartitionResult> remoteReplicaStatusPartitions;
    private final ExcessiveLoggingHandler excessiveLoggingHandler;
    private boolean localMirrorTopicCaughtUpToRemoteTopic;
    private boolean finalReplicaStatusCheckCompleted;
    private volatile Option<TaskDescription> taskDesc;

    public static int $lessinit$greater$default$7() {
        return ClusterLinkReverseAndSwapMirror$.MODULE$.$lessinit$greater$default$7();
    }

    private /* synthetic */ int super$rescheduleDelayMs() {
        return super.rescheduleDelayMs();
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private Set<TopicPartition> partitions() {
        return this.partitions;
    }

    private void partitions_$eq(Set<TopicPartition> x$1) {
        this.partitions = x$1;
    }

    private Map<TopicPartition, PartitionResult> remoteReplicaStatusPartitions() {
        return this.remoteReplicaStatusPartitions;
    }

    private ExcessiveLoggingHandler excessiveLoggingHandler() {
        return this.excessiveLoggingHandler;
    }

    private boolean localMirrorTopicCaughtUpToRemoteTopic() {
        return this.localMirrorTopicCaughtUpToRemoteTopic;
    }

    private void localMirrorTopicCaughtUpToRemoteTopic_$eq(boolean x$1) {
        this.localMirrorTopicCaughtUpToRemoteTopic = x$1;
    }

    private boolean finalReplicaStatusCheckCompleted() {
        return this.finalReplicaStatusCheckCompleted;
    }

    private void finalReplicaStatusCheckCompleted_$eq(boolean x$1) {
        this.finalReplicaStatusCheckCompleted = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        ClusterLinkTopicState state;
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty());
        this.partitions_$eq(this.metadataManager().topicPartitions(this.topic));
        if (this.partitions().isEmpty()) {
            this.warn((Function0<String> & Serializable)() -> "Cannot reverse and swap mirror topic for deleted topic '" + $this.topic + "'. Shutting down ClusterLinkReverseAndSwapMirrorTopic task.");
            return this.onCompletion(taskContext);
        }
        Option mirrorState = this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic}))).get(this.topic);
        boolean bl = false;
        Some some = null;
        Option option = mirrorState;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            if (some.value() instanceof ClusterLinkTopicState.PendingSynchronizeMirror) {
                this.info((Function0<String> & Serializable)() -> "Attempting to reverse and swap mirror topic " + $this.topic + ".");
                return this.transition(taskContext);
            }
        }
        if (bl && (state = (ClusterLinkTopicState)some.value()) instanceof ClusterLinkTopicState.PausedMirror) {
            ClusterLinkTopicState.PausedMirror pausedMirror = (ClusterLinkTopicState.PausedMirror)state;
            TopicLinkState topicLinkState = pausedMirror.previousState();
            TopicLinkPendingSynchronizeMirror$ topicLinkPendingSynchronizeMirror$ = TopicLinkPendingSynchronizeMirror$.MODULE$;
            if (topicLinkState == null ? topicLinkPendingSynchronizeMirror$ != null : !topicLinkState.equals(topicLinkPendingSynchronizeMirror$)) {
                this.warn((Function0<String> & Serializable)() -> "Previous to paused state for " + $this.topic + " is not PendingSynchronizeMirror. Shutting down ClusterLinkReverseAndSwapMirrorTopic task");
                return this.onCompletion(taskContext);
            }
            this.info((Function0<String> & Serializable)() -> "Local mirror topic " + $this.topic + " is in a paused state. Will wait " + this.super$rescheduleDelayMs() + " before trying to do reverse and swap again.");
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)package$.MODULE$.Seq().empty());
        }
        if (bl) {
            ClusterLinkTopicState state2 = (ClusterLinkTopicState)some.value();
            this.warn((Function0<String> & Serializable)() -> "See unsupported '" + state2 + "' for mirror topic '" + $this.topic + "', shutting down ClusterLinkReverseAndSwapMirrorTopic task");
            return this.onCompletion(taskContext);
        }
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String> & Serializable)() -> "No mirror state for mirror topic '" + $this.topic + "', shutting down ClusterLinkReverseAndSwapMirrorTopic task");
            return this.onCompletion(taskContext);
        }
        throw new MatchError(option);
    }

    private ClusterLinkScheduler.TaskResult transition(ClusterLinkScheduler.TaskContext taskContext2) {
        if (!this.localMirrorTopicCaughtUpToRemoteTopic() && this.remoteReplicaStatusPartitions().isEmpty()) {
            return this.cacheRemoteReplicaStatus(taskContext2);
        }
        if (!this.localMirrorTopicCaughtUpToRemoteTopic() && !this.remoteReplicaStatusPartitions().isEmpty()) {
            return this.checkLocalReplicaStatus(taskContext2, (Function2<ClusterLinkScheduler.TaskContext, ReplicaStatusResult, ClusterLinkScheduler.TaskResult> & Serializable)(taskContext, localReplicaStatusResult) -> this.handleLocalReplicaStatus((ClusterLinkScheduler.TaskContext)taskContext, (ReplicaStatusResult)localReplicaStatusResult));
        }
        if (!this.finalReplicaStatusCheckCompleted()) {
            return this.finalRemoteReplicaStatusCheck(taskContext2);
        }
        return this.promoteLocalMirrorTopic(taskContext2);
    }

    private ClusterLinkScheduler.TaskResult cacheRemoteReplicaStatus(ClusterLinkScheduler.TaskContext taskContext) {
        ReplicaStatusResult remoteReplicaStatusResult = this.remoteAdmin.replicaStatus(CollectionConverters$.MODULE$.SetHasAsJava(this.partitions()).asJava());
        this.scheduleWhenComplete(remoteReplicaStatusResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleRemoteReplicaStatus((ClusterLinkScheduler.TaskContext)tc, remoteReplicaStatusResult), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleRemoteReplicaStatus(ClusterLinkScheduler.TaskContext taskContext, ReplicaStatusResult remoteReplicaStatusResult) {
        Some<TaskErrorCodeAndMsg> errOpt;
        Option option;
        boolean retryRemoteReplicaStatus = false;
        HashMap<TopicPartition, PartitionResult> remoteReplicaStatusFutures = new HashMap<TopicPartition, PartitionResult>();
        try {
            remoteReplicaStatusFutures.putAll(remoteReplicaStatusResult.allResults().get());
            retryRemoteReplicaStatus = ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(remoteReplicaStatusFutures).asScala().map((Function1<Tuple2, Option> & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala(((PartitionResult)x$2._2()).replicas()).asScala().find((Function1<ReplicaStatus, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.isLeader())))).filter((Function1<Option, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(x$4.isDefined()))).map((Function1<Option, Optional> & Serializable)x$5 -> ((ReplicaStatus)x$5.get()).mirrorInfo())).filter((Function1<Optional, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(x$6.isPresent()))).map((Function1<Optional, ReplicaStatus.MirrorInfo.State> & Serializable)x$7 -> ((ReplicaStatus.MirrorInfo)x$7.get()).state())).exists((Function1<ReplicaStatus.MirrorInfo.State, Object> & Serializable)x$8 -> BoxesRunTime.boxToBoolean(ClusterLinkReverseAndSwapMirror.$anonfun$handleRemoteReplicaStatus$7(x$8)));
            option = None$.MODULE$;
        }
        catch (ExecutionException e) {
            String errMsg = "Encountered exception while getting remote replica status for topic " + this.topic + ".";
            this.excessiveLoggingHandler().handle(e, this, errMsg);
            option = new Some<TaskErrorCodeAndMsg>(this.taskErrorCodeAndMsg("Failed to get the remote replicas statuses for topic " + this.topic, false, e));
        }
        Some<TaskErrorCodeAndMsg> some = errOpt = option;
        if (None$.MODULE$.equals(some)) {
            if (retryRemoteReplicaStatus) {
                this.debug((Function0<String> & Serializable)() -> "Not all leaders on remote cluster have propagated PendingMirror state, will retry again in " + this.super$rescheduleDelayMs() + " ms.");
                return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
            }
            this.debug((Function0<String> & Serializable)() -> "Cached remote replica status for topic " + $this.topic + ". Will wait for lag to get to zero before promoting local mirror topic");
            this.remoteReplicaStatusPartitions().putAll(remoteReplicaStatusFutures);
            return this.transition(taskContext);
        }
        if (some instanceof Some) {
            Some<TaskErrorCodeAndMsg> some2 = some;
            TaskErrorCodeAndMsg e = some2.value();
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)e), Nil$.MODULE$)));
        }
        throw new MatchError(some);
    }

    private ClusterLinkScheduler.TaskResult checkLocalReplicaStatus(ClusterLinkScheduler.TaskContext taskContext, Function2<ClusterLinkScheduler.TaskContext, ReplicaStatusResult, ClusterLinkScheduler.TaskResult> handleLocalReplicaStatusFunc) {
        ReplicaStatusResult localReplicaStatusResult = this.localAdmin.replicaStatus(CollectionConverters$.MODULE$.SetHasAsJava(this.partitions()).asJava());
        this.scheduleWhenComplete(localReplicaStatusResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> (ClusterLinkScheduler.TaskResult)handleLocalReplicaStatusFunc.apply((ClusterLinkScheduler.TaskContext)tc, localReplicaStatusResult), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleLocalReplicaStatus(ClusterLinkScheduler.TaskContext taskContext, ReplicaStatusResult localReplicaStatusResult) {
        Option errOpt;
        Option option;
        try {
            Map<TopicPartition, PartitionResult> localReplicaStatusPartitions = localReplicaStatusResult.allResults().get();
            Iterator<Map.Entry<TopicPartition, PartitionResult>> remoteReplicaStatusPartitionIterator = this.remoteReplicaStatusPartitions().entrySet().iterator();
            while (remoteReplicaStatusPartitionIterator.hasNext()) {
                Map.Entry<TopicPartition, PartitionResult> entry = remoteReplicaStatusPartitionIterator.next();
                TopicPartition tp = entry.getKey();
                PartitionResult remotePartitionResult = entry.getValue();
                PartitionResult localPartitionResult = localReplicaStatusPartitions.get(tp);
                if (!this.isLagCaughtUp(tp, localPartitionResult, remotePartitionResult, taskContext)) continue;
                remoteReplicaStatusPartitionIterator.remove();
            }
            option = None$.MODULE$;
        }
        catch (ExecutionException e) {
            String errMsg = "Encountered exception while getting local replica status for topic " + this.topic + ".";
            this.excessiveLoggingHandler().handle(e, this, errMsg);
            option = new Some<TaskErrorCodeAndMsg>(this.taskErrorCodeAndMsg("Failed to get the local replicas statuses for topic " + this.topic, true, e));
        }
        Option option2 = errOpt = option;
        if (None$.MODULE$.equals(option2)) {
            if (!this.remoteReplicaStatusPartitions().isEmpty()) {
                this.debug((Function0<String> & Serializable)() -> "Not all local mirror topic partitions are caught up with the remote topic. Will check again in " + this.super$rescheduleDelayMs() + " ms.");
                return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
            }
            this.debug((Function0<String> & Serializable)() -> "All local mirror topic partitions are caught up with the remote topic. Will do one final check of remote replica status before promoting local mirror topic.");
            this.localMirrorTopicCaughtUpToRemoteTopic_$eq(true);
            return this.transition(taskContext);
        }
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            TaskErrorCodeAndMsg e = (TaskErrorCodeAndMsg)some.value();
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)e), Nil$.MODULE$)));
        }
        throw new MatchError(option2);
    }

    private ClusterLinkScheduler.TaskResult finalRemoteReplicaStatusCheck(ClusterLinkScheduler.TaskContext taskContext2) {
        Set<TopicPartition> topicPartitions = this.metadataManager().topicPartitions(this.topic);
        if (topicPartitions.size() != this.partitions().size()) {
            this.warn((Function0<String> & Serializable)() -> "Detected change in partitions while syncing local mirror topic with remote mirror topic. Retrying data sync.");
            this.partitions_$eq(topicPartitions);
            this.localMirrorTopicCaughtUpToRemoteTopic_$eq(false);
            v0 = this.transition(taskContext2);
        } else {
            v0 = BoxedUnit.UNIT;
        }
        if (this.remoteReplicaStatusPartitions().isEmpty()) {
            return this.cacheRemoteReplicaStatus(taskContext2);
        }
        return this.checkLocalReplicaStatus(taskContext2, (Function2<ClusterLinkScheduler.TaskContext, ReplicaStatusResult, ClusterLinkScheduler.TaskResult> & Serializable)(taskContext, localReplicaStatusResult) -> this.finalLocalReplicaStatusCheck((ClusterLinkScheduler.TaskContext)taskContext, (ReplicaStatusResult)localReplicaStatusResult));
    }

    private ClusterLinkScheduler.TaskResult finalLocalReplicaStatusCheck(ClusterLinkScheduler.TaskContext taskContext, ReplicaStatusResult localReplicaStatusResult) {
        Some<TaskErrorCodeAndMsg> errOpt;
        Option option;
        boolean remoteReplicaStatusChanged = false;
        try {
            Map<TopicPartition, PartitionResult> localReplicaStatusPartitions = localReplicaStatusResult.allResults().get();
            Set notCaughtUpPartitions = CollectionConverters$.MODULE$.IteratorHasAsScala(this.remoteReplicaStatusPartitions().entrySet().iterator()).asScala().filter((Function1<Map.Entry<TopicPartition, PartitionResult>, Object>)(Function1<Map.Entry, Object> & Serializable)entry -> BoxesRunTime.boxToBoolean(ClusterLinkReverseAndSwapMirror.$anonfun$finalLocalReplicaStatusCheck$1(this, localReplicaStatusPartitions, taskContext, entry))).map((Function1<Map.Entry, TopicPartition> & Serializable)x$9 -> (TopicPartition)x$9.getKey()).toSet();
            if (notCaughtUpPartitions.nonEmpty()) {
                this.info((Function0<String> & Serializable)() -> "Not all local mirror topic partitions have same offset as remote topic partitions. Will restart process of synchronizing data and checking in " + this.super$rescheduleDelayMs());
                remoteReplicaStatusChanged = true;
                return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
            }
            option = None$.MODULE$;
        }
        catch (ExecutionException e) {
            String errMsg = "Encountered exception while getting local replica status for topic " + this.topic + ".";
            this.excessiveLoggingHandler().handle(e, this, errMsg);
            option = new Some<TaskErrorCodeAndMsg>(this.taskErrorCodeAndMsg("Failed to get the final local replicas statuses for topic " + this.topic, true, e));
        }
        Some<TaskErrorCodeAndMsg> some = errOpt = option;
        if (None$.MODULE$.equals(some)) {
            if (remoteReplicaStatusChanged) {
                this.localMirrorTopicCaughtUpToRemoteTopic_$eq(false);
            } else {
                this.debug((Function0<String> & Serializable)() -> "All local mirror topic partitions are caught up with the remote topic. Will proceed to promote local mirror topic.");
                this.finalReplicaStatusCheckCompleted_$eq(true);
            }
            return this.transition(taskContext);
        }
        if (some instanceof Some) {
            Some<TaskErrorCodeAndMsg> some2 = some;
            TaskErrorCodeAndMsg e = some2.value();
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)e), Nil$.MODULE$)));
        }
        throw new MatchError(some);
    }

    private boolean isLagCaughtUp(TopicPartition tp, PartitionResult localPartitionResult, PartitionResult remotePartitionResult, ClusterLinkScheduler.TaskContext taskContext) {
        Option localPartitionResultLeader = CollectionConverters$.MODULE$.ListHasAsScala(localPartitionResult.replicas()).asScala().find((Function1<ReplicaStatus, Object> & Serializable)x$10 -> BoxesRunTime.boxToBoolean(x$10.isLeader()));
        if (localPartitionResultLeader.isEmpty()) {
            return false;
        }
        Option remoteLogEndOffset = CollectionConverters$.MODULE$.ListHasAsScala(remotePartitionResult.replicas()).asScala().find((Function1<ReplicaStatus, Object> & Serializable)x$11 -> BoxesRunTime.boxToBoolean(x$11.isLeader())).map((Function1<ReplicaStatus, Object> & Serializable)x$12 -> BoxesRunTime.boxToLong(x$12.logEndOffset()));
        if (remoteLogEndOffset.isEmpty()) {
            return false;
        }
        Optional<ReplicaStatus.MirrorInfo> localMirrorState = ((ReplicaStatus)localPartitionResultLeader.get()).mirrorInfo();
        if (!localMirrorState.isPresent()) {
            this.warn((Function0<String> & Serializable)() -> "No mirror information found for local partition, topic may have been deleted and recreated. Shutting down ClusterLinkReverseAndSwapMirrorTopic.");
            this.onCompletion(taskContext);
            return false;
        }
        if (!localMirrorState.get().state().equals((Object)ReplicaStatus.MirrorInfo.State.PENDING_SYNCHRONIZE)) {
            this.warn((Function0<String> & Serializable)() -> "Local mirror topic state changed from PendingSynchronizeMirror to " + localMirrorState + ". Shuttingdown ClusterLinkReverseAndSwapMirrorTopic.");
            this.onCompletion(taskContext);
            return false;
        }
        if (localPartitionResult.replicas().stream().allMatch(x$13 -> x$13.logEndOffset() == BoxesRunTime.unboxToLong(remoteLogEndOffset.get()))) {
            return true;
        }
        this.debug((Function0<String> & Serializable)() -> "Local mirror topic partition " + tp + " has not caught up to remote topic partition. Local mirror topic partition has log end offset of " + ((ReplicaStatus)localPartitionResultLeader.get()).logEndOffset() + " whereas remote topic partition has log end offset of " + remoteLogEndOffset.get());
        return false;
    }

    private ClusterLinkScheduler.TaskResult promoteLocalMirrorTopic(ClusterLinkScheduler.TaskContext taskContext) {
        boolean bl = false;
        Some some = null;
        Option option = this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic}))).get(this.topic);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            if (some.value() instanceof ClusterLinkTopicState.PendingSynchronizeMirror) {
                this.info((Function0<String> & Serializable)() -> "Executing promote operation on local mirror topic " + $this.topic);
                AlterMirrorsResult stopMirrorTopicResult = this.localAdmin.alterMirrors(Collections.singletonMap(this.topic, AlterMirrorOp.PROMOTE));
                this.scheduleWhenComplete(stopMirrorTopicResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handlePromoteLocalMirrorTopic((ClusterLinkScheduler.TaskContext)tc, stopMirrorTopicResult), taskContext));
                return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
            }
        }
        if (bl) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            this.warn((Function0<String> & Serializable)() -> "See mirror topic state " + state + " for mirror topic " + $this.topic + ", mirror topic state has changed from PendingSynchronize. Shutting down ClusterLinkReverseAndSwapMirrorTopic task.");
            return this.onCompletion(taskContext);
        }
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String> & Serializable)() -> "No mirror topic state found for mirror topic " + $this.topic + ", shutting down ClusterLinkReverseAndSwapMirrorTopic task.");
            return this.onCompletion(taskContext);
        }
        throw new MatchError(option);
    }

    private ClusterLinkScheduler.TaskResult handlePromoteLocalMirrorTopic(ClusterLinkScheduler.TaskContext taskContext, AlterMirrorsResult stopMirrorTopicResult) {
        ClusterLinkScheduler.TaskResult taskResult;
        try {
            stopMirrorTopicResult.all().get();
            this.debug((Function0<String> & Serializable)() -> "Successfully completed promote operation on local mirror topic " + $this.topic);
            taskResult = this.onCompletion(taskContext);
        }
        catch (ExecutionException e) {
            String errMsg = "Encountered exception while promoting local mirror topic " + this.topic + ".";
            this.excessiveLoggingHandler().handle(e, this, errMsg);
            taskResult = ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)this.taskErrorCodeAndMsg("Failed to promote the local mirror topic " + this.topic, true, e)), Nil$.MODULE$)));
        }
        return taskResult;
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    private ClusterLinkScheduler.TaskResult onCompletion(ClusterLinkScheduler.TaskContext taskContext) {
        this.info((Function0<String> & Serializable)() -> "Shutting down ClusterLinkReverseAndSwapMirrorTopic task.");
        this.shutdown();
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String> & Serializable)() -> "Completed with task result " + result);
        this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.clientManager.metrics(), ClusterLinkReverseAndSwapMirrorTopicType$.MODULE$, true, "reverse and swap the mirror"));
    }

    private TaskErrorCodeAndMsg taskErrorCodeAndMsg(String errMsgPrefix, boolean localAdminUsed, ExecutionException ex) {
        return ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg(errMsgPrefix, localAdminUsed, ex);
    }

    public static final /* synthetic */ boolean $anonfun$handleRemoteReplicaStatus$7(ReplicaStatus.MirrorInfo.State x$8) {
        return !x$8.equals((Object)ReplicaStatus.MirrorInfo.State.PENDING_MIRROR);
    }

    public static final /* synthetic */ boolean $anonfun$finalLocalReplicaStatusCheck$1(ClusterLinkReverseAndSwapMirror $this, Map localReplicaStatusPartitions$1, ClusterLinkScheduler.TaskContext taskContext$1, Map.Entry entry) {
        return !$this.isLagCaughtUp((TopicPartition)entry.getKey(), (PartitionResult)localReplicaStatusPartitions$1.get(entry.getKey()), (PartitionResult)entry.getValue(), taskContext$1);
    }

    public ClusterLinkReverseAndSwapMirror(String topic, ClusterLinkDestClientManager clientManager, ClusterLinkBatchAdmin remoteAdmin, ClusterLinkBatchAdmin localAdmin, Time time, ClusterLinkRequestQuota quota, int intervalMs) {
        this.topic = topic;
        this.clientManager = clientManager;
        this.remoteAdmin = remoteAdmin;
        this.localAdmin = localAdmin;
        super(clientManager.scheduler(), "ClusterLinkReverseAndSwapMirror-topic-" + topic + "-link-" + clientManager.linkData().linkName(), intervalMs, time, quota);
        this.metadataManager = clientManager.metadataManager();
        this.remoteReplicaStatusPartitions = new HashMap<TopicPartition, PartitionResult>();
        this.excessiveLoggingHandler = ExcessiveLoggingHandler$.MODULE$.apply(ExcessiveLoggingHandler$.MODULE$.apply$default$1(), ExcessiveLoggingHandler$.MODULE$.apply$default$2(), ExcessiveLoggingHandler$.MODULE$.apply$default$3());
        this.localMirrorTopicCaughtUpToRemoteTopic = false;
        this.finalReplicaStatusCheckCompleted = false;
        this.taskDesc = None$.MODULE$;
    }
}

