/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkBatchAdmin$;
import kafka.server.link.ClusterLinkClearStartOffsetsForMirrors;
import kafka.server.link.ClusterLinkClearStartOffsetsForMirrors$;
import kafka.server.link.ClusterLinkConvertTopicsToMirrors;
import kafka.server.link.ClusterLinkConvertTopicsToMirrors$;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkPeriodicTasks;
import kafka.server.link.ClusterLinkPreparePendingRestoreMirrors;
import kafka.server.link.ClusterLinkPreparePendingRestoreMirrors$;
import kafka.server.link.ClusterLinkRepairMirrors;
import kafka.server.link.ClusterLinkRepairMirrors$;
import kafka.server.link.ClusterLinkReverseAndSwapMirrors;
import kafka.server.link.ClusterLinkReverseAndSwapMirrors$;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.ClusterLinkStopMirrors;
import kafka.server.link.ClusterLinkStopMirrors$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTransitionMirrors;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\tmg\u0001\u0002'N\u0001QC\u0001\"\u0019\u0001\u0003\u0006\u0004%\tA\u0019\u0005\tM\u0002\u0011\t\u0011)A\u0005G\"Aq\r\u0001B\u0001B\u0003%\u0001\u000e\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003n\u0011!\t\bA!A!\u0002\u0013\u0011\b\"\u0002@\u0001\t\u0003y\b\"CA\u0006\u0001\t\u0007I\u0011AA\u0007\u0011!\t)\u0002\u0001Q\u0001\n\u0005=\u0001\"CA\f\u0001\t\u0007I\u0011BA\r\u0011!\tI\t\u0001Q\u0001\n\u0005m\u0001\"CAF\u0001\u0001\u0007I\u0011BAG\u0011%\t)\u000b\u0001a\u0001\n\u0013\t9\u000b\u0003\u0005\u0002.\u0002\u0001\u000b\u0015BAH\u0011%\t9\f\u0001b\u0001\n\u0003\tI\f\u0003\u0005\u0002B\u0002\u0001\u000b\u0011BA^\u0011%\t\u0019\r\u0001b\u0001\n\u0003\t)\r\u0003\u0005\u0002N\u0002\u0001\u000b\u0011BAd\u0011%\ty\r\u0001b\u0001\n\u0003\t\t\u000e\u0003\u0005\u0002Z\u0002\u0001\u000b\u0011BAj\u0011%\tY\u000e\u0001b\u0001\n\u0003\ti\u000e\u0003\u0005\u0002f\u0002\u0001\u000b\u0011BAp\u0011%\t9\u000f\u0001b\u0001\n\u0003\tI\u000f\u0003\u0005\u0002r\u0002\u0001\u000b\u0011BAv\u0011%\t\u0019\u0010\u0001b\u0001\n\u0003\t)\u0010\u0003\u0005\u0002~\u0002\u0001\u000b\u0011BA|\u0011%\ty\u0010\u0001b\u0001\n\u0003\u0011\t\u0001\u0003\u0005\u0003\n\u0001\u0001\u000b\u0011\u0002B\u0002\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003{BqA!\u0004\u0001\t\u0003\u0011y\u0001C\u0004\u0003\u0012\u0001!\t!!\u0017\t\u000f\tM\u0001\u0001\"\u0001\u0003\u0016!9\u0011Q\u000f\u0001\u0005\u0002\te\u0001b\u0002B\u000f\u0001\u0011%!q\u0004\u0005\b\u0005C\u0001A\u0011\u0002B\u0012\u0011\u001d\u0011Y\u0003\u0001C\u0005\u0005[AaA!\u000f\u0001\t\u0003\u0011\u0007b\u0002B\u001e\u0001\u0011\u0005!Q\b\u0005\b\u0005;\u0002A\u0011\u0002B0\u0011\u001d\u0011I\b\u0001C\u0001\u0005wBq!!\"\u0001\t\u0003\t9IB\u0005\u0002J\u0001\u0001\n1%\u0001\u0002L!9\u0011QJ\u0015\u0007\u0002\u0005=\u0003bBA,S\u0019\u0005\u0011\u0011\f\u0005\b\u0003CJc\u0011AA2\u0011\u001d\t)(\u000bD\u0001\u0003oBq!a\u001f*\r\u0003\ti\bC\u0004\u0002\u0006&2\t!a\"\u0007\r\t%\u0005\u0001\u0002BF\u0011\u0019q\b\u0007\"\u0001\u0003\u000e\"I\u0011Q\n\u0019C\u0002\u0013\u0005\u0013q\n\u0005\t\u0005#\u0003\u0004\u0015!\u0003\u0002R!a!1\u0013\u0019A\u0002\u0003\u0007I\u0011A'\u0003\u0016\"a!q\u0013\u0019A\u0002\u0003\u0007I\u0011A'\u0003\u001a\"Y!Q\u0014\u0019A\u0002\u0003\u0005\u000b\u0015BA.\u0011\u001d\t9\u0006\rC!\u00033Bq!!\u00191\t\u0003\u0012\t\u000bC\u0004\u0002vA\"\tE!*\t\u000f\u0005m\u0004\u0007\"\u0011\u0002~!9\u0011Q\u0011\u0019\u0005B\u0005\u001deA\u0002BU\u0001\u0011\u0011Y\u000b\u0003\u0006\u0003(q\u0012\t\u0011)A\u0005\u0005SA!B!,=\u0005\u0003\u0005\u000b\u0011BAK\u0011\u0019qH\b\"\u0001\u00030\"I\u0011Q\n\u001fC\u0002\u0013\u0005\u0013q\n\u0005\t\u0005#c\u0004\u0015!\u0003\u0002R!I!q\u0017\u001fC\u0002\u0013%!\u0011\u0018\u0005\t\u0005\u0017d\u0004\u0015!\u0003\u0003<\"a!1\u0013\u001fA\u0002\u0003\u0007I\u0011A'\u0003\u0016\"a!q\u0013\u001fA\u0002\u0003\u0007I\u0011A'\u0003N\"Y!Q\u0014\u001fA\u0002\u0003\u0005\u000b\u0015BA.\u0011\u001d\t9\u0006\u0010C\u0001\u00033Bq!!\u0019=\t\u0003\u0011\u0019\u000eC\u0004\u0002vq\"\tAa6\t\u000f\u0005mD\b\"\u0001\u0002~!9\u0011Q\u0011\u001f\u0005\u0002\u0005\u001d%AF\"mkN$XM\u001d'j].$\u0016m]6NC:\fw-\u001a:\u000b\u00059{\u0015\u0001\u00027j].T!\u0001U)\u0002\rM,'O^3s\u0015\u0005\u0011\u0016!B6bM.\f7\u0001A\n\u0004\u0001U[\u0006C\u0001,Z\u001b\u00059&\"\u0001-\u0002\u000bM\u001c\u0017\r\\1\n\u0005i;&AB!osJ+g\r\u0005\u0002]?6\tQL\u0003\u0002_#\u0006)Q\u000f^5mg&\u0011\u0001-\u0018\u0002\b\u0019><w-\u001b8h\u0003\u0015Ig\u000eZ3y+\u0005\u0019\u0007C\u0001,e\u0013\t)wKA\u0002J]R\fa!\u001b8eKb\u0004\u0013AE2mkN$XM\u001d'j].l\u0015M\\1hKJ\u0004\"!\u001b6\u000e\u00035K!a['\u0003%\rcWo\u001d;fe2Kgn['b]\u0006<WM]\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003]>l\u0011aT\u0005\u0003a>\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006!A/[7f!\t\u0019H0D\u0001u\u0015\tqVO\u0003\u0002wo\u000611m\\7n_:T!A\u0015=\u000b\u0005eT\u0018AB1qC\u000eDWMC\u0001|\u0003\ry'oZ\u0005\u0003{R\u0014A\u0001V5nK\u00061A(\u001b8jiz\"\"\"!\u0001\u0002\u0004\u0005\u0015\u0011qAA\u0005!\tI\u0007\u0001C\u0003b\r\u0001\u00071\rC\u0003h\r\u0001\u0007\u0001\u000eC\u0003m\r\u0001\u0007Q\u000eC\u0003r\r\u0001\u0007!/A\u0005tG\",G-\u001e7feV\u0011\u0011q\u0002\t\u0004S\u0006E\u0011bAA\n\u001b\n!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003-awnY1m\u0003\u0012l\u0017N\\:\u0016\u0005\u0005m\u0001\u0003CA\u000f\u0003W\ty#!\u0012\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\t)#a\n\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003S\tAA[1wC&!\u0011QFA\u0010\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0005\u0003c\tyD\u0004\u0003\u00024\u0005m\u0002cAA\u001b/6\u0011\u0011q\u0007\u0006\u0004\u0003s\u0019\u0016A\u0002\u001fs_>$h(C\u0002\u0002>]\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA!\u0003\u0007\u0012aa\u0015;sS:<'bAA\u001f/B\u0019\u0011qI\u0015\u000e\u0003\u0001\u0011!\u0002T8dC2\fE-\\5o'\tIS+\u0001\u0006cCR\u001c\u0007.\u00113nS:,\"!!\u0015\u0011\u0007%\f\u0019&C\u0002\u0002V5\u0013Qc\u00117vgR,'\u000fT5oW\n\u000bGo\u00195BI6Lg.A\u000bhKR|%o\u0011:fCR,Gj\\2bY\u0006#W.\u001b8\u0015\u0005\u0005m\u0003cA5\u0002^%\u0019\u0011qL'\u0003+\rcWo\u001d;fe2Kgn\u001b'pG\u0006d\u0017\tZ7j]\u00069\u0011\r\u001a3MS:\\G\u0003BA3\u0003W\u00022AVA4\u0013\r\tIg\u0016\u0002\u0005+:LG\u000fC\u0004\u0002n1\u0002\r!a\u001c\u0002\u00111Lgn\u001b#bi\u0006\u00042![A9\u0013\r\t\u0019(\u0014\u0002\u0010\u00072,8\u000f^3s\u0019&t7\u000eR1uC\u0006Q!/Z7pm\u0016d\u0015N\\6\u0015\t\u0005\u0015\u0014\u0011\u0010\u0005\b\u0003[j\u0003\u0019AA8\u0003\u001dI7/R7qif,\"!a \u0011\u0007Y\u000b\t)C\u0002\u0002\u0004^\u0013qAQ8pY\u0016\fg.\u0001\u0005tQV$Hm\\<o)\t\t)'\u0001\u0007m_\u000e\fG.\u00113nS:\u001c\b%\u0001\tm_\u000e\fGN\u0011:pW\u0016\u0014\u0018\tZ7j]V\u0011\u0011q\u0012\t\u0006-\u0006E\u0015QS\u0005\u0004\u0003';&AB(qi&|g\u000e\u0005\u0003\u0002\u0018\u0006\u0005VBAAM\u0015\u0011\tY*!(\u0002\u000b\u0005$W.\u001b8\u000b\u0007\u0005}u/A\u0004dY&,g\u000e^:\n\t\u0005\r\u0016\u0011\u0014\u0002\u000f\u0007>tg\r\\;f]R\fE-\\5o\u0003QawnY1m\u0005J|7.\u001a:BI6Lgn\u0018\u0013fcR!\u0011QMAU\u0011%\tY\u000bDA\u0001\u0002\u0004\ty)A\u0002yIE\n\u0011\u0003\\8dC2\u0014%o\\6fe\u0006#W.\u001b8!Q\ri\u0011\u0011\u0017\t\u0004-\u0006M\u0016bAA[/\nAao\u001c7bi&dW-\u0001\rdYV\u001cH/\u001a:MS:\\\u0007+\u001a:j_\u0012L7\rV1tWN,\"!a/\u0011\u0007%\fi,C\u0002\u0002@6\u0013\u0001d\u00117vgR,'\u000fT5oWB+'/[8eS\u000e$\u0016m]6t\u0003e\u0019G.^:uKJd\u0015N\\6QKJLw\u000eZ5d)\u0006\u001c8n\u001d\u0011\u0002-\rdWo\u001d;fe2Kgn[*u_Bl\u0015N\u001d:peN,\"!a2\u0011\u0007%\fI-C\u0002\u0002L6\u0013ac\u00117vgR,'\u000fT5oWN#x\u000e]'jeJ|'o]\u0001\u0018G2,8\u000f^3s\u0019&t7n\u0015;pa6K'O]8sg\u0002\n\u0001e\u00197vgR,'\u000fT5oWJ+g/\u001a:tK\u0006sGmU<ba6K'O]8sgV\u0011\u00111\u001b\t\u0004S\u0006U\u0017bAAl\u001b\n\u00013\t\\;ti\u0016\u0014H*\u001b8l%\u00164XM]:f\u0003:$7k^1q\u001b&\u0014(o\u001c:t\u0003\u0005\u001aG.^:uKJd\u0015N\\6SKZ,'o]3B]\u0012\u001cv/\u00199NSJ\u0014xN]:!\u0003m\u0019G.^:uKJd\u0015N\\6D_:4XM\u001d;U_6K'O]8sgV\u0011\u0011q\u001c\t\u0004S\u0006\u0005\u0018bAAr\u001b\n\t3\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg/\u001a:u)>\u0004\u0018nY:U_6K'O]8sg\u0006a2\r\\;ti\u0016\u0014H*\u001b8l\u0007>tg/\u001a:u)>l\u0015N\u001d:peN\u0004\u0013\u0001G2mkN$XM\u001d'j].\u0014V\r]1je6K'O]8sgV\u0011\u00111\u001e\t\u0004S\u00065\u0018bAAx\u001b\nA2\t\\;ti\u0016\u0014H*\u001b8l%\u0016\u0004\u0018-\u001b:NSJ\u0014xN]:\u00023\rdWo\u001d;fe2Kgn\u001b*fa\u0006L'/T5se>\u00148\u000fI\u0001'G2,8\u000f^3s\u0019&t7n\u00117fCJ\u001cF/\u0019:u\u001f\u001a47/\u001a;t\r>\u0014X*\u001b:s_J\u001cXCAA|!\rI\u0017\u0011`\u0005\u0004\u0003wl%AJ\"mkN$XM\u001d'j].\u001cE.Z1s'R\f'\u000f^(gMN,Go\u001d$pe6K'O]8sg\u000693\r\\;ti\u0016\u0014H*\u001b8l\u00072,\u0017M]*uCJ$xJ\u001a4tKR\u001chi\u001c:NSJ\u0014xN]:!\u0003\u001d\u001aG.^:uKJd\u0015N\\6Qe\u0016\u0004\u0018M]3QK:$\u0017N\\4SKN$xN]3NSJ\u0014xN]:\u0016\u0005\t\r\u0001cA5\u0003\u0006%\u0019!qA'\u0003O\rcWo\u001d;fe2Kgn\u001b)sKB\f'/\u001a)f]\u0012Lgn\u001a*fgR|'/Z'jeJ|'o]\u0001)G2,8\u000f^3s\u0019&t7\u000e\u0015:fa\u0006\u0014X\rU3oI&twMU3ti>\u0014X-T5se>\u00148\u000fI\u0001\u0011g\u000eDW\rZ;mKJ\u001cF/\u0019:uK\u0012\f1#\\1zE\u0016\u001cF/\u0019:u'\u000eDW\rZ;mKJ$\"!a\u0004\u00027\u001d,Go\u0014:De\u0016\fG/Z*iCJ,G\rT8dC2\fE-\\5o\u0003i9W\r^(s\u0007J,\u0017\r^3M_\u000e\fGNQ1uG\"\fE-\\5o)\u0011\t\tFa\u0006\t\u000f\u00055t\u00041\u0001\u0002pQ!\u0011Q\rB\u000e\u0011\u001d\ti\u0007\ta\u0001\u0003_\n1$\\1zE\u0016\u001c%/Z1uKNC\u0017M]3e\u0019>\u001c\u0017\r\\!e[&tGCAA#\u0003mi\u0017-\u001f2f\u0007J,\u0017\r^3UK:\fg\u000e\u001e'pG\u0006d\u0017\tZ7j]R!\u0011Q\tB\u0013\u0011\u001d\u00119C\ta\u0001\u0005S\tA\u0002^3oC:$\bK]3gSb\u0004RAVAI\u0003_\tQB\\3x\u0005\u0006$8\r[!e[&tG\u0003BA)\u0005_AqA!\r$\u0001\u0004\u0011\u0019$\u0001\thKR|%o\u0011:fCR,\u0017\tZ7j]B)aK!\u000e\u0002\u0016&\u0019!qG,\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014\u0001\u0007;pi\u0006dGj\\2bY\u0006#W.\u001b8Rk\u0016,XmU5{K\u0006A\u0002O]8dKN\u001cX*\u001b:s_J\u001cF/\u0019;f\u0007\"\fgnZ3\u0015\u0015\u0005\u0015$q\bB\"\u0005\u001b\u0012\u0019\u0006C\u0004\u0003B\u0015\u0002\r!a\f\u0002\u000bQ|\u0007/[2\t\u000f\t\u0015S\u00051\u0001\u0003H\u0005YQ.\u001b:s_J\u001cF/\u0019;f!\rI'\u0011J\u0005\u0004\u0005\u0017j%!F\"mkN$XM\u001d'j].$v\u000e]5d'R\fG/\u001a\u0005\b\u0005\u001f*\u0003\u0019\u0001B)\u0003!yG\u000eZ*uCR,\u0007#\u0002,\u0002\u0012\n\u001d\u0003b\u0002B+K\u0001\u0007!qK\u0001\u000eG2LWM\u001c;NC:\fw-\u001a:\u0011\u0007%\u0014I&C\u0002\u0003\\5\u0013Ad\u00117vgR,'\u000fT5oW\u0012+7\u000f^\"mS\u0016tG/T1oC\u001e,'/A\tue\u0006t7/\u001b;j_:l\u0015N\u001d:peN,\"A!\u0019\u0011\r\t\r$Q\u000eB:\u001d\u0011\u0011)G!\u001b\u000f\t\u0005U\"qM\u0005\u00021&\u0019!1N,\u0002\u000fA\f7m[1hK&!!q\u000eB9\u0005\r\u0019V-\u001d\u0006\u0004\u0005W:\u0006cA5\u0003v%\u0019!qO'\u00039\rcWo\u001d;fe2Kgn\u001b+sC:\u001c\u0018\u000e^5p]6K'O]8sg\u0006arN\u001c'j].\u001cun\u001c:eS:\fGo\u001c:SKNLwM\\1uS>tG\u0003BA3\u0005{BqAa (\u0001\u0004\u0011\t)\u0001\u0004mS:\\\u0017\n\u001a\t\u0005\u0005\u0007\u0013))D\u0001v\u0013\r\u00119)\u001e\u0002\u0005+VLGM\u0001\tTQ\u0006\u0014X\r\u001a'pG\u0006d\u0017\tZ7j]N!\u0001'VA#)\t\u0011y\tE\u0002\u0002HA\n1BY1uG\"\fE-\\5oA\u0005QAn\\2bY\u0006#W.\u001b8\u0016\u0005\u0005m\u0013A\u00047pG\u0006d\u0017\tZ7j]~#S-\u001d\u000b\u0005\u0003K\u0012Y\nC\u0005\u0002,V\n\t\u00111\u0001\u0002\\\u0005YAn\\2bY\u0006#W.\u001b8!Q\r1\u0014\u0011\u0017\u000b\u0005\u0003K\u0012\u0019\u000bC\u0004\u0002na\u0002\r!a\u001c\u0015\t\u0005\u0015$q\u0015\u0005\b\u0003[J\u0004\u0019AA8\u0005A!VM\\1oi2{7-\u00197BI6Lgn\u0005\u0003=+\u0006\u0015\u0013\u0001E5oi\u0016\u0014(I]8lKJ\fE-\\5o)\u0019\u0011\tLa-\u00036B\u0019\u0011q\t\u001f\t\u000f\t\u001dr\b1\u0001\u0003*!9!QV A\u0002\u0005U\u0015!\u00027j].\u001cXC\u0001B^!\u0019\u0011iLa2\u0002p5\u0011!q\u0018\u0006\u0005\u0005\u0003\u0014\u0019-A\u0004nkR\f'\r\\3\u000b\u0007\t\u0015w+\u0001\u0006d_2dWm\u0019;j_:LAA!3\u0003@\n\u00191+\u001a;\u0002\r1Lgn[:!)\u0011\t)Ga4\t\u0013\u0005-V)!AA\u0002\u0005m\u0003f\u0001$\u00022R!\u0011Q\rBk\u0011\u001d\ti\u0007\u0013a\u0001\u0003_\"B!!\u001a\u0003Z\"9\u0011QN%A\u0002\u0005=\u0004")
public class ClusterLinkTaskManager
implements Logging {
    private final int index;
    public final ClusterLinkManager kafka$server$link$ClusterLinkTaskManager$$clusterLinkManager;
    private final KafkaConfig brokerConfig;
    private final Time time;
    private final ClusterLinkScheduler scheduler;
    private final ConcurrentHashMap<String, LocalAdmin> localAdmins;
    private volatile Option<ConfluentAdmin> localBrokerAdmin;
    private final ClusterLinkPeriodicTasks clusterLinkPeriodicTasks;
    private final ClusterLinkStopMirrors clusterLinkStopMirrors;
    private final ClusterLinkReverseAndSwapMirrors clusterLinkReverseAndSwapMirrors;
    private final ClusterLinkConvertTopicsToMirrors clusterLinkConvertToMirrors;
    private final ClusterLinkRepairMirrors clusterLinkRepairMirrors;
    private final ClusterLinkClearStartOffsetsForMirrors clusterLinkClearStartOffsetsForMirrors;
    private final ClusterLinkPreparePendingRestoreMirrors clusterLinkPreparePendingRestoreMirrors;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ClusterLinkTaskManager clusterLinkTaskManager = this;
        synchronized (clusterLinkTaskManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int index() {
        return this.index;
    }

    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConcurrentHashMap<String, LocalAdmin> localAdmins() {
        return this.localAdmins;
    }

    private Option<ConfluentAdmin> localBrokerAdmin() {
        return this.localBrokerAdmin;
    }

    private void localBrokerAdmin_$eq(Option<ConfluentAdmin> x$1) {
        this.localBrokerAdmin = x$1;
    }

    public ClusterLinkPeriodicTasks clusterLinkPeriodicTasks() {
        return this.clusterLinkPeriodicTasks;
    }

    public ClusterLinkStopMirrors clusterLinkStopMirrors() {
        return this.clusterLinkStopMirrors;
    }

    public ClusterLinkReverseAndSwapMirrors clusterLinkReverseAndSwapMirrors() {
        return this.clusterLinkReverseAndSwapMirrors;
    }

    public ClusterLinkConvertTopicsToMirrors clusterLinkConvertToMirrors() {
        return this.clusterLinkConvertToMirrors;
    }

    public ClusterLinkRepairMirrors clusterLinkRepairMirrors() {
        return this.clusterLinkRepairMirrors;
    }

    public ClusterLinkClearStartOffsetsForMirrors clusterLinkClearStartOffsetsForMirrors() {
        return this.clusterLinkClearStartOffsetsForMirrors;
    }

    public ClusterLinkPreparePendingRestoreMirrors clusterLinkPreparePendingRestoreMirrors() {
        return this.clusterLinkPreparePendingRestoreMirrors;
    }

    public boolean schedulerStarted() {
        return this.scheduler().isStarted();
    }

    public ClusterLinkScheduler maybeStartScheduler() {
        if (!this.scheduler().isStarted()) {
            ClusterLinkTaskManager clusterLinkTaskManager = this;
            synchronized (clusterLinkTaskManager) {
                if (!this.scheduler().isStarted()) {
                    this.debug((Function0<String> & Serializable)() -> "Starting scheduler " + this.index());
                    this.scheduler().startup();
                    this.transitionMirrors().foreach((Function1<ClusterLinkTransitionMirrors, Object> & Serializable)x$1 -> {
                        x$1.startup();
                        return BoxedUnit.UNIT;
                    });
                    this.clusterLinkPeriodicTasks().startup();
                }
            }
        }
        return this.scheduler();
    }

    public ClusterLinkLocalAdmin getOrCreateSharedLocalAdmin() {
        LocalAdmin localAdmin = Predef$.MODULE$.Boolean2boolean(this.brokerConfig.clusterLinkLocalAdminMultiTenantEnable()) ? this.maybeCreateTenantLocalAdmin(None$.MODULE$) : this.maybeCreateSharedLocalAdmin();
        return localAdmin.getOrCreateLocalAdmin();
    }

    public ClusterLinkBatchAdmin getOrCreateLocalBatchAdmin(ClusterLinkData linkData) {
        if (Predef$.MODULE$.Boolean2boolean(this.brokerConfig.clusterLinkLocalAdminMultiTenantEnable())) {
            LocalAdmin localAdmin;
            ClusterLinkTaskManager clusterLinkTaskManager = this;
            synchronized (clusterLinkTaskManager) {
                LocalAdmin localAdmin2 = this.maybeCreateTenantLocalAdmin(linkData.tenantPrefix());
                localAdmin2.addLink(linkData);
                localAdmin = localAdmin2;
            }
            LocalAdmin tenantLocalAdmin = localAdmin;
            return tenantLocalAdmin.batchAdmin();
        }
        return this.maybeCreateSharedLocalAdmin().batchAdmin();
    }

    public void removeLink(ClusterLinkData linkData) {
        String tenantPrefix = (String)linkData.tenantPrefix().getOrElse((Function0<String> & Serializable)() -> "");
        if (Predef$.MODULE$.Boolean2boolean(this.brokerConfig.clusterLinkLocalAdminMultiTenantEnable()) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(tenantPrefix))) {
            ClusterLinkTaskManager clusterLinkTaskManager = this;
            synchronized (clusterLinkTaskManager) {
                LocalAdmin localAdmin = this.localAdmins().get(tenantPrefix);
                Option$.MODULE$.apply(localAdmin).foreach((Function1<LocalAdmin, Object> & Serializable)admin -> {
                    ClusterLinkTaskManager.$anonfun$removeLink$2(this, linkData, localAdmin, tenantPrefix, admin);
                    return BoxedUnit.UNIT;
                });
            }
            return;
        }
    }

    private LocalAdmin maybeCreateSharedLocalAdmin() {
        String key = "";
        LocalAdmin localAdmin = this.localAdmins().get(key);
        if (localAdmin == null) {
            ClusterLinkTaskManager clusterLinkTaskManager = this;
            synchronized (clusterLinkTaskManager) {
                localAdmin = this.localAdmins().computeIfAbsent(key, x$2 -> new SharedLocalAdmin());
            }
        }
        return localAdmin;
    }

    private LocalAdmin maybeCreateTenantLocalAdmin(Option<String> tenantPrefix) {
        String key = (String)tenantPrefix.getOrElse((Function0<String> & Serializable)() -> "");
        LocalAdmin localAdmin = this.localAdmins().get(key);
        if (localAdmin == null) {
            ClusterLinkTaskManager clusterLinkTaskManager = this;
            synchronized (clusterLinkTaskManager) {
                if (this.localBrokerAdmin().isEmpty()) {
                    this.info((Function0<String> & Serializable)() -> "Creating inter-broker admin for task manager " + this.index());
                    this.localBrokerAdmin_$eq(new Some<ConfluentAdmin>(this.kafka$server$link$ClusterLinkTaskManager$$clusterLinkManager.createInterBrokerAdmin(this.scheduler(), this.index())));
                }
                localAdmin = this.localAdmins().computeIfAbsent(key, x$3 -> new TenantLocalAdmin(this, tenantPrefix, this.localBrokerAdmin().get()));
            }
        }
        return localAdmin;
    }

    public ClusterLinkBatchAdmin kafka$server$link$ClusterLinkTaskManager$$newBatchAdmin(Function0<ConfluentAdmin> getOrCreateAdmin) {
        return ClusterLinkBatchAdmin$.MODULE$.apply(getOrCreateAdmin, () -> Predef$.MODULE$.Integer2int($this.brokerConfig.clusterLinkAdminRequestBatchSize()), () -> Predef$.MODULE$.Integer2int($this.brokerConfig.clusterLinkAdminMaxInFlightRequests()), this.scheduler(), this.time, (Function0<Sensor> & Serializable)() -> $this.kafka$server$link$ClusterLinkTaskManager$$clusterLinkManager.brokerMetrics().localAdminQueueTimeSensor(), (Function0<Sensor> & Serializable)() -> $this.kafka$server$link$ClusterLinkTaskManager$$clusterLinkManager.brokerMetrics().localAdminRequestTimeSensor());
    }

    public int totalLocalAdminQueueSize() {
        return this.localAdmins().values().stream().mapToInt(x$4 -> x$4.batchAdmin().queueSize()).sum();
    }

    public void processMirrorStateChange(String topic, ClusterLinkTopicState mirrorState, Option<ClusterLinkTopicState> oldState, ClusterLinkDestClientManager clientManager) {
        if (!this.kafka$server$link$ClusterLinkTaskManager$$clusterLinkManager.metadataManager().isLinkCoordinator(mirrorState.linkName())) {
            this.debug((Function0<String> & Serializable)() -> "Not starting tasks for mirror state " + mirrorState.state() + " for topic '" + topic + "' since this broker is not the link coordinator for cluster link '" + mirrorState.linkName() + "'");
            return;
        }
        this.debug((Function0<String> & Serializable)() -> "Processing mirror state " + mirrorState.state() + " for topic '" + topic + "', oldState " + oldState);
        this.clusterLinkStopMirrors().maybeAddTask(topic, mirrorState, oldState, clientManager);
        this.clusterLinkConvertToMirrors().maybeAddTask(topic, mirrorState, oldState, clientManager);
        this.clusterLinkReverseAndSwapMirrors().maybeAddTask(topic, mirrorState, oldState, clientManager);
        this.clusterLinkRepairMirrors().maybeAddTask(topic, mirrorState, oldState, clientManager);
        this.clusterLinkClearStartOffsetsForMirrors().maybeAddTask(topic, mirrorState, oldState, clientManager);
        this.clusterLinkPreparePendingRestoreMirrors().maybeAddTask(topic, mirrorState, oldState, clientManager);
    }

    private Seq<ClusterLinkTransitionMirrors> transitionMirrors() {
        return new $colon$colon<Nothing$>((Nothing$)((Object)this.clusterLinkStopMirrors()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.clusterLinkReverseAndSwapMirrors()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.clusterLinkConvertToMirrors()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.clusterLinkRepairMirrors()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.clusterLinkClearStartOffsetsForMirrors()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.clusterLinkPreparePendingRestoreMirrors()), Nil$.MODULE$))))));
    }

    public void onLinkCoordinatorResignation(Uuid linkId) {
        this.transitionMirrors().foreach((Function1<ClusterLinkTransitionMirrors, Object> & Serializable)x$5 -> {
            x$5.shutdownTasks(linkId, "coordinator resignation", x$5.shutdownTasks$default$3());
            return BoxedUnit.UNIT;
        });
    }

    public void shutdown() {
        this.debug((Function0<String> & Serializable)() -> "Shutting down task manager with scheduler " + this.index());
        this.transitionMirrors().foreach((Function1<ClusterLinkTransitionMirrors, Object> & Serializable)x$6 -> {
            x$6.shutdown();
            return BoxedUnit.UNIT;
        });
        this.transitionMirrors().foreach((Function1<ClusterLinkTransitionMirrors, Object> & Serializable)x$7 -> {
            x$7.shutdownAllTasks();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkPeriodicTasks().shutdown();
        this.clusterLinkPeriodicTasks().shutdownAllTasks();
        CoreUtils$.MODULE$.swallow(() -> this.scheduler().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        this.localBrokerAdmin().foreach((Function1<ConfluentAdmin, Object> & Serializable)x$8 -> {
            x$8.close(Duration.ZERO);
            return BoxedUnit.UNIT;
        });
        this.localAdmins().values().forEach(batchAdmin -> CoreUtils$.MODULE$.swallow(() -> batchAdmin.shutdown(), this, CoreUtils$.MODULE$.swallow$default$3()));
        this.localAdmins().clear();
    }

    public static final /* synthetic */ void $anonfun$removeLink$2(ClusterLinkTaskManager $this, ClusterLinkData linkData$1, LocalAdmin localAdmin$1, String tenantPrefix$1, LocalAdmin admin) {
        admin.removeLink(linkData$1);
        if (localAdmin$1.isEmpty()) {
            $this.localAdmins().remove(tenantPrefix$1);
            localAdmin$1.shutdown();
            return;
        }
    }

    public ClusterLinkTaskManager(int index, ClusterLinkManager clusterLinkManager, KafkaConfig brokerConfig, Time time) {
        this.index = index;
        this.kafka$server$link$ClusterLinkTaskManager$$clusterLinkManager = clusterLinkManager;
        this.brokerConfig = brokerConfig;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq("[ClusterLinkTaskManager brokerId=" + brokerConfig.brokerId() + "] ");
        this.scheduler = new ClusterLinkScheduler(index, ClusterLinkScheduler$.MODULE$.$lessinit$greater$default$2());
        this.localAdmins = new ConcurrentHashMap();
        this.localBrokerAdmin = None$.MODULE$;
        this.clusterLinkPeriodicTasks = new ClusterLinkPeriodicTasks(brokerConfig, clusterLinkManager, this.scheduler(), time);
        this.clusterLinkStopMirrors = new ClusterLinkStopMirrors(brokerConfig, clusterLinkManager, this.scheduler(), time, ClusterLinkStopMirrors$.MODULE$.$lessinit$greater$default$5());
        this.clusterLinkReverseAndSwapMirrors = new ClusterLinkReverseAndSwapMirrors(brokerConfig, clusterLinkManager, this.scheduler(), time, ClusterLinkReverseAndSwapMirrors$.MODULE$.$lessinit$greater$default$5());
        this.clusterLinkConvertToMirrors = new ClusterLinkConvertTopicsToMirrors(brokerConfig, clusterLinkManager, this.scheduler(), time, ClusterLinkConvertTopicsToMirrors$.MODULE$.$lessinit$greater$default$5());
        this.clusterLinkRepairMirrors = new ClusterLinkRepairMirrors(brokerConfig, clusterLinkManager, this.scheduler(), time, ClusterLinkRepairMirrors$.MODULE$.$lessinit$greater$default$5());
        this.clusterLinkClearStartOffsetsForMirrors = new ClusterLinkClearStartOffsetsForMirrors(brokerConfig, clusterLinkManager, this.scheduler(), time, ClusterLinkClearStartOffsetsForMirrors$.MODULE$.$lessinit$greater$default$5());
        this.clusterLinkPreparePendingRestoreMirrors = new ClusterLinkPreparePendingRestoreMirrors(brokerConfig, clusterLinkManager, this.scheduler(), time, ClusterLinkPreparePendingRestoreMirrors$.MODULE$.$lessinit$greater$default$5());
    }

    public interface LocalAdmin {
        public ClusterLinkBatchAdmin batchAdmin();

        public ClusterLinkLocalAdmin getOrCreateLocalAdmin();

        public void addLink(ClusterLinkData var1);

        public void removeLink(ClusterLinkData var1);

        public boolean isEmpty();

        public void shutdown();
    }

    private class SharedLocalAdmin
    implements LocalAdmin {
        private final ClusterLinkBatchAdmin batchAdmin;
        private volatile ClusterLinkLocalAdmin localAdmin;

        @Override
        public ClusterLinkBatchAdmin batchAdmin() {
            return this.batchAdmin;
        }

        public ClusterLinkLocalAdmin localAdmin() {
            return this.localAdmin;
        }

        public void localAdmin_$eq(ClusterLinkLocalAdmin x$1) {
            this.localAdmin = x$1;
        }

        @Override
        public ClusterLinkLocalAdmin getOrCreateLocalAdmin() {
            if (this.localAdmin() == null) {
                SharedLocalAdmin sharedLocalAdmin = this;
                synchronized (sharedLocalAdmin) {
                    if (this.localAdmin() == null) {
                        this.kafka$server$link$ClusterLinkTaskManager$SharedLocalAdmin$$$outer().info((Function0<String> & Serializable)() -> "Creating local admin client for task manager " + this.kafka$server$link$ClusterLinkTaskManager$SharedLocalAdmin$$$outer().index());
                        this.localAdmin_$eq(this.kafka$server$link$ClusterLinkTaskManager$SharedLocalAdmin$$$outer().kafka$server$link$ClusterLinkTaskManager$$clusterLinkManager.createLocalAdmin(this.kafka$server$link$ClusterLinkTaskManager$SharedLocalAdmin$$$outer().maybeStartScheduler(), this.kafka$server$link$ClusterLinkTaskManager$SharedLocalAdmin$$$outer().index(), None$.MODULE$, None$.MODULE$));
                    }
                }
            }
            return this.localAdmin();
        }

        @Override
        public void addLink(ClusterLinkData linkData) {
        }

        @Override
        public void removeLink(ClusterLinkData linkData) {
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public synchronized void shutdown() {
            this.kafka$server$link$ClusterLinkTaskManager$SharedLocalAdmin$$$outer().info((Function0<String> & Serializable)() -> "Shutting down local admin client for task manager " + this.kafka$server$link$ClusterLinkTaskManager$SharedLocalAdmin$$$outer().index());
            this.batchAdmin().shutdown();
            Option$.MODULE$.apply(this.localAdmin()).foreach((Function1<ClusterLinkLocalAdmin, Object> & Serializable)x$10 -> {
                x$10.close(Duration.ZERO);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ ClusterLinkTaskManager kafka$server$link$ClusterLinkTaskManager$SharedLocalAdmin$$$outer() {
            return ClusterLinkTaskManager.this;
        }

        public SharedLocalAdmin() {
            if (ClusterLinkTaskManager.this == null) {
                throw null;
            }
            this.batchAdmin = ClusterLinkTaskManager.this.kafka$server$link$ClusterLinkTaskManager$$newBatchAdmin((Function0<ConfluentAdmin>)(Function0<ClusterLinkLocalAdmin> & Serializable)() -> this.getOrCreateLocalAdmin());
        }
    }

    private class TenantLocalAdmin
    implements LocalAdmin {
        private final Option<String> tenantPrefix;
        private final ConfluentAdmin interBrokerAdmin;
        private final ClusterLinkBatchAdmin batchAdmin;
        private final Set<ClusterLinkData> links;
        private volatile ClusterLinkLocalAdmin localAdmin;
        public final /* synthetic */ ClusterLinkTaskManager $outer;

        @Override
        public ClusterLinkBatchAdmin batchAdmin() {
            return this.batchAdmin;
        }

        private Set<ClusterLinkData> links() {
            return this.links;
        }

        public ClusterLinkLocalAdmin localAdmin() {
            return this.localAdmin;
        }

        public void localAdmin_$eq(ClusterLinkLocalAdmin x$1) {
            this.localAdmin = x$1;
        }

        @Override
        public ClusterLinkLocalAdmin getOrCreateLocalAdmin() {
            if (this.localAdmin() == null) {
                TenantLocalAdmin tenantLocalAdmin = this;
                synchronized (tenantLocalAdmin) {
                    if (this.localAdmin() == null) {
                        this.kafka$server$link$ClusterLinkTaskManager$TenantLocalAdmin$$$outer().info((Function0<String> & Serializable)() -> "Creating tenant-specific local admin client for task manager " + this.kafka$server$link$ClusterLinkTaskManager$TenantLocalAdmin$$$outer().index() + ", tenantPrefix=" + $this.tenantPrefix);
                        this.localAdmin_$eq(this.kafka$server$link$ClusterLinkTaskManager$TenantLocalAdmin$$$outer().kafka$server$link$ClusterLinkTaskManager$$clusterLinkManager.createLocalAdmin(this.kafka$server$link$ClusterLinkTaskManager$TenantLocalAdmin$$$outer().maybeStartScheduler(), this.kafka$server$link$ClusterLinkTaskManager$TenantLocalAdmin$$$outer().index(), this.tenantPrefix, new Some<ConfluentAdmin>(this.interBrokerAdmin)));
                    }
                }
            }
            return this.localAdmin();
        }

        @Override
        public void addLink(ClusterLinkData linkData) {
            this.links().$plus$eq(linkData);
        }

        @Override
        public void removeLink(ClusterLinkData linkData) {
            this.links().$minus$eq(linkData);
        }

        @Override
        public boolean isEmpty() {
            return this.links().isEmpty();
        }

        @Override
        public synchronized void shutdown() {
            this.kafka$server$link$ClusterLinkTaskManager$TenantLocalAdmin$$$outer().info((Function0<String> & Serializable)() -> "Shutting down tenant-specific local admin client for task manager " + this.kafka$server$link$ClusterLinkTaskManager$TenantLocalAdmin$$$outer().index() + ", tenantPrefix=" + $this.tenantPrefix);
            this.batchAdmin().shutdown();
            Option$.MODULE$.apply(this.localAdmin()).foreach((Function1<ClusterLinkLocalAdmin, Object> & Serializable)x$12 -> {
                TenantLocalAdmin.$anonfun$shutdown$11(x$12);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ ClusterLinkTaskManager kafka$server$link$ClusterLinkTaskManager$TenantLocalAdmin$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$shutdown$11(ClusterLinkLocalAdmin x$12) {
            x$12.controllerAdmin().close(Duration.ZERO);
        }

        public TenantLocalAdmin(ClusterLinkTaskManager $outer, Option<String> tenantPrefix, ConfluentAdmin interBrokerAdmin) {
            this.tenantPrefix = tenantPrefix;
            this.interBrokerAdmin = interBrokerAdmin;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.batchAdmin = $outer.kafka$server$link$ClusterLinkTaskManager$$newBatchAdmin((Function0<ConfluentAdmin>)(Function0<ClusterLinkLocalAdmin> & Serializable)() -> this.getOrCreateLocalAdmin());
            this.links = (Set)Set$.MODULE$.empty();
        }
    }
}

