/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.tier.GCCandidatePartition;
import kafka.tier.GCPartition;
import kafka.tier.GCTopic;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierPartitionDeletePreInitiate;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.raft.OffsetAndEpoch;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001B\b\u0011\u0001UA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!A!\u0007\u0001B\u0001B\u0003%1\u0007C\u0003@\u0001\u0011\u0005\u0001\tC\u0004G\u0001\t\u0007I\u0011B$\t\rm\u0003\u0001\u0015!\u0003I\u0011\u001da\u0006A1A\u0005\nuCa!\u001a\u0001!\u0002\u0013q\u0006\"\u00024\u0001\t\u00039\u0007\"B;\u0001\t\u00031\b\"B?\u0001\t\u0003q\bbBA\u0001\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001b\u0011!\u0004V5fe>\u0013'.Z2u\u000f\u0006\u0014(-Y4f\u0007>dG.Z2u_JT!!\u0005\n\u0002\tQLWM\u001d\u0006\u0002'\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u00179A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\u0004\"!\b\u0011\u000e\u0003yQ!a\b\n\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0005r\"a\u0002'pO\u001eLgnZ\u0001\u0011i&,'\u000fV8qS\u000el\u0015M\\1hKJ\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\t\u0002\u000bQ|\u0007/[2\n\u0005!*#\u0001\u0005+jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u00035iW\r^1eCR\f7)Y2iKB\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\t[\u0016$\u0018\rZ1uC*\u0011qFE\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005Eb#AE&SC\u001a$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016\fA\u0001^5nKB\u0011A'P\u0007\u0002k)\u0011qD\u000e\u0006\u0003oa\naaY8n[>t'BA\n:\u0015\tQ4(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002y\u0005\u0019qN]4\n\u0005y*$\u0001\u0002+j[\u0016\fa\u0001P5oSRtD\u0003B!D\t\u0016\u0003\"A\u0011\u0001\u000e\u0003AAQA\t\u0003A\u0002\rBQ!\u000b\u0003A\u0002)BQA\r\u0003A\u0002M\n\u0001bZ2U_BL7m]\u000b\u0002\u0011B!\u0011J\u0014)Y\u001b\u0005Q%BA&M\u0003\u001diW\u000f^1cY\u0016T!!\u0014\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002P\u0015\n\u0019Q*\u00199\u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016\u0001B;uS2T\u0011!V\u0001\u0005U\u00064\u0018-\u0003\u0002X%\n!Q+V%E!\t\u0011\u0015,\u0003\u0002[!\t9qi\u0011+pa&\u001c\u0017!C4d)>\u0004\u0018nY:!\u0003U97mQ1oI&$\u0017\r^3QCJ$\u0018\u000e^5p]N,\u0012A\u0018\t\u0005\u0013:{&\r\u0005\u0002CA&\u0011\u0011\r\u0005\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004\"AQ2\n\u0005\u0011\u0004\"\u0001F$D\u0007\u0006tG-\u001b3bi\u0016\u0004\u0016M\u001d;ji&|g.\u0001\fhG\u000e\u000bg\u000eZ5eCR,\u0007+\u0019:uSRLwN\\:!\u0003E\tG\r\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u000b\u0004Q.l\u0007CA\fj\u0013\tQ\u0007D\u0001\u0003V]&$\b\"\u00027\n\u0001\u0004y\u0016\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u0015q\u0017\u00021\u0001p\u0003}\u0001\u0018M\u001d;ji&|gn\u0011:fCRLwN\\(gMN,G/\u00118e\u000bB|7\r\u001b\t\u0003aNl\u0011!\u001d\u0006\u0003eb\nAA]1gi&\u0011A/\u001d\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i\u0003qyg\u000eU1si&$\u0018n\u001c8EK2,G/\u001a)sK&s\u0017\u000e^5bi\u0016$2\u0001[<y\u0011\u0015a'\u00021\u0001`\u0011\u0015I(\u00021\u0001{\u0003m!W\r\\3uKB\u0013X-\u00138ji&\fG/\u001a*fG>\u0014H\rV5nKB\u0011qc_\u0005\u0003yb\u0011A\u0001T8oO\u0006IrN\u001c)beRLG/[8o\t\u0016dW\r^3J]&$\u0018.\u0019;f)\tAw\u0010C\u0003m\u0017\u0001\u0007q,A\rp]B\u000b'\u000f^5uS>tG)\u001a7fi\u0016\u001cu.\u001c9mKR,Gc\u00015\u0002\u0006!)A\u000e\u0004a\u0001?\u0006\tS.Y=cKB\u0013X-\u00138ji&\fG/\u001a)beRLG/[8o\t\u0016dW\r^5p]R\t\u0001.A\u000bnCf\u0014W\rR3mKR,\u0007+\u0019:uSRLwN\\:\u0015\u0007!\fy\u0001\u0003\u0004\u0002\u00129\u0001\rA_\u0001\u0010I\u0016dW\r^3CC\u000e\\wN\u001a4Ng\u0002")
public class TierObjectGarbageCollector
implements Logging {
    private final TierTopicManager tierTopicManager;
    private final KRaftMetadataCache metadataCache;
    private final Time time;
    private final Map<UUID, GCTopic> gcTopics;
    private final Map<TopicIdPartition, GCCandidatePartition> gcCandidatePartitions;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TierObjectGarbageCollector tierObjectGarbageCollector = this;
        synchronized (tierObjectGarbageCollector) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Map<UUID, GCTopic> gcTopics() {
        return this.gcTopics;
    }

    private Map<TopicIdPartition, GCCandidatePartition> gcCandidatePartitions() {
        return this.gcCandidatePartitions;
    }

    public void addTopicPartition(TopicIdPartition topicIdPartition, OffsetAndEpoch partitionCreationOffsetAndEpoch) {
        ((GCTopic)this.gcTopics().getOrElseUpdate(topicIdPartition.topicId(), (Function0<GCTopic> & Serializable)() -> new GCTopic(topicIdPartition.topic(), partitionCreationOffsetAndEpoch))).partitions().getOrElseUpdate(BoxesRunTime.boxToInteger(topicIdPartition.partition()), (Function0<GCPartition> & Serializable)() -> new GCPartition(false));
    }

    public void onPartitionDeletePreInitiate(TopicIdPartition topicIdPartition, long deletePreInitiateRecordTime) {
        this.gcTopics().get(topicIdPartition.topicId()).foreach((Function1<GCTopic, Object> & Serializable)topic -> {
            TierObjectGarbageCollector.$anonfun$onPartitionDeletePreInitiate$1(topicIdPartition, topic);
            return BoxedUnit.UNIT;
        });
        this.gcCandidatePartitions().getOrElseUpdate(topicIdPartition, (Function0<GCCandidatePartition> & Serializable)() -> new GCCandidatePartition(deletePreInitiateRecordTime, false));
    }

    public void onPartitionDeleteInitiate(TopicIdPartition topicIdPartition) {
        this.gcCandidatePartitions().get(topicIdPartition).foreach((Function1<GCCandidatePartition, Object> & Serializable)x$9 -> {
            x$9.isDeleteInitiated_$eq(true);
            return BoxedUnit.UNIT;
        });
    }

    public void onPartitionDeleteComplete(TopicIdPartition topicIdPartition) {
        this.gcTopics().get(topicIdPartition.topicId()).foreach((Function1<GCTopic, Object> & Serializable)topic -> {
            topic.partitions().remove(BoxesRunTime.boxToInteger(topicIdPartition.partition()));
            if (topic.partitions().isEmpty()) {
                return this.gcTopics().remove(topicIdPartition.topicId());
            }
            return BoxedUnit.UNIT;
        });
        this.gcCandidatePartitions().remove(topicIdPartition);
    }

    public void maybePreInitiatePartitionDeletion() {
        MetadataImage currentMetadataImage = this.metadataCache.currentImage();
        Map deletedTopics = (Map)this.gcTopics().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(TierObjectGarbageCollector.$anonfun$maybePreInitiatePartitionDeletion$1(currentMetadataImage, x0$1)));
        deletedTopics.foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
            TierObjectGarbageCollector.$anonfun$maybePreInitiatePartitionDeletion$2(this, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public void maybeDeletePartitions(long deleteBackoffMs) {
        ((IterableOps.WithFilter)((MapOps.WithFilter)this.gcCandidatePartitions().withFilter((Function1<Tuple2<TopicIdPartition, GCCandidatePartition>, Object>)(Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(TierObjectGarbageCollector.$anonfun$maybeDeletePartitions$1(check$ifrefutable$1))).withFilter((Function1<Tuple2, Object> & Serializable)x$12 -> BoxesRunTime.boxToBoolean(TierObjectGarbageCollector.$anonfun$maybeDeletePartitions$2(x$12)))).withFilter((Function1<Tuple2, Object> & Serializable)x$13 -> BoxesRunTime.boxToBoolean(TierObjectGarbageCollector.$anonfun$maybeDeletePartitions$3(this, deleteBackoffMs, x$13)))).foreach((Function1<Tuple2, CompletableFuture> & Serializable)x$14 -> {
            Tuple2 tuple2 = x$14;
            if (tuple2 != null) {
                TopicIdPartition topicIdPartition = (TopicIdPartition)tuple2._1();
                GCCandidatePartition gcCandidatePartition = (GCCandidatePartition)tuple2._2();
                gcCandidatePartition.isDeleteInitiated_$eq(true);
                this.info((Function0<String> & Serializable)() -> "Send TierPartitionDeleteInitiate for " + topicIdPartition);
                return $this.tierTopicManager.addMetadata(new TierPartitionDeleteInitiate(topicIdPartition, -1, UUID.randomUUID())).whenComplete((x$11, e) -> {
                    if (e != null) {
                        this.error((Function0<String> & Serializable)() -> "Error while trying to send TierPartitionDeleteInitiate for " + topicIdPartition, (Function0<Throwable> & Serializable)() -> e);
                        gcCandidatePartition.isDeleteInitiated_$eq(false);
                        return;
                    }
                });
            }
            throw new MatchError(tuple2);
        });
    }

    public static final /* synthetic */ void $anonfun$onPartitionDeletePreInitiate$1(TopicIdPartition topicIdPartition$2, GCTopic topic) {
        topic.partitions().get(BoxesRunTime.boxToInteger(topicIdPartition$2.partition())).foreach((Function1<GCPartition, Object> & Serializable)partition -> {
            partition.isDeletePreInitiated_$eq(true);
            return BoxedUnit.UNIT;
        });
    }

    private static final boolean checkTopicDeleted$1(UUID topicId, GCTopic gcTopic, MetadataImage metadataImage) {
        return Ordering.Implicits$.MODULE$.infixOrderingOps(gcTopic.topicCreationOffsetAndEpoch(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).$less$eq(metadataImage.highestOffsetAndEpoch()) && metadataImage.topics().getTopic(new Uuid(topicId.getMostSignificantBits(), topicId.getLeastSignificantBits())) == null;
    }

    public static final /* synthetic */ boolean $anonfun$maybePreInitiatePartitionDeletion$1(MetadataImage currentMetadataImage$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            UUID topicId = (UUID)tuple2._1();
            GCTopic gcTopic = (GCTopic)tuple2._2();
            return TierObjectGarbageCollector.checkTopicDeleted$1(topicId, gcTopic, currentMetadataImage$1);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$maybePreInitiatePartitionDeletion$2(TierObjectGarbageCollector $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            UUID topicId = (UUID)tuple2._1();
            GCTopic gcTopic = (GCTopic)tuple2._2();
            gcTopic.partitions().foreach((Function1<Tuple2, Object> & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    int partitionId = tuple2._1$mcI$sp();
                    GCPartition partition = (GCPartition)tuple2._2();
                    if (!partition.isDeletePreInitiated()) {
                        partition.isDeletePreInitiated_$eq(true);
                        TopicIdPartition topicIdPartition = new TopicIdPartition(gcTopic.topicName(), topicId, partitionId);
                        $this.info((Function0<String> & Serializable)() -> "Send TierPartitionDeletePreInitiate for " + topicIdPartition);
                        return $this.tierTopicManager.addMetadata(new TierPartitionDeletePreInitiate(topicIdPartition, UUID.randomUUID())).whenComplete((x$10, e) -> {
                            if (e != null) {
                                $this.error((Function0<String> & Serializable)() -> "Error while trying to send TierPartitionDeletePreInitiate for " + topicIdPartition, (Function0<Throwable> & Serializable)() -> e);
                                partition.isDeletePreInitiated_$eq(false);
                                return;
                            }
                        });
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError(tuple2);
            });
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$maybeDeletePartitions$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$maybeDeletePartitions$2(Tuple2 x$12) {
        Tuple2 tuple2 = x$12;
        if (tuple2 != null) {
            GCCandidatePartition gcCandidatePartition = (GCCandidatePartition)tuple2._2();
            return !gcCandidatePartition.isDeleteInitiated();
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$maybeDeletePartitions$3(TierObjectGarbageCollector $this, long deleteBackoffMs$1, Tuple2 x$13) {
        Tuple2 tuple2 = x$13;
        if (tuple2 != null) {
            GCCandidatePartition gcCandidatePartition = (GCCandidatePartition)tuple2._2();
            return gcCandidatePartition.deletePreInitiateRecordTime() + deleteBackoffMs$1 <= $this.time.milliseconds();
        }
        throw new MatchError(tuple2);
    }

    public TierObjectGarbageCollector(TierTopicManager tierTopicManager, KRaftMetadataCache metadataCache, Time time) {
        this.tierTopicManager = tierTopicManager;
        this.metadataCache = metadataCache;
        this.time = time;
        Logging.$init$(this);
        this.gcTopics = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        this.gcCandidatePartitions = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
    }
}

