/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.io.InputStream;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.TierOffsetIndexIterator;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OffsetIndexFetchRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffsetIndexFetchRequest.class);

    public static TierFetchOffsetIndexResult fetchOffsetPositionForStartingOffset(CancellationContext cancellationContext, TierObjectStore tierObjectStore, ObjectMetadata tierObjectMetadata, long targetOffset) throws Exception {
        try (TierObjectStoreResponse response = tierObjectStore.getObjectStoreFragment(tierObjectMetadata, FragmentType.OFFSET_INDEX);){
            TierFetchOffsetIndexResult tierFetchOffsetIndexResult = OffsetIndexFetchRequest.searchByTargetOffset(cancellationContext, response, tierObjectMetadata.baseOffset(), targetOffset, targetOffset);
            return tierFetchOffsetIndexResult;
        }
    }

    public static CompletableFuture<TierFetchOffsetIndexResult> fetchOffsetPositionForStartingOffsetAsync(CancellationContext cancellationContext, TierObjectStore tierObjectStore, ObjectMetadata tierObjectMetadata, long targetOffset, long endOffset) {
        return tierObjectStore.getObjectStoreFragmentAsync(tierObjectMetadata, FragmentType.OFFSET_INDEX).thenApply(res -> {
            try {
                TierFetchOffsetIndexResult tierFetchOffsetIndexResult = OffsetIndexFetchRequest.searchByTargetOffset(cancellationContext, res, tierObjectMetadata.baseOffset(), targetOffset, endOffset);
                return tierFetchOffsetIndexResult;
            }
            finally {
                try {
                    res.close();
                }
                catch (Exception e) {
                    LOGGER.warn("failed to close TierObjectStoreResponse of OFFSET_INDEX", e);
                }
            }
        });
    }

    private static TierFetchOffsetIndexResult searchByTargetOffset(CancellationContext cancellationContext, TierObjectStoreResponse response, long baseOffset, long targetOffset, long endOffset) {
        OffsetPosition op;
        OffsetPosition startOffsetPosition = new OffsetPosition(baseOffset, 0);
        OffsetPosition endOffsetPosition = null;
        InputStream responseInputStream = response.getInputStream();
        TierOffsetIndexIterator tierOffsetIndexIterator = new TierOffsetIndexIterator(responseInputStream, baseOffset);
        while (tierOffsetIndexIterator.hasNext()) {
            if (cancellationContext.isCancelled()) {
                throw new CancellationException("Tiered offset index fetch request cancelled");
            }
            op = (OffsetPosition)tierOffsetIndexIterator.next();
            if (targetOffset == op.offset) {
                startOffsetPosition = op;
                if (targetOffset != endOffset) break;
                endOffsetPosition = op;
                break;
            }
            if (targetOffset > op.offset) {
                startOffsetPosition = op;
                continue;
            }
            if (targetOffset >= op.offset) continue;
            if (endOffset < 0L || op.offset < endOffset) break;
            endOffsetPosition = op;
            break;
        }
        if (endOffset >= 0L && endOffsetPosition == null) {
            while (tierOffsetIndexIterator.hasNext()) {
                if (cancellationContext.isCancelled()) {
                    throw new CancellationException("Tiered offset index fetch request cancelled");
                }
                op = (OffsetPosition)tierOffsetIndexIterator.next();
                if (op.offset < endOffset) continue;
                endOffsetPosition = op;
                break;
            }
        }
        OffsetPosition next = null;
        if (endOffset >= 0L && tierOffsetIndexIterator.hasNext()) {
            next = (OffsetPosition)tierOffsetIndexIterator.next();
        }
        return new TierFetchOffsetIndexResult(startOffsetPosition, next);
    }

    public static class TierFetchOffsetIndexResult {
        public final OffsetPosition startOffsetPosition;
        public final OffsetPosition endOffsetPosition;

        public TierFetchOffsetIndexResult(OffsetPosition startOffsetPosition, OffsetPosition endOffsetPosition) {
            this.startOffsetPosition = startOffsetPosition;
            this.endOffsetPosition = endOffsetPosition;
        }

        public String toString() {
            return String.format("TierFetchOffsetIndexResult(startOffsetPosition = %s, endOffsetPosition = %s)", this.startOffsetPosition, this.endOffsetPosition);
        }
    }
}

