/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher.objectcache;

import kafka.server.KafkaConfig;

public class ObjectCacheConfig {
    public static final ObjectCacheConfig DEFAULT = new ObjectCacheConfig(false, 0xC800000L, 0x100000L, 0x500000L);
    public final boolean prefetchCacheEnabled;
    public final long prefetchCacheMaxSizeBytes;
    public final long prefetchCacheEntrySizeBytes;
    public final long prefetchCacheRangeBytes;

    public ObjectCacheConfig(KafkaConfig config) {
        this.prefetchCacheEnabled = config.confluentConfig().tierPrefetchCacheEnable();
        this.prefetchCacheMaxSizeBytes = config.confluentConfig().tierPrefetchCacheTotalSizeBytes();
        this.prefetchCacheEntrySizeBytes = config.confluentConfig().tierPrefetchCacheEntrySizeBytes();
        this.prefetchCacheRangeBytes = config.confluentConfig().tierPrefetchCacheRangeBytes();
    }

    public ObjectCacheConfig(boolean prefetchCacheEnabled, long prefetchCacheMaxSizeBytes, long prefetchCacheEntrySizeBytes, long prefetchRangeBytes) {
        this.prefetchCacheEnabled = prefetchCacheEnabled;
        this.prefetchCacheMaxSizeBytes = prefetchCacheMaxSizeBytes;
        this.prefetchCacheEntrySizeBytes = prefetchCacheEntrySizeBytes;
        this.prefetchCacheRangeBytes = prefetchRangeBytes;
    }

    public String toString() {
        return "ObjectCacheConfig(prefetchCacheEnable=" + this.prefetchCacheEnabled + ", cacheEntryBytes=" + this.prefetchCacheEntrySizeBytes + ", cacheMaxBytes=" + this.prefetchCacheMaxSizeBytes + ", cacheRangeBytes=" + this.prefetchCacheRangeBytes + ")";
    }
}

