/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.snapshot;

import io.confluent.kafka.storage.cloud.EpochAndSeqNumber;
import io.confluent.kafka.storage.cloud.SequencedObject;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Calendar;
import java.util.Objects;
import java.util.TimeZone;

public class TierTopicSnapshotObject
implements SequencedObject {
    private static final String DELIMITER = "_";
    private static final String SEPARATOR = "/";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final long startTimestampMs;
    private final long endTimestampMs;
    private final EpochAndSeqNumber current;
    private final EpochAndSeqNumber previous;
    private final Path path;

    public TierTopicSnapshotObject(long startTimestampMs, long endTimestampMs, EpochAndSeqNumber current, EpochAndSeqNumber previous) {
        this.startTimestampMs = startTimestampMs;
        this.endTimestampMs = endTimestampMs;
        this.current = current;
        this.previous = previous;
        this.path = this.encodeSnapshotName();
    }

    public final Path encodeSnapshotName() {
        String dirName = TierTopicSnapshotObject.getDirName(this.startTimestampMs);
        String fileName = String.join((CharSequence)DELIMITER, String.valueOf(this.startTimestampMs), String.valueOf(this.endTimestampMs), String.valueOf(this.current.epoch()), String.valueOf(this.current.seqNumber()), String.valueOf(this.previous.epoch()), String.valueOf(this.previous.seqNumber()));
        return Paths.get(dirName, fileName);
    }

    public static String getDirName(long timeMs) {
        Calendar calendar = Calendar.getInstance(UTC);
        calendar.setTimeInMillis(timeMs);
        return String.join((CharSequence)SEPARATOR, String.valueOf(calendar.get(1)), String.valueOf(calendar.get(6)), String.valueOf(calendar.get(11)));
    }

    public static String getDirNameWithDayPrefix(long timeMs) {
        Calendar calendar = Calendar.getInstance(UTC);
        calendar.setTimeInMillis(timeMs);
        return String.join((CharSequence)SEPARATOR, String.valueOf(calendar.get(1)), String.valueOf(calendar.get(6)));
    }

    public static long getDaysFromEpoch(long timeMs) {
        return timeMs / Duration.ofDays(1L).toMillis();
    }

    public static TierTopicSnapshotObject decodeSnapshotName(String key) {
        String[] dirName = key.split(SEPARATOR);
        if (dirName.length != 4) {
            throw new IllegalArgumentException("key=" + key + " is not formatted correctly. Split on / has " + dirName.length + " instead of 4 arguments");
        }
        String[] fileName = dirName[3].split(DELIMITER);
        if (fileName.length != 6) {
            throw new IllegalArgumentException(dirName[3] + " is not formatted correctly key=" + key + " . Split on _ has " + fileName.length + " instead of 6 arguments");
        }
        return new TierTopicSnapshotObject(Long.parseLong(fileName[0]), Long.parseLong(fileName[1]), new EpochAndSeqNumber(Integer.parseInt(fileName[2]), Long.parseLong(fileName[3])), new EpochAndSeqNumber(Integer.parseInt(fileName[4]), Long.parseLong(fileName[5])));
    }

    public long startTimestampMs() {
        return this.startTimestampMs;
    }

    public long endTimestampMs() {
        return this.endTimestampMs;
    }

    @Override
    public EpochAndSeqNumber currentEpochAndSeqNumber() {
        return this.current;
    }

    @Override
    public EpochAndSeqNumber previousEpochAndSeqNumber() {
        return this.previous;
    }

    @Override
    public Path path() {
        return this.path;
    }

    @Override
    public int compareTo(SequencedObject o) {
        return this.current.compareTo(o.currentEpochAndSeqNumber());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierTopicSnapshotObject that = (TierTopicSnapshotObject)o;
        return this.startTimestampMs == that.startTimestampMs && this.endTimestampMs == that.endTimestampMs && this.current.equals(that.current) && this.previous.equals(that.previous) && this.path.equals(that.path);
    }

    public int hashCode() {
        return Objects.hash(this.startTimestampMs, this.endTimestampMs, this.current, this.previous, this.path);
    }

    public String toString() {
        return "TierTopicSnapshotObject{startTimestampMs=" + this.startTimestampMs + ", endTimestampMs=" + this.endTimestampMs + ", current=" + String.valueOf(this.current) + ", previous=" + String.valueOf(this.previous) + ", path=" + String.valueOf(this.path) + "}";
    }
}

