/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Optional;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.encryption.DataEncryptionKeyHolder;
import kafka.tier.store.encryption.EncryptedDataKey;
import kafka.tier.store.encryption.EncryptionKeyCacheRefiller;
import kafka.tier.store.encryption.KeySha;
import kafka.tier.store.encryption.TenantAwareEncryptionKeyManager;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import org.slf4j.Logger;

public class TierObjectStoreByokUtils {
    private static DataEncryptionKeyHolder maybeRefillCache(String key, ObjectMetadata objectMetadata, Optional<TenantAwareEncryptionKeyManager> encryptionKeyManagerOpt, Optional<EncryptionKeyCacheRefiller> encryptionKeyCacheRefillerOpt, Logger log) {
        String logicalClusterId = TenantAwareEncryptionKeyManager.getLogicalClusterIdOrThrow(objectMetadata.topicIdPartition());
        KeySha keySha = KeySha.fromRawBytes(objectMetadata.opaqueData().intoByteArray());
        DataEncryptionKeyHolder keyInfo = encryptionKeyManagerOpt.get().key(logicalClusterId, keySha);
        if (keyInfo == null) {
            log.info("[{}] TenantAwareEncryptionKeyManager cache miss while downloading object at key {} with {}, fetching object metadata for cache hydration", logicalClusterId, key, keySha);
            if (encryptionKeyCacheRefillerOpt.isEmpty()) {
                throw new TierObjectStoreFatalException(String.format("[%s] FTPS Cache Refiller is not configured while BYOK is enabled.", logicalClusterId));
            }
            ByteBuffer encryptedDekBytes = encryptionKeyCacheRefillerOpt.get().get(objectMetadata.topicIdPartition(), objectMetadata.objectId());
            if (encryptedDekBytes == null) {
                throw new TierObjectStoreFatalException(String.format("[%s] Could not obtain metadata to refill cache for KeySha %s", logicalClusterId, keySha));
            }
            EncryptedDataKey encryptedDataKey = new EncryptedDataKey(encryptedDekBytes.array());
            HashMap<String, String> metadata = TenantAwareEncryptionKeyManager.keyToObjectMetadata(keySha, encryptedDataKey, Optional.empty());
            keyInfo = encryptionKeyManagerOpt.get().registerKeyFromObjectMetadata(logicalClusterId, metadata);
            if (!keyInfo.keySha.equals(keySha)) {
                throw new TierObjectStoreFatalException(String.format("[%s] KeySha of key material restored from object metadata %s does not match KeySha provided via OpaqueData %s", logicalClusterId, keyInfo.keySha, keySha));
            }
        }
        return encryptionKeyManagerOpt.get().key(logicalClusterId, keySha);
    }

    static boolean shouldUploadEncrypted(ObjectMetadata objectMetadata, String key, Optional<TenantAwareEncryptionKeyManager> encryptionKeyManagerOpt) {
        boolean isNonEmptyOpaqueData;
        OpaqueData opaqueData = objectMetadata.opaqueData();
        boolean bl = isNonEmptyOpaqueData = opaqueData != null && !opaqueData.isEmpty();
        if (isNonEmptyOpaqueData && encryptionKeyManagerOpt.isEmpty()) {
            throw new TierObjectStoreFatalException(String.format("Attempted to upload a segment with non-empty OpaqueData, but encryption is not configured. key=%s, objectMetadata=%s", key, objectMetadata));
        }
        return isNonEmptyOpaqueData;
    }

    static byte[] maybeGetRawEncryptionKeyForObject(String key, ObjectType objectType, ObjectStoreMetadata objectMetadata, Optional<TenantAwareEncryptionKeyManager> encryptionKeyManagerOpt, Optional<EncryptionKeyCacheRefiller> encryptionKeyCacheRefillerOpt, Logger log) {
        if (TierObjectStore.isEncryptedObject(objectMetadata, objectType)) {
            if (encryptionKeyManagerOpt.isEmpty()) {
                throw new TierObjectStoreFatalException("A TenantAwareEncryptionKeyManager instance is not configured, while OpaqueData is non-empty for object at path " + key);
            }
            if (!(objectMetadata instanceof ObjectMetadata)) {
                throw new IllegalStateException(String.format("For ObjectType %s expected an instance of ObjectMetadata to be supplied, but received: %s", new Object[]{ObjectType.SEGMENT, objectMetadata.getClass()}));
            }
            DataEncryptionKeyHolder keyContext = TierObjectStoreByokUtils.maybeRefillCache(key, (ObjectMetadata)objectMetadata, encryptionKeyManagerOpt, encryptionKeyCacheRefillerOpt, log);
            return keyContext.cleartextDataKey.rawKeyMaterial();
        }
        return null;
    }

    static byte[] generateRawEncryptionKeyForObject(TopicIdPartition topicIdPartition, KeySha keySha, Optional<TenantAwareEncryptionKeyManager> encryptionKeyManagerOpt) {
        String logicalClusterId = TenantAwareEncryptionKeyManager.getLogicalClusterIdOrThrow(topicIdPartition);
        DataEncryptionKeyHolder key = encryptionKeyManagerOpt.get().key(logicalClusterId, keySha);
        if (key == null) {
            throw new TierObjectStoreFatalException(String.format("No valid DataEncryptionKeyHolder for KeySha '%s'", keySha));
        }
        return key.cleartextDataKey.rawKeyMaterial();
    }

    static TierObjectStore.ByokKeyHolder getByokKeyHolderForTopicIdPartition(TopicIdPartition topicIdPartition, Optional<TenantAwareEncryptionKeyManager> encryptionKeyManagerOpt, Logger log) {
        String logicalClusterId;
        if (encryptionKeyManagerOpt.isPresent() && (logicalClusterId = TenantAwareEncryptionKeyManager.maybeGetLogicalClusterId(topicIdPartition)) != null) {
            log.debug("[{}] Logical cluster ID found for partition {}", (Object)logicalClusterId, (Object)topicIdPartition);
            return encryptionKeyManagerOpt.get().getActiveKey(logicalClusterId);
        }
        return TierObjectStore.ByokKeyHolder.defaultByokKeyHolder();
    }
}

