/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.encryption;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;

class EncryptionKeyManagerMetrics {
    private static final String METRIC_GROUP_NAME = "EncryptionKeyManager";
    private static final String ACTIVE_KEY_AGE_PREFIX = "ActiveKeyAge";
    private static final String MAX_KEY_AGE_PREFIX = "MaxKeyAge";
    static final String ENCRYPT_CALL_PREFIX = "EncryptCall";
    static final String DECRYPT_CALL_PREFIX = "DecryptCall";
    private final Metrics metrics;
    final MetricName activeKeyAgeMetricName;
    final MetricName maxKeyAgeMetricName;
    final MetricName encrypt50PMetricName;
    final MetricName encrypt90PMetricName;
    final MetricName encrypt99PMetricName;
    final MetricName encryptCountMetricName;
    final MetricName decrypt50PMetricName;
    final MetricName decrypt90PMetricName;
    final MetricName decrypt99PMetricName;
    final MetricName decryptCountMetricName;
    private final Sensor encrypt;
    private final Sensor decrypt;
    private final ArrayList<Sensor> sensors = new ArrayList();
    private volatile Instant activeKeyCreationTime;
    private volatile Duration maxKeyAge;

    public EncryptionKeyManagerMetrics(Metrics metrics) {
        this.metrics = metrics;
        this.activeKeyAgeMetricName = metrics.metricName(ACTIVE_KEY_AGE_PREFIX, METRIC_GROUP_NAME, "The age of the current active key in milliseconds");
        this.maxKeyAgeMetricName = metrics.metricName(MAX_KEY_AGE_PREFIX, METRIC_GROUP_NAME, "The current max key age in milliseconds");
        this.encrypt = this.sensor(ENCRYPT_CALL_PREFIX, new Sensor[0]);
        this.decrypt = this.sensor(DECRYPT_CALL_PREFIX, new Sensor[0]);
        this.metrics.addMetric(this.activeKeyAgeMetricName, new Gauge<Long>(){

            @Override
            public Long value(MetricConfig config, long now) {
                if (EncryptionKeyManagerMetrics.this.activeKeyCreationTime == null) {
                    return 0L;
                }
                Instant tNow = Instant.ofEpochMilli(now);
                return tNow.minusMillis(EncryptionKeyManagerMetrics.this.activeKeyCreationTime.toEpochMilli()).toEpochMilli();
            }
        });
        this.metrics.addMetric(this.maxKeyAgeMetricName, new Gauge<Long>(){

            @Override
            public Long value(MetricConfig config, long now) {
                if (EncryptionKeyManagerMetrics.this.maxKeyAge == null) {
                    return 0L;
                }
                return EncryptionKeyManagerMetrics.this.maxKeyAge.toMillis();
            }
        });
        int maxEncryptDecryptTime = 30000;
        this.encrypt50PMetricName = metrics.metricName("EncryptCallP50Percentile", METRIC_GROUP_NAME, "The 50th-percentile latency for encrypt calls using the master key");
        this.encrypt90PMetricName = metrics.metricName("EncryptCallP90Percentile", METRIC_GROUP_NAME, "The 90th-percentile latency for encrypt calls using the master key");
        this.encrypt99PMetricName = metrics.metricName("EncryptCallP99Percentile", METRIC_GROUP_NAME, "The 99th-percentile latency for encrypt calls using the master key");
        this.encryptCountMetricName = metrics.metricName("EncryptCallCount", METRIC_GROUP_NAME, "The number of times a key was encrypted using the master key");
        this.encrypt.add(new Percentiles(maxEncryptDecryptTime * 4, (double)maxEncryptDecryptTime, Percentiles.BucketSizing.CONSTANT, new Percentile(this.encrypt50PMetricName, 50.0), new Percentile(this.encrypt90PMetricName, 90.0), new Percentile(this.encrypt99PMetricName, 99.0)));
        this.encrypt.add(this.encryptCountMetricName, new CumulativeCount());
        this.decrypt50PMetricName = metrics.metricName("DecryptCallP50Percentile", METRIC_GROUP_NAME, "The 50th-percentile latency for decrypt calls using the master key");
        this.decrypt90PMetricName = metrics.metricName("DecryptCallP90Percentile", METRIC_GROUP_NAME, "The 90th-percentile latency for decrypt calls using the master key");
        this.decrypt99PMetricName = metrics.metricName("DecryptCallP99Percentile", METRIC_GROUP_NAME, "The 99th-percentile latency for decrypt calls using the master key");
        this.decryptCountMetricName = metrics.metricName("DecryptCallCount", METRIC_GROUP_NAME, "The number of times a key was decrypted using the master key");
        this.decrypt.add(new Percentiles(maxEncryptDecryptTime * 4, (double)maxEncryptDecryptTime, Percentiles.BucketSizing.CONSTANT, new Percentile(this.decrypt50PMetricName, 50.0), new Percentile(this.decrypt90PMetricName, 90.0), new Percentile(this.decrypt99PMetricName, 99.0)));
        this.decrypt.add(this.decryptCountMetricName, new CumulativeCount());
    }

    public void recordEncryptCall(long timeMs) {
        this.encrypt.record(timeMs);
    }

    public void recordDecryptCall(long timeMs) {
        this.decrypt.record(timeMs);
    }

    public void updateActiveKeyCreationTime(Instant creationTime) {
        this.activeKeyCreationTime = creationTime;
    }

    public void updateMaxKeyAge(Duration maxKeyAge) {
        this.maxKeyAge = maxKeyAge;
    }

    private Sensor sensor(String name, Sensor ... parents) {
        Sensor sensor = this.metrics.sensor(name, parents);
        this.sensors.add(sensor);
        return sensor;
    }

    public void close() {
        for (Sensor sensor : this.sensors) {
            this.metrics.removeSensor(sensor.name());
        }
        this.metrics.removeMetric(this.activeKeyAgeMetricName);
        this.metrics.removeMetric(this.maxKeyAgeMetricName);
    }
}

