/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.api.client.ClientOptions;
import io.confluent.ksql.api.client.exception.KsqlClientException;
import io.confluent.ksql.security.AuthType;
import io.confluent.ksql.security.oauth.IdpConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ClientOptionsImpl
implements ClientOptions {
    private String host = "localhost";
    private int port = 8088;
    private boolean useTls = false;
    private boolean verifyHost = true;
    private boolean useAlpn = false;
    private AuthType authType = AuthType.NONE;
    private String trustStorePath;
    private String trustStorePassword;
    private String keyStorePath;
    private String keyStorePassword;
    private String keyPassword;
    private String keyAlias;
    private String storeType;
    private String securityProviders;
    private String keyManagerAlgorithm;
    private String trustManagerAlgorithm;
    private String basicAuthUsername;
    private String basicAuthPassword;
    private int executeQueryMaxResultRows = 10000;
    private int http2MultiplexingLimit = -1;
    private Map<String, String> requestHeaders;
    private IdpConfig idpConfig;

    public ClientOptionsImpl() {
    }

    private ClientOptionsImpl(String host, int port, boolean useTls, boolean verifyHost, boolean useAlpn, String trustStorePath, String trustStorePassword, String keyStorePath, String keyStorePassword, String keyPassword, String keyAlias, String storeType, String securityProviders, String keyManagerAlgorithm, String trustManagerAlgorithm, String basicAuthUsername, String basicAuthPassword, int executeQueryMaxResultRows, int http2MultiplexingLimit, Map<String, String> requestHeaders, IdpConfig idpConfig, AuthType authType) {
        this.host = Objects.requireNonNull(host);
        this.port = port;
        this.useTls = useTls;
        this.verifyHost = verifyHost;
        this.useAlpn = useAlpn;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.keyPassword = keyPassword;
        this.keyAlias = keyAlias;
        this.storeType = storeType;
        this.securityProviders = securityProviders;
        this.keyManagerAlgorithm = keyManagerAlgorithm;
        this.trustManagerAlgorithm = trustManagerAlgorithm;
        this.basicAuthUsername = basicAuthUsername;
        this.basicAuthPassword = basicAuthPassword;
        this.executeQueryMaxResultRows = executeQueryMaxResultRows;
        this.http2MultiplexingLimit = http2MultiplexingLimit;
        this.requestHeaders = requestHeaders;
        this.idpConfig = idpConfig;
        this.authType = authType;
    }

    @Override
    public ClientOptions setHost(String host) {
        this.host = host;
        return this;
    }

    @Override
    public ClientOptions setPort(int port) {
        this.port = port;
        return this;
    }

    @Override
    public ClientOptions setUseTls(boolean useTls) {
        this.useTls = useTls;
        return this;
    }

    @Override
    public ClientOptions setVerifyHost(boolean verifyHost) {
        this.verifyHost = verifyHost;
        return this;
    }

    @Override
    public ClientOptions setUseAlpn(boolean useAlpn) {
        this.useAlpn = useAlpn;
        return this;
    }

    @Override
    public ClientOptions setTrustStore(String trustStorePath) {
        this.trustStorePath = trustStorePath;
        return this;
    }

    @Override
    public ClientOptions setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    @Override
    public ClientOptions setKeyStore(String keyStorePath) {
        this.keyStorePath = keyStorePath;
        return this;
    }

    @Override
    public ClientOptions setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    @Override
    public ClientOptions setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
        return this;
    }

    @Override
    public ClientOptions setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
        return this;
    }

    @Override
    public ClientOptions setStoreType(String storeType) {
        this.storeType = storeType;
        return this;
    }

    @Override
    public ClientOptions setSecurityProviders(String securityProviders) {
        this.securityProviders = securityProviders;
        return this;
    }

    @Override
    public ClientOptions setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        this.keyManagerAlgorithm = keyManagerAlgorithm;
        return this;
    }

    @Override
    public ClientOptions setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this.trustManagerAlgorithm = trustManagerAlgorithm;
        return this;
    }

    @Override
    public ClientOptions setBasicAuthCredentials(String username, String password) {
        if (this.authType == AuthType.OAUTHBEARER) {
            throw new KsqlClientException("Cannot configure basic and bearer auth simultaneously.");
        }
        this.authType = AuthType.BASIC;
        this.basicAuthUsername = username;
        this.basicAuthPassword = password;
        return this;
    }

    @Override
    public ClientOptions setExecuteQueryMaxResultRows(int maxRows) {
        this.executeQueryMaxResultRows = maxRows;
        return this;
    }

    @Override
    public ClientOptions setHttp2MultiplexingLimit(int http2MultiplexingLimit) {
        this.http2MultiplexingLimit = http2MultiplexingLimit;
        return this;
    }

    @Override
    public ClientOptions setRequestHeaders(Map<String, String> requestHeaders) {
        this.requestHeaders = requestHeaders == null ? null : ImmutableMap.copyOf(requestHeaders);
        return this;
    }

    @Override
    public ClientOptions setIdpConfig(IdpConfig idpConfig) {
        if (this.authType == AuthType.BASIC) {
            throw new KsqlClientException("Cannot configure basic and bearer auth simultaneously.");
        }
        this.authType = AuthType.OAUTHBEARER;
        this.idpConfig = idpConfig;
        return this;
    }

    @Override
    public String getHost() {
        return this.host == null ? "" : this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isUseTls() {
        return this.useTls;
    }

    @Override
    public boolean isVerifyHost() {
        return this.verifyHost;
    }

    @Override
    public boolean isUseAlpn() {
        return this.useAlpn;
    }

    @Override
    public AuthType getAuthType() {
        return this.authType;
    }

    @Override
    public String getTrustStore() {
        return this.trustStorePath == null ? "" : this.trustStorePath;
    }

    @Override
    public String getTrustStorePassword() {
        return this.trustStorePassword == null ? "" : this.trustStorePassword;
    }

    @Override
    public String getKeyStore() {
        return this.keyStorePath == null ? "" : this.keyStorePath;
    }

    @Override
    public String getKeyStorePassword() {
        return this.keyStorePassword == null ? "" : this.keyStorePassword;
    }

    @Override
    public String getKeyPassword() {
        return this.keyPassword == null ? "" : this.keyPassword;
    }

    @Override
    public String getKeyAlias() {
        return this.keyAlias == null ? "" : this.keyAlias;
    }

    @Override
    public String getStoreType() {
        return this.storeType == null ? "JKS" : this.storeType;
    }

    @Override
    public String getSecurityProviders() {
        return this.securityProviders == null ? "" : this.securityProviders;
    }

    @Override
    public String getKeyManagerAlgorithm() {
        return this.keyManagerAlgorithm == null ? "" : this.keyManagerAlgorithm;
    }

    @Override
    public String getTrustManagerAlgorithm() {
        return this.trustManagerAlgorithm == null ? "" : this.trustManagerAlgorithm;
    }

    @Override
    public String getBasicAuthUsername() {
        return this.basicAuthUsername == null ? "" : this.basicAuthUsername;
    }

    @Override
    public String getBasicAuthPassword() {
        return this.basicAuthPassword == null ? "" : this.basicAuthPassword;
    }

    @Override
    public IdpConfig getIdpConfig() {
        return this.idpConfig;
    }

    @Override
    public int getExecuteQueryMaxResultRows() {
        return this.executeQueryMaxResultRows;
    }

    @Override
    public int getHttp2MultiplexingLimit() {
        return this.http2MultiplexingLimit;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders == null ? new HashMap<String, String>() : new HashMap<String, String>(this.requestHeaders);
    }

    @Override
    public ClientOptions copy() {
        IdpConfig idpConfigCopy = this.idpConfig;
        if (idpConfigCopy != null) {
            idpConfigCopy = this.idpConfig.copy();
        }
        return new ClientOptionsImpl(this.host, this.port, this.useTls, this.verifyHost, this.useAlpn, this.trustStorePath, this.trustStorePassword, this.keyStorePath, this.keyStorePassword, this.keyPassword, this.keyAlias, this.storeType, this.securityProviders, this.keyManagerAlgorithm, this.trustManagerAlgorithm, this.basicAuthUsername, this.basicAuthPassword, this.executeQueryMaxResultRows, this.http2MultiplexingLimit, this.requestHeaders, idpConfigCopy, this.authType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientOptionsImpl that = (ClientOptionsImpl)o;
        return this.port == that.port && this.useTls == that.useTls && this.verifyHost == that.verifyHost && this.useAlpn == that.useAlpn && this.executeQueryMaxResultRows == that.executeQueryMaxResultRows && this.host.equals(that.host) && Objects.equals(this.trustStorePath, that.trustStorePath) && Objects.equals(this.trustStorePassword, that.trustStorePassword) && Objects.equals(this.keyStorePath, that.keyStorePath) && Objects.equals(this.keyStorePassword, that.keyStorePassword) && Objects.equals(this.keyPassword, that.keyPassword) && Objects.equals(this.keyAlias, that.keyAlias) && Objects.equals(this.storeType, that.storeType) && Objects.equals(this.securityProviders, that.securityProviders) && Objects.equals(this.keyManagerAlgorithm, that.keyManagerAlgorithm) && Objects.equals(this.trustManagerAlgorithm, that.trustManagerAlgorithm) && Objects.equals(this.basicAuthUsername, that.basicAuthUsername) && Objects.equals(this.basicAuthPassword, that.basicAuthPassword) && this.http2MultiplexingLimit == that.http2MultiplexingLimit && Objects.equals(this.requestHeaders, that.requestHeaders) && Objects.equals(this.idpConfig, that.idpConfig);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.useTls, this.verifyHost, this.useAlpn, this.trustStorePath, this.trustStorePassword, this.keyStorePath, this.keyStorePassword, this.keyPassword, this.keyAlias, this.storeType, this.securityProviders, this.keyManagerAlgorithm, this.trustManagerAlgorithm, this.basicAuthUsername, this.basicAuthPassword, this.executeQueryMaxResultRows, this.http2MultiplexingLimit, this.requestHeaders, this.idpConfig);
    }

    public String toString() {
        return "ClientOptions{host='" + this.host + "', port=" + this.port + ", useTls=" + this.useTls + ", verifyHost=" + this.verifyHost + ", useAlpn=" + this.useAlpn + ", trustStorePath='" + this.trustStorePath + "', trustStorePassword='" + this.trustStorePassword + "', keyStorePath='" + this.keyStorePath + "', keyStorePassword='" + this.keyStorePassword + "', keyPassword='" + this.keyPassword + "', keyAlias='" + this.keyAlias + "', storeType='" + this.storeType + "', securityProviders='" + this.securityProviders + "', keyManagerAlgorithm='" + this.keyManagerAlgorithm + "', trustManagerAlgorithm='" + this.trustManagerAlgorithm + "', basicAuthUsername='" + this.basicAuthUsername + "', basicAuthPassword='" + this.basicAuthPassword + "', executeQueryMaxResultRows=" + this.executeQueryMaxResultRows + ", http2MultiplexingLimit=" + this.http2MultiplexingLimit + ", requestHeaders='" + String.valueOf(this.requestHeaders) + "', idpConfig='" + String.valueOf(this.idpConfig) + "'}";
    }
}

