/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import io.confluent.ksql.api.client.QueryInfo;
import java.util.Objects;
import java.util.Optional;

public class QueryInfoImpl
implements QueryInfo {
    private final QueryInfo.QueryType queryType;
    private final String id;
    private final String sql;
    private final Optional<String> sinkName;
    private final Optional<String> sinkTopicName;

    QueryInfoImpl(QueryInfo.QueryType queryType, String id, String sql, Optional<String> sinkName, Optional<String> sinkTopicName) {
        this.queryType = Objects.requireNonNull(queryType);
        this.id = Objects.requireNonNull(id);
        this.sql = Objects.requireNonNull(sql);
        this.sinkName = Objects.requireNonNull(sinkName);
        this.sinkTopicName = Objects.requireNonNull(sinkTopicName);
    }

    @Override
    public QueryInfo.QueryType getQueryType() {
        return this.queryType;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    @Override
    public Optional<String> getSink() {
        return this.sinkName;
    }

    @Override
    public Optional<String> getSinkTopic() {
        return this.sinkTopicName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryInfoImpl queryInfo = (QueryInfoImpl)o;
        return this.queryType == queryInfo.queryType && this.id.equals(queryInfo.id) && this.sql.equals(queryInfo.sql) && this.sinkName.equals(queryInfo.sinkName) && this.sinkTopicName.equals(queryInfo.sinkTopicName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.queryType, this.id, this.sql, this.sinkName, this.sinkTopicName});
    }

    public String toString() {
        return "QueryInfo{queryType=" + String.valueOf((Object)this.queryType) + ", id='" + this.id + "', sql='" + this.sql + "', sinkName=" + String.valueOf(this.sinkName) + ", sinkTopicName=" + String.valueOf(this.sinkTopicName) + "}";
    }
}

