/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.api.client.FieldInfo;
import io.confluent.ksql.api.client.QueryInfo;
import io.confluent.ksql.api.client.SourceDescription;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class SourceDescriptionImpl
implements SourceDescription {
    private final String name;
    private final String type;
    private final ImmutableList<FieldInfo> fields;
    private final String topic;
    private final String keyFormat;
    private final String valueFormat;
    private final ImmutableList<QueryInfo> readQueries;
    private final ImmutableList<QueryInfo> writeQueries;
    private final Optional<String> timestampColumn;
    private final Optional<String> windowType;
    private final String sqlStatement;
    private final ImmutableList<String> sourceConstraints;

    SourceDescriptionImpl(String name, String type, List<FieldInfo> fields, String topic, String keyFormat, String valueFormat, List<QueryInfo> readQueries, List<QueryInfo> writeQueries, Optional<String> timestampColumn, Optional<String> windowType, String sqlStatement, List<String> sourceConstraints) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type, "type");
        this.fields = ImmutableList.copyOf((Collection)Objects.requireNonNull(fields, "fields"));
        this.topic = Objects.requireNonNull(topic, "topic");
        this.keyFormat = Objects.requireNonNull(keyFormat, "keyFormat");
        this.valueFormat = Objects.requireNonNull(valueFormat, "valueFormat");
        this.readQueries = ImmutableList.copyOf((Collection)Objects.requireNonNull(readQueries, "readQueries"));
        this.writeQueries = ImmutableList.copyOf((Collection)Objects.requireNonNull(writeQueries, "writeQueries"));
        this.timestampColumn = Objects.requireNonNull(timestampColumn, "timestampColumn");
        this.windowType = Objects.requireNonNull(windowType, "windowType");
        this.sqlStatement = Objects.requireNonNull(sqlStatement, "sqlStatement");
        this.sourceConstraints = ImmutableList.copyOf((Collection)Objects.requireNonNull(sourceConstraints, "sourceConstraints"));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="fields is ImmutableList")
    public List<FieldInfo> fields() {
        return this.fields;
    }

    @Override
    public String topic() {
        return this.topic;
    }

    @Override
    public String keyFormat() {
        return this.keyFormat;
    }

    @Override
    public String valueFormat() {
        return this.valueFormat;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="readQueries is ImmutableList")
    public List<QueryInfo> readQueries() {
        return this.readQueries;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="writeQueries is ImmutableList")
    public List<QueryInfo> writeQueries() {
        return this.writeQueries;
    }

    @Override
    public Optional<String> timestampColumn() {
        return this.timestampColumn;
    }

    @Override
    public Optional<String> windowType() {
        return this.windowType;
    }

    @Override
    public String sqlStatement() {
        return this.sqlStatement;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="sourceConstraints is ImmutableList")
    public List<String> getSourceConstraints() {
        return this.sourceConstraints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceDescriptionImpl that = (SourceDescriptionImpl)o;
        return this.name.equals(that.name) && this.type.equals(that.type) && this.fields.equals(that.fields) && this.topic.equals(that.topic) && this.keyFormat.equals(that.keyFormat) && this.valueFormat.equals(that.valueFormat) && this.readQueries.equals(that.readQueries) && this.writeQueries.equals(that.writeQueries) && this.timestampColumn.equals(that.timestampColumn) && this.windowType.equals(that.windowType) && this.sqlStatement.equals(that.sqlStatement);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.fields, this.topic, this.keyFormat, this.valueFormat, this.readQueries, this.writeQueries, this.timestampColumn, this.windowType, this.sqlStatement);
    }

    public String toString() {
        return "SourceDescription{name='" + this.name + "', type='" + this.type + "', fields=" + String.valueOf(this.fields) + ", topic='" + this.topic + "', keyFormat='" + this.keyFormat + "', valueFormat='" + this.valueFormat + "', readQueries=" + String.valueOf(this.readQueries) + ", writeQueries=" + String.valueOf(this.writeQueries) + ", timestampColumn='" + String.valueOf(this.timestampColumn) + "', windowType=" + String.valueOf(this.windowType) + ", sqlStatement='" + this.sqlStatement + "'}";
    }
}

