/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.api.client.KsqlObject;
import io.confluent.ksql.reactive.BaseSubscriber;
import io.vertx.core.Context;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Objects;
import org.reactivestreams.Subscription;

public class StreamInsertsSubscriber
extends BaseSubscriber<KsqlObject> {
    private static final Logger log = LoggerFactory.getLogger(StreamInsertsSubscriber.class);
    private static final int REQUEST_BATCH_SIZE = 200;
    private final HttpClientRequest httpRequest;
    private int outstandingTokens;
    private boolean drainHandlerSet;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public StreamInsertsSubscriber(Context context, HttpClientRequest httpRequest) {
        super(context);
        this.httpRequest = Objects.requireNonNull(httpRequest);
    }

    protected void afterSubscribe(Subscription subscription) {
        this.checkRequest();
    }

    protected void handleValue(KsqlObject row) {
        this.httpRequest.writeCustomFrame(0, 0, Buffer.buffer().appendString(row.toJsonString()).appendString("\n"));
        --this.outstandingTokens;
        if (this.httpRequest.writeQueueFull()) {
            if (!this.drainHandlerSet) {
                this.httpRequest.drainHandler(this::httpRequestReceptive);
                this.drainHandlerSet = true;
            } else {
                this.checkRequest();
            }
        }
    }

    protected void handleComplete() {
        this.httpRequest.end();
    }

    protected void handleError(Throwable t) {
        log.error((Object)"Received error from streamInserts() publisher. Ending connection.", t);
        this.httpRequest.end();
    }

    private void checkRequest() {
        if (this.outstandingTokens == 0) {
            this.outstandingTokens = 200;
            this.makeRequest(200L);
        }
    }

    private void httpRequestReceptive(Void v) {
        this.drainHandlerSet = false;
        this.checkRequest();
    }
}

