/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.api.client.ColumnType;
import io.confluent.ksql.api.client.Row;
import io.confluent.ksql.api.client.StreamedQueryResult;
import io.confluent.ksql.api.client.exception.KsqlClientException;
import io.confluent.ksql.api.client.impl.ClientImpl;
import io.confluent.ksql.api.client.impl.PollableSubscriber;
import io.confluent.ksql.reactive.BufferedPublisher;
import io.vertx.core.Context;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;

public class StreamedQueryResultImpl
extends BufferedPublisher<Row>
implements StreamedQueryResult {
    private static final Logger log = LoggerFactory.getLogger(StreamedQueryResultImpl.class);
    private final String queryId;
    private final ImmutableList<String> columnNames;
    private final ImmutableList<ColumnType> columnTypes;
    private final PollableSubscriber pollableSubscriber;
    private volatile boolean polling;
    private boolean subscribing;
    private final AtomicReference<String> continuationToken;
    private final String sql;
    private final Map<String, Object> properties;
    private final ClientImpl client;

    StreamedQueryResultImpl(Context context, String queryId, List<String> columnNames, List<ColumnType> columnTypes, AtomicReference<String> continuationToken, String sql, Map<String, Object> properties, ClientImpl client) {
        super(context);
        this.queryId = queryId;
        this.columnNames = ImmutableList.copyOf(columnNames);
        this.columnTypes = ImmutableList.copyOf(columnTypes);
        this.pollableSubscriber = new PollableSubscriber(this.ctx, this::handleErrorWhilePolling);
        this.continuationToken = continuationToken;
        this.sql = sql;
        this.properties = properties;
        this.client = client;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="columnNames is ImmutableList")
    public List<String> columnNames() {
        return this.columnNames;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="columnTypes is ImmutableList")
    public List<ColumnType> columnTypes() {
        return this.columnTypes;
    }

    @Override
    public String queryID() {
        return this.queryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Subscriber<? super Row> subscriber) {
        if (this.polling) {
            throw new IllegalStateException("Cannot set subscriber if polling");
        }
        StreamedQueryResultImpl streamedQueryResultImpl = this;
        synchronized (streamedQueryResultImpl) {
            this.subscribing = true;
            super.subscribe(subscriber);
        }
    }

    @Override
    public Row poll() {
        return this.poll(Duration.ZERO);
    }

    @Override
    public Row poll(Duration timeout) {
        return this.poll(timeout, null);
    }

    private synchronized Row poll(Duration timeout, Runnable callback) {
        if (this.subscribing) {
            throw new IllegalStateException("Cannot poll if subscriber has been set");
        }
        if (this.isFailed()) {
            throw new IllegalStateException("Cannot poll on StreamedQueryResult that has failed. Check logs for failure reason.");
        }
        if (callback != null) {
            callback.run();
        }
        if (!this.polling) {
            this.subscribe((Subscriber<? super Row>)this.pollableSubscriber);
            this.subscribing = false;
            this.polling = true;
        }
        return this.pollableSubscriber.poll(timeout);
    }

    @Override
    public boolean isComplete() {
        return super.isComplete();
    }

    @Override
    public boolean isFailed() {
        return super.isFailed();
    }

    public void handleError(Exception e) {
        this.sendError(e);
    }

    private void handleErrorWhilePolling(Throwable t) {
        log.error((Object)("Unexpected error while polling: " + String.valueOf(t)));
    }

    public boolean hasContinuationToken() {
        return !Objects.equals(this.continuationToken.get(), "");
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public AtomicReference<String> getContinuationToken() {
        return this.continuationToken;
    }

    @Override
    public CompletableFuture<StreamedQueryResult> continueFromLastContinuationToken() {
        if (!this.hasContinuationToken()) {
            throw new KsqlClientException("Can only continue queries that have saved a continuation token.");
        }
        return this.client.streamQuery(this.sql, this.properties);
    }

    public static Row pollWithCallback(StreamedQueryResult queryResult, Runnable callback) {
        if (!(queryResult instanceof StreamedQueryResultImpl)) {
            throw new IllegalArgumentException("Can only poll with callback on StreamedQueryResultImpl");
        }
        StreamedQueryResultImpl streamedQueryResult = (StreamedQueryResultImpl)queryResult;
        return streamedQueryResult.poll(Duration.ZERO, callback);
    }
}

