/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.auth;

import com.google.common.cache.Cache;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.metrics.KafkaMetric;

class CachedExceptionKafkaProducer
implements Producer<byte[], byte[]> {
    private final Cache<Map.Entry<String, String>, ApiException> exceptionCache;
    private final String cacheKey;
    private final KafkaProducer<byte[], byte[]> delegate;

    CachedExceptionKafkaProducer(Cache<Map.Entry<String, String>, ApiException> exceptionCache, String cacheKey, KafkaProducer<byte[], byte[]> delegate) {
        this.exceptionCache = Objects.requireNonNull(exceptionCache, "Exception cache cannot be null");
        this.cacheKey = cacheKey;
        this.delegate = delegate;
    }

    public void initTransactions() {
        this.delegate.initTransactions();
    }

    public void beginTransaction() throws ProducerFencedException {
        this.delegate.beginTransaction();
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) throws ProducerFencedException {
        this.delegate.sendOffsetsToTransaction(offsets, groupMetadata);
    }

    public void commitTransaction() throws ProducerFencedException {
        this.delegate.commitTransaction();
    }

    public void abortTransaction() throws ProducerFencedException {
        this.delegate.abortTransaction();
    }

    public void registerMetricForSubscription(KafkaMetric metric) {
        this.delegate.registerMetricForSubscription(metric);
    }

    public void unregisterMetricFromSubscription(KafkaMetric metric) {
        this.delegate.unregisterMetricFromSubscription(metric);
    }

    public Future<RecordMetadata> send(ProducerRecord<byte[], byte[]> producerRecord) {
        return this.delegate.send(producerRecord);
    }

    public Future<RecordMetadata> send(ProducerRecord<byte[], byte[]> producerRecord, Callback callback) {
        return this.delegate.send(producerRecord, callback);
    }

    public void flush() {
        this.delegate.flush();
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        AbstractMap.SimpleEntry<String, String> key = new AbstractMap.SimpleEntry<String, String>(this.cacheKey, topic);
        ApiException e = (ApiException)this.exceptionCache.getIfPresent(key);
        if (e != null) {
            throw e;
        }
        try {
            return this.delegate.partitionsFor(topic);
        }
        catch (AuthenticationException | AuthorizationException ex) {
            this.exceptionCache.put(key, (Object)ex);
            throw ex;
        }
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.delegate.metrics();
    }

    public Uuid clientInstanceId(Duration timeout) {
        return this.delegate.clientInstanceId(timeout);
    }

    public void close() {
        this.delegate.close();
    }

    public void close(Duration timeout) {
        this.delegate.close(timeout);
    }
}

