/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.auth;

import com.google.common.base.Preconditions;
import io.confluent.kafkarest.CeKafkaRestConfig;
import io.confluent.kafkarest.DefaultKafkaRestContext;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.auth.CloudPrincipal;
import io.confluent.kafkarest.auth.RestRequestProxyProtocolInfo;
import io.confluent.kafkarest.v2.KafkaConsumerManager;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudKafkaRestContext
implements KafkaRestContext {
    private static final Logger log = LoggerFactory.getLogger(CloudKafkaRestContext.class);
    private static final String JMX_REPORTER_CLASS = "org.apache.kafka.common.metrics.JmxReporter";
    private final DefaultKafkaRestContext delegate;
    private final RestRequestProxyProtocolInfo proxyProtocolInfo;
    @Nullable
    private volatile CloudPrincipal principal;
    @Nullable
    private Admin adminClient;
    @Nullable
    private volatile Producer<byte[], byte[]> producer;

    public CloudKafkaRestContext(CloudPrincipal principal, KafkaRestConfig config, RestRequestProxyProtocolInfo proxyProtocolInfo) {
        log.debug("Creating context with config: {}", (Object)config);
        this.principal = Objects.requireNonNull(principal);
        this.delegate = new DefaultKafkaRestContext(config);
        this.proxyProtocolInfo = proxyProtocolInfo;
    }

    public KafkaRestConfig getConfig() {
        return this.delegate.getConfig();
    }

    public KafkaConsumerManager getKafkaConsumerManager() {
        throw new UnsupportedOperationException();
    }

    public synchronized Admin getAdmin() {
        if (this.adminClient == null) {
            this.adminClient = AdminClient.create((Properties)this.getAdminProperties());
        }
        return this.adminClient;
    }

    private Map<String, Object> getProxyProtocolClientConfig() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        Properties kafkaRestConfigProps = this.delegate.getConfig().getOriginalProperties();
        Object useProxyProtocolWithBrokerObject = kafkaRestConfigProps.getOrDefault((Object)"use.proxy.protocol.with.broker", (Object)false);
        boolean useProxyProtocolWithBroker = false;
        if (useProxyProtocolWithBrokerObject instanceof Boolean) {
            useProxyProtocolWithBroker = (Boolean)useProxyProtocolWithBrokerObject;
        } else if (useProxyProtocolWithBrokerObject instanceof String) {
            useProxyProtocolWithBroker = Boolean.parseBoolean((String)useProxyProtocolWithBrokerObject);
        }
        if (!useProxyProtocolWithBroker) {
            return configs;
        }
        ProxyProtocol proxyProtocolVersionSupported = ProxyProtocol.forName((String)((String)kafkaRestConfigProps.getOrDefault((Object)"proxy.protocol.client.version", CeKafkaRestConfig.PROXY_PROTOCOL_CLIENT_VERSION_DEFAULT)));
        if (proxyProtocolVersionSupported == ProxyProtocol.NONE) {
            return configs;
        }
        configs.put("confluent.proxy.protocol.client.version", proxyProtocolVersionSupported.toString());
        configs.put("confluent.proxy.protocol.client.address", this.proxyProtocolInfo.getClientIp());
        configs.put("confluent.proxy.protocol.client.port", this.proxyProtocolInfo.getClientPort());
        configs.put("confluent.lkc.id", this.principal.getClusterId());
        return configs;
    }

    public Properties getAdminProperties() {
        Preconditions.checkState((this.principal != null ? 1 : 0) != 0);
        Properties properties = this.delegate.getConfig().getAdminProperties();
        properties.putAll(this.getProxyProtocolClientConfig());
        log.debug("Properties passed to AdminClient are {}", (Object)properties);
        properties.putAll((Map<?, ?>)this.principal.getClientConfigs());
        if (properties.get("metric.reporters") != null) {
            properties.setProperty("metric.reporters", JMX_REPORTER_CLASS);
        }
        this.maybeAddClientConfigLoggingProperty(properties);
        return properties;
    }

    private void maybeAddClientConfigLoggingProperty(Properties properties) {
        if (!properties.containsKey("confluent.configs.logging.enabled")) {
            properties.setProperty("confluent.configs.logging.enabled", Boolean.toString(this.delegate.getConfig().getDoLog()));
        }
    }

    private void maybeAddClientConfigLoggingProperty(Map<String, Object> configs) {
        if (!configs.containsKey("confluent.configs.logging.enabled")) {
            configs.put("confluent.configs.logging.enabled", Boolean.toString(this.delegate.getConfig().getDoLog()));
        }
    }

    public Map<String, Object> getProducerConfigs() {
        Preconditions.checkState((this.principal != null ? 1 : 0) != 0);
        Map configs = this.delegate.getConfig().getProducerConfigs();
        configs.putAll(this.getProxyProtocolClientConfig());
        log.debug("Properties passed to ProducerClient are {}", (Object)configs);
        configs.putAll(this.principal.getClientConfigs());
        if (configs.get("metric.reporters") != null) {
            configs.put("metric.reporters", JMX_REPORTER_CLASS);
        }
        this.maybeAddClientConfigLoggingProperty(configs);
        return configs;
    }

    public Properties getConsumerProperties() {
        Preconditions.checkState((this.principal != null ? 1 : 0) != 0);
        Properties properties = this.delegate.getConfig().getConsumerProperties();
        properties.putAll(this.getProxyProtocolClientConfig());
        log.debug("Properties passed to ConsumerClient are {}", (Object)properties);
        properties.putAll((Map<?, ?>)this.principal.getClientConfigs());
        if (properties.get("metric.reporters") != null) {
            properties.setProperty("metric.reporters", JMX_REPORTER_CLASS);
        }
        this.maybeAddClientConfigLoggingProperty(properties);
        return properties;
    }

    public String getProducerCacheKey() {
        Preconditions.checkState((this.principal != null ? 1 : 0) != 0);
        return this.principal.getCacheKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Producer<byte[], byte[]> getProducer() {
        KafkaProducer localProducer = this.producer;
        if (localProducer == null) {
            CloudKafkaRestContext cloudKafkaRestContext = this;
            synchronized (cloudKafkaRestContext) {
                localProducer = this.producer;
                if (localProducer == null) {
                    this.producer = localProducer = new KafkaProducer(this.getProducerConfigs(), (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
                }
            }
        }
        return localProducer;
    }

    public Consumer<byte[], byte[]> getConsumer(Properties properties) {
        Properties baseConsumerConfig = this.getConsumerProperties();
        baseConsumerConfig.putAll((Map<?, ?>)properties);
        KafkaConsumer consumer = new KafkaConsumer(baseConsumerConfig);
        return consumer;
    }

    public synchronized void shutdown() {
        log.debug("Shutting down");
        this.principal = null;
        if (this.adminClient != null) {
            this.adminClient.close();
            this.adminClient = null;
        }
        if (this.producer != null) {
            this.producer = null;
        }
    }
}

