/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.confluent.kafkarest.CeKafkaRestConfig;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.auth.KafkaProducerCacheUtils;
import io.confluent.kafkarest.backends.kafka.KafkaProducerCache;
import io.confluent.kafkarest.utils.ReferenceCountingHolder;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProducerCacheImpl
implements KafkaProducerCache {
    private static final Logger log = LoggerFactory.getLogger(KafkaProducerCacheImpl.class);
    private static final String PRODUCER_CACHE_CONFIG_PREFIX = "kafka.producer.cache";
    public static final String PRODUCER_CACHE_CAPACITY_CONFIG = "kafka.producer.cache.capacity";
    public static final String PRODUCER_CACHE_VALIDITY_MILLIS_CONFIG = "kafka.producer.cache.validity.ms";
    public static final int PRODUCER_CACHE_DEFAULT_CAPACITY = 100;
    public static final long PRODUCER_CACHE_DEFAULT_VALIDITY_MILLIS = 30000L;
    private static final String EXCEPTION_CACHE_CONFIG_PREFIX = "exception.cache";
    public static final String EXCEPTION_CACHE_ENABLE_CONFIG = "kafka.producer.cache.exception.cache.enable";
    public static final String EXCEPTION_CACHE_CAPACITY_CONFIG = "kafka.producer.cache.exception.cache.capacity";
    public static final String EXCEPTION_CACHE_VALIDITY_MILLIS_CONFIG = "kafka.producer.cache.exception.cache.validity.ms";
    public static final int EXCEPTION_CACHE_DEFAULT_CAPACITY = 200;
    public static final long EXCEPTION_CACHE_DEFAULT_VALIDITY_MILLIS = 10000L;
    public static final boolean EXCEPTION_CACHE_ENABLE_DEFAULT = false;
    private final int producerCacheCapacity;
    private final long producerCacheValidity;
    private final boolean exceptionCacheEnable;
    private final int exceptionCacheCapacity;
    private final long exceptionCacheValidity;
    private final Cache<String, ReferenceCountingHolder<Producer<byte[], byte[]>>> cache;
    private final Cache<Map.Entry<String, String>, ApiException> exceptionCache;

    @Inject
    public KafkaProducerCacheImpl(Provider<KafkaRestConfig> configProvider) {
        KafkaRestConfig config = (KafkaRestConfig)configProvider.get();
        this.producerCacheCapacity = CeKafkaRestConfig.getIntOrDefault(config, PRODUCER_CACHE_CAPACITY_CONFIG, 100);
        this.producerCacheValidity = CeKafkaRestConfig.getLongOrDefault(config, PRODUCER_CACHE_VALIDITY_MILLIS_CONFIG, 30000L);
        this.exceptionCacheEnable = CeKafkaRestConfig.getBooleanOrDefault(config, EXCEPTION_CACHE_ENABLE_CONFIG, false);
        this.exceptionCacheCapacity = CeKafkaRestConfig.getIntOrDefault(config, EXCEPTION_CACHE_CAPACITY_CONFIG, 200);
        this.exceptionCacheValidity = CeKafkaRestConfig.getLongOrDefault(config, EXCEPTION_CACHE_VALIDITY_MILLIS_CONFIG, 10000L);
        log.info("KRest cache: capacity {}, validity {}ms", (Object)this.producerCacheCapacity, (Object)this.producerCacheValidity);
        log.info("KRest exception cache: capacity {}, validity {}ms", (Object)this.exceptionCacheCapacity, (Object)this.exceptionCacheValidity);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)this.producerCacheCapacity).expireAfterAccess(this.producerCacheValidity, TimeUnit.MILLISECONDS).removalListener(notification -> {
            log.info("KRest cache: Producer evicted from cache");
            ((ReferenceCountingHolder)notification.getValue()).decrement();
        }).build();
        this.exceptionCache = this.exceptionCacheEnable ? CacheBuilder.newBuilder().maximumSize((long)this.exceptionCacheCapacity).expireAfterWrite(Duration.ofMillis(this.exceptionCacheValidity)).build() : null;
    }

    @Override
    public Producer<byte[], byte[]> provide(String cacheKey, Map<String, Object> configs) {
        if (cacheKey == null) {
            return new KafkaProducer(configs, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
        }
        try {
            ReferenceCountingHolder holder = (ReferenceCountingHolder)this.cache.get((Object)cacheKey, this.exceptionCacheEnable ? KafkaProducerCacheUtils.getProducerCallable(configs, this.exceptionCache, cacheKey) : KafkaProducerCacheUtils.getProducerCallable(configs));
            holder.increment();
            log.debug("KRest cache: Serving produce request");
            InvocationHandler delegatingHandler = (proxy, method, args) -> {
                if ("close".equals(method.getName())) {
                    holder.decrement();
                    return null;
                }
                Object returnObject = null;
                try {
                    returnObject = method.invoke(holder.get(), args);
                }
                catch (InvocationTargetException e) {
                    log.error("KRest cache: error in producer invocation: " + String.valueOf(e.getCause()));
                    throw e.getCause();
                }
                return returnObject;
            };
            return (Producer)Proxy.newProxyInstance(Producer.class.getClassLoader(), new Class[]{Producer.class}, delegatingHandler);
        }
        catch (UncheckedExecutionException uee) {
            Throwables.throwIfUnchecked((Throwable)uee.getCause());
            throw new RuntimeException(uee);
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee.getCause());
        }
    }

    @Override
    public void dispose(Producer<byte[], byte[]> producer) {
        log.debug("KRest cache: closing producer");
        producer.close();
    }

    @VisibleForTesting
    Cache<String, ReferenceCountingHolder<Producer<byte[], byte[]>>> getCache() {
        return this.cache;
    }

    @VisibleForTesting
    int getCapacity() {
        return this.producerCacheCapacity;
    }

    @VisibleForTesting
    long getValidity() {
        return this.producerCacheValidity;
    }

    @VisibleForTesting
    Cache<Map.Entry<String, String>, ApiException> getExceptionCache() {
        return this.exceptionCache;
    }
}

