/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.auth;

import com.google.common.cache.Cache;
import io.confluent.kafkarest.auth.CachedExceptionKafkaProducer;
import io.confluent.kafkarest.utils.ReferenceCountingHolder;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProducerCacheUtils {
    private static final Logger log = LoggerFactory.getLogger(KafkaProducerCacheUtils.class);

    private KafkaProducerCacheUtils() {
    }

    public static Callable<ReferenceCountingHolder<Producer<byte[], byte[]>>> getProducerCallable(Map<String, Object> configs, Cache<Map.Entry<String, String>, ApiException> exceptionCache, String cacheKey) {
        return () -> {
            KafkaProducer producer = new KafkaProducer(configs, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
            log.debug("KRest cache: creating new producer for cache with exception cache");
            return new ReferenceCountingHolder<CachedExceptionKafkaProducer>(new CachedExceptionKafkaProducer(exceptionCache, cacheKey, (KafkaProducer<byte[], byte[]>)producer));
        };
    }

    public static Callable<ReferenceCountingHolder<Producer<byte[], byte[]>>> getProducerCallable(Map<String, Object> configs) {
        return () -> {
            KafkaProducer producer = new KafkaProducer(configs, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
            log.debug("KRest cache: creating new producer for cache without exception cache");
            return new ReferenceCountingHolder<KafkaProducer>(producer);
        };
    }
}

