/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafka.clients.CloudAdmin;
import io.confluent.kafkarest.common.KafkaFutures;
import io.confluent.kafkarest.controllers.CellsManager;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.entities.CellState;
import io.confluent.kafkarest.entities.Cluster;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.message.DescribeCellsResponseData;

final class CellsManagerImpl
implements CellsManager {
    private final ClusterManager clusterManager;
    private final CloudAdmin cloudAdmin;

    @Inject
    CellsManagerImpl(ClusterManager clusterManager, CloudAdmin cloudAdmin) {
        this.clusterManager = Objects.requireNonNull(clusterManager);
        this.cloudAdmin = Objects.requireNonNull(cloudAdmin);
    }

    @Override
    public CompletableFuture<CellState> describeCells(String clusterId) {
        return ((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists((Optional)cluster, (String)"Cluster %s cannot be found.", (Object[])new Object[]{clusterId}))).thenCompose(cluster -> KafkaFutures.toCompletableFuture((KafkaFuture)this.cloudAdmin.describeCells(Collections.emptyList()).value()).thenApply(values -> CellsManagerImpl.toCellState(clusterId, values)));
    }

    private static CellState toCellState(String clusterId, DescribeCellsResponseData value) {
        CellState.Builder builder = CellState.builder().setClusterId(clusterId).setCells(value.cells()).setCellsEnabled(value.cellsEnabled());
        if (!value.errorMessage().isEmpty() || value.errorCode() != 0) {
            builder = builder.setErrorCode(value.errorCode()).setErrorMessage(value.errorMessage());
        }
        return builder.build();
    }
}

