/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.ClusterManagerImpl;
import io.confluent.kafkarest.entities.Cluster;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.admin.Admin;

final class CloudClusterManagerImpl
implements ClusterManager {
    private final ClusterManager delegate;

    @Inject
    CloudClusterManagerImpl(Admin adminClient) {
        this.delegate = new ClusterManagerImpl(adminClient);
    }

    public CompletableFuture<List<Cluster>> listClusters() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Optional<Cluster>> getCluster(String clusterId) {
        Objects.requireNonNull(clusterId);
        return this.delegate.listClusters().thenApply(clusters -> clusters.stream().map(cluster -> cluster.toBuilder().setClusterId(clusterId).build()).findAny());
    }

    public CompletableFuture<Cluster> getLocalCluster() {
        throw new UnsupportedOperationException();
    }
}

