/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.common.KafkaFutures;
import io.confluent.kafkarest.controllers.BrokerConfigManager;
import io.confluent.kafkarest.controllers.BrokerManager;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.DefaultTopicConfigManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.entities.AbstractConfig;
import io.confluent.kafkarest.entities.Broker;
import io.confluent.kafkarest.entities.BrokerConfig;
import io.confluent.kafkarest.entities.ConfigSource;
import io.confluent.kafkarest.entities.ConfigSynonym;
import io.confluent.kafkarest.entities.TopicConfig;
import jakarta.inject.Inject;
import jakarta.ws.rs.NotFoundException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;

final class DefaultTopicConfigManagerImpl
implements DefaultTopicConfigManager {
    private static final String NUM_PARTITIONS = "num.partitions";
    private static final String DEFAULT_REPLICATION_FACTOR = "default.replication.factor";
    private final Admin adminClient;
    private final ClusterManager clusterManager;
    private final BrokerConfigManager brokerConfigManager;
    private final BrokerManager brokerManager;

    @Inject
    DefaultTopicConfigManagerImpl(Admin adminClient, ClusterManager clusterManager, BrokerConfigManager brokerConfigManager, BrokerManager brokerManager) {
        this.adminClient = Objects.requireNonNull(adminClient);
        this.clusterManager = Objects.requireNonNull(clusterManager);
        this.brokerConfigManager = Objects.requireNonNull(brokerConfigManager);
        this.brokerManager = Objects.requireNonNull(brokerManager);
    }

    @Override
    public CompletableFuture<List<TopicConfig>> listDefaultTopicConfigs(String clusterId, String topicName) {
        CompletionStage basicTopicConfig = this.clusterManager.getCluster(clusterId).thenCompose(cluster -> {
            Entities.checkEntityExists((Optional)cluster, (String)"Cluster %s cannot be found.", (Object[])new Object[]{clusterId});
            return KafkaFutures.toCompletableFuture((KafkaFuture)this.adminClient.createTopics(Collections.singletonList(new NewTopic(topicName, Optional.empty(), Optional.empty())), new CreateTopicsOptions().validateOnly(true)).config(topicName));
        });
        CompletionStage handleErrorStateConfigRequest = ((CompletableFuture)((CompletableFuture)basicTopicConfig).handle((config, ex) -> {
            if (ex != null) {
                if (ex.getCause() instanceof InvalidRequestException || ex.getCause() instanceof UnsupportedVersionException) {
                    return this.getOldBrokerFuture(clusterId, topicName);
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new CompletionException((Throwable)ex);
            }
            return CompletableFuture.completedFuture(config);
        })).thenCompose(result -> result);
        CompletionStage patchInReplicationFactorAndPartition = ((CompletableFuture)handleErrorStateConfigRequest).thenCompose(config -> this.attemptToAddReplicationFactorAndPartition(clusterId, (Config)config));
        CompletionStage listOfTopicConfigs = ((CompletableFuture)patchInReplicationFactorAndPartition).thenApply(config -> {
            List configList = config.entries().stream().map(entry -> (TopicConfig)((TopicConfig.Builder)((TopicConfig.Builder)((TopicConfig.Builder)((TopicConfig.Builder)((TopicConfig.Builder)((TopicConfig.Builder)((TopicConfig.Builder)((TopicConfig.Builder)TopicConfig.builder().setClusterId(clusterId)).setTopicName(topicName).setName(entry.name())).setValue(entry.value())).setDefault(entry.isDefault())).setReadOnly(entry.isReadOnly())).setSensitive(entry.isSensitive())).setSource(ConfigSource.fromAdminConfigSource((ConfigEntry.ConfigSource)entry.source()))).setSynonyms(entry.synonyms().stream().map(ConfigSynonym::fromAdminConfigSynonym).collect(Collectors.toList()))).build()).collect(Collectors.toList());
            return configList;
        });
        return listOfTopicConfigs;
    }

    private CompletableFuture<Config> getOldBrokerFuture(String clusterId, String topicName) {
        CompletionStage future = this.brokerManager.listBrokers(clusterId).thenCompose(brokers -> this.brokerConfigManager.listBrokerConfigs(clusterId, ((Broker)brokers.stream().findFirst().get()).getBrokerId()).thenCompose(brokerConfig -> {
            int partitions = Integer.parseInt(this.getConfigValue((List<BrokerConfig>)brokerConfig, NUM_PARTITIONS));
            short replicationFactor = Short.parseShort(this.getConfigValue((List<BrokerConfig>)brokerConfig, DEFAULT_REPLICATION_FACTOR));
            return KafkaFutures.toCompletableFuture((KafkaFuture)this.adminClient.createTopics(Collections.singletonList(new NewTopic(topicName, partitions, replicationFactor)), new CreateTopicsOptions().validateOnly(true)).config(topicName));
        }));
        return future;
    }

    private CompletableFuture<Config> attemptToAddReplicationFactorAndPartition(String clusterId, Config existingConfig) {
        return ((CompletableFuture)this.brokerManager.listBrokers(clusterId).thenCompose(brokers -> this.brokerConfigManager.listBrokerConfigs(clusterId, ((Broker)brokers.stream().findFirst().get()).getBrokerId()).thenCompose(brokerConfig -> {
            Collection updatedConfig = existingConfig.entries().stream().collect(Collectors.toList());
            BrokerConfig numPartitionsBrokerConfig = this.getConfig((List<BrokerConfig>)brokerConfig, NUM_PARTITIONS);
            BrokerConfig defaultReplicationFactorBrokerConfig = this.getConfig((List<BrokerConfig>)brokerConfig, DEFAULT_REPLICATION_FACTOR);
            ConfigEntry numPartitionsTopicConfig = new ConfigEntry(NUM_PARTITIONS, numPartitionsBrokerConfig.getValue(), ConfigEntry.ConfigSource.DEFAULT_CONFIG, numPartitionsBrokerConfig.isSensitive(), numPartitionsBrokerConfig.isReadOnly(), Collections.emptyList(), ConfigEntry.ConfigType.INT, "");
            ConfigEntry replicationFactorTopicConfig = new ConfigEntry(DEFAULT_REPLICATION_FACTOR, defaultReplicationFactorBrokerConfig.getValue(), ConfigEntry.ConfigSource.DEFAULT_CONFIG, defaultReplicationFactorBrokerConfig.isSensitive(), defaultReplicationFactorBrokerConfig.isReadOnly(), Collections.emptyList(), ConfigEntry.ConfigType.INT, "");
            updatedConfig.add(numPartitionsTopicConfig);
            updatedConfig.add(replicationFactorTopicConfig);
            return CompletableFuture.completedFuture(new Config(updatedConfig));
        }))).handle((updatedConfig, ex) -> {
            if (ex != null) {
                return existingConfig;
            }
            return updatedConfig;
        });
    }

    private String getConfigValue(List<BrokerConfig> brokerConfigs, String configName) {
        return this.getConfig(brokerConfigs, configName).getValue();
    }

    private BrokerConfig getConfig(List<BrokerConfig> brokerConfigs, String configName) {
        return (BrokerConfig)Entities.findEntityByKey(brokerConfigs, AbstractConfig::getName, (Object)configName).orElseThrow(() -> new NotFoundException(String.format("Could not determine required broker configuration: %s", configName)));
    }
}

