/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.HealthCheckManager;
import io.confluent.kafkarest.entities.HealthCheckStatus;
import jakarta.inject.Inject;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

final class HealthCheckManagerImpl
implements HealthCheckManager {
    private final ClusterManager clusterManager;

    @Inject
    HealthCheckManagerImpl(ClusterManager clusterManager) {
        this.clusterManager = Objects.requireNonNull(clusterManager);
    }

    @Override
    public CompletableFuture<HealthCheckStatus> getHealthCheckStatus() {
        try {
            return this.clusterManager.listClusters().handle((clusters, error) -> {
                if (error != null) {
                    return HealthCheckStatus.WARNING;
                }
                if (clusters.isEmpty()) {
                    return HealthCheckStatus.UNKNOWN;
                }
                return HealthCheckStatus.OK;
            });
        }
        catch (Throwable t) {
            return CompletableFuture.completedFuture(HealthCheckStatus.WARNING);
        }
    }
}

